/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400CommonPCMLManager;
import com.helpsystems.common.as400.dm.IAS400CommonPCMLManager;
import com.helpsystems.common.as400.dm.ISystemValueManager;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.LocalizedDate;
import com.helpsystems.common.core.busobj.LocalizedTime;
import com.helpsystems.common.core.dm.SystemInformationDM;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemValue;
import java.sql.Time;
import java.util.Date;

public class SystemInformationDMAS400
extends AbstractManager
implements SystemInformationDM {
    private ISystemValueManager sysValMgr;
    private IAS400CommonPCMLManager commonMgr;

    public SystemInformationDMAS400(ISystemValueManager iSystemValueManager, IAS400CommonPCMLManager iAS400CommonPCMLManager, String string) {
        if (iSystemValueManager == null) {
            throw new NullPointerException("The ISystemValueManager passed in is null.");
        }
        this.sysValMgr = iSystemValueManager;
        if (iAS400CommonPCMLManager == null) {
            throw new NullPointerException("The AS400CommonPCMLManager passed in is null.");
        }
        this.commonMgr = iAS400CommonPCMLManager;
        this.setName(string);
    }

    public String getSerialNumber() throws ResourceUnavailableException {
        String string = (String)this.sysValMgr.getSystemValue("QSRLNBR");
        return string.trim();
    }

    public String getModelNumber() throws ResourceUnavailableException {
        String string = (String)this.sysValMgr.getSystemValue("QMODEL");
        return string.trim();
    }

    public String getPrcFeature() throws ResourceUnavailableException {
        String string = (String)this.sysValMgr.getSystemValue("QPRCFEAT");
        return string.trim();
    }

    public int getPartitionNumber() throws ResourceUnavailableException {
        return this.commonMgr.retrievePartitionNumber();
    }

    public String getHardwareIdentifier() throws ResourceUnavailableException {
        String string = this.getSerialNumber();
        String string2 = this.getModelNumber();
        String string3 = this.getPrcFeature();
        int n = this.getPartitionNumber();
        return SystemInformationDMAS400.buildHardwareID(string, string2, string3, n);
    }

    public java.sql.Date getSystemDate() throws ResourceUnavailableException {
        java.sql.Date date = (java.sql.Date)this.sysValMgr.getSystemValue("QDATE");
        LocalizedDate localizedDate = new LocalizedDate((Date)date);
        LocalizedDate.correctTime((Date)localizedDate);
        return localizedDate;
    }

    public Time getSystemTime() throws ResourceUnavailableException {
        Time time = (Time)this.sysValMgr.getSystemValue("QTIME");
        LocalizedTime localizedTime = new LocalizedTime(time);
        LocalizedDate.correctTime((Date)localizedTime);
        return localizedTime;
    }

    public String getSystemName() throws ResourceUnavailableException {
        return this.commonMgr.retrieveSystemName();
    }

    public int getSystemOSType() {
        return 1;
    }

    public static String getHardwareIdentifier(AS400 aS400) throws ResourceUnavailableException {
        int n = AS400CommonPCMLManager.retrievePartitionNumber(aS400);
        SystemValue systemValue = new SystemValue(aS400, "QSRLNBR");
        SystemValue systemValue2 = new SystemValue(aS400, "QMODEL");
        SystemValue systemValue3 = new SystemValue(aS400, "QPRCFEAT");
        try {
            String string = ((String)systemValue.getValue()).trim();
            String string2 = ((String)systemValue2.getValue()).trim();
            String string3 = ((String)systemValue3.getValue()).trim();
            return SystemInformationDMAS400.buildHardwareID(string, string2, string3, n);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve the hardware identifier.", (Throwable)exception);
        }
    }

    private static String buildHardwareID(String string, String string2, String string3, int n) {
        ValidationHelper.checkForNullAndBlank((String)"Serial Number", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"Model Number", (String)string2);
        ValidationHelper.checkForNullAndBlank((String)"Processor Feature Code", (String)string3);
        return "I-" + string + "-" + string2 + "-" + string3 + "-" + n;
    }
}

