/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.busobj.SoftCmdLicense;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.ProgramCallDocument;
import org.apache.log4j.Logger;

public class SoftCmdLicenseAccess {
    private static final Logger logger = Logger.getLogger(SoftCmdLicenseAccess.class);
    private static final String PCML_FILE = "com.helpsystems.common.as400.access.xx911s";
    private static final String PGM_AT = "AT911S";
    private static final String PGM_RM = "RM911S";
    private static final String PGM_RL = "RL911S";
    protected ProgramCallDocument pcml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftCmdLicense getLicense(AS400 aS400, String string, String string2) throws ResourceUnavailableException {
        ValidationHelper.checkForNullAndBlank((String)"Library", (String)string2);
        ValidationHelper.checkForNullAndBlank((String)"Product Code", (String)string);
        String string3 = SoftCmdLicenseAccess.getProductPgm(string);
        try {
            this.loadPCML(aS400);
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem(aS400);
                String string4 = "XX911S";
                String string5 = "/QSYS.LIB/" + string2.trim() + ".LIB/" + string3 + ".PGM";
                this.pcml.setPath(string4, string5);
                logger.debug((Object)("Getting license with: " + string5));
                this.pcml.setValue(string4 + ".returnArray", (Object)"");
                this.pcml.setValue(string4 + ".serialNumber", (Object)"");
                this.pcml.setIntValue(string4 + ".partition", 0);
                this.pcml.setIntValue(string4 + ".funcAndOffset", 0);
                this.pcml.setValue(string4 + ".license", (Object)"");
                this.pcml.setValue(string4 + ".expDate", (Object)"");
                AbstractProgramCallManager.doCallAndReturn(this.pcml, string4, null);
                byte[] byArray = (byte[])this.pcml.getValue(string4 + ".returnArray");
                String string6 = (String)this.pcml.getValue(string4 + ".license");
                int n = this.pcml.getIntValue(string4 + ".funcAndOffset");
                String string7 = (String)this.pcml.getValue(string4 + ".expDate");
                if (byArray.length != 32) {
                    throw new ResourceUnavailableException("Return array length (" + byArray.length + ") is not valid (32).");
                }
                int n2 = 0;
                int n3 = 0;
                if (string.equals("AT")) {
                    n2 = n - 67;
                    n3 = n - 75;
                } else if (string.equals("MTR")) {
                    n2 = n - 94;
                    n3 = n - 69;
                } else if (string.equals("LPR")) {
                    n2 = n - 73;
                    n3 = n - 62;
                }
                if (n3 < 1) {
                    n3 += 32;
                } else if (n3 > 32) {
                    n3 -= 32;
                }
                if (n2 < 1 || n2 > 32) {
                    throw new ResourceUnavailableException("Invalid position of status byte one: " + n);
                }
                if (n3 < 1 || n3 > 32) {
                    throw new ResourceUnavailableException("Invalid position of status byte two: " + n);
                }
                SoftCmdLicense softCmdLicense = new SoftCmdLicense();
                softCmdLicense.setProductCode(string);
                softCmdLicense.setLicenseCode(string6);
                byte by = byArray[n2 - 1];
                if ((by & 2) > 0) {
                    softCmdLicense.setValid(true);
                    byte by2 = byArray[n3 - 1];
                    if ((by2 & 2) > 0) {
                        softCmdLicense.setType(1);
                    } else {
                        softCmdLicense.setType(2);
                        if (string7.length() != 13) {
                            throw new ResourceUnavailableException("Invalid expiration date length: " + string7);
                        }
                        softCmdLicense.setExpirationDate(string7.substring(1, 7));
                    }
                } else {
                    softCmdLicense.setValid(false);
                }
                return softCmdLicense;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error retrieving the " + SoftCmdLicenseAccess.getProductName(string) + " license.", (Throwable)exception);
        }
    }

    public SoftCmdLicense saveLicense(AS400 aS400, SoftCmdLicense softCmdLicense, String string) throws ResourceUnavailableException {
        ValidationHelper.checkForNullAndBlank((String)"Library", (String)string);
        ValidationHelper.checkForNull((String)"License Object", (Object)((Object)softCmdLicense));
        String string2 = softCmdLicense.getProductCode();
        try {
            SoftCmdLicense softCmdLicense2 = this.verifyLicense(aS400, softCmdLicense, string);
            if (!softCmdLicense2.isValid()) {
                throw new IllegalArgumentException(softCmdLicense.getLicenseCode() + " is not a valid license code for " + SoftCmdLicenseAccess.getProductName(string2) + ".");
            }
            this.loadPCML(aS400);
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem(aS400);
                String string3 = SoftCmdLicenseAccess.getProductPgm(string2);
                String string4 = "XX911S";
                String string5 = "/QSYS.LIB/" + string.trim() + ".LIB/" + string3 + ".PGM";
                this.pcml.setPath(string4, string5);
                logger.debug((Object)("Saving license with: " + string5));
                logger.debug((Object)("Saving license code: " + softCmdLicense.getLicenseCode()));
                this.pcml.setValue(string4 + ".returnArray", (Object)"");
                this.pcml.setValue(string4 + ".serialNumber", (Object)"");
                this.pcml.setIntValue(string4 + ".partition", 0);
                this.pcml.setIntValue(string4 + ".funcAndOffset", -1);
                this.pcml.setValue(string4 + ".license", (Object)softCmdLicense.getLicenseCode());
                this.pcml.setValue(string4 + ".expDate", (Object)"");
                AbstractProgramCallManager.doCallAndReturn(this.pcml, string4, null);
                SoftCmdLicense softCmdLicense3 = this.getLicense(aS400, softCmdLicense.getProductCode(), string);
                if (softCmdLicense.getLicenseCode().equals(softCmdLicense3.getLicenseCode())) {
                    return softCmdLicense3;
                }
                throw new ResourceUnavailableException("The license was not updated. (" + softCmdLicense.getLicenseCode() + " <--> " + softCmdLicense3.getLicenseCode() + ")");
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error saving the " + SoftCmdLicenseAccess.getProductName(string2) + " license.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftCmdLicense verifyLicense(AS400 aS400, SoftCmdLicense softCmdLicense, String string) throws ResourceUnavailableException {
        ValidationHelper.checkForNullAndBlank((String)"Library", (String)string);
        ValidationHelper.checkForNull((String)"License Object", (Object)((Object)softCmdLicense));
        String string2 = softCmdLicense.getProductCode();
        String string3 = SoftCmdLicenseAccess.getProductPgm(string2);
        try {
            this.loadPCML(aS400);
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem(aS400);
                String string4 = "XX911S";
                String string5 = "/QSYS.LIB/" + string.trim() + ".LIB/" + string3 + ".PGM";
                this.pcml.setPath(string4, string5);
                logger.debug((Object)("Verifying license with: " + string5));
                logger.debug((Object)("Verifying license code: " + softCmdLicense.getLicenseCode()));
                this.pcml.setValue(string4 + ".returnArray", (Object)"");
                this.pcml.setValue(string4 + ".serialNumber", (Object)"");
                this.pcml.setIntValue(string4 + ".partition", 0);
                this.pcml.setIntValue(string4 + ".funcAndOffset", -3);
                this.pcml.setValue(string4 + ".license", (Object)softCmdLicense.getLicenseCode());
                this.pcml.setValue(string4 + ".expDate", (Object)"");
                AbstractProgramCallManager.doCallAndReturn(this.pcml, string4, null);
                byte[] byArray = (byte[])this.pcml.getValue(string4 + ".returnArray");
                String string6 = (String)this.pcml.getValue(string4 + ".license");
                int n = this.pcml.getIntValue(string4 + ".funcAndOffset");
                String string7 = (String)this.pcml.getValue(string4 + ".expDate");
                if (byArray.length != 32) {
                    throw new ResourceUnavailableException("Return array length (" + byArray.length + ") is not valid (32).");
                }
                int n2 = 0;
                int n3 = 0;
                if (string2.equals("AT")) {
                    n2 = n - 67;
                    n3 = n - 75;
                } else if (string2.equals("MTR")) {
                    n2 = n - 94;
                    n3 = n - 69;
                } else if (string2.equals("LPR")) {
                    n2 = n - 73;
                    n3 = n - 62;
                }
                if (n3 < 1) {
                    n3 += 32;
                } else if (n3 > 32) {
                    n3 -= 32;
                }
                if (n2 < 1 || n2 > 32) {
                    throw new ResourceUnavailableException("Invalid position of status byte one: " + n);
                }
                if (n3 < 1 || n3 > 32) {
                    throw new ResourceUnavailableException("Invalid position of status byte two: " + n);
                }
                SoftCmdLicense softCmdLicense2 = new SoftCmdLicense();
                softCmdLicense2.setProductCode(string2);
                softCmdLicense2.setLicenseCode(string6);
                int n4 = n2 - 1;
                byte by = byArray[n4];
                if ((by & 2) > 0) {
                    softCmdLicense2.setValid(true);
                    int n5 = n3 - 1;
                    byte by2 = byArray[n5];
                    if ((by2 & 2) > 0) {
                        softCmdLicense2.setType(1);
                    } else {
                        softCmdLicense2.setType(2);
                        if (string7.length() != 13) {
                            throw new ResourceUnavailableException("Invalid expiration date length: " + string7);
                        }
                        softCmdLicense2.setExpirationDate(string7.substring(1, 7));
                    }
                } else {
                    softCmdLicense2.setValid(false);
                }
                return softCmdLicense2;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error verifying the " + SoftCmdLicenseAccess.getProductName(string2) + " license.", (Throwable)exception);
        }
    }

    private void loadPCML(AS400 aS400) {
        if (this.pcml == null) {
            try {
                this.pcml = new ProgramCallDocument(aS400, PCML_FILE);
            }
            catch (Exception exception) {
                logger.error((Object)"Error loading license access pcml.", (Throwable)exception);
            }
        }
    }

    private static String getProductName(String string) {
        ValidationHelper.checkForNull((String)"Product Code", (Object)string);
        if (string.equals("AT")) {
            return "Autotune";
        }
        if (string.equals("MTR")) {
            return "Monitor";
        }
        if (string.equals("LPR")) {
            return "LPAR";
        }
        return "Unknown (" + string + ")";
    }

    private static String getProductPgm(String string) throws ResourceUnavailableException {
        ValidationHelper.checkForNullAndBlank((String)"Product Code", (String)string);
        if (string.equals("AT")) {
            return PGM_AT;
        }
        if (string.equals("MTR")) {
            return PGM_RM;
        }
        if (string.equals("LPR")) {
            return PGM_RL;
        }
        throw new ResourceUnavailableException("Unknown product code: " + string);
    }
}

