/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400JobDescriptor;
import com.helpsystems.common.as400.busobj.OS400SpooledFile;
import com.helpsystems.common.as400.busobj.OS400SpooledFileProxy;
import com.helpsystems.common.as400.dataset.SpooledFileLineDataSet;
import com.helpsystems.common.as400.dataset.SpooledFileListDataSet;
import com.helpsystems.common.as400.dm.OS400SpooledFileDM;
import com.helpsystems.common.as400.dm.OS400UtilitiesAM;
import com.helpsystems.common.as400.ex.JobException;
import com.helpsystems.common.as400.filter.FilterFieldOS400JobDescriptor;
import com.helpsystems.common.as400.filter.FilterFieldOS400QualifiedObject;
import com.helpsystems.common.as400.util.OS400Utilities;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.NotAuthorizedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.filter.FilterField;
import com.helpsystems.common.core.filter.FilterFieldList;
import com.helpsystems.common.core.filter.FilterFieldString;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.list.SpooledFileListItem;
import com.ibm.as400.access.list.SpooledFileOpenList;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;

public class OS400SpooledFileDMAS400
extends AbstractAS400Manager
implements OS400SpooledFileDM {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)OS400SpooledFileDMAS400.class.getName());
    private static final Logger logger = Logger.getLogger(OS400SpooledFileDMAS400.class);
    private static OS400UtilitiesAM os400UtilitiesAM;
    public static final String FILTER_FIELD_JOB = "jobInformation";
    public static final String FILTER_FIELD_OUTQ = "outputQueue";
    public static final String FILTER_FIELD_STATUS = "status";
    public static final String FILTER_FIELD_USER = "user";
    public static final String FILTER_FIELD_USER_DATA = "userData";
    private SortField[] SORT_FIELDS = new SortField[]{new GenericSortField(2, 0), new GenericSortField(3, 0), new GenericSortField(4, 0), new GenericSortField(5, 0), new GenericSortField(6, 0), new GenericSortField(9, 0), new GenericSortField(11, 0), new GenericSortField(8, 0), new GenericSortField(7, 0), new GenericSortField(10, 1), new GenericSortField(1, 1), new GenericSortField(12, 1), new GenericSortField(13, 0)};

    public OS400SpooledFileDMAS400(String string, String string2, OS400UtilitiesAM oS400UtilitiesAM) {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
        os400UtilitiesAM = oS400UtilitiesAM;
    }

    @Override
    public void delete(UserIdentity userIdentity, OS400SpooledFileProxy oS400SpooledFileProxy) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"OS400SpooledFileProxy", (Object)((Object)oS400SpooledFileProxy));
        WrappedAS400 wrappedAS400 = this.createConnectionForUser(userIdentity);
        try {
            SpooledFile spooledFile = new SpooledFile((AS400)wrappedAS400, oS400SpooledFileProxy.getSpooledFileName(), oS400SpooledFileProxy.getSpooledFileNumber(), oS400SpooledFileProxy.getJobName(), oS400SpooledFileProxy.getJobUser(), oS400SpooledFileProxy.getJobNumber());
            spooledFile.delete();
        }
        catch (AS400Exception aS400Exception) {
            String string = OS400Utilities.convertAS400ExceptionToString(aS400Exception);
            throw new ResourceUnavailableException(string, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string = "Error deleting OS400 spooled file.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    @Override
    public OS400SpooledFile getSpooledFile(UserIdentity userIdentity, String string, int n, String string2, String string3, String string4) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"SpooledFileName", (Object)string);
        ValidationHelper.checkForNull((String)"JobName", (Object)string2);
        ValidationHelper.checkForNull((String)"JobUser", (Object)string3);
        ValidationHelper.checkForNull((String)"JobNumber", (Object)string4);
        OS400SpooledFileProxy oS400SpooledFileProxy = new OS400SpooledFileProxy();
        oS400SpooledFileProxy.setSpooledFileName(string);
        oS400SpooledFileProxy.setSpooledFileNumber(n);
        oS400SpooledFileProxy.setJobName(string2);
        oS400SpooledFileProxy.setJobUser(string3);
        oS400SpooledFileProxy.setJobNumber(string4);
        return this.getSpooledFile(userIdentity, oS400SpooledFileProxy);
    }

    @Override
    public OS400SpooledFile getSpooledFile(UserIdentity userIdentity, OS400SpooledFileProxy oS400SpooledFileProxy) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"OS400SpooledFileProxy", (Object)((Object)oS400SpooledFileProxy));
        WrappedAS400 wrappedAS400 = this.createOneTimeUseConnection(userIdentity);
        OS400SpooledFile oS400SpooledFile = new OS400SpooledFile();
        try {
            SpooledFile spooledFile = new SpooledFile((AS400)wrappedAS400, oS400SpooledFileProxy.getSpooledFileName(), oS400SpooledFileProxy.getSpooledFileNumber(), oS400SpooledFileProxy.getJobName(), oS400SpooledFileProxy.getJobUser(), oS400SpooledFileProxy.getJobNumber());
            this.loadSpooledFile(oS400SpooledFile, spooledFile);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string = "Error retrieving OS400 spooled file.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return oS400SpooledFile;
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        try {
            return this.getList(userIdentity, dataFilter, sortField);
        }
        catch (JobException jobException) {
            throw new ResourceUnavailableException(jobException.getMessage(), (Throwable)jobException);
        }
    }

    @Override
    public DataSet getList(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException, JobException {
        WrappedAS400 wrappedAS400 = this.createOneTimeUseConnection(userIdentity);
        SpooledFileOpenList spooledFileOpenList = new SpooledFileOpenList((AS400)wrappedAS400);
        try {
            this.applyFilter(spooledFileOpenList, dataFilter);
            this.applySort(spooledFileOpenList, sortField);
            return SpooledFileListDataSet.createDataSet(wrappedAS400, spooledFileOpenList, this);
        }
        catch (JobException jobException) {
            throw jobException;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            try {
                spooledFileOpenList.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
            String string = "Error retrieving OS400 spooled file proxy list.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    private void applyFilter(SpooledFileOpenList spooledFileOpenList, DataFilter dataFilter) throws PropertyVetoException, ResourceUnavailableException {
        if (dataFilter == null) {
            return;
        }
        FilterCriteria[] filterCriteriaArray = dataFilter.getCriteria();
        for (int i = 0; i < filterCriteriaArray.length; ++i) {
            Object object;
            String string = filterCriteriaArray[i].getFieldName();
            String string2 = null;
            if (!(filterCriteriaArray[i].getValue() instanceof String)) {
                object = "Invalid filter criteria.";
                logger.debug(object);
                throw new ResourceUnavailableException((String)object, null);
            }
            string2 = (String)((Object)filterCriteriaArray[i].getValue());
            if (string.equals(FILTER_FIELD_USER)) {
                spooledFileOpenList.setFilterUsers(new String[]{string2});
                continue;
            }
            if (string.equals(FILTER_FIELD_OUTQ)) {
                object = string2.split("/");
                String string3 = object[0];
                String string4 = object[1];
                QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName();
                qSYSObjectPathName.setLibraryName(string3);
                qSYSObjectPathName.setObjectName(string4);
                qSYSObjectPathName.setObjectType("OUTQ");
                String string5 = qSYSObjectPathName.getPath();
                spooledFileOpenList.setFilterOutputQueues(new String[]{string5});
                continue;
            }
            if (string.equals(FILTER_FIELD_JOB)) {
                object = new OS400JobDescriptor();
                ((OS400JobDescriptor)((Object)object)).setAll(string2);
                spooledFileOpenList.setFilterJobInformation(((OS400JobDescriptor)((Object)object)).getJobName(), ((OS400JobDescriptor)((Object)object)).getJobUser(), ((OS400JobDescriptor)((Object)object)).getJobNumber());
                continue;
            }
            if (string.equals(FILTER_FIELD_STATUS)) {
                spooledFileOpenList.setFilterStatuses(new String[]{string2});
                continue;
            }
            if (!string.equals(FILTER_FIELD_USER_DATA)) continue;
            spooledFileOpenList.setFilterUserData(string2);
        }
    }

    private void applySort(SpooledFileOpenList spooledFileOpenList, SortField sortField) throws ResourceUnavailableException {
        SortField sortField2 = sortField;
        if (sortField2 == null) {
            sortField2 = new GenericSortField(11, 0);
        }
        spooledFileOpenList.clearSortFields();
        switch (sortField2.getField()) {
            case 2: {
                spooledFileOpenList.addSortField(0, sortField2.isAscending());
                spooledFileOpenList.addSortField(1, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 4: {
                spooledFileOpenList.addSortField(1, sortField2.isAscending());
                spooledFileOpenList.addSortField(0, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 3: {
                spooledFileOpenList.addSortField(2, sortField2.isAscending());
                spooledFileOpenList.addSortField(0, true);
                spooledFileOpenList.addSortField(1, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 5: {
                spooledFileOpenList.addSortField(3, sortField2.isAscending());
                spooledFileOpenList.addSortField(4, true);
                spooledFileOpenList.addSortField(0, true);
                spooledFileOpenList.addSortField(1, true);
                spooledFileOpenList.addSortField(2, true);
                break;
            }
            case 6: {
                spooledFileOpenList.addSortField(4, sortField2.isAscending());
                spooledFileOpenList.addSortField(3, true);
                spooledFileOpenList.addSortField(0, true);
                spooledFileOpenList.addSortField(1, true);
                spooledFileOpenList.addSortField(2, true);
                break;
            }
            case 9: {
                spooledFileOpenList.addSortField(19, sortField2.isAscending());
                spooledFileOpenList.addSortField(6, true);
                spooledFileOpenList.addSortField(7, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 8: {
                spooledFileOpenList.addSortField(12, sortField2.isAscending());
                spooledFileOpenList.addSortField(13, true);
                spooledFileOpenList.addSortField(19, true);
                spooledFileOpenList.addSortField(6, true);
                spooledFileOpenList.addSortField(7, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 7: {
                spooledFileOpenList.addSortField(13, sortField2.isAscending());
                spooledFileOpenList.addSortField(12, true);
                spooledFileOpenList.addSortField(19, true);
                spooledFileOpenList.addSortField(6, true);
                spooledFileOpenList.addSortField(7, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 10: {
                spooledFileOpenList.addSortField(15, sortField2.isAscending());
                spooledFileOpenList.addSortField(19, true);
                spooledFileOpenList.addSortField(6, true);
                spooledFileOpenList.addSortField(7, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 1: {
                spooledFileOpenList.addSortField(6, sortField2.isAscending());
                spooledFileOpenList.addSortField(7, sortField2.isAscending());
                spooledFileOpenList.addSortField(19, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 12: {
                spooledFileOpenList.addSortField(17, sortField2.isAscending());
                spooledFileOpenList.addSortField(19, true);
                spooledFileOpenList.addSortField(6, true);
                spooledFileOpenList.addSortField(7, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            case 13: {
                spooledFileOpenList.addSortField(10, sortField2.isAscending());
                spooledFileOpenList.addSortField(19, true);
                spooledFileOpenList.addSortField(6, true);
                spooledFileOpenList.addSortField(7, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
                break;
            }
            default: {
                spooledFileOpenList.addSortField(5, sortField2.isAscending());
                spooledFileOpenList.addSortField(19, true);
                spooledFileOpenList.addSortField(6, true);
                spooledFileOpenList.addSortField(7, true);
                spooledFileOpenList.addSortField(2, true);
                spooledFileOpenList.addSortField(4, true);
            }
        }
    }

    public OS400SpooledFileProxy copyToProxy(SpooledFileListItem spooledFileListItem, OS400SpooledFileProxy oS400SpooledFileProxy) throws BadDataException, ResourceUnavailableException {
        if (spooledFileListItem == null) {
            throw new NullPointerException("The spooled file passed in is null.");
        }
        OS400SpooledFileProxy oS400SpooledFileProxy2 = oS400SpooledFileProxy == null ? new OS400SpooledFileProxy() : oS400SpooledFileProxy;
        try {
            oS400SpooledFileProxy2.setCopiesLeftToPrint(spooledFileListItem.getCopiesLeftToPrint());
            Date date = DateTranslator.unpackDate((String)(spooledFileListItem.getDateOpened() + spooledFileListItem.getTimeOpened()));
            oS400SpooledFileProxy2.setDateFileOpened(date);
            oS400SpooledFileProxy2.setFormType(spooledFileListItem.getFormType());
            oS400SpooledFileProxy2.setJobName(spooledFileListItem.getJobName());
            oS400SpooledFileProxy2.setJobNumber(spooledFileListItem.getJobNumber());
            oS400SpooledFileProxy2.setJobUser(spooledFileListItem.getJobUser());
            if (" ".equals(spooledFileListItem.getPriority())) {
                oS400SpooledFileProxy2.setOutputPriority(5);
            } else {
                oS400SpooledFileProxy2.setOutputPriority(Integer.parseInt(spooledFileListItem.getPriority()));
            }
            oS400SpooledFileProxy2.setOutputQueue(spooledFileListItem.getOutputQueueName());
            oS400SpooledFileProxy2.setOutputQueueLibrary(spooledFileListItem.getOutputQueueLibrary());
            oS400SpooledFileProxy2.setStatus(this.lookupStatus(spooledFileListItem.getStatus()));
            oS400SpooledFileProxy2.setSpooledFileName(spooledFileListItem.getName());
            oS400SpooledFileProxy2.setSpooledFileNumber(spooledFileListItem.getNumber());
            oS400SpooledFileProxy2.setTotalPages(spooledFileListItem.getTotalPages());
            oS400SpooledFileProxy2.setUserData(spooledFileListItem.getUserData());
            oS400SpooledFileProxy2.setAuxiliaryStoragePool(spooledFileListItem.getASP());
            oS400SpooledFileProxy2.setSize(spooledFileListItem.getSize() / 1024L);
        }
        catch (RuntimeException runtimeException) {
            ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
            exceptionErrorList.addException((Exception)runtimeException);
            BadDataException badDataException = new BadDataException("Error copying fields into the spooled file.", (Object)oS400SpooledFileProxy2, (ErrorList)exceptionErrorList);
            badDataException.initCause((Throwable)runtimeException);
            throw badDataException;
        }
        catch (Exception exception) {
            String string = "Error retrieving spooled file information.";
            logger.debug((Object)string, (Throwable)exception);
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
        return oS400SpooledFileProxy2;
    }

    private void loadSpooledFile(OS400SpooledFile oS400SpooledFile, SpooledFile spooledFile) throws ResourceUnavailableException {
        try {
            this.loadSpooledFileWithBasicFields(oS400SpooledFile, spooledFile);
            if (spooledFile.getStringAttribute(11).equals("*YES")) {
                oS400SpooledFile.setAlignPage(true);
            } else {
                oS400SpooledFile.setAlignPage(false);
            }
            oS400SpooledFile.setCharactersPerInch(spooledFile.getFloatAttribute(23).floatValue());
            Date date = DateTranslator.unpackDate((String)(spooledFile.getStringAttribute(34) + spooledFile.getStringAttribute(110)));
            oS400SpooledFile.setDateFileOpened(date);
            oS400SpooledFile.setFileBecomesAvailable(this.lookupFileBecomesAvailable(spooledFile.getStringAttribute(107)));
            oS400SpooledFile.setFormFeed(this.lookupFormFeed(spooledFile.getStringAttribute(47)));
            if (spooledFile.getStringAttribute(57).equals("*YES")) {
                oS400SpooledFile.setHoldBeforeWritten(true);
            } else {
                oS400SpooledFile.setHoldBeforeWritten(false);
            }
            oS400SpooledFile.setLastPagePrinted(spooledFile.getIntegerAttribute(63));
            oS400SpooledFile.setLinesPerInch(spooledFile.getFloatAttribute(64).floatValue());
            oS400SpooledFile.setOverflowLineNumber(spooledFile.getIntegerAttribute(76));
            if (spooledFile.getStringAttribute(218).equals("*YES")) {
                oS400SpooledFile.setPageCountEsimate(true);
            } else {
                oS400SpooledFile.setPageCountEsimate(false);
            }
            int n = spooledFile.getIntegerAttribute(108);
            if (n == 0) {
                n = 1;
            }
            oS400SpooledFile.setPageRangeStart(n);
            oS400SpooledFile.setPageRangeEnd(spooledFile.getIntegerAttribute(43));
            oS400SpooledFile.setPageSizeLenth(spooledFile.getFloatAttribute(78).floatValue());
            oS400SpooledFile.setPageSizeWidth(spooledFile.getFloatAttribute(81).floatValue());
            oS400SpooledFile.setPageSizeMeasurementMethod(this.lookupPageSizeMeasurementMethod(spooledFile.getStringAttribute(79)));
            oS400SpooledFile.setPrinterDeviceType(this.lookupPrinterDeviceType(spooledFile.getStringAttribute(90)));
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(spooledFile.getStringAttribute(-7));
            oS400SpooledFile.setPrinterFile(qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName());
            oS400SpooledFile.setPrintQuality(this.lookupPrintQuality(spooledFile.getStringAttribute(86)));
            oS400SpooledFile.setRecordLength(spooledFile.getIntegerAttribute(95));
            oS400SpooledFile.setRestartPrinting(spooledFile.getIntegerAttribute(99));
            if (spooledFile.getStringAttribute(100).equals("*YES")) {
                oS400SpooledFile.setSaveAfterWritten(true);
            } else {
                oS400SpooledFile.setSaveAfterWritten(false);
            }
            oS400SpooledFile.setSourceDrawer(spooledFile.getIntegerAttribute(102));
            oS400SpooledFile.setSystemCreatedOn(spooledFile.getStringAttribute(188));
            oS400SpooledFile.setTotalCopies(spooledFile.getIntegerAttribute(28));
            oS400SpooledFile.setUnitOfMeasure(this.lookupUnitOfMeasure(spooledFile.getStringAttribute(114)));
            this.loadSpooledFileWithProblemData(oS400SpooledFile, spooledFile);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (AS400Exception aS400Exception) {
            String string = OS400Utilities.convertAS400ExceptionToString(aS400Exception);
            logger.debug((Object)string, (Throwable)aS400Exception);
            throw new ResourceUnavailableException(string, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string = "Error loading spooled file object.";
            logger.debug((Object)string, (Throwable)exception);
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    private void loadSpooledFileWithBasicFields(OS400SpooledFile oS400SpooledFile, SpooledFile spooledFile) throws ResourceUnavailableException {
        try {
            oS400SpooledFile.setCopiesLeftToPrint(spooledFile.getIntegerAttribute(29));
            Date date = DateTranslator.unpackDate((String)(spooledFile.getStringAttribute(34) + spooledFile.getStringAttribute(110)));
            oS400SpooledFile.setDateFileOpened(date);
            oS400SpooledFile.setFormType(spooledFile.getStringAttribute(48));
            oS400SpooledFile.setJobName(spooledFile.getStringAttribute(59));
            oS400SpooledFile.setJobNumber(spooledFile.getStringAttribute(60));
            oS400SpooledFile.setJobUser(spooledFile.getStringAttribute(62));
            oS400SpooledFile.setOutputPriority(OS400Utilities.convertObjectToInt(spooledFile.getStringAttribute(72)));
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(spooledFile.getStringAttribute(-6));
            oS400SpooledFile.setOutputQueue(qSYSObjectPathName.getObjectName());
            oS400SpooledFile.setOutputQueueLibrary(qSYSObjectPathName.getLibraryName());
            oS400SpooledFile.setStatus(this.lookupStatus(spooledFile.getStringAttribute(106)));
            oS400SpooledFile.setSpooledFileName(spooledFile.getStringAttribute(104));
            oS400SpooledFile.setSpooledFileNumber(spooledFile.getIntegerAttribute(105));
            oS400SpooledFile.setTotalPages(spooledFile.getIntegerAttribute(111));
            oS400SpooledFile.setUserData(spooledFile.getStringAttribute(116));
        }
        catch (AS400Exception aS400Exception) {
            String string = OS400Utilities.convertAS400ExceptionToString(aS400Exception);
            logger.debug((Object)string, (Throwable)aS400Exception);
            throw new ResourceUnavailableException(string, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string = "Error loading spooled file proxy object.";
            logger.debug((Object)string, (Throwable)exception);
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    private void loadSpooledFileWithProblemData(OS400SpooledFile oS400SpooledFile, SpooledFile spooledFile) {
        String string;
        try {
            oS400SpooledFile.setAccountingCode(spooledFile.getStringAttribute(265));
            oS400SpooledFile.setAuxiliaryStoragePool(spooledFile.getIntegerAttribute(252));
            Date date = DateTranslator.unpackDate((String)spooledFile.getStringAttribute(269), (String)"0000");
            oS400SpooledFile.setDateFileLastUsed(date);
            string = spooledFile.getStringAttribute(271);
            String string2 = spooledFile.getStringAttribute(272);
            if (string2 == null || string2.equals("")) {
                oS400SpooledFile.setProgramThatOpenedFile("");
            } else {
                oS400SpooledFile.setProgramThatOpenedFile(string + "/" + string2);
            }
            int n = spooledFile.getIntegerAttribute(310);
            int n2 = spooledFile.getIntegerAttribute(311);
            oS400SpooledFile.setSize(n * n2 / 1024);
        }
        catch (Exception exception) {
            oS400SpooledFile.setAccountingCode("-98");
            oS400SpooledFile.setAuxiliaryStoragePool(-98);
            oS400SpooledFile.setDateFileLastUsed(null);
            oS400SpooledFile.setProgramThatOpenedFile("-98");
            oS400SpooledFile.setSize(-98L);
            string = "Error retrieving some spooled file attributes.";
            logger.debug((Object)string, (Throwable)exception);
        }
        try {
            oS400SpooledFile.setDeviceType(spooledFile.getStringAttribute(40));
        }
        catch (Exception exception) {
            oS400SpooledFile.setDeviceType("PRINTER");
            string = "Error retrieving some spooled file attributes.";
            logger.debug((Object)string, (Throwable)exception);
        }
    }

    private int lookupStatus(String string) {
        int n = 0;
        n = string.equals("*CLOSED") ? 0 : (string.equals("*DEFERRED") ? 1 : (string.equals("*HELD") ? 2 : (string.equals("*MESSAGE") ? 3 : (string.equals("*OPEN") ? 4 : (string.equals("*PENDING") ? 5 : (string.equals("*PRINTER") ? 6 : (string.equals("*READY") ? 7 : (string.equals("*SAVED") ? 8 : (string.equals("*SENDING") ? 9 : (string.equals("*WRITING") ? 10 : (string.equals("*FINISHED") ? 11 : -99)))))))))));
        return n;
    }

    private int lookupFileBecomesAvailable(String string) {
        int n = 0;
        n = string.equals("*IMMED") ? 0 : (string.equals("*FILEEND") ? 1 : (string.equals("*JOBEND") ? 2 : -99));
        return n;
    }

    private int lookupPrinterDeviceType(String string) {
        int n = 0;
        n = string.equals("*SCS") ? 0 : (string.equals("*IPDS") ? 1 : (string.equals("*AFPDS") ? 2 : (string.equals("*LINE") ? 3 : (string.equals("*AFPDSLINE") ? 4 : (string.equals("*USERASCII") ? 5 : -99)))));
        return n;
    }

    private int lookupPageSizeMeasurementMethod(String string) {
        int n = 0;
        n = string.equals("*ROWCOL") ? 0 : (string.equals("*UOM") ? 1 : -99);
        return n;
    }

    private int lookupPrintQuality(String string) {
        int n = 0;
        n = string.equals("*STD") ? 0 : (string.equals("*DRAFT") ? 1 : (string.equals("*NLQ") ? 2 : (string.equals("*DEVD") ? 3 : (string.equals("*FASTDRAFT") ? 4 : -99))));
        return n;
    }

    private int lookupFormFeed(String string) {
        int n = 0;
        n = string.equals("*CONT") ? 0 : (string.equals("*CONT2") ? 1 : (string.equals("*CUT") ? 2 : (string.equals("*AUTOCUT") ? 3 : (string.equals("*DEVD") ? 4 : -99))));
        return n;
    }

    private int lookupUnitOfMeasure(String string) {
        int n = 0;
        n = string.equals("*INCH") ? 0 : (string.equals("*CM") ? 1 : -99);
        return n;
    }

    @Override
    public DataSet getSpooledFileLineData(UserIdentity userIdentity, OS400SpooledFileProxy oS400SpooledFileProxy) throws ResourceUnavailableException, IllegalArgumentException, NotAuthorizedException {
        ValidationHelper.checkForNull((String)"OS400SpooledFileProxy", (Object)((Object)oS400SpooledFileProxy));
        WrappedAS400 wrappedAS400 = this.createConnectionForUser(userIdentity);
        SpooledFile spooledFile = new SpooledFile((AS400)wrappedAS400, oS400SpooledFileProxy.getSpooledFileName(), oS400SpooledFileProxy.getSpooledFileNumber(), oS400SpooledFileProxy.getJobName(), oS400SpooledFileProxy.getJobUser(), oS400SpooledFileProxy.getJobNumber());
        try {
            if (!spooledFile.getStringAttribute(90).equals("*SCS")) {
                throw new IllegalArgumentException("Cannot view data from non-SCS spooled files.");
            }
            return SpooledFileLineDataSet.createDataSet(wrappedAS400, spooledFile, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (NotAuthorizedException notAuthorizedException) {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
            throw notAuthorizedException;
        }
        catch (Exception exception) {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
            String string = "Error retrieving OS400 spooled file proxy list.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    @Override
    public void save(UserIdentity userIdentity, OS400SpooledFile oS400SpooledFile) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"OS400SpooledFile", (Object)((Object)oS400SpooledFile));
        oS400SpooledFile.validate();
        WrappedAS400 wrappedAS400 = this.createConnectionForUser(userIdentity);
        try {
            SpooledFile spooledFile = new SpooledFile((AS400)wrappedAS400, oS400SpooledFile.getSpooledFileName(), oS400SpooledFile.getSpooledFileNumber(), oS400SpooledFile.getJobName(), oS400SpooledFile.getJobUser(), oS400SpooledFile.getJobNumber());
            PrintParameterList printParameterList = new PrintParameterList();
            this.buildPrintParameterList(userIdentity, oS400SpooledFile, printParameterList);
            spooledFile.setAttributes(printParameterList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (AS400Exception aS400Exception) {
            String string = OS400Utilities.convertAS400ExceptionToString(aS400Exception);
            logger.debug((Object)string, (Throwable)aS400Exception);
            throw new ResourceUnavailableException(string, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string = "Error applying changes to OS400 spooled file.";
            logger.debug((Object)string, (Throwable)exception);
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private void buildPrintParameterList(UserIdentity userIdentity, OS400SpooledFile oS400SpooledFile, PrintParameterList printParameterList) {
        if (oS400SpooledFile.isAlignPage()) {
            printParameterList.setParameter(11, "*YES");
        } else {
            printParameterList.setParameter(11, "*NO");
        }
        printParameterList.setParameter(28, oS400SpooledFile.getCopiesLeftToPrint());
        String string = null;
        int n = oS400SpooledFile.getFormFeed();
        switch (n) {
            case 3: {
                string = "*AUTOCUT";
                break;
            }
            case 0: {
                string = "*CONT";
                break;
            }
            case 1: {
                string = "*CONT2";
                break;
            }
            case 2: {
                string = "*CUT";
                break;
            }
            case 4: {
                string = "*DEVD";
            }
        }
        if (string != null) {
            printParameterList.setParameter(47, string);
        }
        if (oS400SpooledFile.getFormType() != null) {
            printParameterList.setParameter(48, oS400SpooledFile.getFormType());
        }
        printParameterList.setParameter(72, oS400SpooledFile.getOutputPriority());
        String string2 = oS400SpooledFile.getOutputQueue();
        String string3 = oS400SpooledFile.getOutputQueueLibrary();
        if (!os400UtilitiesAM.objectExists(userIdentity, string2, string3, "OUTQ")) {
            throw new IllegalArgumentException(rbh.getMsg("output_queue_not_exist", (Object)string3, (Object)string2));
        }
        Object object = new QSYSObjectPathName(string3, string2, "OUTQ");
        printParameterList.setParameter(-6, object.getPath());
        object = null;
        int n2 = oS400SpooledFile.getPrintQuality();
        switch (n2) {
            case 0: {
                object = "*STD";
                break;
            }
            case 1: {
                object = "*DRAFT";
                break;
            }
            case 2: {
                object = "*NLQ";
                break;
            }
            case 3: {
                object = "*DEVD";
                break;
            }
            case 4: {
                object = "*FASTDRAFT";
            }
        }
        if (object != null) {
            printParameterList.setParameter(86, (String)object);
        }
        printParameterList.setParameter(108, oS400SpooledFile.getPageRangeStart());
        printParameterList.setParameter(43, oS400SpooledFile.getPageRangeEnd());
        if (oS400SpooledFile.getRestartPrinting() != -3) {
            printParameterList.setParameter(99, oS400SpooledFile.getRestartPrinting());
        }
        if (oS400SpooledFile.isSaveAfterWritten()) {
            printParameterList.setParameter(100, "*YES");
        } else {
            printParameterList.setParameter(100, "*NO");
        }
        if (oS400SpooledFile.getUserData() != null) {
            printParameterList.setParameter(116, oS400SpooledFile.getUserData());
        }
    }

    @Override
    public DataFilter[] getDataFilters() {
        DataFilter[] dataFilterArray = new DataFilter[2];
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria(FILTER_FIELD_USER, (Serializable)((Object)"*CURRENT"), 0));
        dataFilter.setDataFilterName(rbh.getText("current_user"));
        dataFilterArray[0] = dataFilter;
        dataFilterArray[1] = new DataFilter(rbh.getText("all_spooled_files"));
        return dataFilterArray;
    }

    @Override
    public FilterField[] getFilterFields() {
        FilterField[] filterFieldArray = new FilterField[]{new FilterFieldString(rbh.getStdMsg("user_noun"), FILTER_FIELD_USER, 10, true, false, 1, new String[]{"0"}), new FilterFieldList(rbh.getStdMsg(FILTER_FIELD_STATUS), FILTER_FIELD_STATUS, OS400SpooledFile.getStatusDescriptions(), OS400SpooledFile.getStatusValues(), "0"), new FilterFieldOS400QualifiedObject(rbh.getText("output_queue"), FILTER_FIELD_OUTQ, new String[]{"*LIBL", "*CURLIB"}), new FilterFieldOS400JobDescriptor(rbh.getText("job_information"), FILTER_FIELD_JOB), new FilterFieldString(rbh.getText("user_data"), FILTER_FIELD_USER_DATA, 10, true, false, 1, new String[]{"0"})};
        return filterFieldArray;
    }

    @Override
    public SortField[] getSortFields() {
        return this.SORT_FIELDS;
    }

    @Override
    public int getFirstLineNumberOfPage(int n, OS400SpooledFileProxy oS400SpooledFileProxy) {
        return n * 68 - 67;
    }
}

