/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.dm.OS400DataQueueDM;
import com.helpsystems.common.core.access.ExistsAlreadyException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueAttributes;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.QSYSObjectPathName;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OS400DataQueueDMAS400
extends AbstractAS400Manager
implements OS400DataQueueDM {
    private static Logger logger = Logger.getLogger(OS400DataQueueDMAS400.class);

    public OS400DataQueueDMAS400(String string, String string2) {
        super(string);
        this.setName(string2);
    }

    @Override
    public void createDataQueue(String string, String string2, int n) throws ResourceUnavailableException, ExistsAlreadyException {
        if (this.dataQueueExists(string, string2)) {
            throw new ExistsAlreadyException("A data queue named " + string2 + " already exists in library " + string);
        }
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName();
            qSYSObjectPathName.setLibraryName(string);
            qSYSObjectPathName.setObjectName(string2);
            qSYSObjectPathName.setObjectType("DTAQ");
            DataQueue dataQueue = new DataQueue((AS400)wrappedAS400, qSYSObjectPathName.getPath());
            DataQueueAttributes dataQueueAttributes = new DataQueueAttributes();
            dataQueueAttributes.setAuthority("*ALL");
            dataQueueAttributes.setDescription(string2);
            dataQueueAttributes.setEntryLength(n);
            dataQueueAttributes.setFIFO(true);
            dataQueueAttributes.setForceToAuxiliaryStorage(false);
            dataQueueAttributes.setSaveSenderInfo(false);
            dataQueue.create(dataQueueAttributes);
        }
        catch (Exception exception) {
            String string3 = "Error creating Data Queue " + string2 + " in library " + string;
            logger.debug((Object)string3, (Throwable)exception);
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean dataQueueExists(String string, String string2) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName();
            qSYSObjectPathName.setLibraryName(string);
            qSYSObjectPathName.setObjectName(string2);
            qSYSObjectPathName.setObjectType("DTAQ");
            DataQueue dataQueue = new DataQueue((AS400)wrappedAS400, qSYSObjectPathName.getPath());
            boolean bl = dataQueue.exists();
            return bl;
        }
        catch (Exception exception) {
            String string3 = "Error checking if Data Queue " + string2 + " in library " + string + " already exists.";
            logger.debug((Object)string3, (Throwable)exception);
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public byte[][] getDataQueueEntries(String string, String string2) throws ResourceUnavailableException {
        return this.getDataQueueEntries(string, string2, -1);
    }

    @Override
    public byte[][] getDataQueueEntries(String string, String string2, int n) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        DataQueueEntry dataQueueEntry = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        int n2 = 4096;
        boolean bl = false;
        try {
            wrappedAS400 = this.borrowConnection();
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName();
            qSYSObjectPathName.setLibraryName(string);
            qSYSObjectPathName.setObjectName(string2);
            qSYSObjectPathName.setObjectType("DTAQ");
            DataQueue dataQueue = new DataQueue((AS400)wrappedAS400, qSYSObjectPathName.getPath());
            while (!bl) {
                dataQueueEntry = dataQueue.read(n);
                if (dataQueueEntry == null) {
                    bl = true;
                    continue;
                }
                byte[] byArray = dataQueueEntry.getData();
                if (byArray.length < n2) {
                    Object object2 = new byte[n2];
                    System.arraycopy(byArray, 0, object2, 0, byArray.length);
                    for (int i = byArray.length; i < n2; ++i) {
                        object2[i] = 64;
                    }
                    arrayList.add(object2);
                    continue;
                }
                arrayList.add(byArray);
            }
            if (arrayList.size() > 0) {
                object = new byte[arrayList.size()][];
                int n3 = 0;
                for (byte[] byArray : arrayList) {
                    object[n3] = byArray;
                    ++n3;
                }
            }
            byte[][] byArray = object;
            return byArray;
        }
        catch (Exception exception) {
            String string3 = "Error reading from Data Queue " + string2 + " in library " + string;
            logger.debug((Object)string3, (Throwable)exception);
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void putDataQueueEntry(String string, String string2, String string3) throws ResourceUnavailableException {
        byte[] byArray = null;
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            byArray = CharConverter.stringToByteArray((AS400)wrappedAS400, (String)string3);
        }
        catch (Exception exception) {
            String string4 = "Unble to convert data queue entry.";
            logger.debug((Object)string4, (Throwable)exception);
            throw new ResourceUnavailableException(string4, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
                wrappedAS400 = null;
            }
        }
        this.putDataQueueEntry(string, string2, byArray);
    }

    @Override
    public void putDataQueueEntry(String string, String string2, byte[] byArray) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName();
            qSYSObjectPathName.setLibraryName(string);
            qSYSObjectPathName.setObjectName(string2);
            qSYSObjectPathName.setObjectType("DTAQ");
            DataQueue dataQueue = new DataQueue((AS400)wrappedAS400, qSYSObjectPathName.getPath());
            dataQueue.write(byArray);
        }
        catch (Exception exception) {
            String string3 = "Error writing data to Data Queue " + string2 + " in library " + string;
            logger.debug((Object)string3, (Throwable)exception);
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
                wrappedAS400 = null;
            }
        }
    }
}

