/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400CommonPCMLManager;
import com.helpsystems.common.as400.access.AS400UserListManager;
import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.CcsidManager;
import com.helpsystems.common.as400.access.DateConversionProgramCallPCML;
import com.helpsystems.common.as400.access.IFSFileManager;
import com.helpsystems.common.as400.access.IFSJavaFileDMAS400;
import com.helpsystems.common.as400.access.InstalledProductsDMAS400;
import com.helpsystems.common.as400.access.LibraryManager;
import com.helpsystems.common.as400.access.LicensedProductDMAS400;
import com.helpsystems.common.as400.access.OS400CommandInfoPCML;
import com.helpsystems.common.as400.access.OS400DataQueueDMAS400;
import com.helpsystems.common.as400.access.OS400JobAMAS400;
import com.helpsystems.common.as400.access.OS400JobDMAS400;
import com.helpsystems.common.as400.access.OS400MessageDMAS400;
import com.helpsystems.common.as400.access.OS400MessageDescriptionDMAS400;
import com.helpsystems.common.as400.access.OS400ProductLicenseDMAS400;
import com.helpsystems.common.as400.access.OS400ProfileDMAS400;
import com.helpsystems.common.as400.access.OS400ServerInfoDMAS400;
import com.helpsystems.common.as400.access.OS400SpooledFileAMAS400;
import com.helpsystems.common.as400.access.OS400SpooledFileDMAS400;
import com.helpsystems.common.as400.access.OS400SupportPCML;
import com.helpsystems.common.as400.access.OS400SystemStatusDMAS400;
import com.helpsystems.common.as400.access.OS400UtilitiesAMAS400;
import com.helpsystems.common.as400.access.ProductSupportPCML;
import com.helpsystems.common.as400.access.RelModDMAS400;
import com.helpsystems.common.as400.access.RemoteFileAMAS400;
import com.helpsystems.common.as400.access.SoftCmdLicenseDMAS400;
import com.helpsystems.common.as400.access.SystemInformationDMAS400;
import com.helpsystems.common.as400.access.SystemValueManager;
import com.helpsystems.common.as400.alert.RecipientAMAS400;
import com.helpsystems.common.as400.busobj.OS400LibraryList;
import com.helpsystems.common.as400.console.ConsoleProgramCallPCML;
import com.helpsystems.common.as400.dm.ISystemValueManager;
import com.helpsystems.common.as400.ex.RobotSyslibUnavailableException;
import com.helpsystems.common.as400.network.StatusMessageAMAS400;
import com.helpsystems.common.as400.schedule.CommonScheduleJobPCML;
import com.helpsystems.common.as400.schedule.ReservedCommandVariableAMAS400;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.AbstractManagerLoader;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.busobj.InstalledProducts;
import com.helpsystems.common.core.busobj.LocalizedDate;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.util.RelMod;
import com.ibm.as400.data.PcmlException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class CommonPCMLLoader
extends AbstractManagerLoader {
    private static final Logger logger = Logger.getLogger(CommonPCMLLoader.class);
    private ArrayList<String> managerIDs = new ArrayList();
    private String as400PoolName = null;
    private String suffix;
    private String originalSuffix;
    private String applicationName = null;
    private String rsldftOverride = null;
    private RelMod interfaceRelMod = null;
    private ProductSupportPCML productManager;
    private InstalledProductsDMAS400 ipDM;
    private boolean overrideAs400ObjectCcsid;
    private boolean overrideAs400ObjectCcsidFlagHasBeenSet;

    public CommonPCMLLoader(String string, String string2) {
        this(string, string2, null);
    }

    public CommonPCMLLoader(String string, String string2, String string3) {
        if (string == null || string.trim().length() < 1) {
            throw new NullPointerException("The database AS400 pool name passed in is null.");
        }
        this.as400PoolName = string;
        this.suffix = string3;
        this.originalSuffix = string3;
        this.applicationName = string2 == null || string2.trim().length() < 1 ? "COMMON" : string2;
    }

    public void loadAll() throws ResourceUnavailableException {
        this.loadCommonPCMLManagers();
        this.loadInstalledProducts();
        this.loadProductCommonManagers();
    }

    public void unloadAll() {
        if (this.managerIDs.size() < 1) {
            logger.trace((Object)"No common PCML Data Managers exist to unload.");
        } else {
            logger.trace((Object)"Unloading PCML Data Mangers.");
        }
        for (int i = 0; i < this.managerIDs.size(); ++i) {
            String string = this.managerIDs.get(i);
            IAbstractManager iAbstractManager = ManagerRegistry.removeManager((String)string);
            if (iAbstractManager == null) {
                logger.debug((Object)("  ** Failed removing manger: " + string + " **"));
                continue;
            }
            logger.trace((Object)(" Common PCML Manager was removed: " + string));
        }
        LocalizedDate.setLocalTimeZone(null);
    }

    private void loadPCMLManager(AbstractManager abstractManager) {
        String string;
        abstractManager.setInterfaceVersion(this.interfaceRelMod);
        this.setAdditionalManagerAttributes(abstractManager);
        if (this.suffix != null && this.suffix.length() > 0 && !(string = abstractManager.getName()).endsWith(this.suffix)) {
            abstractManager.setName(string, this.suffix);
        }
        string = abstractManager.getName();
        logger.trace((Object)(" loading PCML Manger: " + string));
        this.managerIDs.add(string);
        ManagerRegistry.registerManager((IAbstractManager)abstractManager);
    }

    private void loadCommonPCMLManagers() throws ResourceUnavailableException {
        logger.trace((Object)"Loading the Common PCML data managers.");
        try {
            RelModDMAS400 relModDMAS400 = new RelModDMAS400("RBTSYSLIB", this.as400PoolName, "SYSRELMOD", "RSLIVER", "COMMON.RelModDM");
            try {
                this.interfaceRelMod = relModDMAS400.retrieveInterfaceVersion();
            }
            catch (NoDataException noDataException) {
                logger.debug((Object)noDataException);
                throw new RobotSyslibUnavailableException("Unable to get Release/Modification data.", noDataException);
            }
            this.loadPCMLManager(relModDMAS400);
            LibraryManager libraryManager = new LibraryManager(this.as400PoolName);
            this.loadPCMLManager(libraryManager);
            OS400SupportPCML oS400SupportPCML = new OS400SupportPCML(this.as400PoolName);
            this.loadPCMLManager(oS400SupportPCML);
            this.productManager = new ProductSupportPCML(this.as400PoolName, libraryManager, oS400SupportPCML);
            this.loadPCMLManager(this.productManager);
            AbstractAS400Manager abstractAS400Manager = new IFSFileManager(this.as400PoolName);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new IFSJavaFileDMAS400(this.as400PoolName, "COMMON.IFSJavaFileDM");
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400ProductLicenseDMAS400(this.as400PoolName);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new LicensedProductDMAS400(this.as400PoolName);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new SoftCmdLicenseDMAS400(this.as400PoolName);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400DataQueueDMAS400(this.as400PoolName, "COMMON.OS400DataQueueDM");
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400JobDMAS400(this.as400PoolName, "COMMON.OS400JobDM");
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400JobAMAS400(this.as400PoolName, "COMMON.OS400JobAM");
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400MessageDMAS400(this.as400PoolName, null, "COMMON.OS400MessageDM");
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400ProfileDMAS400(this.as400PoolName, "COMMON.OS400ProfileDM");
            this.loadPCMLManager(abstractAS400Manager);
            AS400CommonPCMLManager aS400CommonPCMLManager = new AS400CommonPCMLManager("COMMON.IAS400CommonPCMLManager", this.as400PoolName);
            this.loadPCMLManager(aS400CommonPCMLManager);
            SystemValueManager systemValueManager = new SystemValueManager(this.as400PoolName);
            this.loadPCMLManager(systemValueManager);
            this.fetchTimeZone(systemValueManager);
            SystemInformationDMAS400 systemInformationDMAS400 = new SystemInformationDMAS400(systemValueManager, aS400CommonPCMLManager, "COMMON.SystemInformationDM");
            this.loadPCMLManager(systemInformationDMAS400);
            abstractAS400Manager = new OS400CommandInfoPCML(this.as400PoolName);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new DateConversionProgramCallPCML(this.as400PoolName);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400SpooledFileAMAS400(this.as400PoolName, "COMMON.OS400SpooledFileAM");
            this.loadPCMLManager(abstractAS400Manager);
            OS400UtilitiesAMAS400 oS400UtilitiesAMAS400 = new OS400UtilitiesAMAS400(this.as400PoolName, "COMMON.OS400UtilitiesAM");
            this.loadPCMLManager(oS400UtilitiesAMAS400);
            abstractAS400Manager = new OS400SpooledFileDMAS400(this.as400PoolName, "COMMON.OS400SpooledFileDM", oS400UtilitiesAMAS400);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400MessageDescriptionDMAS400(this.as400PoolName, "COMMON.OS400MessageDescriptionDM", oS400UtilitiesAMAS400);
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400ServerInfoDMAS400(this.as400PoolName, null, "COMMON.ServerInfoDM");
            this.loadPCMLManager(abstractAS400Manager);
            abstractAS400Manager = new OS400SystemStatusDMAS400(this.as400PoolName, "COMMON.OS400SystemStatusDM");
            this.loadPCMLManager(abstractAS400Manager);
            AS400UserListManager aS400UserListManager = new AS400UserListManager(this.as400PoolName, "COMMON.UserListManager");
            this.loadPCMLManager(aS400UserListManager);
            aS400UserListManager = new AS400UserListManager(this.as400PoolName, "COMMON.AS400UserListManager");
            this.loadPCMLManager(aS400UserListManager);
            RemoteFileAMAS400 remoteFileAMAS400 = new RemoteFileAMAS400(this.as400PoolName, "COMMON.RemoteFileAM");
            this.loadPCMLManager(remoteFileAMAS400);
            this.ipDM = new InstalledProductsDMAS400(this.as400PoolName, "COMMON.InstalledProductsDM");
            this.loadPCMLManager(this.ipDM);
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to create a Common PCML manager.", (Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadProductCommonManagers() throws ResourceUnavailableException {
        logger.trace((Object)"Loading the Product Common PCML data managers.");
        try {
            String string = InstalledProduct.getApplCode((int)2);
            InstalledProduct installedProduct = InstalledProducts.getInstance().getInstalledProduct(string, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadAlertManagers(installedProduct.getLibraryName());
            }
            string = InstalledProduct.getApplCode((int)3);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct(string, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadConsoleManagers(installedProduct.getLibraryName());
            }
            string = InstalledProduct.getApplCode((int)10);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct(string, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadNetworkManagers(installedProduct.getLibraryName());
            }
            string = InstalledProduct.getApplCode((int)1);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct(string, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadScheduleManagers(installedProduct.getLibraryName());
            }
            string = InstalledProduct.getApplCode((int)28);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct(string, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct == null || installedProduct.isInstalled()) {
                // empty if block
            }
            string = InstalledProduct.getApplCode((int)20);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct(string, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && !installedProduct.isInstalled()) return;
        }
        catch (Exception exception) {
            if (!(exception instanceof ResourceUnavailableException)) throw new ResourceUnavailableException("Unable to create a Common PCML manager.", (Throwable)exception);
            throw (ResourceUnavailableException)((Object)exception);
        }
    }

    private void loadConsoleManagers(String string) throws PcmlException {
        CcsidManager ccsidManager = new CcsidManager();
        ccsidManager.setCcsidOfDBField(this.ccsidOfDBField());
        CcsidManager ccsidManager2 = ccsidManager;
        ccsidManager2.setName("COMMON.EncodingManager");
        this.temporarilyReplaceLoaderSuffixWith("CONSOLE");
        this.loadPCMLManager(ccsidManager2);
        this.restoreLoaderSuffix();
        ConsoleProgramCallPCML consoleProgramCallPCML = new ConsoleProgramCallPCML(this.as400PoolName, string, this.ipDM);
        this.loadPCMLManager(consoleProgramCallPCML);
    }

    private void loadAlertManagers(String string) throws PcmlException {
        CcsidManager ccsidManager = new CcsidManager();
        ccsidManager.setCcsidOfDBField(this.ccsidOfDBField());
        CcsidManager ccsidManager2 = ccsidManager;
        ccsidManager2.setName("COMMON.EncodingManager");
        this.temporarilyReplaceLoaderSuffixWith("ALERT");
        this.loadPCMLManager(ccsidManager2);
        this.restoreLoaderSuffix();
        RecipientAMAS400 recipientAMAS400 = new RecipientAMAS400(this.as400PoolName, string, this.ipDM);
        this.loadPCMLManager(recipientAMAS400);
    }

    private void loadNetworkManagers(String string) throws PcmlException {
        CcsidManager ccsidManager = new CcsidManager();
        ccsidManager.setCcsidOfDBField(this.ccsidOfDBField());
        CcsidManager ccsidManager2 = ccsidManager;
        ccsidManager2.setName("COMMON.EncodingManager");
        this.temporarilyReplaceLoaderSuffixWith("NETWORK");
        this.loadPCMLManager(ccsidManager2);
        this.restoreLoaderSuffix();
        StatusMessageAMAS400 statusMessageAMAS400 = new StatusMessageAMAS400(this.as400PoolName, string);
        this.loadPCMLManager(statusMessageAMAS400);
    }

    private void loadScheduleManagers(String string) throws PcmlException {
        CcsidManager ccsidManager = new CcsidManager();
        ccsidManager.setCcsidOfDBField(this.ccsidOfDBField());
        CcsidManager ccsidManager2 = ccsidManager;
        ccsidManager2.setName("COMMON.EncodingManager");
        this.temporarilyReplaceLoaderSuffixWith("SCHEDULE");
        this.loadPCMLManager(ccsidManager2);
        this.restoreLoaderSuffix();
        AbstractProgramCallManager abstractProgramCallManager = new CommonScheduleJobPCML(this.as400PoolName, string);
        this.loadPCMLManager(abstractProgramCallManager);
        abstractProgramCallManager = new ReservedCommandVariableAMAS400(this.as400PoolName, string);
        this.loadPCMLManager(abstractProgramCallManager);
        if (this.getEnvironment() == 1) {
            String string2 = InstalledProduct.getApplCode((int)14);
            InstalledProduct installedProduct = InstalledProducts.getInstance().getInstalledProduct(string2, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                abstractProgramCallManager = new CommonScheduleJobPCML(this.as400PoolName, string);
                abstractProgramCallManager.setName("COMMON.CommonScheduleJobDM", "_HPI");
                this.loadPCMLManager(abstractProgramCallManager);
                abstractProgramCallManager = new CommonScheduleJobPCML(this.as400PoolName, string);
                OS400LibraryList oS400LibraryList = new OS400LibraryList();
                oS400LibraryList.addLibrary(installedProduct.getLibraryName());
                oS400LibraryList.addLibrary(string);
                abstractProgramCallManager.setLibraryList(oS400LibraryList);
                abstractProgramCallManager.setName("COMMON.CommonScheduleJobDM", "_PM");
                this.loadPCMLManager(abstractProgramCallManager);
                abstractProgramCallManager = new ReservedCommandVariableAMAS400(this.as400PoolName, string);
                abstractProgramCallManager.setLibraryList(oS400LibraryList);
                abstractProgramCallManager.setName("COMMON.ReservedCommandVariableAM", "_PM");
                this.loadPCMLManager(abstractProgramCallManager);
            }
        }
    }

    private int ccsidOfDBField() {
        int n = 0;
        ISystemValueManager iSystemValueManager = (ISystemValueManager)ManagerRegistry.getManagerOrFail((String)"COMMON.SystemValueManager", (String)this.suffix);
        try {
            Integer n2 = (Integer)iSystemValueManager.getSystemValue("QCCSID");
            n = n2;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RuntimeException("Error retrieving the QCCSID System value.", resourceUnavailableException);
        }
        if (n == 65535) {
            return 37;
        }
        return n;
    }

    private void temporarilyReplaceLoaderSuffixWith(String string) {
        this.suffix = string;
    }

    private void restoreLoaderSuffix() {
        this.suffix = this.originalSuffix;
    }

    private void setAdditionalManagerAttributes(AbstractManager abstractManager) {
        if (abstractManager instanceof AbstractAS400Manager) {
            AbstractAS400Manager abstractAS400Manager = (AbstractAS400Manager)abstractManager;
            if (!this.overrideAs400ObjectCcsidFlagHasBeenSet) {
                this.overrideAs400ObjectCcsid = true;
                this.overrideAs400ObjectCcsidFlagHasBeenSet = true;
            }
            abstractAS400Manager.setOverrideAS400ObjectCcsid(this.overrideAs400ObjectCcsid);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getAs400PoolName() {
        return this.as400PoolName;
    }

    public String getRsldftOverride() {
        return this.rsldftOverride;
    }

    private void loadInstalledProducts() throws ResourceUnavailableException {
        InstalledProducts installedProducts = InstalledProducts.getInstance();
        InstalledProduct[] installedProductArray = this.ipDM.getInstalledProducts();
        for (int i = 0; i < installedProductArray.length; ++i) {
            installedProducts.add(installedProductArray[i], (BasicIdentifier)ProductIID.DIRECT_CONNECT);
        }
    }

    private void fetchTimeZone(SystemValueManager systemValueManager) {
        try {
            CharSequence charSequence;
            TimeZone timeZone = null;
            TimeZone timeZone2 = TimeZone.getTimeZone("A really bogus timezone ID");
            String string = (String)systemValueManager.getSystemValue("QUTCOFFSET");
            String string2 = null;
            try {
                string2 = (String)systemValueManager.getSystemValue("QTIMZON");
                string2 = string2.trim();
                charSequence = this.lookupIBMTimeZone(string2);
                if (charSequence != null) {
                    string2 = charSequence;
                    timeZone = TimeZone.getTimeZone((String)charSequence);
                } else {
                    timeZone = this.guessTimeZone(string2);
                }
            }
            catch (Exception exception) {
                if (string2 == null) {
                    logger.trace((Object)"System does not support QTIMZON system value. Using UTC offset instead.", (Throwable)exception);
                } else {
                    logger.trace((Object)("Unable to parse timezone " + string2 + ", Using UTC offset instead."), (Throwable)exception);
                }
                timeZone = null;
            }
            if (timeZone == null) {
                charSequence = new StringBuffer(string);
                for (int i = ((StringBuffer)charSequence).length() - 1; i > 0; --i) {
                    char c = ((StringBuffer)charSequence).charAt(i);
                    if (Character.isDigit(c)) continue;
                    ((StringBuffer)charSequence).deleteCharAt(i);
                }
                String string3 = ((StringBuffer)charSequence).toString();
                timeZone = TimeZone.getTimeZone("GMT" + string3);
                if (timeZone.equals(timeZone2)) {
                    throw new ParseException(string + " [" + string3 + "]", 0);
                }
            }
            if (timeZone != null) {
                logger.trace((Object)("Remote system timezone is interpreted as " + timeZone.getID()));
                LocalizedDate.setLocalTimeZone((TimeZone)timeZone);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to determine the time zone of this system.", (Throwable)exception);
        }
    }

    private TimeZone guessTimeZone(String string) throws ParseException {
        TimeZone timeZone = null;
        TimeZone timeZone2 = TimeZone.getTimeZone("A really bogus timezone ID");
        String string2 = string;
        while (string2.length() > 0 && Character.isDigit(string2.charAt(string2.length() - 1))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (!bl) {
                if (!Character.isDigit(c)) continue;
                bl = true;
                continue;
            }
            if (Character.isDigit(c)) continue;
            String string3 = string2.substring(i);
            timeZone = TimeZone.getTimeZone(string3);
            if (!timeZone.equals(timeZone2)) break;
            throw new ParseException(string2, i);
        }
        return timeZone;
    }

    private String lookupIBMTimeZone(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        if (string2.equals("QN0500EST") || string2.equals("QN0500EST3")) {
            return "America/New_York";
        }
        if (string2.equals("QN0500EST2")) {
            return "EST";
        }
        if (string2.equals("QN0600CST") || string2.equals("QN0600CST2")) {
            return "America/Chicago";
        }
        if (string2.equals("QN0700MST") || string2.equals("QN0700MST3")) {
            return "America/Denver";
        }
        if (string2.equals("QN0700MST2")) {
            return "MST";
        }
        if (string2.equals("QN0800PST") || string2.equals("QN0800PST2")) {
            return "America/Los_Angeles";
        }
        if (string2.equals("QN0900AST") || string2.equals("QN0900AST2")) {
            return "US/Alaska";
        }
        if (string2.equals("QN1000HAS") || string2.equals("QN1000HAS2")) {
            return "US/Hawaii";
        }
        return null;
    }
}

