/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.PCMLUtil;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.ibm.as400.access.AS400;
import java.beans.PropertyVetoException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;

public class AS400ConnectionFactory
implements PoolableObjectFactory {
    static Logger logger = Logger.getLogger(AS400ConnectionFactory.class);
    private String serverAddress;
    private String username;
    private String password;
    private String rbtsyslib;
    private String sysLibOverride;
    private boolean cleanSystemLibraryList = true;

    public AS400ConnectionFactory(String string, String string2, String string3) {
        this.serverAddress = string;
        this.username = string2.toUpperCase();
        this.password = string3;
    }

    public void activateObject(Object object) {
    }

    public void destroyObject(Object object) {
        if (!(object instanceof AS400)) {
            return;
        }
        AS400 aS400 = (AS400)object;
        aS400.disconnectAllServices();
    }

    public String getSysLibrary() {
        return this.rbtsyslib;
    }

    public String getSysLibOverride() {
        return this.sysLibOverride;
    }

    public void setCleanSystemLibraryList(boolean bl) {
        this.cleanSystemLibraryList = bl;
    }

    public Object makeObject() throws Exception {
        return this.makeObject(this.username, this.password);
    }

    public Object makeObject(String string, String string2) throws Exception {
        WrappedAS400 wrappedAS400 = new WrappedAS400(this.serverAddress, string);
        wrappedAS400.setPassword(string2);
        AS400ConnectionFactory.signonConnection(wrappedAS400);
        return wrappedAS400;
    }

    public static void signonConnection(AS400 aS400) throws Exception {
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.debug((Object)"Warning: The AS400 object rejected the property setGuiAvailable(false). Unwanted GUI prompting may occur.");
        }
        AS400.setPasswordExpirationWarningDays((int)-1);
        aS400.validateSignon();
    }

    public void passivateObject(Object object) {
    }

    public void setSysLibrary(String string) {
        this.rbtsyslib = string;
    }

    public void setSyslibOverride(String string) {
        this.sysLibOverride = string;
    }

    public boolean validateObject(Object object) {
        return object != null;
    }

    protected boolean checkUser(AS400 aS400) {
        if (aS400 == null) {
            return false;
        }
        String string = this.password;
        try {
            String string2 = PCMLUtil.whoami(aS400);
            if (this.username.equalsIgnoreCase(string2)) {
                return true;
            }
            if (string == null || string.length() == 0 || string.equals("*CURRENT")) {
                return false;
            }
            byte[] byArray = PCMLUtil.generateToken(aS400, this.username, string);
            boolean bl = PCMLUtil.swap(aS400, byArray);
            if (!bl) {
                return false;
            }
            string2 = PCMLUtil.whoami(aS400);
            return this.username.equalsIgnoreCase(string2);
        }
        catch (Exception exception) {
            logger.debug((Object)"CheckUser failed.", (Throwable)exception);
            return false;
        }
    }

    public String getServerAddress() {
        return this.serverAddress;
    }
}

