/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.rbtschedule.SkybotJob;
import com.helpsystems.enterprise.core.dm.rbtschedule.SkybotServerHelperDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteScheduleServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerRequestType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.remoteserver.RemoteScheduleServerInstaller;
import com.helpsystems.enterprise.remoteserver.ReqQEntryFormat;
import com.helpsystems.enterprise.remoteserver.RespQEntryFormat;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.KeyedDataQueue;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteServerRequestMonitor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RemoteServerRequestMonitor.class);
    private long remoteServerID;
    private static final String REQUEST_Q_NAME = "REQQ";
    private static final String RESPONSE_Q_NAME = "RESPQ";
    private String library = "ROBOTLIB";
    public static int CONNECTION_TIMEOUT = 50;
    private KeyedDataQueue responseQ;
    private DataQueue requestQ;
    private final RemoteScheduleServerInstaller rmScheduleServerInstaller = new RemoteScheduleServerInstaller();
    private RemoteScheduleServer remoteServer = null;
    private AS400 as400 = null;

    public RemoteServerRequestMonitor(long l) {
        this.remoteServerID = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info((Object)"Starting Remote Server Request Monitor...");
        try {
            try {
                while (true) {
                    this.confirmConnection(this.remoteServerID);
                    this.library = this.remoteServer.getLibrary();
                    if (this.requestQ == null) {
                        this.requestQ = this.rmScheduleServerInstaller.getDataQueue(this.library, REQUEST_Q_NAME, this.as400);
                    }
                    if (this.responseQ == null) {
                        this.responseQ = this.rmScheduleServerInstaller.getKeyedDataQueue(this.library, RESPONSE_Q_NAME, this.as400);
                    }
                    DataQueueEntry dataQueueEntry = this.requestQ.read(CONNECTION_TIMEOUT);
                    boolean bl = false;
                    byte[] byArray = new byte[]{};
                    if (dataQueueEntry != null) {
                        byArray = dataQueueEntry.getData();
                        this.manageQueues(byArray);
                    } else {
                        bl = true;
                    }
                    if (byArray.length <= 0 && !bl) continue;
                    if (bl) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)("Request Data Queue has timed out from " + this.as400.getSystemName()));
                        continue;
                    }
                    if (byArray.length <= 0) continue;
                    LOGGER.debug((Object)("Request Data Queue data is empty from " + this.as400.getSystemName()));
                }
            }
            catch (Exception exception) {
                String string = "Remote Server Request Monitor error.";
                LOGGER.error((Object)string, (Throwable)exception);
                this.closeConnection();
            }
        }
        catch (Throwable throwable) {
            this.closeConnection();
            throw throwable;
        }
        LOGGER.info((Object)"Ending Remote Server Request Monitor...");
    }

    private void confirmConnection(long l) throws ResourceUnavailableException, RemoteServerException {
        RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServersDM");
        RemoteScheduleServer remoteScheduleServer = (RemoteScheduleServer)remoteServersDM.getServer(l);
        if (remoteScheduleServer == null) {
            throw new ResourceUnavailableException("Remote Server not found for ID: " + l);
        }
        if (this.remoteServer == null) {
            this.remoteServer = remoteScheduleServer;
            this.closeConnection();
        } else {
            String string = remoteScheduleServer.getSystemName();
            String string2 = this.remoteServer.getSystemName();
            String string3 = remoteScheduleServer.getUser();
            String string4 = this.remoteServer.getUser();
            String string5 = remoteScheduleServer.getPwd();
            String string6 = this.remoteServer.getPwd();
            if (!(string.equals(string2) && string3.equals(string4) && string5.equals(string6))) {
                LOGGER.debug((Object)("Change detected for remote server " + remoteScheduleServer.getName() + "."));
                this.closeConnection();
                this.remoteServer = remoteScheduleServer;
            }
        }
        if (this.as400 == null) {
            this.as400 = this.rmScheduleServerInstaller.establishConnection(this.remoteServer);
        }
    }

    private void closeConnection() {
        this.requestQ = null;
        this.responseQ = null;
        if (this.as400 != null) {
            try {
                this.as400.disconnectAllServices();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.as400 = null;
        }
    }

    private void manageQueues(byte[] byArray) throws UnsupportedEncodingException, DataException, ResourceUnavailableException {
        ReqQEntryFormat reqQEntryFormat = new ReqQEntryFormat();
        Record record = reqQEntryFormat.getNewRecord(byArray);
        long l = (Long)record.getField("RequestKey");
        RemoteServerRequestType remoteServerRequestType = RemoteServerRequestType.persistanceCodeToEnum((int)((Integer)record.getField("RequestType")));
        int n = (Integer)record.getField("JobType");
        SkybotServerHelperDM skybotServerHelperDM = (SkybotServerHelperDM)ManagerRegistry.getManager((String)"ENTERPRISE.SkybotServerHelper");
        switch (remoteServerRequestType) {
            case GET_EVENTS: {
                List list = skybotServerHelperDM.getEventList(JobType.persistanceCodeToEnum((Integer)n));
                this.addEventsToRespQ(list, l);
                break;
            }
            case GET_NOTIFIABLE_EVENT_STATUSES: {
                List list = skybotServerHelperDM.getNotifiableEventStatuses(JobType.persistanceCodeToEnum((Integer)n));
                int n2 = list.size();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append((String)list.get(i));
                    if (i == n2 - 1) continue;
                    stringBuilder.append(",");
                }
                this.addStatusesToRespQ(stringBuilder.toString(), n, l);
                break;
            }
            case NOTIFY_OF_DEPENDENCY: {
                break;
            }
        }
    }

    private void addEventsToRespQ(List<SkybotJob> list, long l) {
        this.addFirstRecordToRespQ(l);
        for (SkybotJob skybotJob : list) {
            Record record = new Record((RecordFormat)new RespQEntryFormat());
            long l2 = skybotJob.getId();
            record.setField("ResponseType", (Object)1);
            record.setField("JobID", (Object)l2);
            record.setField("JobName", (Object)skybotJob.getName());
            record.setField("JobType", (Object)skybotJob.getType().persistanceCode());
            record.setField("RequestType", (Object)RemoteServerRequestType.GET_EVENTS.persistanceCode());
            try {
                byte[] byArray = record.getContents();
                if (this.responseQ == null) continue;
                this.responseQ.write(ByteBuffer.allocate(8).putLong(l).array(), byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error((Object)("UnsupportedEncodingException: Error processing event entry for job ID " + l2), (Throwable)unsupportedEncodingException);
            }
            catch (CharConversionException charConversionException) {
                LOGGER.error((Object)("CharConversionException: Error processing event entry for job ID " + l2), (Throwable)charConversionException);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error processing event entry for job ID " + l2), (Throwable)exception);
            }
        }
        this.addLastRecordToRespQ(l, list.size());
    }

    private void addStatusesToRespQ(String string, int n, long l) {
        Record record = new Record((RecordFormat)new RespQEntryFormat());
        this.addFirstRecordToRespQ(l);
        record.setField("ResponseType", (Object)1);
        record.setField("JobType", (Object)n);
        record.setField("StatusList", (Object)string);
        record.setField("RequestType", (Object)RemoteServerRequestType.GET_NOTIFIABLE_EVENT_STATUSES.persistanceCode());
        try {
            byte[] byArray = record.getContents();
            if (this.responseQ != null) {
                this.responseQ.write(ByteBuffer.allocate(8).putLong(l).array(), byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error((Object)("UnsupportedEncodingException: Error processing status entry for request key " + l + " job type " + n), (Throwable)unsupportedEncodingException);
        }
        catch (CharConversionException charConversionException) {
            LOGGER.error((Object)("CharConversionException: Error processing status entry for request key " + l + " job type " + n), (Throwable)charConversionException);
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error processing status entry for request key " + l + " job type " + n), (Throwable)exception);
        }
        this.addLastRecordToRespQ(l, string.length());
    }

    private void addFirstRecordToRespQ(long l) {
        Record record = new Record((RecordFormat)new RespQEntryFormat());
        record.setField("ResponseType", (Object)0);
        try {
            if (this.responseQ != null) {
                this.responseQ.write(ByteBuffer.allocate(8).putLong(l).array(), record.getContents());
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error writing the first record to response queue for request key: " + l), (Throwable)exception);
        }
    }

    private void addLastRecordToRespQ(long l, int n) {
        Record record = new Record((RecordFormat)new RespQEntryFormat());
        record.setField("ResponseType", (Object)2);
        record.setField("ResponseCount", (Object)n);
        try {
            if (this.responseQ != null) {
                this.responseQ.write(ByteBuffer.allocate(8).putLong(l).array(), record.getContents());
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error writing the last record to response queue for request key " + l + " with response count " + n), (Throwable)exception);
        }
    }
}

