/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEvent;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventDM;
import com.helpsystems.enterprise.core.remoteserver.RegisteredServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteScheduleServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerNotConfiguredException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.remoteserver.RemoteServerDMScheduleImpl;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.KeyedDataQueue;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteScheduleServerInstaller {
    private static final Logger logger = Logger.getLogger(RemoteScheduleServerInstaller.class);

    public long install(long l, RemoteServerDMScheduleImpl remoteServerDMScheduleImpl) throws RemoteServerException {
        RemoteScheduleServer remoteScheduleServer;
        try {
            remoteScheduleServer = this.getRemoteServerInfo(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"The creation of the required data queue (and/or database entry) needed to interact with remote server {0} failed.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
        }
        String string = "NOTIFQ";
        String string2 = remoteScheduleServer.getLibrary();
        AS400 aS400 = this.establishConnection(remoteScheduleServer);
        try {
            long l2;
            this.validateScheduleInstalled(aS400, remoteScheduleServer);
            this.validateSkybotNotAlreadyInstalled(remoteServerDMScheduleImpl, remoteScheduleServer);
            try {
                this.createDataQueue(string2, string, aS400);
            }
            catch (InstallationException installationException) {
                throw new InstallationException(MessageUtil.formatMsg((String)"Error while trying to create the data queue on remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), installationException);
            }
            try {
                l2 = remoteServerDMScheduleImpl.createSkybotTableEntry(string);
            }
            catch (Exception exception) {
                throw new InstallationException(MessageUtil.formatMsg((String)"Error while trying to create the database entry on remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), exception);
            }
            long l3 = l2;
            return l3;
        }
        catch (InstallationException installationException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"The creation of the required data queue (and/or database entry) needed to interact with remote server {0} failed.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)installationException);
        }
        finally {
            aS400.disconnectAllServices();
        }
    }

    public void uninstall(long l, RemoteServerDMScheduleImpl remoteServerDMScheduleImpl) throws RemoteServerException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        RemoteScheduleServer remoteScheduleServer;
        try {
            remoteServerDMScheduleImpl.verifyInstall();
        }
        catch (Exception exception) {
            throw new RemoteServerException("Uninstall request failed. Could not verify that we were installed.", (Throwable)exception);
        }
        this.validateThatThereAreNoDependencies(l);
        try {
            remoteScheduleServer = this.getRemoteServerInfo(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"The removal of the required data queue (and/or database entry) needed to interact with remote server {0} failed.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
        }
        String string = "NOTIFQ";
        AS400 aS400 = this.establishConnection(remoteScheduleServer);
        try {
            try {
                this.deleteDataQueue(remoteScheduleServer.getLibrary(), string, aS400);
            }
            catch (InstallationException installationException) {
                throw new InstallationException(MessageUtil.formatMsg((String)"Error while trying to delete the data queue on remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), installationException);
            }
            try {
                remoteServerDMScheduleImpl.deleteSkybotTableEntry(remoteScheduleServer);
            }
            catch (Exception exception) {
                throw new InstallationException(MessageUtil.formatMsg((String)"Error while trying to delete the database entry on remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), exception);
            }
        }
        catch (InstallationException installationException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"The removal of the required data queue (and/or database entry) needed to interact with remote server {0} failed.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)installationException);
        }
        finally {
            aS400.disconnectAllServices();
        }
    }

    private void createDataQueue(String string, String string2, AS400 aS400) throws InstallationException {
        try {
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, new AS400Text(10).toBytes((Object)string2)), new ProgramParameter(2, new AS400Text(10).toBytes((Object)string))};
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(aS400);
            String string3 = QSYSObjectPathName.toPath((String)string, (String)"RBT642", (String)"SRVPGM");
            serviceProgramCall.setProgram(string3, programParameterArray);
            serviceProgramCall.setProcedureName("RBT642M1");
            serviceProgramCall.setReturnValueFormat(0);
            if (!serviceProgramCall.run()) {
                String string4 = this.messagesToString(serviceProgramCall.getMessageList());
                throw new InstallationException(string4);
            }
        }
        catch (Exception exception) {
            throw new InstallationException(MessageUtil.formatMsg((String)"Error creating the data queue {0}.{1}.", (Object[])new Object[]{string, string2}), exception);
        }
    }

    private void deleteDataQueue(String string, String string2, AS400 aS400) throws InstallationException {
        try {
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, new AS400Text(10).toBytes((Object)string2)), new ProgramParameter(2, new AS400Text(10).toBytes((Object)string))};
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(aS400);
            String string3 = QSYSObjectPathName.toPath((String)string, (String)"RBT642", (String)"SRVPGM");
            serviceProgramCall.setProgram(string3, programParameterArray);
            serviceProgramCall.setProcedureName("RBT642M2");
            serviceProgramCall.setReturnValueFormat(0);
            if (!serviceProgramCall.run()) {
                String string4 = this.messagesToString(serviceProgramCall.getMessageList());
                throw new InstallationException(string4);
            }
        }
        catch (Exception exception) {
            throw new InstallationException(MessageUtil.formatMsg((String)"Error deleting the data queue {0}.{1}.", (Object[])new Object[]{string, string2}), exception);
        }
    }

    KeyedDataQueue getKeyedDataQueue(String string, String string2, AS400 aS400) {
        String string3 = QSYSObjectPathName.toPath((String)string, (String)string2, (String)"DTAQ");
        return new KeyedDataQueue(aS400, string3);
    }

    DataQueue getDataQueue(String string, String string2, AS400 aS400) {
        String string3 = QSYSObjectPathName.toPath((String)string, (String)string2, (String)"DTAQ");
        return new DataQueue(aS400, string3);
    }

    AS400 establishConnection(RemoteScheduleServer remoteScheduleServer) throws RemoteServerException {
        if (remoteScheduleServer.getType() != RemoteServerType.SCHEDULE) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Attempting to establish a connection to an unexpected type of Remote Server. Type = {0}.", (Object[])new Object[]{remoteScheduleServer.getType()}));
        }
        String string = remoteScheduleServer.getSystemName();
        String string2 = remoteScheduleServer.getUser();
        AS400 aS400 = new AS400(string, string2, remoteScheduleServer.getPwd());
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.debug((Object)"Warning: The AS400 object rejected the property setGuiAvailable(false). Unwanted GUI prompting may occur.");
        }
        AS400.setPasswordExpirationWarningDays((int)-1);
        try {
            aS400.validateSignon();
        }
        catch (Exception exception) {
            String string3 = MessageUtil.formatMsg((String)"Error trying to create a connection for user {0} on server {1}. Unable to validate the user.", (Object[])new Object[]{string2, string});
            throw new RemoteServerException(string3, (Throwable)exception);
        }
        return aS400;
    }

    private RemoteScheduleServer getRemoteServerInfo(long l) throws ResourceUnavailableException {
        RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServersDM");
        if (remoteServersDM == null) {
            throw new IllegalStateException("Unable to retrieve remote server info. The remote server data manager was not found.");
        }
        RemoteScheduleServer remoteScheduleServer = (RemoteScheduleServer)remoteServersDM.getServer(l);
        return remoteScheduleServer;
    }

    private String getRemoteServerName(long l) {
        RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServersDM");
        if (remoteServersDM == null) {
            return MessageUtil.formatMsg((String)"Remote Server (id={0})", (Object[])new Object[]{l});
        }
        return remoteServersDM.getServerName(l);
    }

    private String messagesToString(AS400Message[] aS400MessageArray) {
        String string = "";
        if (aS400MessageArray != null) {
            for (AS400Message aS400Message : aS400MessageArray) {
                String string2 = MessageUtil.formatMsg((String)"{0}: {1}", (Object[])new Object[]{aS400Message.getID(), aS400Message.getText()});
                string = string.isEmpty() ? string2 : string + " " + string2;
            }
        }
        return string;
    }

    static boolean testAccessToRemoteServer(RemoteScheduleServer remoteScheduleServer) throws RemoteServerUnreachableException {
        String string = remoteScheduleServer.getSystemName();
        String string2 = remoteScheduleServer.getUser();
        AS400 aS400 = new AS400(string, string2, remoteScheduleServer.getPwd());
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.debug((Object)"Warning: The AS400 object rejected the property setGuiAvailable(false). Unwanted GUI prompting may occur.");
        }
        try {
            aS400.validateSignon();
            return true;
        }
        catch (Exception exception) {
            throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"Unable to access server {0}.", (Object[])new Object[]{remoteScheduleServer.getName()}), (Throwable)exception);
        }
    }

    private void validateScheduleInstalled(AS400 aS400, RemoteScheduleServer remoteScheduleServer) throws InstallationException {
        String string = remoteScheduleServer.getLibrary();
        try {
            String string2 = "CHKOBJ OBJ(*LIBL/" + string + ") OBJTYPE(*LIB)";
            CommandCall commandCall = new CommandCall(aS400);
            boolean bl = commandCall.run(string2);
            if (!bl) {
                AS400Message[] aS400MessageArray = commandCall.getMessageList();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Robot SCHEDULE is not installed on this system. ");
                for (AS400Message aS400Message : aS400MessageArray) {
                    stringBuffer.append("(" + aS400Message.getID() + ") " + aS400Message.getText());
                }
                throw new InstallationException(stringBuffer.toString());
            }
            commandCall = new CommandCall(aS400);
            string2 = "CHKOBJ OBJ(" + string + "/RBTSKYBOT) OBJTYPE(*FILE)";
            bl = commandCall.run(string2);
            if (!bl) {
                AS400Message[] aS400MessageArray = commandCall.getMessageList();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Robot SCHEDULE must be updated to interface with Automate. ");
                for (AS400Message aS400Message : aS400MessageArray) {
                    stringBuffer.append("(" + aS400Message.getID() + ") " + aS400Message.getText());
                }
                throw new InstallationException(stringBuffer.toString());
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new InstallationException("Error validating Robot SCHEDULE Installation.", propertyVetoException);
        }
        catch (InterruptedException interruptedException) {
            throw new InstallationException("Error validating Robot SCHEDULE Installation.", interruptedException);
        }
        catch (IOException iOException) {
            throw new InstallationException("Error validating Robot SCHEDULE Installation.", iOException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            throw new InstallationException("Error validating Robot SCHEDULE Installation.", errorCompletingRequestException);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new InstallationException("Error validating Robot SCHEDULE Installation.", aS400SecurityException);
        }
    }

    private void validateSkybotNotAlreadyInstalled(RemoteServerDMScheduleImpl remoteServerDMScheduleImpl, RemoteScheduleServer remoteScheduleServer) throws InstallationException {
        if (remoteScheduleServer.getInstalledDateTime() != 0L) {
            String string = "This Automate Remote Server definition is already registered (" + remoteScheduleServer.getInstalledDateTime() + ").";
            throw new InstallationException(string);
        }
        RegisteredServer[] registeredServerArray = null;
        try {
            registeredServerArray = remoteServerDMScheduleImpl.getRegisteredServers((RemoteServer)remoteScheduleServer);
        }
        catch (Exception exception) {
            String string = "Error verifying installation status.";
            throw new InstallationException(string, exception);
        }
        if (registeredServerArray != null && registeredServerArray.length > 0) {
            for (int i = 0; i < registeredServerArray.length; ++i) {
                logger.warn((Object)("Registered Automate server detected: Name=" + registeredServerArray[i].getServerName() + " InstallDateTime=" + registeredServerArray[i].getInstalledDateTime() + " Notifq=" + registeredServerArray[i].getNotificationQueue()));
            }
            String string = "Robot SCHEDULE on " + remoteScheduleServer.getSystemName() + " is already registered by another Automate Server.";
            throw new InstallationException(string);
        }
    }

    private void validateThatThereAreNoDependencies(long l) {
        RemoteEventDM remoteEventDM = (RemoteEventDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteEventDM");
        PrereqDM prereqDM = (PrereqDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
        boolean bl = false;
        try {
            List list = remoteEventDM.getAll(l);
            for (RemoteEvent remoteEvent : list) {
                if (prereqDM.eventIsPrerequisite(null, remoteEvent.getId(), PrereqEventType.REMOTE_EVENT)) {
                    bl = true;
                    continue;
                }
                logger.warn((Object)("Deleting orphaned remote event: " + remoteEvent.getRemoteObjectName()));
                remoteEventDM.delete(remoteEvent.getId());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error checking Remote Event dependencies.", exception);
        }
        if (bl) {
            throw new IllegalStateException("The remote server (ID:" + l + ") has Remote Events still referenced by dependencies.");
        }
    }

    private class InstallationException
    extends Exception {
        private InstallationException(String string) {
            super(string);
        }

        private InstallationException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

