/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.processor;

import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.processor.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class CommandBroadcaster
extends Thread {
    private Peer localPeer;
    private Command command;
    private PeerID[] recipientArray;
    private PeerID localPeerID;
    private int hopCount;
    private List<PeerID> alreadyNotifiedList;
    private static final Logger logger = Logger.getLogger(CommandBroadcaster.class);

    public CommandBroadcaster(Peer peer, Command command, int n, PeerID[] peerIDArray) {
        this.localPeer = peer;
        this.command = command;
        this.localPeerID = peer.getRemotePeerID();
        this.recipientArray = peer.getPeersFromRoutingTable();
        this.hopCount = n;
        this.alreadyNotifiedList = new ArrayList<PeerID>();
        this.alreadyNotifiedList.add(this.localPeerID);
        if (peerIDArray != null && peerIDArray.length > 0) {
            this.alreadyNotifiedList.addAll(Arrays.asList(peerIDArray));
        }
    }

    @Override
    public void run() {
        this.setName("Broadcasting command " + this.command);
        for (int i = 0; i < this.recipientArray.length; ++i) {
            PeerID peerID = this.recipientArray[i];
            if (this.alreadyNotifiedList.contains(peerID)) continue;
            try {
                Envelope envelope = new Envelope();
                envelope.setSource(this.localPeerID);
                envelope.setDestination(peerID);
                envelope.setPayload(this.command);
                envelope.setRemainingHops(this.hopCount);
                this.localPeer.sendEnvelope(envelope);
                continue;
            }
            catch (Exception exception) {
                logger.trace((Object)("Unable to broadcast command" + this.command + " to peer " + peerID), (Throwable)exception);
            }
        }
    }
}

