/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.ex.InvalidCredentialsException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class TestHost
extends HeavyweightPeer {
    private static final Logger logger = Logger.getLogger(TestHost.class);
    boolean badMood;

    public TestHost(PeerDescriptor peerDescriptor) throws PeerStartupException {
        super(peerDescriptor, (Serializable)((Object)"MyHostLib"), new HeavyweightPeerConfig());
    }

    @Override
    protected void checkCredentials(ConnectRequest connectRequest) throws InvalidCredentialsException {
        boolean bl = this.badMood = !this.badMood;
        if (this.badMood) {
            logger.info((Object)("REFUSING connect from " + connectRequest.getPeerID()));
            throw new InvalidCredentialsException("Go away, I'm in a bad mood.");
        }
        logger.info((Object)("Accepting connect from " + connectRequest.getPeerID()));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("Need a listen-port number.");
            System.exit(-1);
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 1) {
            System.out.println("invalid listen-port number.");
            System.exit(-1);
        }
        PeerDescriptor peerDescriptor = PeerDescriptor.createLocalPeerDescriptor(n, 1);
        TestHost testHost = null;
        try {
            testHost = new TestHost(peerDescriptor);
            testHost.startup();
        }
        catch (Exception exception) {
            logger.error((Object)"Can't start the node.", (Throwable)exception);
            System.exit(-1);
        }
    }
}

