/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.event.SimpleEventListenerList;
import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimpleConfig;
import com.helpsystems.common.tl.dm.RemoteEventAM;
import com.helpsystems.common.tl.event.PeerDisconnectEvent;
import com.helpsystems.common.tl.ex.PeerConnectException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class SimplePeer
extends HeavyweightPeer {
    private static final Logger logger = Logger.getLogger(SimplePeer.class);
    private SimpleEventListenerList listenerList = new SimpleEventListenerList();

    protected SimplePeer() throws PeerStartupException {
        this(SimplePeer.makeDefaultConfig());
    }

    protected SimplePeer(String string) throws PeerStartupException {
        this(string, SimplePeer.makeDefaultConfig());
    }

    protected SimplePeer(SimpleConfig simpleConfig) throws PeerStartupException {
        this(SimplePeer.generateInstanceID(), simpleConfig);
    }

    protected SimplePeer(String string, SimpleConfig simpleConfig) throws PeerStartupException {
        super(PeerDescriptor.createLocalPeerDescriptor(simpleConfig.getListenPort(), 3), (Serializable)((Object)string), simpleConfig);
    }

    protected SimplePeer(String string, SimpleConfig simpleConfig, int n) throws PeerStartupException {
        super(PeerDescriptor.createLocalPeerDescriptor(simpleConfig.getListenPort(), n), (Serializable)((Object)string), simpleConfig);
    }

    private static SimpleConfig makeDefaultConfig() {
        SimpleConfig simpleConfig = new SimpleConfig();
        simpleConfig.setListenPort(-1234);
        return simpleConfig;
    }

    private static String generateInstanceID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Long.toHexString(System.currentTimeMillis()));
        stringBuilder.append("-");
        int n = (int)Math.abs(Math.random() * 100000.0);
        stringBuilder.append(Integer.toHexString(n));
        return stringBuilder.toString();
    }

    @Override
    protected void checkCredentials(ConnectRequest connectRequest) {
    }

    public static SimplePeer createAnInstance() throws PeerStartupException {
        SimplePeer simplePeer = new SimplePeer();
        simplePeer.startup();
        return simplePeer;
    }

    @Override
    public PeerID connectToPeer(PeerDescriptor peerDescriptor, Serializable serializable) throws PeerConnectException {
        PeerID peerID = super.connectToPeer(peerDescriptor, serializable);
        RemoteEventAM remoteEventAM = (RemoteEventAM)ManagerRegistry.getManagerOrFail((String)"PEER.RemoteEventAM");
        try {
            remoteEventAM.addListenerToPeer(peerID, new MyEventListener());
        }
        catch (ActionFailedException actionFailedException) {
            logger.debug((Object)("Unable to attach a listener to peer " + peerDescriptor), (Throwable)actionFailedException);
        }
        return peerID;
    }

    @Override
    public void disconnectAll() {
        super.disconnectAll();
        ManagerRegistryPlugin managerRegistryPlugin = ManagerRegistry.getPlugin();
        if (managerRegistryPlugin != null) {
            managerRegistryPlugin.reset();
        }
        this.listenerList.clear();
    }

    public void addRemoteListener(SimpleEventListener simpleEventListener) {
        this.listenerList.addListener(simpleEventListener);
    }

    public void removeRemoteListener(SimpleEventListener simpleEventListener) {
        this.listenerList.removeListener(simpleEventListener);
    }

    private void fireRemoteEvent(GenericEvent genericEvent) {
        this.listenerList.fireEvent(genericEvent);
    }

    public class MyEventListener
    implements SimpleEventListener {
        public void serviceEvent(GenericEvent genericEvent) {
            ManagerRegistryPlugin managerRegistryPlugin;
            PeerDisconnectEvent peerDisconnectEvent;
            PeerID peerID;
            PeerDescriptor peerDescriptor;
            if (genericEvent instanceof PeerDisconnectEvent && (peerDescriptor = (peerID = (peerDisconnectEvent = (PeerDisconnectEvent)genericEvent).getPeerID()).getPeerDescriptor()).getType() != 3 && (managerRegistryPlugin = ManagerRegistry.getPlugin()) != null) {
                managerRegistryPlugin.reset();
            }
            SimplePeer.this.fireRemoteEvent(genericEvent);
        }
    }
}

