/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.LoadNetworkHostInfoDM;
import com.helpsystems.common.tl.LoadNode;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.ex.EnvelopeException;
import com.helpsystems.common.tl.ex.InvalidCredentialsException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.common.tl.processor.CommandResponse;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.impl.DataManagerCommand;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LoadHost
extends HeavyweightPeer {
    private static final Logger logger = Logger.getLogger(LoadHost.class);
    private long forwardCount;
    private boolean taking_a_break;

    public LoadHost(PeerDescriptor peerDescriptor) throws PeerStartupException {
        super(peerDescriptor, (Serializable)((Object)(LoadNode.FAKE_LIBRARY + peerDescriptor.getPort())), new HeavyweightPeerConfig());
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                LoadHost.this.updateDisplay();
            }
        }, 0L, 250L);
    }

    private void updateDisplay() {
        if (this.getPeersFromRoutingTable().length > 1) {
            System.out.print("\r" + LoadNode.getSpinChar() + " " + this.forwardCount);
        }
    }

    @Override
    protected void checkCredentials(ConnectRequest connectRequest) throws InvalidCredentialsException {
        if (this.taking_a_break) {
            logger.info((Object)("REFUSING connect from " + connectRequest.getPeerID()));
            throw new InvalidCredentialsException("Go away, I'm taking a break.");
        }
        logger.info((Object)("Accepting connect from " + connectRequest.getPeerID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findOpenPort(int n) {
        int n2 = n;
        Socket socket = null;
        while (true) {
            try {
                socket = new Socket("localhost", n2);
                ++n2;
                continue;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = LoadHost.findOpenPort(2000);
        Logger logger = Logger.getRootLogger();
        logger.setLevel(Level.WARN);
        String string = "h" + (n - 2000) + ".log";
        logger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("<%-5p %d{ISO8601} %t> %m\n"), string, false));
        PeerDescriptor peerDescriptor = PeerDescriptor.createLocalPeerDescriptor(n, 1);
        LoadHost loadHost = null;
        try {
            loadHost = new LoadHost(peerDescriptor);
            loadHost.startup();
            loadHost.loadManagers();
            loadHost.connectToOtherHosts();
        }
        catch (Exception exception) {
            LoadHost.logger.error((Object)"Can't start the host.", (Throwable)exception);
            System.exit(-1);
        }
        loadHost.waitAndBreak();
    }

    private void waitAndBreak() {
        Random random = new Random();
        long l = (5 + random.nextInt(5)) * 1000 * 60;
        while (true) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("\nTaking a break...");
            this.taking_a_break = true;
            this.disconnectAll();
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.taking_a_break = false;
            this.connectToOtherHosts();
            l = (5 + random.nextInt(5)) * 1000 * 60;
        }
    }

    private void connectToOtherHosts() {
        for (int i = 2000; i < 2005; ++i) {
            PeerDescriptor peerDescriptor = new PeerDescriptor();
            peerDescriptor.addAddress("localhost");
            peerDescriptor.setPort(i);
            peerDescriptor.setType(1);
            try {
                this.connectToPeer(peerDescriptor, (Serializable)((Object)"me"));
                continue;
            }
            catch (Exception exception) {
                logger.warn((Object)("Unable to connect to peer " + peerDescriptor), (Throwable)exception);
            }
        }
    }

    private void loadManagers() {
        ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin(this));
        ManagerRegistry.registerManager((IAbstractManager)new LoadNetworkHostInfoDM(this));
    }

    @Override
    protected void forwardEnvelope(Envelope envelope) throws EnvelopeException {
        CommandResponse commandResponse;
        Object object;
        Processable processable = null;
        try {
            processable = envelope.getPayload();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (processable instanceof DataManagerCommand) {
            DataManagerCommand dataManagerCommand = (DataManagerCommand)processable;
            Object[] objectArray = dataManagerCommand.getParameters();
            if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof Long) {
                Long l = (Long)objectArray[0];
                logger.info((Object)("Forwarding command/number " + l + " to peer " + envelope.getDestination()));
            }
        } else if (processable instanceof CommandResponse && (object = (commandResponse = (CommandResponse)processable).getResponse()) instanceof Long) {
            Long l = (Long)object;
            logger.info((Object)("Forwarding response " + l + " to node " + envelope.getDestination()));
        }
        super.forwardEnvelope(envelope);
        ++this.forwardCount;
    }
}

