/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.xml.ObjectPair;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.tl.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class HeavyweightPeerConfig
extends CommonVersionedObject
implements XMLSerializable {
    private int listenPort;
    private Hashtable<String, ServiceDescriptor> serviceTable;
    private ArrayList<ModuleDescriptor> moduleList;
    private String backlogDirectory;
    private static final long serialVersionUID = 5748595661866936928L;
    private String encryptedPassword;
    private Properties log4jprops;

    public HeavyweightPeerConfig() {
        this._internalInit();
    }

    private void _internalInit() {
        this.serviceTable = new Hashtable();
        this.moduleList = new ArrayList();
        this.log4jprops = new Properties();
        this.setBacklogDirectory("backlog");
    }

    public void addLog4jSetting(ObjectPair objectPair) {
        Object object = objectPair.getKey();
        Object object2 = objectPair.getValue();
        if (object == null) {
            throw new NullPointerException("The key is null.");
        }
        if (object2 == null) {
            throw new NullPointerException("The value is null.");
        }
        this.log4jprops.put(object.toString(), object2.toString());
    }

    public void addModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        this.moduleList.add(moduleDescriptor);
    }

    public void addServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        if (serviceDescriptor.getName() == null) {
            throw new NullPointerException("The descriptor's name is null.");
        }
        this.serviceTable.put(serviceDescriptor.getName(), serviceDescriptor);
    }

    public String[] doNotInvoke() {
        return new String[]{"getLog4jProperties"};
    }

    public String getBacklogDirectory() {
        return this.backlogDirectory;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public Properties getLog4jProperties() {
        return this.log4jprops;
    }

    public ObjectPair[] getLog4jSettings() {
        return ObjectPair.toArray((Map)this.log4jprops);
    }

    public ModuleDescriptor[] getModuleDescriptors() {
        ModuleDescriptor[] moduleDescriptorArray = new ModuleDescriptor[this.moduleList.size()];
        this.moduleList.toArray(moduleDescriptorArray);
        return moduleDescriptorArray;
    }

    public ModuleDescriptor[] getModuleDescriptorsForProduct(String string) {
        ModuleDescriptor[] moduleDescriptorArray = this.getModuleDescriptors();
        ArrayList<ModuleDescriptor> arrayList = new ArrayList<ModuleDescriptor>();
        for (int i = 0; i < moduleDescriptorArray.length; ++i) {
            if (!string.equalsIgnoreCase(moduleDescriptorArray[i].getProductName())) continue;
            arrayList.add(moduleDescriptorArray[i]);
        }
        ModuleDescriptor[] moduleDescriptorArray2 = new ModuleDescriptor[arrayList.size()];
        arrayList.toArray(moduleDescriptorArray2);
        return moduleDescriptorArray2;
    }

    public ServiceDescriptor getServiceDescriptor(String string) {
        return this.serviceTable.get(string);
    }

    public ServiceDescriptor[] getServiceDescriptors() {
        ServiceDescriptor[] serviceDescriptorArray = new ServiceDescriptor[this.serviceTable.size()];
        Enumeration<ServiceDescriptor> enumeration = this.serviceTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serviceDescriptorArray[n] = enumeration.nextElement();
            ++n;
        }
        return serviceDescriptorArray;
    }

    public void setListenPort(int n) {
        this.listenPort = n;
    }

    public void removeLog4jSetting(String string) {
        this.log4jprops.remove(string);
    }

    public void removeService(String string) {
        if (string == null) {
            throw new NullPointerException("The service name passed in is null.");
        }
        this.serviceTable.remove(string);
    }

    public void removeAllModuleDescriptors() {
        this.moduleList.clear();
    }

    public boolean removeModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        return this.moduleList.remove((Object)moduleDescriptor);
    }

    public void setBacklogDirectory(String string) {
        if (string == null) {
            throw new NullPointerException("The directory name passed in is null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The directory name passed in is blank.");
        }
        this.backlogDirectory = string;
    }

    public void setEncryptedPassword(String string) {
        this.encryptedPassword = string;
    }
}

