/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.enterprise.module.windows.Kernel32Ext;
import com.helpsystems.enterprise.module.windows.Kernel32Tools;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.WindowsAgentAM;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import org.apache.log4j.Logger;

public class WindowsAgentAMImpl
extends AbstractManager
implements WindowsAgentAM {
    private static final Logger logger = Logger.getLogger(WindowsAgentAMImpl.class);

    public static void main(String[] stringArray) {
        WindowsAgentAMImpl windowsAgentAMImpl = new WindowsAgentAMImpl(null);
        System.out.println("is64BitWindowsOS: " + windowsAgentAMImpl.is64BitWindowsOS());
        System.out.println("getProcessBitDepth: " + windowsAgentAMImpl.getProcessBitDepth());
        System.out.println("getOSBitDepth: " + windowsAgentAMImpl.getOSBitDepth());
        System.out.println("isThisProcessWow64: " + windowsAgentAMImpl.isThisProcessWow64());
    }

    public WindowsAgentAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.WindowsAgentAM");
    }

    public boolean is64BitWindowsOS() {
        return this.getOSBitDepth() == 64;
    }

    private int getProcessBitDepth() {
        if (Pointer.SIZE == 8) {
            return 64;
        }
        return 32;
    }

    private int getOSBitDepth() {
        if (this.getProcessBitDepth() == 64) {
            return 64;
        }
        if (this.isThisProcessWow64()) {
            return 64;
        }
        return 32;
    }

    private boolean isThisProcessWow64() {
        ByteByReference byteByReference = new ByteByReference();
        WinNT.HANDLE hANDLE = Kernel32Ext.INSTANCE.GetCurrentProcess();
        boolean bl = false;
        try {
            bl = Kernel32Ext.INSTANCE.IsWow64Process(hANDLE, byteByReference);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        if (!bl) {
            int n = Kernel32Ext.INSTANCE.GetLastError();
            String string = "Error calling isWow64Process: " + Kernel32Tools.getErrorMessage(n);
            logger.error((Object)string);
            return false;
        }
        return byteByReference.getValue() != 0;
    }
}

