/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.enterprise.module.windows.Process32;
import com.sun.jna.Callback;
import com.sun.jna.platform.win32.WinNT;
import org.apache.log4j.Logger;

public class GenerateConsoleCtrlEvent {
    private static final Logger logger = Logger.getLogger(GenerateConsoleCtrlEvent.class);

    public void generateThreadDump(int n) {
        WinNT.HANDLE hANDLE = Process32.INSTANCE.GetStdHandle(-11);
        WinNT.HANDLE hANDLE2 = Process32.INSTANCE.GetStdHandle(-12);
        if (hANDLE == null || hANDLE2 == null) {
            logger.debug((Object)"No Console output is currently available.");
            return;
        }
        int n2 = Process32.INSTANCE.GetCurrentProcessId();
        if (n == 0) {
            logger.debug((Object)("Generating ThreadDump for the current process.  PID = " + n2));
        } else {
            logger.debug((Object)("Generating ThreadDump for the process id " + n));
        }
        if (!Process32.INSTANCE.GenerateConsoleCtrlEvent(1, 0)) {
            logger.debug((Object)("Could not generate the thread dump.  Windows Error = " + Process32.INSTANCE.GetLastError()));
        } else {
            logger.debug((Object)"ThreadDump has finsihed normally.");
        }
    }

    public void registerHandlerRoutine() {
        Process32.INSTANCE.SetConsoleCtrlHandler(new handlerRoutine(), true);
    }

    public static void main(String[] stringArray) {
        GenerateConsoleCtrlEvent generateConsoleCtrlEvent = new GenerateConsoleCtrlEvent();
        generateConsoleCtrlEvent.generateThreadDump(0);
        System.exit(0);
    }

    public class handlerRoutine
    implements Callback {
        public boolean handleRoutine(int n) {
            switch (n) {
                case 0: 
                case 2: 
                case 6: {
                    return true;
                }
                case 5: {
                    return false;
                }
            }
            return false;
        }
    }
}

