/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.enterprise.module.windows.Advapi32;
import com.helpsystems.enterprise.module.windows.Kernel32Tools;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class Advapi32Tools {
    private static final Logger logger = Logger.getLogger(Advapi32Tools.class);
    public static final String REGPATH_SOFTWARE = "SOFTWARE";
    private static final HashMap<REGISTRY_ROOT_KEY, Integer> rootKeyMap = new HashMap();
    String lpMachineName = null;
    String lpDatabaseName = null;
    WinNT.HANDLE hScm = null;
    WinNT.HANDLE hService = null;
    Pointer service_status = new Memory(40L);

    public static void main(String[] stringArray) {
        System.out.println("Software registry path exists: " + Advapi32Tools.doesKeyExist(REGISTRY_ROOT_KEY.LOCAL_MACHINE, REGPATH_SOFTWARE));
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesKeyExist(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY, String string) {
        int n = 0;
        boolean bl = false;
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        try {
            n = Advapi32Tools.getRegistryRootKey(rEGISTRY_ROOT_KEY);
            IntByReference intByReference = new IntByReference();
            hANDLEByReference.setPointer(intByReference.getPointer());
            WString wString = new WString(string);
            int n2 = Advapi32.INSTANCE.RegOpenKeyEx(n, wString, 0, 131097, hANDLEByReference);
            switch (n2) {
                case 0: {
                    bl = true;
                    boolean bl2 = true;
                    return bl2;
                }
                case 2: {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            String string2 = Kernel32Tools.getErrorMessage(n2);
            logger.debug((Object)string2);
            boolean bl4 = false;
            return bl4;
        }
        catch (Throwable throwable) {
            logger.debug((Object)("Error checking for registry key: " + string), throwable);
            boolean bl5 = false;
            return bl5;
        }
        finally {
            block21: {
                try {
                    Advapi32.INSTANCE.RegCloseKey(hANDLEByReference.getValue());
                }
                catch (Throwable throwable) {
                    if (!bl) break block21;
                    logger.debug((Object)"Error closing open registry handle.", throwable);
                }
            }
            Advapi32Tools.closeRegistryRootKey(n);
        }
    }

    private static int getRegistryRootKey(REGISTRY_ROOT_KEY rEGISTRY_ROOT_KEY) {
        int n = 0;
        IntByReference intByReference = new IntByReference();
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        hANDLEByReference.setPointer(intByReference.getPointer());
        if (Advapi32.INSTANCE.RegOpenKeyEx(rootKeyMap.get((Object)rEGISTRY_ROOT_KEY), null, 0, 0, hANDLEByReference) == 0) {
            n = intByReference.getValue();
        }
        return n;
    }

    private static void closeRegistryRootKey(int n) {
        try {
            IntByReference intByReference = new IntByReference(n);
            WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
            hANDLEByReference.setPointer(intByReference.getPointer());
            Advapi32.INSTANCE.RegCloseKey(hANDLEByReference.getValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean isServiceRunning(String string) {
        boolean bl = false;
        try {
            this.hScm = Advapi32.INSTANCE.OpenSCManager(this.lpMachineName, this.lpDatabaseName, 983103);
            if (this.hScm != null) {
                this.hService = Advapi32.INSTANCE.OpenService(this.hScm, string, 983551);
                if (this.hService != null) {
                    if (Advapi32.INSTANCE.QueryServiceStatus(this.hService, this.service_status)) {
                        System.out.println("Query Service Status completed");
                        Advapi32.SERVICE_STATUS sERVICE_STATUS = new Advapi32.SERVICE_STATUS(this.service_status);
                        if (sERVICE_STATUS.dwCurrentState == 4) {
                            bl = true;
                        }
                    } else {
                        System.out.println("Query Service Status error " + Kernel32.INSTANCE.GetLastError());
                    }
                    Advapi32.INSTANCE.CloseServiceHandle(this.hService);
                } else {
                    System.out.println("hService is null " + Kernel32.INSTANCE.GetLastError());
                }
                Advapi32.INSTANCE.CloseServiceHandle(this.hScm);
            } else {
                System.out.println("hScm is null " + Kernel32.INSTANCE.GetLastError());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    boolean startService(String string) {
        boolean bl = false;
        try {
            this.hScm = Advapi32.INSTANCE.OpenSCManager(this.lpMachineName, this.lpDatabaseName, 983103);
            if (this.hScm != null) {
                this.hService = Advapi32.INSTANCE.OpenService(this.hScm, string, 983551);
                if (this.hService != null) {
                    Advapi32.INSTANCE.StartService(this.hService, 0, null);
                    Advapi32.INSTANCE.CloseServiceHandle(this.hService);
                    bl = true;
                } else {
                    System.out.println("hService is null " + Kernel32.INSTANCE.GetLastError());
                }
                Advapi32.INSTANCE.CloseServiceHandle(this.hScm);
            } else {
                System.out.println("hScm is null " + Kernel32.INSTANCE.GetLastError());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception!");
        }
        return bl;
    }

    boolean stopService(String string) {
        boolean bl = false;
        try {
            this.hScm = Advapi32.INSTANCE.OpenSCManager(this.lpMachineName, this.lpDatabaseName, 983103);
            if (this.hScm != null) {
                this.hService = Advapi32.INSTANCE.OpenService(this.hScm, string, 983551);
                if (this.hService != null) {
                    if (Advapi32.INSTANCE.ControlService(this.hService, 1, this.service_status)) {
                        bl = true;
                    } else {
                        System.out.println("Stop Service error " + Kernel32.INSTANCE.GetLastError());
                    }
                    Advapi32.INSTANCE.CloseServiceHandle(this.hService);
                } else {
                    System.out.println("hService is null " + Kernel32.INSTANCE.GetLastError());
                }
                Advapi32.INSTANCE.CloseServiceHandle(this.hScm);
            } else {
                System.out.println("hScm is null " + Kernel32.INSTANCE.GetLastError());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception!");
        }
        return bl;
    }

    static {
        rootKeyMap.put(REGISTRY_ROOT_KEY.CLASSES_ROOT, Integer.MIN_VALUE);
        rootKeyMap.put(REGISTRY_ROOT_KEY.CURRENT_USER, -2147483647);
        rootKeyMap.put(REGISTRY_ROOT_KEY.LOCAL_MACHINE, -2147483646);
        rootKeyMap.put(REGISTRY_ROOT_KEY.USERS, -2147483645);
    }

    public static interface WINNT {
        public static final int DELETE = 65536;
        public static final int READ_CONTROL = 131072;
        public static final int WRITE_DAC = 262144;
        public static final int WRITE_OWNER = 524288;
        public static final int SYNCHRONIZE = 0x100000;
        public static final int STANDARD_RIGHTS_REQUIRED = 983040;
        public static final int STANDARD_RIGHTS_READ = 131072;
        public static final int STANDARD_RIGHTS_WRITE = 131072;
        public static final int STANDARD_RIGHTS_EXECUTE = 131072;
        public static final int STANDARD_RIGHTS_ALL = 0x1F0000;
        public static final int SPECIFIC_RIGHTS_ALL = 65535;
        public static final int GENERIC_EXECUTE = 0x20000000;
        public static final int SERVICE_WIN32_OWN_PROCESS = 16;
        public static final int KEY_QUERY_VALUE = 1;
        public static final int KEY_SET_VALUE = 2;
        public static final int KEY_CREATE_SUB_KEY = 4;
        public static final int KEY_ENUMERATE_SUB_KEYS = 8;
        public static final int KEY_NOTIFY = 16;
        public static final int KEY_CREATE_LINK = 32;
        public static final int KEY_READ = 131097;
        public static final int KEY_WRITE = 131078;
        public static final int REG_NONE = 0;
        public static final int REG_SZ = 1;
        public static final int REG_EXPAND_SZ = 2;
        public static final int REG_BINARY = 3;
        public static final int REG_DWORD = 4;
        public static final int REG_DWORD_LITTLE_ENDIAN = 4;
        public static final int REG_DWORD_BIG_ENDIAN = 5;
        public static final int REG_LINK = 6;
        public static final int REG_MULTI_SZ = 7;
        public static final int REG_RESOURCE_LIST = 8;
        public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
        public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
        public static final int REG_OPTION_RESERVED = 0;
        public static final int REG_OPTION_NON_VOLATILE = 0;
        public static final int REG_OPTION_VOLATILE = 1;
        public static final int REG_OPTION_CREATE_LINK = 2;
        public static final int REG_OPTION_BACKUP_RESTORE = 4;
        public static final int REG_OPTION_OPEN_LINK = 8;
    }

    public static interface WINREG {
        public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
        public static final int HKEY_CURRENT_USER = -2147483647;
        public static final int HKEY_LOCAL_MACHINE = -2147483646;
        public static final int HKEY_USERS = -2147483645;
    }

    public static interface WINERROR {
        public static final int ERROR_SUCCESS = 0;
        public static final int NO_ERROR = 0;
        public static final int ERROR_FILE_NOT_FOUND = 2;
        public static final int ERROR_MORE_DATA = 234;
    }

    public static enum REGISTRY_ROOT_KEY {
        CLASSES_ROOT,
        CURRENT_USER,
        LOCAL_MACHINE,
        USERS;

    }
}

