/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.uc;

import com.google.gson.Gson;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.module.exec.LogFileWrapper;
import com.helpsystems.enterprise.module.uc.CommandFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Base64;

public final class UCExecutor {
    private static Gson GSON = new Gson();
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");

    private UCExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(String string, long l, String string2, String string3, String string4, Map map, Map map2, LogFileWrapper logFileWrapper, String string5, AtomicBoolean atomicBoolean, Object object, String string6, String string7, boolean bl) {
        int n;
        boolean bl2 = false;
        String string8 = "";
        String string9 = null;
        String string10 = null;
        try {
            Object object2;
            ValidationHelper.checkForNull((String)"Server url", (Object)string);
            ValidationHelper.checkForNull((String)"Template UUID", (Object)string3);
            ValidationHelper.checkForNull((String)"UC parms map", (Object)map);
            ValidationHelper.checkForNull((String)"Requestor Info map", (Object)map2);
            ValidationHelper.checkForNull((String)"Log File Wrapper", (Object)logFileWrapper);
            ValidationHelper.checkForNull((String)"isTerminateCommand", (Object)atomicBoolean);
            ValidationHelper.checkForNull((String)"Wait lock", (Object)object);
            ValidationHelper.checkForNull((String)"User name", (Object)string6);
            ValidationHelper.checkForNull((String)"Password", (Object)string7);
            logFileWrapper.write(string5);
            UCExecutor.logActivityWithTimeStamp(logFileWrapper, "Starting process to run Interface: '" + string2 + "' and Template: '" + string4 + "'");
            string10 = UCExecutor.basicAuthHeaderValue(string6, string7);
            Proxy proxy = UCExecutor.configureProxy(map);
            string8 = MessageUtil.formatMsg((String)"{0}/universal-connector/api/v1", (Object[])new Object[]{string});
            string9 = UCExecutor.requestConnectorRun(string8, l, string3, map, map2, string10, logFileWrapper);
            UCExecutor.logParms(map, logFileWrapper);
            bl2 = true;
            long l2 = TimeUnit.SECONDS.toMillis(10L);
            String string11 = "";
            String string12 = "";
            while (!atomicBoolean.get()) {
                string11 = UCExecutor.getConnectorRunStatus(string9, string10);
                if (!string11.equals(string12)) {
                    UCExecutor.logActivityWithTimeStamp(logFileWrapper, "Status = " + string11);
                    string12 = string11;
                }
                if (string11.equalsIgnoreCase("COMPLETED") || string11.equalsIgnoreCase("FAILED") || string11.equalsIgnoreCase("ERROR") || string11.equalsIgnoreCase("CANCELED")) break;
                object2 = object;
                synchronized (object2) {
                    try {
                        object.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (atomicBoolean.get()) {
                UCExecutor.logActivityWithTimeStamp(logFileWrapper, "Requesting that the Universal Connector cancel the interface template run.");
                string11 = UCExecutor.cancelBatchRun(string9, string10, logFileWrapper);
            }
            n = string11.equalsIgnoreCase("COMPLETED") ? 0 : 1;
            if (bl) {
                try {
                    UCExecutor.logActivityWithTimeStamp(logFileWrapper, "UC log retrieval requested.");
                    object2 = UCExecutor.getConnectorRunLog(string9, string10);
                    logFileWrapper.write(string5);
                    logFileWrapper.write("==== Start of the UC Log ====\n");
                    String[] stringArray = ((String)object2).split("\n");
                    logFileWrapper.write(stringArray);
                    logFileWrapper.write(string5);
                    logFileWrapper.write("\n==== End of the UC Log ====\n");
                }
                catch (CommandFailedException commandFailedException) {
                    commandFailedException.printStackTrace();
                    UCExecutor.logActivityWithTimeStamp(logFileWrapper, "UC log retrieval failed. " + commandFailedException.getMessage());
                }
            }
        }
        catch (Exception exception) {
            n = 1;
            if (exception instanceof CommandFailedException && !((CommandFailedException)exception).isLoggedConnectorMessage()) {
                UCExecutor.logActivityWithTimeStamp(logFileWrapper, MessageUtil.formatMsg((String)"Request that interface {0} (ID:{1}) on the Universal Connector server located at {2} be run.", (Object[])new Object[]{string2, l, string8}));
            }
            if (!bl2) {
                UCExecutor.logParms(map, logFileWrapper);
            }
            UCExecutor.logActivityWithTimeStamp(logFileWrapper, MessageUtil.formatMsg((String)"Command failure: {0}", (Object[])new Object[]{UCExecutor.nestedMsgText(exception)}));
        }
        return n;
    }

    private static String getConnectorRunLog(String string, String string2) throws CommandFailedException {
        int n;
        HttpURLConnection httpURLConnection;
        URL uRL;
        String string3 = string + "/log";
        String string4 = "";
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CommandFailedException("Invalid (malformed) URL.", malformedURLException);
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new CommandFailedException("Unable to create a HttpURLConnection object.", iOException);
        }
        httpURLConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(20L));
        httpURLConnection.setReadTimeout((int)TimeUnit.MINUTES.toMillis(1L));
        httpURLConnection.setRequestProperty("Authorization", string2);
        httpURLConnection.setRequestProperty("Accept", "application/json");
        try {
            n = httpURLConnection.getResponseCode();
        }
        catch (ConnectException connectException) {
            throw new CommandFailedException(MessageUtil.formatMsg((String)"Cannot connect to {0}.", (Object[])new Object[]{uRL}), connectException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            int n2 = httpURLConnection.getReadTimeout();
            String string5 = "Socket time out";
            if (n2 > 0) {
                string5 = MessageUtil.formatMsg((String)"Socket time out. A response from the server was not received within {0} milliseconds.", (Object[])new Object[]{n2});
            }
            throw new CommandFailedException(string5, socketTimeoutException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return string4;
        }
        if (n != 200) {
            String string6 = UCExecutor.processUnexpectedStatus(httpURLConnection);
            throw new CommandFailedException(string6);
        }
        Map<String, Object> map = UCExecutor.extractDataFromHttpMessageBody(httpURLConnection);
        string4 = (String)map.get("log");
        if (string4 == null) {
            throw new CommandFailedException("No log found in response data.");
        }
        return string4;
    }

    private static boolean anythingLeft() {
        return false;
    }

    private static String basicAuthHeaderValue(String string, String string2) {
        Charset charset = Charset.forName("US-ASCII");
        String string3 = new StringBuffer().append(string).append(":").append(string2).toString();
        byte[] byArray = string3.getBytes(charset);
        byte[] byArray2 = Base64.encodeBase64((byte[])byArray);
        String string4 = new String(byArray2, charset);
        return "Basic " + string4;
    }

    private static String cancelBatchRun(String string, String string2, LogFileWrapper logFileWrapper) throws CommandFailedException {
        String string3;
        int n;
        OutputStream outputStream;
        HttpURLConnection httpURLConnection;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CommandFailedException("Invalid (malformed) URL.", malformedURLException);
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new CommandFailedException("Unable to create a HttpURLConnection object.", iOException);
        }
        httpURLConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(20L));
        httpURLConnection.setReadTimeout((int)TimeUnit.MINUTES.toMillis(1L));
        httpURLConnection.setDoOutput(true);
        try {
            httpURLConnection.setRequestMethod("PUT");
        }
        catch (ProtocolException protocolException) {
            throw new CommandFailedException("HTTP error.", protocolException);
        }
        httpURLConnection.setRequestProperty("Authorization", string2);
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        String string4 = "{\"cancelBatchRun\":true}";
        try {
            outputStream = httpURLConnection.getOutputStream();
        }
        catch (ConnectException connectException) {
            throw new CommandFailedException(MessageUtil.formatMsg((String)"Cannot connect to {0}.", (Object[])new Object[]{uRL}), connectException);
        }
        catch (IOException iOException) {
            throw new CommandFailedException("I/O Error.", iOException);
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(string4);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new CommandFailedException("I/O Error.", iOException);
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                } else if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            n = httpURLConnection.getResponseCode();
        }
        catch (ConnectException connectException) {
            throw new CommandFailedException(MessageUtil.formatMsg((String)"Cannot connect to {0}.", (Object[])new Object[]{uRL}), connectException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            int n2 = httpURLConnection.getReadTimeout();
            String string5 = "Socket time out";
            if (n2 > 0) {
                string5 = MessageUtil.formatMsg((String)"Socket time out. A response from the server was not received within {0} milliseconds.", (Object[])new Object[]{n2});
            }
            throw new CommandFailedException(string5, socketTimeoutException);
        }
        catch (IOException iOException) {
            throw new CommandFailedException("I/O Error.", iOException);
        }
        switch (n) {
            case 202: {
                UCExecutor.logActivityWithTimeStamp(logFileWrapper, "The request to cancel the interface template run was accepted by the Universal Connector.");
                string3 = "CANCELED";
                break;
            }
            case 404: {
                UCExecutor.logActivityWithTimeStamp(logFileWrapper, "The Universal Connector reports that it was unable to find the interface template run.");
                string3 = "CANCELED";
                break;
            }
            case 409: {
                try {
                    string3 = UCExecutor.getConnectorRunStatus(string, string2);
                    UCExecutor.logActivityWithTimeStamp(logFileWrapper, MessageUtil.formatMsg((String)"The interface template run was already in a terminal status - ''{0}''.", (Object[])new Object[]{string3}));
                }
                catch (Exception exception) {
                    string3 = "CANCELED";
                    UCExecutor.logActivityWithTimeStamp(logFileWrapper, "The interface template run was already in a terminal status.");
                }
                break;
            }
            default: {
                UCExecutor.logActivityWithTimeStamp(logFileWrapper, MessageUtil.formatMsg((String)"Unanticipated HTTP response status ({0}) received on request to cancel the interface template run.", (Object[])new Object[]{n}));
                string3 = "CANCELED";
            }
        }
        return string3;
    }

    private static Proxy configureProxy(Map map) {
        return null;
    }

    private static void consumeIt() {
    }

    private static String errorMessage(int n, HttpURLConnection httpURLConnection) throws IOException {
        Map<String, Object> map;
        String string;
        if (n == 401) {
            string = "Invalid username and/or password.";
        } else {
            map = UCExecutor.extractMessageFromErrorStream(httpURLConnection);
            string = (String)map.get("message");
            if (string == null) {
                string = "none";
            }
        }
        map = MessageUtil.formatMsg((String)"An error response status ({0}) has been received from the Universal Connector server. Response message: {1}. Details: {2}", (Object[])new Object[]{n, httpURLConnection.getResponseMessage(), string});
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> extractDataFromHttpMessageBody(HttpURLConnection httpURLConnection) {
        Map map = null;
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            if (inputStream != null) {
                String string = httpURLConnection.getHeaderField("content-type").toLowerCase();
                if (string == null || !string.contains("application/json")) {
                    throw new InvalidStateException("Error.");
                }
                map = UCExecutor.parseJsonObject(inputStream);
                if (UCExecutor.anythingLeft()) {
                    UCExecutor.consumeIt();
                }
                inputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Map<String, Object> map2 = null;
            return map2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return map;
    }

    private static String getConnectorRunStatus(String string, String string2) throws CommandFailedException {
        int n;
        HttpURLConnection httpURLConnection;
        URL uRL;
        String string3 = "";
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CommandFailedException("Invalid (malformed) URL.", malformedURLException);
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new CommandFailedException("Unable to create a HttpURLConnection object.", iOException);
        }
        httpURLConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(20L));
        httpURLConnection.setReadTimeout((int)TimeUnit.MINUTES.toMillis(1L));
        httpURLConnection.setRequestProperty("Authorization", string2);
        httpURLConnection.setRequestProperty("Accept", "application/json");
        try {
            n = httpURLConnection.getResponseCode();
        }
        catch (ConnectException connectException) {
            throw new CommandFailedException(MessageUtil.formatMsg((String)"Cannot connect to {0}.", (Object[])new Object[]{uRL}), connectException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            int n2 = httpURLConnection.getReadTimeout();
            String string4 = "Socket time out";
            if (n2 > 0) {
                string4 = MessageUtil.formatMsg((String)"Socket time out. A response from the server was not received within {0} milliseconds.", (Object[])new Object[]{n2});
            }
            throw new CommandFailedException(string4, socketTimeoutException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return string3;
        }
        if (n != 200) {
            String string5 = UCExecutor.processUnexpectedStatus(httpURLConnection);
            throw new CommandFailedException(string5);
        }
        Map<String, Object> map = UCExecutor.extractDataFromHttpMessageBody(httpURLConnection);
        string3 = (String)map.get("status");
        if (string3 == null) {
            string3 = "unknown";
        }
        return string3;
    }

    private static void logParms(Map<String, Object> map, LogFileWrapper logFileWrapper) {
        UCExecutor.logMap(map, "Parameters:", logFileWrapper);
    }

    private static void logMap(Map<String, Object> map, String string, LogFileWrapper logFileWrapper) {
        String string2 = "    ";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            arrayList.add(MessageUtil.formatMsg((String)"{0}{1} = {2}", (Object[])new Object[]{string2, entry.getKey(), entry.getValue()}));
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        UCExecutor.logActivityWithTimeStamp(logFileWrapper, stringArray);
    }

    private static String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }

    private static Map parseJsonObject(InputStream inputStream) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        Map map = (Map)GSON.fromJson((Reader)inputStreamReader, Map.class);
        return map;
    }

    private static String processUnexpectedStatus(HttpURLConnection httpURLConnection) {
        String string;
        try {
            int n = httpURLConnection.getResponseCode();
            if (n >= 400) {
                return UCExecutor.errorMessage(n, httpURLConnection);
            }
            String string2 = httpURLConnection.getResponseMessage();
            string = MessageUtil.formatMsg((String)"Status: {0} {1}.", (Object[])new Object[]{n, string2});
        }
        catch (IOException iOException) {
            string = "Note: Could not parse the response status and message, to provide further details.";
        }
        String string3 = MessageUtil.formatMsg((String)"An unexpected response status has been received from the Universal Connector server. {0}", (Object[])new Object[]{string});
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String requestConnectorRun(String string, long l, String string2, Map map, Map map2, String string3, LogFileWrapper logFileWrapper) throws CommandFailedException {
        int n;
        OutputStream outputStream;
        HttpURLConnection httpURLConnection;
        URL uRL;
        String string4 = "";
        try {
            uRL = new URL(MessageUtil.formatMsg((String)"{0}/interfaces/{1}/runs", (Object[])new Object[]{string, l}));
        }
        catch (MalformedURLException malformedURLException) {
            throw new CommandFailedException("Invalid (malformed) URL.", malformedURLException);
        }
        UCExecutor.logActivityWithTimeStamp(logFileWrapper, "Posting to URL: " + uRL);
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new CommandFailedException("Unable to create a HttpURLConnection object.", iOException);
        }
        httpURLConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(20L));
        httpURLConnection.setReadTimeout((int)TimeUnit.MINUTES.toMillis(1L));
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Authorization", string3);
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("template-uuid", string2);
        hashMap.put("input-parameters", map);
        hashMap.put("requestor", map2);
        String string5 = GSON.toJson(hashMap);
        try {
            outputStream = httpURLConnection.getOutputStream();
        }
        catch (ConnectException connectException) {
            throw new CommandFailedException(MessageUtil.formatMsg((String)"Cannot connect to {0}.", (Object[])new Object[]{string}), connectException);
        }
        catch (IOException iOException) {
            return string4;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(string5);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string6 = string4;
            return string6;
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                } else if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            n = httpURLConnection.getResponseCode();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            int n2 = httpURLConnection.getReadTimeout();
            String string7 = "Socket time out";
            if (n2 > 0) {
                string7 = MessageUtil.formatMsg((String)"Socket time out. A response from the server was not received within {0} milliseconds.", (Object[])new Object[]{n2});
            }
            throw new CommandFailedException(string7, socketTimeoutException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return string4;
        }
        Map<String, Object> map3 = UCExecutor.extractDataFromHttpMessageBody(httpURLConnection);
        if (n != 202) {
            String string8 = UCExecutor.processUnexpectedStatus(httpURLConnection);
            String string9 = (String)UCExecutor.getFromResponseData(map3, "message");
            if (string9 != null) {
                UCExecutor.logActivityWithTimeStamp(logFileWrapper, string9);
            }
            throw new CommandFailedException(string8, true);
        }
        String string10 = httpURLConnection.getHeaderField("location");
        UCExecutor.validateUcRunResourceURLstr(string10, uRL);
        string4 = string10;
        String string11 = (String)UCExecutor.getFromResponseData(map3, "message");
        if (string11 == null) {
            string11 = "No interface run description was returned from the Universal Connector server.";
        }
        UCExecutor.logActivityWithTimeStamp(logFileWrapper, string11);
        Object object = UCExecutor.getFromResponseData(map3, "runID");
        Double d = (Double)object;
        if (d != null) {
            int n3 = d.intValue();
            UCExecutor.logActivityWithTimeStamp(logFileWrapper, MessageUtil.formatMsg((String)"Run ID {0} has been assigned.", (Object[])new Object[]{n3}));
        }
        return string4;
    }

    private static Object getFromResponseData(Map<String, Object> map, String string) {
        Object object = null;
        if (map != null && (object = map.get(string)) == null) {
            object = MessageUtil.formatMsg((String)"No {0} was returned from the Universal Connector server.", (Object[])new Object[]{string});
        }
        return object;
    }

    private static void logActivityWithTimeStamp(LogFileWrapper logFileWrapper, Object object) {
        String string = formatter.format(new Date(System.currentTimeMillis()));
        if (object instanceof String[]) {
            logFileWrapper.writeNoEOL(string + ": ");
            logFileWrapper.write((String[])object);
        } else {
            logFileWrapper.write(string + ": " + object);
        }
    }

    private static void validateUcRunResourceURLstr(String string, URL uRL) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> extractMessageFromErrorStream(HttpURLConnection httpURLConnection) {
        Map map = null;
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getErrorStream();
            if (inputStream != null) {
                String string = httpURLConnection.getHeaderField("content-type").toLowerCase();
                if (string == null || !string.contains("application/json")) {
                    throw new InvalidStateException("Error.");
                }
                map = UCExecutor.parseJsonObject(inputStream);
                if (UCExecutor.anythingLeft()) {
                    UCExecutor.consumeIt();
                }
                inputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Map<String, Object> map2 = null;
            return map2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return map;
    }
}

