/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import java.util.HashMap;
import java.util.Properties;

public class SAPDestinationDataProvider
implements DestinationDataProvider {
    public static final String NAME = "SkybotSAPDestinationDataProvider";
    private DestinationDataEventListener eventListener;
    private HashMap<String, Properties> secureDBStorage = new HashMap();

    public Properties getDestinationProperties(String string) {
        try {
            Properties properties = this.secureDBStorage.get(string);
            if (properties != null) {
                if (properties.isEmpty()) {
                    throw new DataProviderException(DataProviderException.Reason.INVALID_CONFIGURATION, "destination configuration is incorrect", null);
                }
                return properties;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            throw new DataProviderException(DataProviderException.Reason.INTERNAL_ERROR, (Throwable)runtimeException);
        }
    }

    public void setDestinationDataEventListener(DestinationDataEventListener destinationDataEventListener) {
        this.eventListener = destinationDataEventListener;
    }

    public boolean supportsEvents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeProperties(String string, Properties properties) {
        HashMap<String, Properties> hashMap = this.secureDBStorage;
        synchronized (hashMap) {
            if (properties == null) {
                if (this.secureDBStorage.remove(string) != null) {
                    this.eventListener.deleted(string);
                }
            } else {
                this.secureDBStorage.put(string, properties);
                this.eventListener.updated(string);
            }
        }
    }
}

