/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.sap.SAPConnectionType;
import com.helpsystems.enterprise.core.busobj.sap.SAPReturnMessage;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystem;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemEnvironment;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemDefinitionsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemEnvironmentsDM;
import com.helpsystems.enterprise.module.sap.SAPConnection;
import com.helpsystems.enterprise.module.sap.SAPDestinationDataProvider;
import com.helpsystems.enterprise.module.sap.SAPFunctionUtility;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class SAPConnectionProvider
extends AbstractManager {
    private static Logger logger = Logger.getLogger(SAPConnectionProvider.class);
    private SAPSystemEnvironmentsDM sapSystemEnvironmentsDM;
    private SAPSystemDefinitionsDM sapSystemDefinitionsDM;
    private static SAPDestinationDataProvider myProvider = new SAPDestinationDataProvider();

    protected SAPConnection getSAPConnection(long l) throws ResourceUnavailableException {
        SAPSystemDefinition sAPSystemDefinition = this.getSAPSystemDefinition(l);
        return this.getSAPConnection(sAPSystemDefinition);
    }

    protected SAPConnection getSAPConnection(SAPSystemDefinition sAPSystemDefinition) throws ResourceUnavailableException {
        SAPSystemEnvironment sAPSystemEnvironment;
        try {
            sAPSystemEnvironment = this.getSAPSystemEnvironment(sAPSystemDefinition.getDefaultEnvironmentID());
            logger.debug((Object)("SAP System Definition(" + sAPSystemDefinition.getName() + ") Environment(" + sAPSystemEnvironment.getName() + ")  XBP Version(" + sAPSystemDefinition.getXbpVersion().persistanceCode() + ")"));
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining Connection to SAP System Definition " + sAPSystemDefinition.getName(), (Throwable)exception);
        }
        SAPSystem sAPSystem = new SAPSystem(sAPSystemDefinition, sAPSystemEnvironment);
        JCoDestination jCoDestination = this.getDestination(sAPSystem);
        SAPConnection sAPConnection = null;
        try {
            sAPConnection = new SAPConnection(jCoDestination, sAPSystem);
        }
        catch (JCoException jCoException) {
            String string = "Error connecting to SAP System " + sAPSystemDefinition.getName() + ".";
            logger.error((Object)string, (Throwable)jCoException);
            throw new ResourceUnavailableException(string, (Throwable)jCoException);
        }
        return sAPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JCoDestination getDestination(SAPSystem sAPSystem) throws ResourceUnavailableException {
        JCoDestination jCoDestination = null;
        try {
            Object object = myProvider;
            synchronized (object) {
                if (!Environment.isDestinationDataProviderRegistered()) {
                    logger.debug((Object)"About to register myProvider.  Note: This should only be done once.");
                    Environment.registerDestinationDataProvider((DestinationDataProvider)this.getMyProvider());
                }
            }
            object = sAPSystem.getUniqueIdentifier();
            Properties properties = new Properties();
            SAPConnectionType sAPConnectionType = SAPConnectionType.persistanceCodeToEnum(sAPSystem.getSAPConnectionType());
            logger.debug((Object)("SAP Connection Type: " + sAPConnectionType));
            if (sAPSystem.getSAPConnectionType() == 2) {
                properties.setProperty("jco.client.mshost", sAPSystem.getMessageServer());
                properties.setProperty("jco.client.r3name", sAPSystem.getR3name());
                properties.setProperty("jco.client.group", sAPSystem.getGroupOrServer());
            } else {
                properties.setProperty("jco.client.sysnr", sAPSystem.getSystemNumber());
                properties.setProperty("jco.client.ashost", sAPSystem.getAshost());
            }
            properties.setProperty("jco.client.saprouter", sAPSystem.getRouter());
            properties.setProperty("jco.client.client", sAPSystem.getClient());
            properties.setProperty("jco.client.user", sAPSystem.getUser());
            properties.setProperty("jco.client.passwd", sAPSystem.getDecryptedPassword());
            properties.setProperty("jco.client.lang", sAPSystem.getLanguage());
            String string = sAPSystem.getUser();
            for (int i = 0; i < string.length(); ++i) {
                int n = string.codePointAt(i);
                if (n < 256) continue;
                logger.debug((Object)"Setting jco.client.codepage to 4102");
                properties.setProperty("jco.client.codepage", "4102");
                break;
            }
            logger.debug((Object)("About to changeProperties with " + (String)object));
            this.getMyProvider().changeProperties((String)object, properties);
            jCoDestination = JCoDestinationManager.getDestination((String)object);
            logger.trace((Object)("SAP Destination " + jCoDestination.getDestinationName() + " was obtained."));
            logger.trace((Object)("*** theDestination = " + jCoDestination));
        }
        catch (Exception exception) {
            logger.error((Object)"Error obtaining destination.", (Throwable)exception);
            throw new ResourceUnavailableException("Error obtaining destination.", (Throwable)exception);
        }
        return jCoDestination;
    }

    private SAPDestinationDataProvider getMyProvider() {
        return myProvider;
    }

    protected SAPSystemEnvironment getSAPSystemEnvironment(long l) throws ResourceUnavailableException {
        try {
            if (this.sapSystemEnvironmentsDM == null) {
                this.sapSystemEnvironmentsDM = (SAPSystemEnvironmentsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPSystemEnvironmentsDM");
            }
            return this.sapSystemEnvironmentsDM.get(l);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAPSystemEnvironment for ID " + l, (Throwable)exception);
        }
    }

    protected SAPSystemDefinition getSAPSystemDefinition(long l) throws ResourceUnavailableException {
        try {
            return this.getSAPSystemDefinitionsDM().get(l);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAPSystemDefinition for ID " + l, (Throwable)exception);
        }
    }

    protected SAPSystemDefinitionsDM getSAPSystemDefinitionsDM() throws ResourceUnavailableException {
        if (this.sapSystemDefinitionsDM == null) {
            this.sapSystemDefinitionsDM = (SAPSystemDefinitionsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPSystemDefinitionsDM");
        }
        return this.sapSystemDefinitionsDM;
    }

    protected String startSAPXMISession(SAPConnection sAPConnection) throws ResourceUnavailableException, JCoException {
        String string = "None";
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionXMILogon(sAPConnection);
        sAPConnection.executeFirstFunction(jCoFunction);
        string = jCoFunction.getExportParameterList().getString("SESSIONID");
        logger.debug((Object)("sessionID = " + string));
        JCoFunction jCoFunction2 = SAPFunctionUtility.getFunctionXMISetAuditLevel(sAPConnection);
        sAPConnection.executeMiddleFunction(jCoFunction2);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction2);
        if (sAPReturnMessage.isError()) {
            logger.warn((Object)("Error setting XMI Audit Level to " + sAPConnection.getXMIAuditLevel() + ".  " + sAPReturnMessage.getFullReturnMessage()));
        } else {
            logger.debug((Object)("XMI Audit Level Set to " + sAPConnection.getXMIAuditLevel() + " for session ID " + string));
        }
        return string;
    }

    protected boolean endSAPXMISession(SAPConnection sAPConnection) {
        if (sAPConnection == null) {
            logger.debug((Object)"Failed to end SAP XMI Session.  SAPConnection is null.");
            return false;
        }
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionXMILogoff(sAPConnection);
            sAPConnection.executeFinalFunction(jCoFunction);
            return true;
        }
        catch (JCoException jCoException) {
            logger.error((Object)"Error ending SAP XMI Session.", (Throwable)jCoException);
            return false;
        }
    }
}

