/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.ServerHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.ServerHistoryReportParser;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServerHistoryReport
extends AbstractJasperReport
implements Serializable {
    public static final String REPORT_NAME = "ServerHistoryReport";
    public static final int REPORT_ID = Reports.ReportType.SERVER_HISTORY_REPORT.getReportID();
    public static final String HEADER_DATE = "HEADER_DATE";
    private static final String ALL_JOBS = "All Jobs";
    private static final Logger logger = Logger.getLogger(ServerHistoryReport.class);
    private List<String> jobList = new ArrayList<String>();
    private List<String> agentList = new ArrayList<String>();
    ServerHistoryReportFilter filter = new ServerHistoryReportFilter();
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private static final String AGENTS = "-agents";
    private static final String TAGS = "-tags";
    private static final String USER_NAME = "-userName";
    private static final String DATE_RANGE = "-dateRange";
    private static final String END_DATE_DURATION = "-endDateDuration";
    private static final String START_DATE_DURATION = "-startDateDuration";
    private static final String JOB_STATUSES = "-jobStatuses";
    private static final String JOB_NAMES = "-jobNames";
    private static final String JOB_IDS = "-jobIds";

    public ServerHistoryReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    public int getReportID() {
        return REPORT_ID;
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = ServerHistoryReport.createReportDataBuilder();
        Long l = this.filter.getToDate();
        Long l2 = this.filter.getFromDate();
        this.parentParams.put("HEADER_REPORT_NAME", "Server History");
        this.parentParams.put("HEADER_FROM_DATE", ReportHelper.getStartDate(l2));
        this.parentParams.put("HEADER_TO_DATE", ReportHelper.getEndDate(l));
        this.parentParams.put(HEADER_DATE, ReportHelper.getFormatedDate(new Date()));
        this.parentParams.put("REPORT_OUTPUT_TYPE", this.getOutputType().name());
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.jobList.add(ALL_JOBS);
        this.agentList.add(ALL_JOBS);
        this.parentParams.put("TITLE_JOB_LIST", this.jobList);
        this.parentParams.put("TITLE_AGENT_LIST", this.agentList);
        this.buildParameterReport(this.parentParams);
        ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getServerHistory(this.filter);
        this.buildParameterReport(this.parentParams);
        if (arrayList != null && !arrayList.isEmpty()) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                reportDataBuilder.nextRow();
                Date date = new Date((Long)arrayList.get(i).get("SERVER_HISTORY_DATE"));
                reportDataBuilder.setFieldValue("SERVER_HISTORY_DATE", date);
                String string = (String)arrayList.get(i).get("SERVER_HISTORY_MESSAGE");
                reportDataBuilder.setFieldValue("SERVER_HISTORY_MESSAGE", string);
            }
            logger.trace((Object)"The Server History has been built.");
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"Server History data has been built.");
        return jasperReportData;
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = ServerHistoryReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        ServerHistoryReportParser serverHistoryReportParser = new ServerHistoryReportParser();
        this.replaceIfNotAKey(objectArray);
        serverHistoryReportParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(DATE_RANGE) || string.equals(AGENTS) || string.equals(TAGS) || string.equals(END_DATE_DURATION) || string.equals(START_DATE_DURATION) || string.equals(JOB_STATUSES) || string.equals(USER_NAME) || string.equals(JOB_NAMES) || string.equals(JOB_IDS) || string.equals("-f");
    }
}

