/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.SAPInterceptedJobHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPInterceptedJobHistoryReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportBuilder;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAPInterceptedJobHistoryReport
extends AbstractJasperReport
implements Serializable {
    SAPInterceptedJobHistoryReportFilter filter = new SAPInterceptedJobHistoryReportFilter();
    private static final long serialVersionUID = -871313742802236807L;
    public static final String REPORT_NAME = "SAPInterceptedJobHistoryReport";
    public static final String PARAM_DELIMITER = " ";
    private static final Logger logger = Logger.getLogger(SAPInterceptedJobHistoryReport.class);
    private ScheduleJobDM job;
    final Map<String, Object> parentParams = new HashMap<String, Object>();

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    public SAPInterceptedJobHistoryReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.job = (ScheduleJobDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleJobDM");
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    JasperReportData buildReportData() {
        Object object;
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPInterceptedJobHistoryReport.createReportDataBuilder();
        this.parentParams.put("HEADER_REPORT_NAME", REPORT_NAME);
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.buildParameterReport(this.parentParams);
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("GROUPING", "HISTORY_LIST");
        ArrayList<HashMap<String, Object>> arrayList = this.reportDM.getSAPInterceptedJobHistory(this.filter);
        if (arrayList != null && !arrayList.isEmpty()) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            object = new ReportBuilder();
            ((ReportBuilder)object).buildSapInterceptedJobHistoryTable(arrayList, false);
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", ((ReportBuilder)object).getParams());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", ((ReportBuilder)object).getJRDataSource());
            this.log("The Job History Data List has been built.");
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        object = new JasperReportData();
        ((JasperReportData)object).setParameters(this.parentParams);
        ((JasperReportData)object).setData(reportDataBuilder.toJRDataSource());
        this.log("SAP Intercepted Job History Report data has been built.");
        return object;
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPInterceptedJobHistoryReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        SAPInterceptedJobHistoryReportFilterParser sAPInterceptedJobHistoryReportFilterParser = new SAPInterceptedJobHistoryReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        sAPInterceptedJobHistoryReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals("-sapClients") || string.equals("-sapJobNames") || string.equals("-sapJobOwners") || string.equals("-sapSystemDefinitions") || string.equals("-agents") || string.equals("-jobNames") || string.equals("-userName") || string.equals("-f") || string.equals("-scheduledReleaseStartDateRange") || string.equals("-scheduledReleaseEndDateDuration") || string.equals("-scheduledReleaseStartDateDuration") || string.equals("-sapPlannedStartDateRange") || string.equals("-sapPlannedEndDateDuration") || string.equals("-sapPlannedStartDateDuration");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.SAP_INTERCEPTED_JOB_HISTORY_REPORT.getReportID();
    }
}

