/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.LanguageCode;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStep;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStepSet;
import com.helpsystems.enterprise.core.busobj.sap.SAPLanguageKeys;
import com.helpsystems.enterprise.core.dm.LanguageCodesDM;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.sap.SAPABAPStepSetsDM;
import com.helpsystems.enterprise.core.enums.AndOrSelection;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.SAPAbapStepSetReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.SAPAbapStepSetReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.module.reports.jasper.SAPJobDefinitionReport;
import com.helpsystems.enterprise.module.reports.jasper.SAPReportHelper;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAPAbapStepSetReport
extends AbstractJasperReport
implements Serializable {
    private static final long serialVersionUID = -3312144399963002957L;
    public static final String REPORT_NAME = "SAPAbapStepSetReport";
    public static final String HEADER_DATE = "HEADER_DATE";
    public static final String FIELD_GROUPING = "GROUPING";
    public static final String END_OF_REPORT = "END_OF_REPORT";
    public static final String NO_DATA_EXISTS = "NO_DATA_EXISTS";
    public static final String ONELINEFIELD = "ONELINEFIELD";
    public static final String FIELD_SHOW_COLUMN_BACK_COLOR = "SHOW_COLUMN_BACK_COLOR";
    private static final Logger logger = Logger.getLogger(SAPJobDefinitionReport.class);
    private SAPAbapStepSetReportFilter filter = new SAPAbapStepSetReportFilter();
    private Long[] sapAbapStepSetListToShow;
    private SAPABAPStepSetsDM sapAbapStepSetsDM;
    private LanguageCodesDM languageCodesDM;
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    public static final String NAMEFIELD = "NAMEFIELD";
    public static final String VALUEFIELD = "VALUEFIELD";

    public SAPAbapStepSetReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
        this.sapAbapStepSetsDM = (SAPABAPStepSetsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPABAPStepSetsDM");
        this.languageCodesDM = (LanguageCodesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.LanguageCodesDM");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.SAP_ABAP_STEP_SET_REPORT.getReportID();
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() throws ReportException {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPAbapStepSetReport.createReportDataBuilder();
        String[] stringArray = this.filter.getAbapStepSetNameList();
        String[] stringArray2 = this.filter.getAbapProgramNameList();
        String[] stringArray3 = this.filter.getSapSystemDefList();
        String[] stringArray4 = this.filter.getTags();
        boolean bl = this.filter.isSelectedAllUntaggedSASSs();
        AndOrSelection andOrSelection = this.filter.getObjectsAndOrSelection();
        this.sapAbapStepSetListToShow = this.reportDM.getSAPAbapStepSetIdList(stringArray, stringArray2, stringArray3, stringArray4, bl, andOrSelection);
        this.parentParams.put(HEADER_DATE, ReportHelper.getFormatedDate(new Date()));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.parentParams.put("REPORT_NAME", REPORT_NAME);
        try {
            this.buildTableOfContentData(reportDataBuilder);
            this.buildParameterReport(this.parentParams);
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
        if (this.sapAbapStepSetListToShow.length == 0) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(NO_DATA_EXISTS, "No SAP NetWeaver\u00ae ABAP Step Set records.");
        } else {
            for (int i = 0; i < this.sapAbapStepSetListToShow.length; ++i) {
                this.buildData(reportDataBuilder, this.sapAbapStepSetListToShow[i]);
            }
            reportDataBuilder.setFieldValue(END_OF_REPORT, "*** End of Report ***");
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"SAP Abap Step Set Report has been built.");
        return jasperReportData;
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (this.isEqualToKey(string) || string.equals("-") || !string.startsWith("-")) continue;
            String string2 = string.replaceAll("-", "val_");
            objectArray[i] = string2;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return false;
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        SAPAbapStepSetReportFilterParser sAPAbapStepSetReportFilterParser = new SAPAbapStepSetReportFilterParser();
        sAPAbapStepSetReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SAPAbapStepSetReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    private void buildTableOfContentData(AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap hashMap = new HashMap();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPAbapStepSetReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        for (int i = 0; i < this.sapAbapStepSetListToShow.length; ++i) {
            try {
                SAPABAPStepSet sAPABAPStepSet = this.sapAbapStepSetsDM.get(this.sapAbapStepSetListToShow[i], null);
                String string = sAPABAPStepSet.getName();
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, string);
                continue;
            }
            catch (NoDataException noDataException) {
                // empty catch block
            }
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.TABLE_OF_CONTENT.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The Table of Content data has been built.");
    }

    private void buildGeneralData(SAPABAPStepSet sAPABAPStepSet, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPAbapStepSetReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.GENERAL.name());
        reportDataBuilder.setFieldValue("SAP_SYSTEM_DEFINITION_NAME", sAPABAPStepSet.getName());
        hashMap.put("HEADER_NAME", sAPABAPStepSet.getName());
        hashMap.put("JLR_SUB_TITLE", "General");
        SAPReportHelper.addRowWithTwoColumns("Name:", sAPABAPStepSet.getName(), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Description:", sAPABAPStepSet.getDescription(), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("Tags:", this.reportDM.getTagsBySapAbapStepSetID(sAPABAPStepSet.getOID()), reportDataBuilder2);
        SAPReportHelper.addRowWithTwoColumns("System Definition:", this.reportDM.getSapSystemDefinitionName(sAPABAPStepSet.getOID()), reportDataBuilder2);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The general report data has been built.");
    }

    private void buildStepsData(SAPABAPStepSet sAPABAPStepSet, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        if (sAPABAPStepSet.getStepList().size() == 0) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SAPAbapStepSetReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        hashMap.put("JLR_SUB_TITLE", "Steps");
        ArrayList<SAPABAPStep> arrayList = sAPABAPStepSet.getStepList();
        int n = 0;
        for (SAPABAPStep sAPABAPStep : arrayList) {
            if (n != 0) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(ONELINEFIELD, "");
                reportDataBuilder2.setFieldValue(FIELD_SHOW_COLUMN_BACK_COLOR, new Boolean(true));
            }
            String string = SAPLanguageKeys.getISOCodeForKey(sAPABAPStep.getLanguageCode());
            LanguageCode languageCode = this.languageCodesDM.getForCode(string);
            SAPReportHelper.buildAbapStepSection(reportDataBuilder2, sAPABAPStep, languageCode);
            SAPReportHelper.buildPrintParamReportSection(reportDataBuilder2, this.reportDM, sAPABAPStep);
            ++n;
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.STEPS.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of sap abap step set steps has been built!");
    }

    private void buildData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, long l) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = reportDataBuilder;
        try {
            SAPABAPStepSet sAPABAPStepSet = this.sapAbapStepSetsDM.get(l, null);
            this.buildGeneralData(sAPABAPStepSet, reportDataBuilder2);
            this.buildStepsData(sAPABAPStepSet, reportDataBuilder2);
            logger.trace((Object)("SAP ABAP Step Set Report for SAP ABAP Step Set " + sAPABAPStepSet.getName() + " has been built."));
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
    }

    private static enum Groupings {
        TABLE_OF_CONTENT,
        GENERAL,
        STEPS,
        Empty;

    }
}

