/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.dm.HistoryReportRowHandler;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.TranslationDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.AuditHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.AuditHistoryReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportBuilder;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.AuditChangeComparator;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class AuditHistoryReport
extends AbstractJasperReport
implements Serializable,
HistoryReportRowHandler {
    private static final long serialVersionUID = -871313742802236807L;
    private static final String ALL_JOBS = "All Jobs";
    public static final String REPORT_NAME = "AuditHistoryReport";
    private static final Logger logger = Logger.getLogger(AuditHistoryReport.class);
    private AuditHistoryReportFilter filter = new AuditHistoryReportFilter();
    private List<String> jobList = new ArrayList<String>();
    private List<String> agentList = new ArrayList<String>();
    private List<String> tagList = new ArrayList<String>();
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private ReportBuilder dataReportBuilder = null;
    private static final String USER_NAME = "-userName";
    private static final String DATE_RANGE = "-dateRange";
    private static final String END_DATE_DURATION = "-endDateDuration";
    private static final String START_DATE_DURATION = "-startDateDuration";
    private static final String JOB_IDS = "-jobIds";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    public AuditHistoryReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    JasperReportData buildReportData() {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = AuditHistoryReport.createReportDataBuilder();
        Long l = this.filter.getToDate();
        Long l2 = this.filter.getFromDate();
        this.parentParams.put("HEADER_REPORT_NAME", REPORT_NAME);
        this.parentParams.put("HEADER_FROM_DATE", ReportHelper.getStartDate(l2));
        this.parentParams.put("HEADER_TO_DATE", ReportHelper.getEndDate(l));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.jobList.add(ALL_JOBS);
        this.agentList.add(ALL_JOBS);
        this.tagList.add(ALL_JOBS);
        this.parentParams.put("TITLE_JOB_LIST", this.jobList);
        this.parentParams.put("TITLE_AGENT_LIST", this.agentList);
        this.parentParams.put("TITLE_TAG_LIST", this.tagList);
        this.reportDM.getAuditHistoryInPeriod(l2, l, this);
        this.buildParameterReport(this.parentParams);
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("GROUPING", "HISTORY_LIST");
        if (this.dataReportBuilder != null) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", this.dataReportBuilder.getParams());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", this.dataReportBuilder.getJRDataSource());
            this.log("The Audit History Data List has been built.");
            reportDataBuilder.nextRow();
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        this.log("Audit History Report data has been built.");
        return jasperReportData;
    }

    private void buildChanges(ArrayList<ArrayList<String>> arrayList, ReportBuilder reportBuilder) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<String> arrayList2 = arrayList.get(i);
            String string = "CHANGE";
            if (arrayList2.size() == 3) {
                string = "UPDATE_CHANGE";
            }
            reportBuilder.nextRow();
            reportBuilder.getReportDataBuilder().setFieldValue("RECORD_LEVEL", string);
            for (int j = 0; j < arrayList2.size(); ++j) {
                String string2 = arrayList2.get(j);
                if (j > 0) {
                    string2 = ReportHelper.getPureString(arrayList2.get(j));
                }
                string2 = j == 0 ? string2.toLowerCase() : string2;
                reportBuilder.getReportDataBuilder().setFieldValue(this.getLineKey(j), string2);
            }
        }
        reportBuilder.nextRow();
        reportBuilder.getReportDataBuilder().setFieldValue("RECORD_LEVEL", "EMPTY_LINE");
    }

    private String getLineKey(int n) {
        switch (n) {
            case 0: {
                return "AUDIT_CHANGE_FIELD";
            }
            case 2: {
                return "AUDIT_CHANGE_NEW_VALUE";
            }
        }
        return "AUDIT_CHANGE_VALUE";
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = AuditHistoryReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        AuditHistoryReportFilterParser auditHistoryReportFilterParser = new AuditHistoryReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        auditHistoryReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(DATE_RANGE) || string.equals(END_DATE_DURATION) || string.equals(START_DATE_DURATION) || string.equals(USER_NAME) || string.equals(JOB_IDS) || string.equals("-f");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.AUDIT_HISTORY_REPORT.getReportID();
    }

    @Override
    public void handleRow(ResultSet resultSet) throws SQLException {
        Object object;
        if (this.dataReportBuilder == null) {
            this.dataReportBuilder = new ReportBuilder();
        }
        this.dataReportBuilder.nextRow();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.dataReportBuilder.getReportDataBuilder().setFieldValue("RECORD_LEVEL", "DETAIL");
        String string = ReportHelper.getActionString(resultSet.getString("action"));
        String string2 = resultSet.getString("audit_type");
        String string3 = resultSet.getString("changes");
        ArrayList<ArrayList<String>> arrayList = this.reportDM.parseAuditChanges(string3, string2);
        TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.TranslationDM");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string4 = resultSet.getString("area");
        stringBuffer2.append("audit_lookup.");
        if (string4 != null) {
            stringBuffer2.append(string4.replace(' ', '_').toLowerCase());
        } else {
            int n = resultSet.getInt("audit_lookup_id");
            logger.warn((Object)("The field 'area' in 'audit_lookup' is null where audit_lookup_id is " + n));
        }
        String string5 = translationDM.getTranslation(stringBuffer2.toString());
        if (string5.indexOf("&reg;") != -1) {
            int n = 174;
            object = new Character((char)n).toString();
            string5 = ReportHelper.replace(string5, "&reg;", (String)object);
        }
        stringBuffer.append(string5);
        stringBuffer.append(" (");
        String string6 = resultSet.getString("key_value");
        if (string6 == null) {
            int n = resultSet.getInt("audit_lookup_id");
            logger.warn((Object)("The field 'key_value' in 'audit_lookup' is null where audit_lookup_id is " + n));
            string6 = "";
        }
        stringBuffer.append(string6);
        stringBuffer.append(")");
        object = resultSet.getTimestamp("CREATED_AT", calendar);
        String string7 = ReportHelper.getActionStringAction(string);
        String string8 = resultSet.getString("username");
        String string9 = "";
        this.dataReportBuilder.put("AUDIT_DATE", "Date", object);
        this.dataReportBuilder.put("AUDIT_AREA", "Area", stringBuffer.toString());
        this.dataReportBuilder.put("AUDIT_ACTION", "Action", string7);
        if ("Note".equals(string2)) {
            string9 = translationDM.getAuditFileTranslation(string4) + " " + translationDM.getAuditFileTranslation(string2);
            this.dataReportBuilder.put("AUDIT_TYPE", "Type", string9);
        } else {
            string9 = translationDM.getAuditFileTranslation(string2);
            this.dataReportBuilder.put("AUDIT_TYPE", "Type", string9);
        }
        this.dataReportBuilder.put("AUDIT_USER", "User", string8);
        this.dataReportBuilder.put("AUDIT_CHANGE", "Changes", arrayList);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing audit record: Timestamp: " + ScheduleLogger.formatTimeStampSecs((Date)object) + " Username: " + string8 + " Area: " + stringBuffer.toString() + " Action: " + string7 + " Type: " + string9 + ""));
        }
        try {
            Collections.sort(arrayList, new AuditChangeComparator());
            this.buildChanges(arrayList, this.dataReportBuilder);
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Unable to get changes.", throwable);
        }
    }
}

