/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.NotificationList;
import com.helpsystems.enterprise.core.busobj.Role;
import com.helpsystems.enterprise.core.busobj.User;
import com.helpsystems.enterprise.core.busobj.UserFile;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.ReportsProcessorAM;
import com.helpsystems.enterprise.core.dm.RoleDM;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.dm.UserDM;
import com.helpsystems.enterprise.core.dm.UserFileDM;
import com.helpsystems.enterprise.core.enums.FileTypeEnum;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.reports.Report;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import com.helpsystems.enterprise.module.reports.jasper.AgentEventHistoryReport;
import com.helpsystems.enterprise.module.reports.jasper.AuditHistoryReport;
import com.helpsystems.enterprise.module.reports.jasper.ForecastJobRunsReport;
import com.helpsystems.enterprise.module.reports.jasper.GoodMorningReport;
import com.helpsystems.enterprise.module.reports.jasper.ImportValidationReport;
import com.helpsystems.enterprise.module.reports.jasper.JobHistoryReport;
import com.helpsystems.enterprise.module.reports.jasper.JobMonitorHistoryReport;
import com.helpsystems.enterprise.module.reports.jasper.JobSetupReport;
import com.helpsystems.enterprise.module.reports.jasper.OutputDistributionHistoryReport;
import com.helpsystems.enterprise.module.reports.jasper.SAPAbapStepSetReport;
import com.helpsystems.enterprise.module.reports.jasper.SAPInterceptedJobHistoryReport;
import com.helpsystems.enterprise.module.reports.jasper.SAPJobDefinitionReport;
import com.helpsystems.enterprise.module.reports.jasper.SAPRunInterceptedJobsReport;
import com.helpsystems.enterprise.module.reports.jasper.SAPSystemDefinitionReport;
import com.helpsystems.enterprise.module.reports.jasper.SNMPTrapMonitorHistoryReport;
import com.helpsystems.enterprise.module.reports.jasper.SecurityReport;
import com.helpsystems.enterprise.module.reports.jasper.ServerHistoryReport;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.ServicePeer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ReportsProcessorAMImpl
extends AbstractManager
implements ReportsProcessorAM {
    private static final Logger logger = Logger.getLogger(ReportsProcessorAMImpl.class);
    private StandbyBackupFileQueueAM standbyBackupFileQueueAM = null;
    private UserFileDM userFileDM = null;
    private RoleDM roleDM = null;
    private final AgentPeer agentPeer;
    private static final String USE_GOOD_MORNING_REPORTS = "use_GoodMorningReports";
    private static final String USE_JOB_HISTORY_REPORTS = "use_JobHistoryReports";
    private static final String USE_AGENT_EVENT_HISTORY_REPORTS = "use_AgentEventHistoryReports";
    private static final String USE_JOB_MONITOR_HISTORY_REPORTS = "use_JobMonitorHistoryReports";
    private static final String USE_OUTPUT_DISTRIBUTION_HISTORY_REPORTS = "use_OutputDistributionHistoryReports";
    private static final String USE_SNMP_TRAP_MONITOR_HISTORY_REPORTS = "use_SNMPTrapMonitorHistoryReports";
    private static final String USE_JOB_SETUP_REPORTS = "use_JobSetupReports";
    private static final String USE_AUDIT_HISTORY_REPORTS = "use_AuditHistoryReports";
    private static final String USE_FORECAST_REPORTS = "use_ForecastReports";
    private static final String USE_SERVER_HISTORY_REPORTS = "use_ServerHistoryReports";
    private static final String USE_SECURITY_REPORTS = "use_SecurityReports";
    private static final String USE_SAP_SYSTEM_DEFINITION_REPORTS = "use_SapSystemDefinitionReports";
    private static final String USE_SAP_JOB_DEFINITION_REPORTS = "use_SapJobDefinitionReports";
    private static final String USE_SAP_ABAP_STEP_SET_REPORTS = "use_SapAbapStepSetReports";
    private static final String USE_SAP_INTERCEPTED_JOB_HISTORY_REPORTS = "use_SapInterceptedJobHistoryReports";
    private EnterpriseEmailAM entEmail;

    public ReportsProcessorAMImpl(AgentPeer agentPeer, EnterpriseEmailAM enterpriseEmailAM) {
        this.setName("ENTERPRISE.ReportsProcessorAM");
        this.agentPeer = agentPeer;
        this.entEmail = enterpriseEmailAM;
    }

    private UserFileDM getDM() {
        if (this.userFileDM == null) {
            this.userFileDM = (UserFileDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.UserFileDM");
        }
        return this.userFileDM;
    }

    private RoleDM getRoleDM() {
        if (this.roleDM == null) {
            this.roleDM = (RoleDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RoleDM");
        }
        return this.roleDM;
    }

    private StandbyBackupFileQueueAM getStandbyBackupFileQueueAM() {
        if (this.standbyBackupFileQueueAM == null) {
            if (this.agentPeer.isServer()) {
                this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.StandbyBackupFileQueueAM");
            } else {
                PeerID peerID = ((ServicePeer)this.agentPeer).getServerPeerID();
                this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.StandbyBackupFileQueueAM");
            }
        }
        return this.standbyBackupFileQueueAM;
    }

    private void checkPermission(int n, String string, String string2, long l) throws ReportException {
        RoleDM roleDM = this.getRoleDM();
        try {
            Role role = roleDM.get(l);
            String string3 = role.getPermissions();
            String string4 = "The user " + string2 + " does not have permission to generate " + string;
            switch (n) {
                case 0: {
                    if (string3.contains(USE_GOOD_MORNING_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 100: {
                    if (string3.contains(USE_JOB_SETUP_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1000: {
                    if (string3.contains(USE_JOB_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1001: {
                    if (string3.contains(USE_AGENT_EVENT_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1002: {
                    if (string3.contains(USE_JOB_MONITOR_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1003: {
                    if (string3.contains(USE_OUTPUT_DISTRIBUTION_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1004: {
                    if (string3.contains(USE_SNMP_TRAP_MONITOR_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1005: {
                    if (string3.contains(USE_AUDIT_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1006: {
                    if (string3.contains(USE_FORECAST_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1007: {
                    if (string3.contains(USE_SERVER_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1009: {
                    if (string3.contains(USE_SAP_SYSTEM_DEFINITION_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1010: {
                    if (string3.contains(USE_SAP_JOB_DEFINITION_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1013: {
                    if (string3.contains(USE_SAP_INTERCEPTED_JOB_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1011: {
                    if (string3.contains(USE_SAP_ABAP_STEP_SET_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1012: {
                    if (string3.contains(USE_SAP_INTERCEPTED_JOB_HISTORY_REPORTS)) break;
                    throw new ReportException(string4);
                }
                case 1014: {
                    if (string3.contains(USE_SECURITY_REPORTS)) break;
                    throw new ReportException(string4);
                }
            }
        }
        catch (DataException dataException) {
            throw new ReportException("Unable check permission", dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ReportException("Unable check permission", resourceUnavailableException);
        }
    }

    @Override
    public Report generateReport(int n, ReportOutput.OutputType outputType, String string, long l, Object ... objectArray) throws ReportException {
        String[] stringArray;
        Object object;
        String string2;
        Object object2;
        Report report = null;
        UserFile userFile = null;
        File file = null;
        File file2 = null;
        String string3 = null;
        User user = null;
        try {
            object2 = (UserDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.UserDM");
            User user2 = null;
            String string4 = Reports.getUserName(objectArray);
            String string5 = null;
            if (string4 == null) {
                string5 = string;
            } else {
                string5 = string4;
                user2 = object2.getUserByName(string4);
            }
            user = user2 != null ? user2 : object2.getUserByNameOrAdmin(string5);
            report = this.getReport(n, outputType, string5, objectArray);
            string2 = report.getReportName();
            file = report.getDestinationFile();
            if (report.getReportID() == 1008) {
                object = file.getAbsolutePath();
                int n2 = ((String)object).indexOf(report.getOutputType().getReportTypeExtension());
                object = ((String)object).substring(0, n2);
                object = (String)object + "_";
                object = (String)object + objectArray[0];
                object = (String)object + report.getOutputType().getReportTypeExtension();
                file = new File((String)object);
                report.setDestinationFile(file);
            }
            userFile = this.addUserFileRecord(file, report.getRunAsUserID(), l);
            file2 = report.getLogFile();
            if (string4 != null && user2 == null) {
                string3 = "User \"" + string4 + "\" does not exist. ";
                logger.info((Object)string3);
                logger.debug((Object)string3);
                report.log("");
                report.log(string3);
                throw new ReportException(string3);
            }
            object = user.getName();
            string3 = "User " + (String)object + " submitted to generate " + string2 + " report with " + outputType.name() + " type.";
            logger.info((Object)string3);
            string3 = "About to render report " + report.getReportName();
            logger.debug((Object)string3);
            report.log("");
            report.log(string3);
            this.checkPermission(n, string2, string5, user.getRoleId());
            string3 = "Rendering report " + report.getReportName() + " to " + file.getAbsolutePath();
            logger.debug((Object)string3);
            report.log(string3);
            report.renderReport();
            try {
                if (logger.isTraceEnabled()) {
                    logger.debug((Object)("Updating Output Distribution history record: " + file));
                }
                userFile.setStatus(2);
                userFile.setFileSize(file.length());
                userFile.setFileType(FileTypeEnum.PDF.getValue());
                this.getDM().save(userFile);
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to update Ouput Distribution History.", (Throwable)exception);
            }
            string3 = "Report " + report.getReportName() + " finished rendering.  Output file is located at: " + file.getAbsolutePath();
            logger.debug((Object)string3);
            report.log(string3);
            StandbyBackupFile standbyBackupFile = new StandbyBackupFile();
            standbyBackupFile.setActionType(0);
            standbyBackupFile.setFileType(1);
            standbyBackupFile.setFullFileName(file.getAbsolutePath());
            String string6 = OutputDistributionSetup.getUserFileRelativeName();
            String string7 = string6 + File.separator + report.getRunAsUserID();
            standbyBackupFile.setServerDirName(string7);
            String string8 = string7 + File.separator + file.getName();
            standbyBackupFile.setServerFileName(string8);
            try {
                this.getStandbyBackupFileQueueAM().putStandbyBackupFile(standbyBackupFile);
            }
            catch (ActionFailedException actionFailedException) {
                logger.error((Object)"Can't put user transfer file in queue", (Throwable)actionFailedException);
            }
            String[] stringArray2 = new String[]{object, string2};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.MANUALLY_GENERATE_REPORT.newLogEntry(stringArray2);
            ScheduleLogger.write(scheduleLogEntry);
        }
        catch (Throwable throwable) {
            if (report == null) {
                string3 = "Report failed.";
                logger.error((Object)string3, throwable);
            } else {
                string3 = "Report " + report.getReportName() + " failed.";
                logger.error((Object)string3, throwable);
                report.log(string3, throwable);
                throwable.printStackTrace(report.getReportLogWriter());
                this.createLogReportFile(file2.getAbsolutePath(), report.getReportLogWriters());
            }
            if (userFile != null && file2 != null) {
                userFile.setFileName(file2.getName());
                userFile.setStatus(3);
                userFile.setFileSize(file2.length());
                userFile.setFileType(FileTypeEnum.LOG.getValue());
                try {
                    this.getDM().save(userFile);
                }
                catch (Exception exception) {
                    string3 = "Problem updating Output Distribution History record.";
                    logger.error((Object)string3, (Throwable)exception);
                    exception.printStackTrace();
                }
                StandbyBackupFile standbyBackupFile = new StandbyBackupFile();
                standbyBackupFile.setFileType(1);
                standbyBackupFile.setFullFileName(file2.getAbsolutePath());
                String string9 = OutputDistributionSetup.getUserFileRelativeName();
                String string10 = string9 + File.separator + report.getRunAsUserID();
                standbyBackupFile.setServerDirName(string10);
                String string11 = string10 + File.separator + report.getReportLogFileName();
                standbyBackupFile.setServerFileName(string11);
                try {
                    this.getStandbyBackupFileQueueAM().putStandbyBackupFile(standbyBackupFile);
                }
                catch (ActionFailedException actionFailedException) {
                    logger.error((Object)"Can't put user transfer file in queue", (Throwable)actionFailedException);
                }
            }
            throw new ReportException(file2.getAbsolutePath());
        }
        report.copyfile(report.getSavedReportFilePath(), report.getSavedReportFileName());
        object2 = new HashSet();
        if (report.getEmailToAddress() != null) {
            for (int i = 0; i < report.getEmailToAddress().length; ++i) {
                object2.add(report.getEmailToAddress()[i]);
            }
        }
        if (report.isEmailToCurrentUser() && user != null) {
            object2.add(user.getEmailAddress());
        }
        if (report.getEmailToNotificationList() != null && report.getEmailToNotificationList().length > 0) {
            NotificationListDM notificationListDM = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
            for (int i = 0; i < report.getEmailToNotificationList().length; ++i) {
                string2 = report.getEmailToNotificationList()[i];
                try {
                    object = notificationListDM.getNotificationListByName(string2);
                    for (int j = 0; j < ((NotificationList)((Object)object)).getListOfUniqueEmails().length; ++j) {
                        object2.add(((NotificationList)((Object)object)).getListOfUniqueEmails()[j]);
                    }
                    continue;
                }
                catch (NoDataException noDataException) {
                    logger.debug((Object)"Error loading notification list", (Throwable)noDataException);
                    continue;
                }
                catch (BadDataException badDataException) {
                    logger.debug((Object)"Error loading notification list", (Throwable)badDataException);
                    continue;
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.debug((Object)"Error loading notification list", (Throwable)resourceUnavailableException);
                }
            }
        }
        if ((stringArray = object2.toArray(new String[object2.size()])).length > 0) {
            report.setSystemExit(false);
            report.sendReport(stringArray, this.entEmail);
        } else {
            report.setSystemExit(true);
        }
        return report;
    }

    private Report getReport(int n, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        logger.debug((Object)("Initalizing report: " + n));
        try {
            switch (n) {
                case 0: {
                    return new GoodMorningReport(Locale.US, outputType, string, objectArray);
                }
                case 100: {
                    return new JobSetupReport(Locale.US, outputType, string, objectArray);
                }
                case 1000: {
                    return new JobHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1001: {
                    return new AgentEventHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1002: {
                    return new JobMonitorHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1003: {
                    return new OutputDistributionHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1004: {
                    return new SNMPTrapMonitorHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1005: {
                    return new AuditHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1006: {
                    return new ForecastJobRunsReport(Locale.US, outputType, string, objectArray);
                }
                case 1007: {
                    return new ServerHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1008: {
                    return new ImportValidationReport(Locale.US, outputType, string, objectArray);
                }
                case 1009: {
                    return new SAPSystemDefinitionReport(Locale.US, outputType, string, objectArray);
                }
                case 1010: {
                    return new SAPJobDefinitionReport(Locale.US, outputType, string, objectArray);
                }
                case 1011: {
                    return new SAPAbapStepSetReport(Locale.US, outputType, string, objectArray);
                }
                case 1013: {
                    return new SAPRunInterceptedJobsReport(Locale.US, outputType, string, objectArray);
                }
                case 1012: {
                    return new SAPInterceptedJobHistoryReport(Locale.US, outputType, string, objectArray);
                }
                case 1014: {
                    return new SecurityReport(Locale.US, outputType, string, objectArray);
                }
            }
        }
        catch (Throwable throwable) {
            String string2 = "Unable to initialize the report.";
            logger.debug((Object)string2, throwable);
            throw new IllegalStateException(string2, throwable);
        }
        throw new IllegalStateException("Report ID: " + n + " is not supported.");
    }

    private UserFile addUserFileRecord(File file, long l, long l2) {
        UserFile userFile = new UserFile();
        userFile.setOid(l2);
        userFile.setFileName(file.getName());
        userFile.setStatus(1);
        userFile.setStoredLocation(file.getParent());
        userFile.setUserId(l);
        UserFile userFile2 = null;
        if (logger.isTraceEnabled()) {
            logger.debug((Object)("Creating User File record: " + file.getName()));
        }
        try {
            userFile2 = this.getDM().save(userFile);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to create User File for report " + file.getName()));
            exception.printStackTrace();
        }
        return userFile2;
    }

    @Override
    public void createLogReportFile(String string, StringWriter stringWriter) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(stringWriter.toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            logger.debug((Object)("Unable to create the log report file " + string), (Throwable)iOException);
        }
    }
}

