/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.util.DurableQueue;
import com.helpsystems.enterprise.core.busobj.UserFile;
import com.helpsystems.enterprise.core.cmdlineobj.ReportCommand;
import com.helpsystems.enterprise.core.dm.ReportSubmitterAM;
import com.helpsystems.enterprise.core.dm.UserDM;
import com.helpsystems.enterprise.core.dm.UserFileDM;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class ReportSubmitterAMImpl
extends AbstractManager
implements ReportSubmitterAM {
    private static Logger logger = Logger.getLogger(ReportSubmitterAMImpl.class);
    private UserFileDM userFileDM = null;

    public ReportSubmitterAMImpl() {
        this.setName("ENTERPRISE.ReportSubmitterAM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putReport(ReportCommand reportCommand) throws ActionFailedException {
        Object object;
        if (reportCommand == null) {
            logger.debug((Object)"ReportRunner is attempting to push a null Report");
            return;
        }
        DurableQueue durableQueue = null;
        try {
            object = OutputDistributionSetup.getReportQueueName();
            logger.debug((Object)("Placing report " + reportCommand.getReportName() + " on the Report Queue " + (String)object));
            durableQueue = new DurableQueue((String)object);
        }
        catch (IOException iOException) {
            throw new ActionFailedException("Unable to submit report " + reportCommand.getReportName() + ".", (Throwable)iOException);
        }
        object = ReportQueue;
        synchronized (object) {
            try {
                UserFile userFile = this.addReportFileRecord(reportCommand);
                reportCommand.setUserFileRecordId(userFile.getOid());
                durableQueue.push((Serializable)((Object)reportCommand));
                durableQueue.close();
            }
            catch (IOException iOException) {
                String string = "Unable to submit report " + reportCommand.getReportName() + ".";
                logger.error((Object)string, (Throwable)iOException);
                throw new ActionFailedException(string, (Throwable)iOException);
            }
            finally {
                ReportQueue.notifyAll();
            }
        }
    }

    private UserFile addReportFileRecord(ReportCommand reportCommand) {
        UserFile userFile = new UserFile();
        UserFile userFile2 = null;
        String string = Reports.getUserName(reportCommand.getParams());
        if (string == null) {
            string = reportCommand.getRunAsUserName();
        }
        userFile.setFileName(Reports.getReportNameByID(reportCommand.getReportID()));
        userFile.setStatus(4);
        userFile.setStoredLocation(reportCommand.getReportName());
        userFile.setUserId(this.getUserID(string));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating Report User File record: " + reportCommand.getReportName()));
        }
        try {
            userFile2 = this.getDM().save(userFile);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to create User File record for report " + reportCommand.getReportName()));
            exception.printStackTrace();
        }
        return userFile2;
    }

    private long getUserID(String string) {
        long l = 1L;
        UserDM userDM = (UserDM)ManagerRegistry.getManager((String)"ENTERPRISE.UserDM");
        try {
            l = userDM.getUserByNameOrAdmin(string).getID();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder("Unable to find the passed in user name:");
            stringBuilder.append(string);
            stringBuilder.append(", so admin id is used, i.e.:");
            stringBuilder.append(l);
            logger.info((Object)stringBuilder.toString(), (Throwable)exception);
        }
        return l;
    }

    private UserFileDM getDM() {
        if (this.userFileDM == null) {
            this.userFileDM = (UserFileDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.UserFileDM");
        }
        return this.userFileDM;
    }
}

