/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.informatica;

import com.helpsystems.enterprise.core.busobj.informatica.ConsoleLogger;
import com.helpsystems.enterprise.core.cmdlineobj.InformaticaCommand;
import com.helpsystems.enterprise.core.dm.informatica.axis_override.SkybotHttpSender;
import com.helpsystems.enterprise.module.exec.InformaticaController;
import com.helpsystems.enterprise.module.informatica.InformaticaKeystoreInfo;
import com.helpsystems.enterprise.module.informatica.RunningResult;

public class InformaticaWorker {
    private static final String SUCCESS_STATUS = "SUCCEEDED";

    public static void main(String[] stringArray) {
        String string = System.getenv("INFO_AXIS_OVERRIDE");
        if (string != null && string.toLowerCase().indexOf("true") > -1) {
            SkybotHttpSender.install();
        }
        InformaticaController informaticaController = new InformaticaController();
        InformaticaCommand informaticaCommand = new InformaticaCommand();
        try {
            informaticaCommand.parseParameters(stringArray);
            if (informaticaCommand.getInformaticaDetails().getRepo().isUseHTTPS()) {
                InformaticaKeystoreInfo.configureKeystore(InformaticaKeystoreInfo.KeystoreType.AGENT);
            }
            RunningResult runningResult = informaticaController.execute(informaticaCommand);
            int n = runningResult.getErrCode();
            String string2 = runningResult.getRunStatus();
            if (!string2.equalsIgnoreCase(SUCCESS_STATUS) || n != 0) {
                ConsoleLogger.println();
                InformaticaWorker.exit(1, "Command failed with status '" + string2 + "' and error code: " + n);
            }
        }
        catch (Exception exception) {
            ConsoleLogger.println("-------------------------------------------------------------");
            ConsoleLogger.println("Informatica Request Failed. Cause: " + exception.getMessage());
            if (exception.getCause() != null) {
                ConsoleLogger.println(exception.getCause().getMessage());
            }
            ConsoleLogger.println("-------------------------------------------------------------");
            InformaticaWorker.exit(1, "Command failed: " + exception.getLocalizedMessage(), exception);
        }
    }

    private static void exit(int n, String string) {
        InformaticaWorker.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }
}

