/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.infocloud;

import com.google.gson.Gson;
import com.helpsystems.enterprise.core.infocloud.busobj.ICError;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ICHelper {
    static DateFormat formatterSecs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static final String DoubleQuote = "\"";
    public static final String EOL = "\n";
    public static final String TAB = "    ";
    public static final String logging_seperator = "===================================================================";

    public static void closeSomething(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String formatLocalTime() {
        return ICHelper.formatMillisecondTimestamp(System.currentTimeMillis());
    }

    public static String formatMillisecondTimestamp(long l) {
        return ICHelper.formatDate(new Date(l));
    }

    public static String formatDate(Date date) {
        return formatterSecs.format(date);
    }

    public static void logWithLocalTime(String string) {
        System.out.println(ICHelper.formatLocalTime() + " - " + string);
    }

    public static String getJSONLine(String string, String string2) {
        return DoubleQuote + string + DoubleQuote + ": " + DoubleQuote + string2 + DoubleQuote;
    }

    public static long getRandomWait() {
        Random random = new Random();
        long l = random.nextInt(15000);
        if (l < 1000L) {
            l += 3000L;
        }
        if (l < 2000L) {
            l += 8000L;
        }
        return l;
    }

    public static long getAgentRandomWait() {
        Random random = new Random();
        long l = random.nextInt(8000);
        if (l < 1000L) {
            l += 3000L;
        }
        return l;
    }

    public static ICError parseError(InputStream inputStream) {
        Gson gson = new Gson();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        ICError iCError = (ICError)gson.fromJson((Reader)inputStreamReader, ICError.class);
        return iCError;
    }

    public static void logICError(ICError iCError, String string) {
        System.out.println(iCError.getSkybotErrorMsg(string));
        System.out.println();
        iCError.logStringArray(TAB);
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processResponseToConsole(InputStream inputStream, HttpResponse httpResponse) throws UnsupportedEncodingException, IOException {
        String string;
        System.out.println();
        Header header = httpResponse.getFirstHeader("Content-Type");
        String string2 = null;
        if (header != null) {
            string2 = header.getValue();
        } else {
            string = "text/html;charset=UTF-8";
            System.out.println("Response Header 'Content-Type' was not provided.  Defaulting: " + string);
            System.out.println();
            string2 = string;
        }
        string = null;
        Object object = string2.replace(" ", "").split(";");
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string3 = object[i];
            if (!string3.startsWith("charset=")) continue;
            string = string3.split("=", 2)[1];
            break;
        }
        if (string == null && (((String)(object = string2.toLowerCase())).startsWith("text/") || ((String)object).startsWith("application/") && (((String)object).contains("json") || ((String)object).contains("xml")))) {
            string = "UTF-8";
        }
        System.out.println("Response Data: ");
        if (string != null) {
            object = null;
            try {
                String string4;
                object = new BufferedReader(new InputStreamReader(inputStream, string));
                while ((string4 = ((BufferedReader)object).readLine()) != null) {
                    System.out.println(string4);
                }
                System.out.println();
            }
            finally {
                ICHelper.closeSomething((Closeable)object);
            }
        } else {
            System.out.println("'Content-Type=" + string2 + "' header does not contain a charset.  Binary data cannot be written to the console.");
        }
    }
}

