/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.enterprise.module.exec.PlatformFactory;
import com.helpsystems.enterprise.module.exec.WindowsPlatform;
import junit.framework.TestCase;

public class WindowsPlatformTest
extends TestCase {
    WindowsPlatform plat;

    protected void setUp() throws Exception {
        super.setUp();
        this.plat = (WindowsPlatform)PlatformFactory.getPlatform();
    }

    protected void tearDown() throws Exception {
        this.plat = null;
        super.tearDown();
    }

    public void testGetName() {
        WindowsPlatformTest.assertEquals((String)"Windows Default", (String)this.plat.getName());
    }

    public void testGetProcessShellCommand() {
        WindowsPlatformTest.assertTrue((boolean)this.plat.getProcessShellCommand(0, "", false)[0].startsWith(System.getenv("ComSpec")));
    }

    public void testGetExitCodeCommand() {
        assert (this.plat.getExitCodeCommand(null).endsWith("echo %Errorlevel%"));
    }

    public void testIsUsable() {
        WindowsPlatformTest.assertTrue((boolean)this.plat.isUsable());
    }

    public void testGetExitCommand() {
        WindowsPlatformTest.assertEquals((String)"exit", (String)this.plat.getExitCommand());
    }

    public void testSanitizeCmdLineArgument() {
        String[][] stringArrayArray = new String[][]{{"a", "^&|()%", "^^^&^|^(^)^%", "", null}, {"a", "^^^&^|^(^)^%", "^^^^^^^&^^^|^^^(^^^)^^^%", "", null}};
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < stringArrayArray[n].length; ++i) {
            WindowsPlatformTest.assertEquals((String)stringArrayArray[n2][i], (String)this.plat.sanitizeCmdLineArgument(stringArrayArray[n][i]));
        }
    }
}

