/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.enterprise.module.exec.Platform;
import com.helpsystems.enterprise.module.exec.ProcessCommand;
import com.helpsystems.enterprise.module.exec.ProcessUtil;
import java.util.ArrayList;
import java.util.Map;

public class WindowsPlatform
implements Platform {
    private static final String CMD_EXTENSION = ".bat";

    @Override
    public String getName() {
        return "Windows Default";
    }

    @Override
    public String[] getProcessShellCommand(int n, String string, boolean bl) {
        return new String[]{System.getenv("ComSpec")};
    }

    @Override
    public String getExitCodeCommand(String string) {
        return "\"" + System.getProperty("user.dir") + "\\bin\\Win32\\eecho\" {0}%Errorlevel%";
    }

    @Override
    public boolean isUsable() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Windows ");
    }

    @Override
    public String getExitCommand() {
        return "exit";
    }

    @Override
    public String[] getEnvCommands(Map<String, String> map, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2);
            arrayList.add("set " + string2 + "=" + this.sanitizeCmdLineArgument(string3));
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    @Override
    public String[] getSwapUserCommand(String string, boolean bl) {
        return null;
    }

    private String quoteIfNeeded(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.trim();
        if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            return string2;
        }
        return "\"" + string + "\"";
    }

    @Override
    public String quoteString(String string) {
        return this.quoteIfNeeded(string);
    }

    @Override
    public String fixPath(String string) {
        return this.quoteIfNeeded(string);
    }

    @Override
    public boolean echoesCommands() {
        return true;
    }

    @Override
    public String makeRemarkCommand(String string, String string2) {
        return "rem " + string;
    }

    @Override
    public boolean sendUserPassword() {
        return true;
    }

    @Override
    public void interpretBIFS(ArrayList<ProcessCommand> arrayList, String string, String string2) {
        ProcessUtil.convertBIFS(this, arrayList, string, string2);
    }

    @Override
    public String getCommandExtension() {
        return CMD_EXTENSION;
    }

    @Override
    public boolean isCommentCommand(String string) {
        return string != null && string.toUpperCase().trim().startsWith("REM ");
    }

    @Override
    public String getSetEnvironment(String string, String string2, String string3) {
        if (string != null && string.trim().length() > 0) {
            StringBuffer stringBuffer = new StringBuffer("SET ");
            stringBuffer.append(string);
            if (string2 != null) {
                stringBuffer.append("=");
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public String sanitizeCmdLineArgument(String string) {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.replace("^", "^^");
            string2 = string2.replace("&", "^&");
            string2 = string2.replace("|", "^|");
            string2 = string2.replace("(", "^(");
            string2 = string2.replace(")", "^)");
            string2 = string2.replace("%", "^%");
            string2 = string2.replace("<", "^<");
            string2 = string2.replace(">", "^>");
        }
        return string2;
    }

    @Override
    public String quoteEnvVarValue(String string, String string2) {
        return string;
    }

    @Override
    public boolean isCSHShell(String string) {
        return false;
    }
}

