/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.DeleteFileException;
import com.helpsystems.enterprise.core.busobj.FileTransferException;
import com.helpsystems.enterprise.core.busobj.FileTransferReturnCode;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferCommand;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferDetails;
import com.helpsystems.enterprise.core.util.RemoteFile;
import com.helpsystems.enterprise.core.util.WildCardUtils;
import com.helpsystems.enterprise.module.exec.Utils;
import com.helpsystems.enterprise.module.filetransfer.IPeerFileTransferClient;
import com.helpsystems.enterprise.module.filetransfer.IPeerFileTransferClientFactory;
import com.helpsystems.enterprise.module.filetransfer.PeerFtpClient;
import com.helpsystems.enterprise.module.filetransfer.PeerFtpClientFactory;
import com.helpsystems.enterprise.module.filetransfer.PeerFtpsClientFactory;
import com.helpsystems.enterprise.module.filetransfer.PeerSftpClient;
import com.helpsystems.enterprise.module.filetransfer.PeerSftpClientFactory;
import com.helpsystems.enterprise.peer.FileTransterUtils;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class FileTransferController {
    private static final boolean verbose = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(FileTransferCommand fileTransferCommand) throws Exception {
        FileTransferDetails fileTransferDetails = fileTransferCommand.getFileTransferDetails();
        FileTransferController.validate(fileTransferDetails);
        FileTransferController.resolvePaths(fileTransferDetails);
        IPeerFileTransferClientFactory iPeerFileTransferClientFactory = null;
        IPeerFileTransferClient iPeerFileTransferClient = null;
        try {
            String string = fileTransferDetails.getPassword();
            if ("".equals(string)) {
                string = null;
            }
            if (fileTransferDetails.getPasswordSalt() != null && !"".equals(fileTransferDetails.getPasswordSalt()) && string != null && !"".equals(string)) {
                string = FileTransterUtils.getPassword((String)string, (String)fileTransferDetails.getPasswordSalt());
            }
            boolean bl = fileTransferDetails.isUnknownHostChallenge();
            int n = fileTransferDetails.getSystemTransferType();
            switch (n) {
                case 0: {
                    iPeerFileTransferClientFactory = new PeerFtpClientFactory();
                    break;
                }
                case 2: {
                    iPeerFileTransferClientFactory = new PeerFtpsClientFactory(fileTransferDetails.isUseImplicitFtps());
                    break;
                }
                case 1: {
                    Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
                    System.out.println("Inserted BouncyCastleProvider to Security in position 1.");
                    iPeerFileTransferClientFactory = new PeerSftpClientFactory(bl, fileTransferDetails.getAuthenticationType(), fileTransferDetails.getPrivateKeyPath());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("There is no such transfare type:" + n);
                }
            }
            try {
                iPeerFileTransferClient = (IPeerFileTransferClient)iPeerFileTransferClientFactory.connect(fileTransferDetails.getHost(), fileTransferDetails.getPort(), fileTransferDetails.getUser(), string);
            }
            catch (SocketException socketException) {
                throw socketException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            String string2 = fileTransferDetails.getSiteCommand();
            if (string2 != null && !string2.isEmpty()) {
                String[] stringArray;
                for (String string3 : stringArray = string2.split(";")) {
                    if (string3 == null || string3.isEmpty()) continue;
                    String string4 = string3.trim();
                    try {
                        iPeerFileTransferClient.sendSiteCommand(string4);
                        System.out.println("Successfull sent site command: " + string4);
                    }
                    catch (IOException iOException) {
                        System.out.println("Error in site command(" + string4 + ") send " + iOException.getMessage());
                    }
                }
            }
            int n2 = 30;
            boolean bl2 = true;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Parameters: hostFile[");
            stringBuilder.append("\"" + fileTransferDetails.getHostFile() + "\"]");
            stringBuilder.append(" agentFile[");
            stringBuilder.append("\"" + fileTransferDetails.getAgentFile() + "\"]");
            stringBuilder.append(" Transfer mode[");
            stringBuilder.append(fileTransferDetails.isBinary() ? "binary" : "text");
            stringBuilder.append("] Replace[");
            stringBuilder.append(fileTransferDetails.isReplace());
            stringBuilder.append("] timeout[");
            stringBuilder.append(n2);
            stringBuilder.append("] CreateDir[");
            stringBuilder.append(bl2);
            stringBuilder.append("] SiteCommand[");
            stringBuilder.append(string2 == null ? "" : string2);
            stringBuilder.append("]");
            System.out.println(stringBuilder);
            if (fileTransferDetails.getDirection() == 0) {
                if (fileTransferDetails.getHostFile().indexOf(42) == -1) {
                    boolean bl3;
                    System.out.println(new File(fileTransferDetails.getAgentFile()).getAbsolutePath());
                    int n3 = 0;
                    boolean bl4 = false;
                    while (!bl3) {
                        try {
                            iPeerFileTransferClient.get(fileTransferDetails.getHostFile(), fileTransferDetails.getAgentFile(), fileTransferDetails.isBinary(), fileTransferDetails.isReplace(), n2, bl2, true, fileTransferDetails.isDeleteAfterTransfer());
                            bl3 = true;
                        }
                        catch (FileTransferException fileTransferException) {
                            if (n3 != 0 || !fileTransferException.getReturnCode().equals((Object)FileTransferReturnCode.systemToFileAlreadyExistsIsFolder)) throw fileTransferException;
                            this.appendSourceFileToTargetFile(fileTransferDetails);
                            n3 = 1;
                        }
                    }
                    if (fileTransferDetails.isDeleteAfterTransfer()) {
                        this.deleteFileFromRemote(n, fileTransferDetails.getHostFile(), iPeerFileTransferClient);
                    }
                } else {
                    String string5 = FileTransterUtils.getRemoteParentFolderPath((String)fileTransferDetails.getHostFile());
                    List<RemoteFile> list = iPeerFileTransferClient.getList(string5, true);
                    if (list == null || list.isEmpty()) {
                        throw new FileTransferException("Remote folder not found or it is empty. Path: " + string5, FileTransferReturnCode.remoteFromFileNotFound);
                    }
                    File file = new File(fileTransferDetails.getAgentFile());
                    if (!file.exists()) {
                        throw new FileTransferException("Agent folder \"" + fileTransferDetails.getAgentFile() + "\" does not exists", FileTransferReturnCode.outputSystemFolderDoesNotExist);
                    }
                    if (!file.isDirectory()) {
                        throw new FileTransferException("Agent system \"" + fileTransferDetails.getAgentFile() + "\" exist but is not a directory", FileTransferReturnCode.outputSystemFolderIsFile);
                    }
                    String string6 = FileTransterUtils.getRemoteWildCardFromRemoteFileName((String)fileTransferDetails.getHostFile());
                    String string7 = WildCardUtils.wildcardToRegexp(string6);
                    List<RemoteFile> list2 = FileTransferController.getFileOrDirectoryListByRegExp(list, string7);
                    if (list2 == null || list2.isEmpty()) {
                        throw new FileTransferException("There is no remote file with wildcard: " + fileTransferDetails.getHostFile(), FileTransferReturnCode.remoteFromFileNotFound);
                    }
                    int n4 = 0;
                    int n5 = 0;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    String string8 = "";
                    for (RemoteFile remoteFile : list2) {
                        ++n4;
                        string8 = (string5 != null && !"".equals(string5) ? string5 + "/" : "") + remoteFile.getName();
                        String string9 = remoteFile.isDirectory() ? file.getAbsolutePath() : file.getAbsolutePath() + FileTransterUtils.FILE_SEPARATOR + remoteFile.getName();
                        try {
                            iPeerFileTransferClient.get(string8, string9, fileTransferDetails.isBinary(), fileTransferDetails.isReplace(), n2, bl2, false, fileTransferDetails.isDeleteAfterTransfer());
                            ++n5;
                        }
                        catch (FileTransferException fileTransferException) {
                            bl5 = true;
                            System.out.println("Error transferring \"" + string8 + "\": (" + fileTransferException.getReturnCode().code() + ") " + fileTransferException.getMessage());
                            if (fileTransferException.getCause() == null) continue;
                            System.out.println(fileTransferException.getCause().getMessage());
                        }
                        catch (DeleteFileException deleteFileException) {
                            bl6 = true;
                            System.out.println("Error deleting \"" + string8 + "\": (" + deleteFileException.getReturnCode().code() + ") " + deleteFileException.getMessage());
                            deleteFileException.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            bl5 = true;
                            System.out.println("Error transferring \"" + string8 + "\": " + throwable.getMessage());
                            throwable.printStackTrace();
                        }
                    }
                    String string10 = "Completed transfers for " + n5 + " of " + n4 + " files.";
                    if (bl5) {
                        throw new FileTransferException(string10, FileTransferReturnCode.failedMultipleTransfer);
                    }
                    if (bl6) {
                        String string11 = "Completed deleting for " + n5 + " of " + n4 + " files.";
                        throw new DeleteFileException(string11, FileTransferReturnCode.remoteToFileCantDelete);
                    }
                    System.out.println(string10);
                }
            } else if (fileTransferDetails.getDirection() == 1) {
                if (fileTransferDetails.getAgentFile().indexOf(42) == -1) {
                    System.out.println(new File(fileTransferDetails.getAgentFile()).getAbsolutePath());
                    iPeerFileTransferClient.put(fileTransferDetails.getHostFile(), fileTransferDetails.getAgentFile(), fileTransferDetails.isBinary(), n2, fileTransferDetails.isReplace(), false);
                    if (fileTransferDetails.isDeleteAfterTransfer()) {
                        this.deleteFileFromAgent(fileTransferDetails.getAgentFile());
                    }
                } else {
                    iPeerFileTransferClient.validateIfFolder(fileTransferDetails.getHostFile());
                    String string12 = FileTransterUtils.getSystemWildCardFromSystemFileName((String)fileTransferDetails.getAgentFile());
                    String string13 = WildCardUtils.wildcardToRegexpForFileSystem(string12);
                    File file = new File(fileTransferDetails.getAgentFile()).getParentFile();
                    if (!file.exists()) {
                        throw new FileTransferException("Agent folder \"" + file.getAbsolutePath() + "\" does not exist", FileTransferReturnCode.systemFromFileNotFound);
                    }
                    ArrayList<File> arrayList = new ArrayList<File>();
                    WildCardUtils.getFileListByRegExp(file, string13, true, true, true, arrayList);
                    if (arrayList == null || arrayList.isEmpty()) {
                        throw new FileTransferException("There is no file with wildcard: " + fileTransferDetails.getAgentFile(), FileTransferReturnCode.systemFromFileNotFound);
                    }
                    int n6 = 0;
                    int n7 = 0;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    String string14 = "";
                    ArrayList<File> arrayList2 = new ArrayList<File>();
                    for (File file2 : arrayList) {
                        ++n6;
                        String string15 = file2.getAbsolutePath();
                        string14 = (fileTransferDetails.getHostFile() != null && !"".equals(fileTransferDetails.getHostFile()) ? fileTransferDetails.getHostFile() + "/" : "") + string15.substring(file.getAbsolutePath().length() + 1, string15.length()).replaceAll("\\\\|/", "/");
                        try {
                            PeerSftpClient peerSftpClient = null;
                            switch (n) {
                                case 0: 
                                case 2: {
                                    break;
                                }
                                case 1: {
                                    peerSftpClient = (PeerSftpClient)iPeerFileTransferClient;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("There is no such transfare type:" + n);
                                }
                            }
                            if (file2.isDirectory()) {
                                if (peerSftpClient != null) {
                                    try {
                                        peerSftpClient.makeDir(string14);
                                        arrayList2.add(file2);
                                    }
                                    catch (Exception exception) {
                                        throw new FileTransferException("Could not create remote folder " + string14 + ".", FileTransferReturnCode.systemFromFileCantCreate);
                                    }
                                } else {
                                    PeerFtpClient peerFtpClient = (PeerFtpClient)iPeerFileTransferClient;
                                    FTPClient fTPClient = peerFtpClient.getFTPClient();
                                    if (!fTPClient.makeDirectory(string14)) throw new FileTransferException("Could not create remote folder " + string14 + ".", FileTransferReturnCode.systemFromFileCantCreate);
                                    arrayList2.add(file2);
                                }
                            } else {
                                iPeerFileTransferClient.put(string14, string15, fileTransferDetails.isBinary(), n2, fileTransferDetails.isReplace(), false);
                                if (fileTransferDetails.isDeleteAfterTransfer()) {
                                    this.deleteFileFromAgent(file2.getAbsolutePath());
                                }
                            }
                            ++n7;
                        }
                        catch (DeleteFileException deleteFileException) {
                            bl8 = true;
                            System.out.println("Error deleting \"" + string14 + "\": (" + deleteFileException.getReturnCode().code() + ") " + deleteFileException.getMessage());
                        }
                        catch (FileTransferException fileTransferException) {
                            bl7 = true;
                            System.out.println("Error transferring \"" + string14 + "\": (" + fileTransferException.getReturnCode().code() + ") " + fileTransferException.getMessage());
                            if (fileTransferException.getCause() == null) continue;
                            System.out.println(fileTransferException.getCause().getMessage());
                        }
                        catch (Throwable throwable) {
                            bl7 = true;
                            System.out.println("Error transferring \"" + string14 + "\": " + throwable.getMessage());
                            throwable.printStackTrace();
                        }
                    }
                    if (fileTransferDetails.isDeleteAfterTransfer()) {
                        this.removeDirectoryFromAgent(arrayList2);
                    }
                    String string16 = "Completed transfers for " + n7 + " of " + n6 + " files.";
                    if (bl7) {
                        throw new FileTransferException(string16, FileTransferReturnCode.failedMultipleTransfer);
                    }
                    if (bl8) {
                        String string17 = "Completed deleting for " + n7 + " of " + n6 + " files.";
                        throw new DeleteFileException(string17, FileTransferReturnCode.remoteToFileCantDelete);
                    }
                    System.out.println(string16);
                }
            }
            String string18 = "Success";
            System.out.println(string18);
            return;
        }
        catch (Exception exception) {
            String string = Utils.concatToStrings("File transfer failed.");
            System.out.println(string);
            throw exception;
        }
        finally {
            if (iPeerFileTransferClientFactory != null && iPeerFileTransferClient != null && fileTransferDetails.getHost() != null) {
                iPeerFileTransferClientFactory.close(iPeerFileTransferClient, fileTransferDetails.getHost());
            }
        }
    }

    private void appendSourceFileToTargetFile(FileTransferDetails fileTransferDetails) {
        String string;
        System.out.println("Appending source file name to target folder...");
        String string2 = fileTransferDetails.getAgentFile();
        String string3 = fileTransferDetails.getHostFile();
        String string4 = "/";
        String string5 = "\\";
        String string6 = "\\\\";
        String string7 = string4;
        switch (fileTransferDetails.getDirection()) {
            case 0: {
                string2 = fileTransferDetails.getAgentFile();
                string3 = fileTransferDetails.getHostFile();
                string7 = System.getProperty("file.separator");
                String string8 = null;
                if (string3.contains(string4)) {
                    string8 = string4;
                } else if (string3.contains(string5)) {
                    string8 = string6;
                }
                if (string8 == null) break;
                String[] stringArray = string3.split(string8);
                string3 = stringArray[stringArray.length - 1];
                break;
            }
            case 1: {
                string2 = fileTransferDetails.getHostFile();
                string3 = fileTransferDetails.getAgentFile();
                String string8 = null;
                if (string3.contains(string4)) {
                    string8 = string4;
                } else if (string3.contains(string5)) {
                    string8 = string6;
                }
                if (string8 == null) break;
                String[] stringArray = string3.split(string8);
                string3 = stringArray[stringArray.length - 1];
                break;
            }
            default: {
                System.out.println("Error: Invalid direction of " + fileTransferDetails.getDirection() + " for FileTransferDetails.  Using default of pull.");
            }
        }
        int n = string2.length();
        char c = string2.charAt(n - 1);
        ArrayList<Character> arrayList = new ArrayList<Character>();
        arrayList.add(Character.valueOf('/'));
        arrayList.add(Character.valueOf('\\'));
        if (arrayList.contains(Character.valueOf(c))) {
            string = string2.concat(string3);
        } else {
            string = string2.concat(string7);
            string = string.concat(string3);
        }
        if (fileTransferDetails.getDirection() == 1) {
            fileTransferDetails.setHostFile(string);
        } else {
            fileTransferDetails.setAgentFile(string);
        }
        System.out.println("Modified target = " + string);
    }

    private static void validate(FileTransferDetails fileTransferDetails) {
        String string = fileTransferDetails.getHost();
        int n = fileTransferDetails.getPort();
        String string2 = fileTransferDetails.getUser();
        String string3 = fileTransferDetails.getHostFile();
        String string4 = fileTransferDetails.getAgentFile();
        int n2 = fileTransferDetails.getDirection();
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Host URL", (String)string);
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Host file name", (String)string3);
        ValidationHelper.validateReqFieldForNullAndBlank((String)"User name", (String)string2);
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Agent file", (String)string4);
        if (n <= 0) {
            throw new IllegalArgumentException("Port argument is not valid");
        }
    }

    private static void resolvePaths(FileTransferDetails fileTransferDetails) {
        String string = FileTransferController.resolveTilde(fileTransferDetails.getAgentFile());
        string = FileTransferController.resolveUserDirPath(string);
        File file = new File(string);
        string = file.getAbsolutePath();
        fileTransferDetails.setAgentFile(string);
        String string2 = fileTransferDetails.getHostFile();
        if (string2 == null) {
            string2 = "";
        } else if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        fileTransferDetails.setHostFile(string2);
    }

    private static String resolveTilde(String string) {
        try {
            String string2;
            if (string != null && string.startsWith("~") && (string2 = System.getProperty("user.home")) != null && string2.trim().length() > 0) {
                String string3 = string2 + string.substring(1);
                System.out.println("Replacing ~ in: \"" + string + "\" with user home: \"" + string3 + "\"");
                return string3;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    private static String resolveUserDirPath(String string) {
        try {
            String string2;
            if (string != null && (string.equals(".") || string.startsWith(".\\") || string.startsWith("./")) && (string2 = System.getProperty("user.dir")) != null && string2.trim().length() > 0) {
                String string3 = string2 + string.substring(1);
                System.out.println("Replacing leading period in: \"" + string + "\" with user directory: \"" + string3 + "\"");
                return string3;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    public static List<RemoteFile> getFileOrDirectoryListByRegExp(List<RemoteFile> list, String string) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher("");
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>();
        for (RemoteFile remoteFile : list) {
            matcher.reset(remoteFile.getName());
            boolean bl = matcher.matches();
            if (!bl) continue;
            arrayList.add(remoteFile);
        }
        return arrayList;
    }

    private void deleteFileFromRemote(int n, String string, IPeerFileTransferClient iPeerFileTransferClient) throws IOException, SftpException, FileTransferException, DeleteFileException {
        switch (n) {
            case 0: 
            case 2: {
                PeerFtpClient peerFtpClient = (PeerFtpClient)iPeerFileTransferClient;
                FTPClient fTPClient = peerFtpClient.getFTPClient();
                try {
                    this.deleteFromFtp(string, fTPClient, false);
                    break;
                }
                catch (IOException iOException) {
                    throw new DeleteFileException("Could not delete remote source file " + string + ".", FileTransferReturnCode.systemToFileCantDelete);
                }
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("There is no such transfer type: " + n);
            }
        }
    }

    public boolean deleteFromFtp(String string, FTPClient fTPClient, boolean bl) throws IOException {
        FTPFile[] fTPFileArray = fTPClient.listFiles(string);
        for (int i = 0; i < fTPFileArray.length; ++i) {
            String string2 = string + "/" + fTPFileArray[i].getName();
            if (!fTPFileArray[i].isDirectory()) {
                if (fTPClient.deleteFile(string)) continue;
                fTPClient.deleteFile(string2);
                continue;
            }
            this.deleteFromFtp(string2, fTPClient, true);
        }
        if (bl) {
            return fTPClient.removeDirectory(string);
        }
        return true;
    }

    public void deleteFileFromAgent(String string) throws DeleteFileException {
        File file = new File(string);
        if (!file.delete()) {
            throw new DeleteFileException("Could not delete local source file " + string + ".", FileTransferReturnCode.systemToFileCantDelete);
        }
        System.out.println("Local source file " + string + " was deleted.");
    }

    public void removeDirectoryFromAgent(ArrayList<File> arrayList) throws DeleteFileException {
        if (arrayList.size() > 0) {
            Iterator<File> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (file == null || !file.exists() || !file.isDirectory() || file.list() != null && file.list().length != 0) continue;
                if (file.delete()) {
                    System.out.println("Local source directory " + file.getAbsolutePath() + " was deleted.");
                    iterator.remove();
                    this.removeDirectoryFromAgent(arrayList);
                    continue;
                }
                throw new DeleteFileException("Could not delete local source directory " + file.getAbsolutePath() + ".", FileTransferReturnCode.systemToFileCantDelete);
            }
        }
    }
}

