/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.UserFile;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.dm.UserFileAM;
import com.helpsystems.enterprise.core.dm.UserFileDM;
import com.helpsystems.enterprise.core.user.file.StandbyBackupFile;
import com.helpsystems.enterprise.core.util.FileHandler;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import com.helpsystems.enterprise.module.exec.RemoteFileCopier;
import java.io.File;
import org.apache.log4j.Logger;

public class UserFileAMImpl
extends AbstractManager
implements UserFileAM {
    private static final Logger logger = Logger.getLogger(UserFileAMImpl.class);
    private final UserFileDM userFileDM = (UserFileDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.UserFileDM");
    private StandbyBackupFileQueueAM standbyBackupFileQueueAM = null;

    public UserFileAMImpl() {
        this.setName("ENTERPRISE.UserFileAM");
    }

    @Override
    public String copyToUserFolder(String string, String string2, PeerID peerID) {
        String string3 = OutputDistributionSetup.getUserFilesDirName();
        String string4 = string3.concat(File.separator).concat(string2);
        new File(string4).mkdirs();
        String string5 = string4.concat(File.separator).concat(FileHandler.getFileExactName(string));
        System.out.println("agentfileName=" + string);
        System.out.println("serverFileName=" + string5);
        RemoteFileCopier remoteFileCopier = new RemoteFileCopier(peerID, string);
        remoteFileCopier.setServerFilename(string5);
        remoteFileCopier.run(true);
        Throwable throwable = remoteFileCopier.getServerWriteError();
        if (throwable != null) {
            StringBuilder stringBuilder = new StringBuilder("Unable to copy genarated report with filename:");
            stringBuilder.append(string);
            stringBuilder.append(" to server's ");
            stringBuilder.append(string5);
            logger.error((Object)stringBuilder.toString(), throwable);
        }
        return string4;
    }

    @Override
    public int purgeUserFile(long l) {
        int n = 1;
        try {
            UserFile userFile = this.userFileDM.get(l);
            if (4 != userFile.getStatus() && 1 != userFile.getStatus()) {
                File file = new File(userFile.getStoredLocation(), userFile.getFileName());
                if (file.exists()) {
                    boolean bl = file.delete();
                    if (bl) {
                        this.putStandbyBackupFileForDelete(file.getAbsolutePath());
                    } else {
                        return 1;
                    }
                }
                this.userFileDM.delete(userFile);
                n = 0;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)("Can't find user file oid is " + l + " for purging"), (Throwable)resourceUnavailableException);
        }
        catch (DataException dataException) {
            logger.debug((Object)"Can't purge user file ", (Throwable)dataException);
        }
        return n;
    }

    private void putStandbyBackupFileForDelete(String string) {
        StandbyBackupFile standbyBackupFile = new StandbyBackupFile();
        standbyBackupFile.setServerFileName(string);
        standbyBackupFile.setActionType(1);
        standbyBackupFile.setFileType(1);
        try {
            this.getStandbyBackupFileQueueAM().putStandbyBackupFile(standbyBackupFile);
        }
        catch (ActionFailedException actionFailedException) {
            logger.error((Object)"Can't put standby backup file in queue", (Throwable)actionFailedException);
        }
    }

    private StandbyBackupFileQueueAM getStandbyBackupFileQueueAM() {
        if (this.standbyBackupFileQueueAM == null) {
            this.standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.StandbyBackupFileQueueAM");
        }
        return this.standbyBackupFileQueueAM;
    }
}

