/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.filter.DataFilterMatcher;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SNMPTrapEvent;
import com.helpsystems.enterprise.core.busobj.SNMPTrapMonitor;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapEventDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorAM;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorDM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.util.HSSnmpPduPacket;
import com.helpsystems.enterprise.core.util.HSSnmpPduTrap;
import java.net.InetAddress;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SNMPTrapMonitorAMImpl
extends AbstractManager
implements SNMPTrapMonitorAM {
    private static Logger logger = Logger.getLogger(SNMPTrapMonitorAMImpl.class);
    private static final int PORT_DEFAULT = 162;
    private static BlockingQueue<SNMPTrapEvent> eventQueue;
    private static Thread eventProcessorThread;
    private static Thread snmpTrapMonitorRunnerThread;
    private SnmpTrapSession trapSession;
    private SystemSetupDM systemSetupDM;
    private SNMPTrapEventDM snmpTrapEventDM;
    private SNMPTrapMonitorDM snmpTrapMonitorDM;
    private EnterpriseEmailAM enterpriseEmailAM;
    private SNMPTrapMonitorRunner snmpTrapMonitorRunner;
    private SNMPTrapMonitor[] monitorList;
    private boolean monitorSNMPTraps;
    private int port = 162;
    private boolean runnerIsActive = false;
    private boolean processorIsActive = false;

    public SNMPTrapMonitorAMImpl() {
        this.setName("ENTERPRISE.SNMPTrapMonitorAM");
        this.systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
        this.snmpTrapEventDM = (SNMPTrapEventDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SNMPTrapEventDM");
        this.snmpTrapMonitorDM = (SNMPTrapMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SNMPTrapMonitorDM");
        this.enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
        this.loadSNMPTrapManagers();
        this.loadSystemSetup(true);
    }

    @Override
    public void reloadSNMPTrapMonitors() {
        this.loadSNMPTrapManagers();
    }

    @Override
    public void reloadSystemSetup() {
        this.loadSystemSetup(false);
    }

    @Override
    public void startSNMPTrapMonitorProcesses() {
        if (this.monitorSNMPTraps && this.isMonitorStopped()) {
            this.startSNMPTrapMonitorEventProcessor();
        }
        if (this.monitorSNMPTraps && !this.runnerIsActive) {
            this.startSNMPTrapMonitorRunner();
        }
    }

    @Override
    public boolean isMonitorStopped() {
        return !this.runnerIsActive && !this.processorIsActive;
    }

    @Override
    public void stopSNMPTrapMonitorProcesses() {
        if (!this.isMonitorStopped()) {
            this.stopSNMPTrapMonitorRunner();
            this.stopSNMPTrapEventProcessor();
        }
    }

    private void loadSystemSetup(boolean bl) {
        Object object;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            object = this.systemSetupDM.get();
            bl2 = this.port != ((SystemSetup)object).getSNMPTrapPort();
            bl3 = this.monitorSNMPTraps != ((SystemSetup)object).isMonitorSNMPTraps();
            this.monitorSNMPTraps = ((SystemSetup)object).isMonitorSNMPTraps();
            this.port = ((SystemSetup)object).getSNMPTrapPort();
        }
        catch (Exception exception) {
            logger.debug((Object)"Error loading System Setup.", (Throwable)exception);
        }
        if (!bl && (bl3 && !this.monitorSNMPTraps || bl2)) {
            if (!this.monitorSNMPTraps) {
                this.stopSNMPTrapMonitorProcesses();
                object = RosettaMsg.SNMP_TRAP_MONITOR_STOPPED.newLogEntry();
                ScheduleLogger.write((ScheduleLogEntry)object);
            } else {
                this.stopSNMPTrapMonitorRunner();
                boolean bl4 = false;
                while (snmpTrapMonitorRunnerThread != null && snmpTrapMonitorRunnerThread.isAlive()) {
                    try {
                        if (!bl4) {
                            logger.debug((Object)"Waiting for the SNMP Trap Monitor to finish shutdown...");
                            bl4 = true;
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.monitorSNMPTraps) {
            this.startSNMPTrapMonitorProcesses();
            if (bl || bl3 && this.monitorSNMPTraps) {
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.SNMP_TRAP_MONITOR_STARTED.newLogEntry();
                ScheduleLogger.write(scheduleLogEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadSNMPTrapManagers() {
        this.monitorList = new SNMPTrapMonitor[0];
        SNMPTrapMonitor[] sNMPTrapMonitorArray = null;
        try {
            sNMPTrapMonitorArray = this.snmpTrapMonitorDM.getList(false);
        }
        catch (Exception exception) {
            logger.debug((Object)"Error loading list of SNMP Trap Monitors.", (Throwable)exception);
        }
        if (sNMPTrapMonitorArray == null) return;
        SNMPTrapMonitor[] sNMPTrapMonitorArray2 = this.monitorList;
        synchronized (this.monitorList) {
            this.monitorList = sNMPTrapMonitorArray;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    private void postSNMPTrapEvent(SNMPTrapEvent sNMPTrapEvent) {
        this.getQueue().offer(sNMPTrapEvent);
    }

    private BlockingQueue<SNMPTrapEvent> getQueue() {
        if (eventQueue == null) {
            eventQueue = new LinkedBlockingQueue<SNMPTrapEvent>();
        }
        return eventQueue;
    }

    private void startSNMPTrapMonitorEventProcessor() {
        if (eventProcessorThread == null || !eventProcessorThread.isAlive()) {
            eventProcessorThread = new Thread(new SNMPTrapEventProcessor());
            eventProcessorThread.setName("SNMPTrapMonitorEventProcessor");
            eventProcessorThread.start();
            this.processorIsActive = true;
        }
    }

    private void startSNMPTrapMonitorRunner() {
        if (snmpTrapMonitorRunnerThread == null || !snmpTrapMonitorRunnerThread.isAlive()) {
            this.snmpTrapMonitorRunner = new SNMPTrapMonitorRunner();
            snmpTrapMonitorRunnerThread = new Thread(this.snmpTrapMonitorRunner);
            snmpTrapMonitorRunnerThread.setName("SNMPTrapMonitorRunner");
            snmpTrapMonitorRunnerThread.start();
            this.runnerIsActive = true;
        }
    }

    private void stopSNMPTrapEventProcessor() {
        if (eventProcessorThread != null && eventProcessorThread.isAlive()) {
            eventProcessorThread.interrupt();
        }
    }

    private void stopSNMPTrapMonitorRunner() {
        if (this.snmpTrapMonitorRunner != null) {
            this.snmpTrapMonitorRunner.shutdown = true;
        }
        if (snmpTrapMonitorRunnerThread != null && snmpTrapMonitorRunnerThread.isAlive()) {
            snmpTrapMonitorRunnerThread.interrupt();
        }
    }

    class SNMPTrapEventProcessor
    implements Runnable {
        private boolean readyToShutDown = false;

        SNMPTrapEventProcessor() {
        }

        @Override
        public void run() {
            try {
                logger.debug((Object)"The SNMPTrapEventProcessor has started.");
                while (!this.readyToShutDown) {
                    this.dequeue();
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"The SNMPTrapEventProcessor has encountered a severe error. No more SNMP Trap Events will be processed until the server is restarted.", throwable);
            }
            finally {
                logger.debug((Object)"The SNMPTrapEventProcessor has ended.");
                SNMPTrapMonitorAMImpl.this.processorIsActive = false;
            }
        }

        private void dequeue() {
            SNMPTrapEvent sNMPTrapEvent;
            block7: {
                sNMPTrapEvent = null;
                try {
                    sNMPTrapEvent = (SNMPTrapEvent)((Object)SNMPTrapMonitorAMImpl.this.getQueue().take());
                }
                catch (InterruptedException interruptedException) {
                    logger.debug((Object)"The SNMPTrapEventProcessor was interrupted.");
                    if (!SNMPTrapMonitorAMImpl.this.getQueue().isEmpty()) break block7;
                    this.readyToShutDown = true;
                }
            }
            if (sNMPTrapEvent == null) {
                return;
            }
            try {
                SNMPTrapMonitorAMImpl.this.snmpTrapEventDM.save(sNMPTrapEvent, null);
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to post SNMPTrapEvent to the database.", (Throwable)exception);
            }
            try {
                this.processSNMPTrapEventActions(sNMPTrapEvent);
            }
            catch (Exception exception) {
                logger.error((Object)"An error occurred processing SNMP Trap Event", (Throwable)exception);
            }
        }

        private void processSNMPTrapEventActions(SNMPTrapEvent sNMPTrapEvent) {
            ScheduleLogEntry scheduleLogEntry;
            String string = String.valueOf(sNMPTrapEvent.getID());
            String[] stringArray = new String[]{sNMPTrapEvent.getSNMPTrapMonitorName(), string};
            switch (sNMPTrapEvent.getEventErrorcode()) {
                case 2: {
                    scheduleLogEntry = RosettaMsg.SNMP_TRAP_EVENT_OCCURRED_HELD.newLogEntry(stringArray);
                    break;
                }
                case 1: {
                    scheduleLogEntry = RosettaMsg.SNMP_TRAP_EVENT_OCCURRED_TIME_RANGE.newLogEntry(stringArray);
                    break;
                }
                default: {
                    scheduleLogEntry = RosettaMsg.SNMP_TRAP_EVENT_OCCURRED.newLogEntry(stringArray);
                }
            }
            ScheduleLogger.write(scheduleLogEntry);
            if (sNMPTrapEvent.getEventErrorcode() == 0 && sNMPTrapEvent.isSendEmail() && sNMPTrapEvent.getNotificationListID() > 0L) {
                NotificationListDM notificationListDM = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
                String[] stringArray2 = null;
                try {
                    stringArray2 = notificationListDM.get(sNMPTrapEvent.getNotificationListID()).getListOfUniqueEmails();
                }
                catch (Exception exception) {
                    logger.error((Object)"Error retrieving Job Monitor Notification Options.", (Throwable)exception);
                }
                if (stringArray2 != null && stringArray2.length > 0) {
                    String string2 = RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_SNMP_TRAP_EVENT_NOTICE, new String[]{sNMPTrapEvent.getSNMPTrapMonitorName()});
                    this.sendEmail(stringArray2, string2, scheduleLogEntry.getMessageText() + "\n\nEvent Data:  " + sNMPTrapEvent.getEventData());
                }
            }
        }

        private void sendEmail(String[] stringArray, String string, String string2) {
            logger.debug((Object)"Sending a SNMP Trap Received email.");
            try {
                SNMPTrapMonitorAMImpl.this.enterpriseEmailAM.sendMessage(stringArray, string, string2);
            }
            catch (Exception exception) {
                logger.error((Object)"Error sending a SNMP Trap Received email.", (Throwable)exception);
            }
        }
    }

    class SNMPTrapMonitorRunner
    implements Runnable,
    SnmpTrapHandler {
        private Object mainWaitObject = new Object();
        private boolean shutdown = false;

        SNMPTrapMonitorRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SNMPTrapMonitorAMImpl.this.port <= 0) {
                SNMPTrapMonitorAMImpl.this.port = 162;
            }
            try {
                SNMPTrapMonitorAMImpl.this.trapSession = new SnmpTrapSession((SnmpTrapHandler)this, SNMPTrapMonitorAMImpl.this.port);
            }
            catch (Exception exception) {
                logger.error((Object)"Error creating a SNMP Trap Session...unable to receive SNMP Traps", (Throwable)exception);
                this.shutdown = true;
            }
            while (!this.shutdown) {
                Object object = this.mainWaitObject;
                synchronized (object) {
                    logger.debug((Object)("Waiting to receive SNMP Traps on port " + SNMPTrapMonitorAMImpl.this.port));
                    try {
                        this.mainWaitObject.wait();
                        logger.debug((Object)"SNMP Trap Monitoring is waking up...");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug((Object)"SNMP Trap Monitoring wakeup requested.");
                    }
                    if (this.shutdown && SNMPTrapMonitorAMImpl.this.trapSession != null && !SNMPTrapMonitorAMImpl.this.trapSession.isClosed()) {
                        try {
                            SNMPTrapMonitorAMImpl.this.trapSession.close();
                            logger.debug((Object)"Stopped receiving SNMP Traps.");
                        }
                        catch (Exception exception) {
                            logger.warn((Object)"Error closing SNMP Trap Session", (Throwable)exception);
                        }
                    }
                }
            }
            logger.debug((Object)"SNMPTrapMonitorRunner has ended.");
            SNMPTrapMonitorAMImpl.this.runnerIsActive = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void snmpReceivedTrap(SnmpTrapSession snmpTrapSession, InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduTrap snmpPduTrap) {
            long l = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received a SNMPv1 Trap from " + inetAddress.getHostName() + ":" + n));
            }
            if (snmpPduTrap != null) {
                if (logger.isTraceEnabled()) {
                    this.logReceivedTrap(inetAddress, n, snmpOctetString, snmpPduTrap);
                }
                HSSnmpPduTrap hSSnmpPduTrap = new HSSnmpPduTrap(snmpPduTrap, inetAddress, snmpOctetString, n);
                boolean bl = false;
                SNMPTrapMonitor[] sNMPTrapMonitorArray = SNMPTrapMonitorAMImpl.this.monitorList;
                synchronized (sNMPTrapMonitorArray) {
                    if (SNMPTrapMonitorAMImpl.this.monitorList != null && SNMPTrapMonitorAMImpl.this.monitorList.length > 0) {
                        for (int i = 0; i < SNMPTrapMonitorAMImpl.this.monitorList.length; ++i) {
                            Object object;
                            Thread.yield();
                            bl = false;
                            if (SNMPTrapMonitorAMImpl.this.monitorList[i].getDataFilter().criteriaSize() > 0) {
                                object = new DataFilterMatcher(SNMPTrapMonitorAMImpl.this.monitorList[i].getDataFilter());
                                try {
                                    bl = object.matches((Object)hSSnmpPduTrap);
                                }
                                catch (Exception exception) {
                                    logger.debug((Object)("Error comparing SNMPv1 Trap to SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()), (Throwable)exception);
                                }
                            }
                            if (bl) {
                                logger.debug((Object)("SNMP Trap Meets Critera for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                                object = new SNMPTrapEvent();
                                ((SNMPTrapEvent)((Object)object)).setSNMPTrapMonitorName(SNMPTrapMonitorAMImpl.this.monitorList[i].getName());
                                ((SNMPTrapEvent)((Object)object)).setSendEmail(SNMPTrapMonitorAMImpl.this.monitorList[i].isSendEmail());
                                ((SNMPTrapEvent)((Object)object)).setNotificationListID(SNMPTrapMonitorAMImpl.this.monitorList[i].getNotificationListID());
                                ((SNMPTrapEvent)((Object)object)).setEventData(this.getEventData(inetAddress, n, snmpOctetString, snmpPduTrap));
                                ((SNMPTrapEvent)((Object)object)).setSNMPTrapMonitorID(SNMPTrapMonitorAMImpl.this.monitorList[i].getID());
                                ((SNMPTrapEvent)((Object)object)).setSourceIPAddress(inetAddress.getHostAddress());
                                ((SNMPTrapEvent)((Object)object)).setTimeDetected(l);
                                ((SNMPTrapEvent)((Object)object)).setReactivityStatus('*');
                                if (SNMPTrapMonitorAMImpl.this.monitorList[i].isDisabled()) {
                                    ((SNMPTrapEvent)((Object)object)).setEventErrorcode(2);
                                    logger.debug((Object)("SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName() + " is disabled"));
                                } else {
                                    String string = DateTranslator.packTime((Date)new Date(l));
                                    int n2 = Integer.parseInt(string);
                                    if (SNMPTrapMonitorAMImpl.this.monitorList[i].getToTime() > SNMPTrapMonitorAMImpl.this.monitorList[i].getFromTime()) {
                                        if (n2 < SNMPTrapMonitorAMImpl.this.monitorList[i].getFromTime() || n2 >= SNMPTrapMonitorAMImpl.this.monitorList[i].getToTime()) {
                                            ((SNMPTrapEvent)((Object)object)).setEventErrorcode(1);
                                            logger.debug((Object)("SNMP Trap is outside time range for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                                        }
                                    } else if (n2 < SNMPTrapMonitorAMImpl.this.monitorList[i].getFromTime() && n2 >= SNMPTrapMonitorAMImpl.this.monitorList[i].getToTime()) {
                                        ((SNMPTrapEvent)((Object)object)).setEventErrorcode(1);
                                        logger.debug((Object)("SNMP Trap is outside time range for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                                    }
                                }
                                SNMPTrapMonitorAMImpl.this.postSNMPTrapEvent((SNMPTrapEvent)((Object)object));
                                continue;
                            }
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)("SNMP Trap does not meet Critera for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void snmpReceivedTrap(SnmpTrapSession snmpTrapSession, InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduPacket snmpPduPacket) {
            long l = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received a SNMPv2 Trap from " + inetAddress.getHostName() + ":" + n));
            }
            if (snmpPduPacket != null) {
                if (logger.isTraceEnabled()) {
                    this.logReceivedTrap(inetAddress, n, snmpOctetString, snmpPduPacket);
                }
                HSSnmpPduPacket hSSnmpPduPacket = new HSSnmpPduPacket(snmpPduPacket, inetAddress, snmpOctetString, n);
                boolean bl = false;
                SNMPTrapMonitor[] sNMPTrapMonitorArray = SNMPTrapMonitorAMImpl.this.monitorList;
                synchronized (sNMPTrapMonitorArray) {
                    if (SNMPTrapMonitorAMImpl.this.monitorList != null && SNMPTrapMonitorAMImpl.this.monitorList.length > 0) {
                        for (int i = 0; i < SNMPTrapMonitorAMImpl.this.monitorList.length; ++i) {
                            SNMPTrapEvent sNMPTrapEvent;
                            Thread.yield();
                            bl = false;
                            if (SNMPTrapMonitorAMImpl.this.monitorList[i].getDataFilter().criteriaSize() > 0) {
                                sNMPTrapEvent = new DataFilterMatcher(SNMPTrapMonitorAMImpl.this.monitorList[i].getDataFilter());
                                try {
                                    bl = sNMPTrapEvent.matches((Object)hSSnmpPduPacket);
                                }
                                catch (Exception exception) {
                                    logger.debug((Object)("Error comparing SNMPv2 Trap to SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()), (Throwable)exception);
                                }
                            }
                            if (bl) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("SNMP Trap Meets Critera for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                                }
                                sNMPTrapEvent = new SNMPTrapEvent();
                                sNMPTrapEvent.setSNMPTrapMonitorName(SNMPTrapMonitorAMImpl.this.monitorList[i].getName());
                                sNMPTrapEvent.setSendEmail(SNMPTrapMonitorAMImpl.this.monitorList[i].isSendEmail());
                                sNMPTrapEvent.setNotificationListID(SNMPTrapMonitorAMImpl.this.monitorList[i].getNotificationListID());
                                sNMPTrapEvent.setEventData(this.getEventData(inetAddress, n, snmpOctetString, snmpPduPacket));
                                sNMPTrapEvent.setSNMPTrapMonitorID(SNMPTrapMonitorAMImpl.this.monitorList[i].getID());
                                sNMPTrapEvent.setSourceIPAddress(inetAddress.getHostAddress());
                                sNMPTrapEvent.setTimeDetected(l);
                                sNMPTrapEvent.setReactivityStatus('*');
                                if (SNMPTrapMonitorAMImpl.this.monitorList[i].isDisabled()) {
                                    sNMPTrapEvent.setEventErrorcode(2);
                                    logger.debug((Object)("SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName() + " is disabled"));
                                } else {
                                    String string = DateTranslator.packTime((Date)new Date(l));
                                    int n2 = Integer.parseInt(string);
                                    if (SNMPTrapMonitorAMImpl.this.monitorList[i].getToTime() > SNMPTrapMonitorAMImpl.this.monitorList[i].getFromTime()) {
                                        if (n2 < SNMPTrapMonitorAMImpl.this.monitorList[i].getFromTime() || n2 >= SNMPTrapMonitorAMImpl.this.monitorList[i].getToTime()) {
                                            sNMPTrapEvent.setEventErrorcode(1);
                                            logger.debug((Object)("SNMP Trap is outside time range for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                                        }
                                    } else if (n2 < SNMPTrapMonitorAMImpl.this.monitorList[i].getFromTime() && n2 >= SNMPTrapMonitorAMImpl.this.monitorList[i].getToTime()) {
                                        sNMPTrapEvent.setEventErrorcode(1);
                                        logger.debug((Object)("SNMP Trap is outside time range for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                                    }
                                }
                                SNMPTrapMonitorAMImpl.this.postSNMPTrapEvent(sNMPTrapEvent);
                                continue;
                            }
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)("SNMP Trap does not meet Critera for SNMP Trap Monitor " + SNMPTrapMonitorAMImpl.this.monitorList[i].getName()));
                        }
                    }
                }
            }
        }

        public void snmpTrapSessionError(SnmpTrapSession snmpTrapSession, int n, Object object) {
            logger.debug((Object)("SNMP Receive Trap Monitoring received error code " + n));
            if (object != null) {
                logger.debug((Object)("SNMP Trap Session error PDU Object:  " + object.toString()));
            }
            if (n == -1) {
                logger.error((Object)"Error receiveing SNMP Traps Requests...unable to receive SNMP Traps");
                this.shutdown = true;
            }
        }

        private void logReceivedTrap(InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduTrap snmpPduTrap) {
            logger.trace((Object)"The SNMP Trap has the following attributes:");
            logger.trace((Object)("  Sender Address:  " + inetAddress));
            logger.trace((Object)("  Port:  " + n));
            logger.trace((Object)("  Community:  " + snmpOctetString));
            logger.trace((Object)("  Address:  " + snmpPduTrap.getAgentAddress()));
            logger.trace((Object)("  Enterprise Id:  " + snmpPduTrap.getEnterprise()));
            logger.trace((Object)("  Generic:  " + snmpPduTrap.getGeneric()));
            logger.trace((Object)("  Specific:  " + snmpPduTrap.getSpecific()));
            logger.trace((Object)("  Timestamp:  " + snmpPduTrap.getTimeStamp()));
            logger.trace((Object)("  Length:  " + snmpPduTrap.getLength()));
            if (snmpPduTrap.getLength() > 0) {
                for (int i = 0; i < snmpPduTrap.getLength(); ++i) {
                    SnmpVarBind snmpVarBind = snmpPduTrap.getVarBindAt(i);
                    if (!logger.isTraceEnabled() || snmpVarBind == null) continue;
                    logger.trace((Object)("  Varbind[" + i + "]:  " + snmpVarBind.getName().toString() + " - " + snmpVarBind.getValue().toString()));
                }
            }
        }

        private void logReceivedTrap(InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduPacket snmpPduPacket) {
            logger.trace((Object)"The SNMP Trap has the following attributes:");
            logger.trace((Object)("  Sender Address:  " + inetAddress));
            logger.trace((Object)("  Port:  " + n));
            logger.trace((Object)("  Community:  " + snmpOctetString));
            logger.trace((Object)("  Command:  " + snmpPduPacket.getCommand()));
            logger.trace((Object)("  Request ID:  " + snmpPduPacket.getRequestId()));
            logger.trace((Object)("  Length:  " + snmpPduPacket.getLength()));
            if (snmpPduPacket.getLength() > 0) {
                for (int i = 0; i < snmpPduPacket.getLength(); ++i) {
                    SnmpVarBind snmpVarBind = snmpPduPacket.getVarBindAt(i);
                    if (!logger.isTraceEnabled() || snmpVarBind == null) continue;
                    logger.trace((Object)("  Varbind[" + i + "]:  " + snmpVarBind.getName().toString() + " - " + snmpVarBind.getValue().toString()));
                }
            }
        }

        private String getEventData(InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduTrap snmpPduTrap) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(inetAddress.getHostAddress()).append(' ');
            stringBuffer.append(n).append(' ');
            stringBuffer.append(snmpOctetString).append(' ');
            stringBuffer.append(snmpPduTrap.getEnterprise()).append(' ');
            stringBuffer.append(snmpPduTrap.getGeneric()).append(' ');
            stringBuffer.append(snmpPduTrap.getSpecific()).append(' ');
            stringBuffer.append(snmpPduTrap.getTimeStamp()).append(' ');
            stringBuffer.append(snmpPduTrap.getLength()).append(' ');
            if (snmpPduTrap.getLength() > 0) {
                SnmpVarBind[] snmpVarBindArray = snmpPduTrap.toVarBindArray();
                for (int i = 0; i < snmpVarBindArray.length; ++i) {
                    stringBuffer.append(' ').append(snmpVarBindArray[i].getName()).append('=').append(snmpVarBindArray[i].getValue());
                }
            }
            return stringBuffer.toString();
        }

        private String getEventData(InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduPacket snmpPduPacket) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(inetAddress.getHostAddress()).append(' ');
            stringBuffer.append(n).append(' ');
            stringBuffer.append(snmpOctetString).append(' ');
            stringBuffer.append(snmpPduPacket.getCommand()).append(' ');
            stringBuffer.append(snmpPduPacket.getRequestId());
            if (snmpPduPacket.getLength() > 0) {
                object = snmpPduPacket.toVarBindArray();
                for (int i = 0; i < ((SnmpVarBind[])object).length; ++i) {
                    stringBuffer.append(' ').append(object[i].getName()).append('=').append(object[i].getValue());
                }
            }
            object = stringBuffer.toString();
            return object;
        }
    }
}

