/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.ex.RemoteManagerNotFoundException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentGroup;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgentWithName;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.CustomMailMessage;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.busobj.JobConditionR02M03;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobLogCopiedEvent;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobQueueType;
import com.helpsystems.enterprise.core.busobj.JobReactCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.NotOnQueueException;
import com.helpsystems.enterprise.core.busobj.PersistedJobQueueEntry;
import com.helpsystems.enterprise.core.busobj.RunningJobLogException;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.JobStatusSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.JobSuitesStatusSNMPTrap;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.EventHistoryXRefDM;
import com.helpsystems.enterprise.core.dm.ForecastAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobInitiationCountRollupDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.dm.JobStartEndRollupDM;
import com.helpsystems.enterprise.core.dm.JobStatusCountRollupDM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.OutputDistributionAM;
import com.helpsystems.enterprise.core.dm.PersistedJobQueueEntryDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.logger.CrossAppenderLogger;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.ActivityMatcherAM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteInstanceMember;
import com.helpsystems.enterprise.core.scheduler.JobSuiteStatus;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobBigProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.SuiteInfo;
import com.helpsystems.enterprise.core.util.FileHandler;
import com.helpsystems.enterprise.core.util.JobConditionMessageGenerator;
import com.helpsystems.enterprise.core.util.JobParameterUtil;
import com.helpsystems.enterprise.module.EmailInformation;
import com.helpsystems.enterprise.module.exec.AgentOutputWorker;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JobTrackerAMImpl
extends AbstractManager
implements JobTrackerAM {
    private static final Logger logger = Logger.getLogger(JobTrackerAMImpl.class);
    private BlockingQueue<JobHistory> queue;
    private JobHistoryDM jobHistoryDM;
    private JobStartEndRollupDM jobStartEndRollupDM;
    private JobStatusCountRollupDM jobStatusCountRollupDM;
    private JobInitiationCountRollupDM jobInitiationCountRollupDM;
    private EnterpriseServerAM enterpriseServerAM;
    private ScheduleJobDM scheduleJobDM;
    private AgentDM agentDM;
    private AgentGroupDM agentGroupDM;
    private EnterpriseSNMPTrapAM snmpTrapAM;
    private NotificationListDM notificationListDM;
    private EnterpriseEmailAM emailAM;
    private JobMonitorManagerAM jobMonitorManagerAM;
    private PrereqDM prereqDM;
    private OutputDistributionAM outputDistributionAM;
    private ActivityMatcherAM activityMatcherAM;
    private AgentPeer peer;
    private JobSuiteDM jobSuiteDM;
    private HashMap<Long, Object> waitingAgents = new HashMap();
    private JobQueuesDM jobQueuesDM;
    private ForecastAM forecastAM;

    public JobTrackerAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.JobTrackerAM");
        this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        this.jobStartEndRollupDM = (JobStartEndRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobStartEndRollupDM");
        this.jobStatusCountRollupDM = (JobStatusCountRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobStatusCountRollupDM");
        this.jobInitiationCountRollupDM = (JobInitiationCountRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobInitiationCountRollupDM");
        this.jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobSuiteDM");
        this.enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseServerAM");
        this.scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        this.agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        this.agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
        this.snmpTrapAM = (EnterpriseSNMPTrapAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseSNMPTrapAM");
        this.emailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
        this.notificationListDM = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
        this.jobMonitorManagerAM = (JobMonitorManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorManagerAM");
        this.prereqDM = (PrereqDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
        this.outputDistributionAM = (OutputDistributionAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.OutputDistributionAM");
        this.activityMatcherAM = (ActivityMatcherAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ActivityMatcherAM");
        this.queue = new LinkedBlockingQueue<JobHistory>();
        this.peer = agentPeer;
        Thread thread = null;
        JobQueueRunner jobQueueRunner = new JobQueueRunner();
        long l = SkybotStackSize.getStackSize();
        thread = l != 0L ? new Thread(null, jobQueueRunner, "JobQueueRunner", l) : new Thread(jobQueueRunner);
        thread.setName("JobQueueRunner");
        thread.start();
    }

    @Override
    public void submitJob(JobHistory jobHistory) {
        this.submitJob(jobHistory, true);
    }

    @Override
    public JobHistory skipJobSuiteMember(JobSuiteInstanceMember jobSuiteInstanceMember, long l, long l2, SuiteInfo suiteInfo, String string) throws ResourceUnavailableException {
        JobHistory jobHistory = null;
        ScheduleJobBigProxy scheduleJobBigProxy = null;
        try {
            scheduleJobBigProxy = this.getScheduleJobBigProxy(jobSuiteInstanceMember.getJobID());
        }
        catch (Exception exception) {
            logger.error((Object)"Error loading job definition for skipped member.", (Throwable)exception);
        }
        long l3 = jobSuiteInstanceMember.getMemberID();
        block10 : switch (jobSuiteInstanceMember.getTargetType()) {
            case AGENT: {
                jobHistory = this.createBasicJobHistoryObject_ForMember(jobSuiteInstanceMember, l, l2, suiteInfo);
                long l4 = jobSuiteInstanceMember.getTargetID();
                jobHistory.setAgentID(l4);
                try {
                    jobHistory.setAgentName(this.agentDM.get(l4).getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jobHistory.setJobQueueID(jobSuiteInstanceMember.getJobQueueID());
                jobHistory.setJobQueueName(jobSuiteInstanceMember.getJobQueueName());
                this.setAgentTimezone(jobHistory);
                jobHistory.setInitiationCode(JobInitCode.SUITE_MEMBER);
                jobHistory.setStatusCode(JobStatusCode.SKIPPED);
                try {
                    jobHistory = this.jobHistoryDM.save(jobHistory, true);
                }
                catch (Exception exception) {
                    this.logError_MemberSubmitError(jobHistory, suiteInfo, exception);
                    throw new RuntimeException(MessageUtil.formatMsg((String)"Unable to create the Job History entry for suite member {0}.", (Object[])new Object[]{jobSuiteInstanceMember.getName()}));
                }
                this.activityMatcherAM.memberSkipped(l3, jobHistory.getAgentID(), jobHistory.getId(), l);
                try {
                    this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy, string);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error perfoming notification of skipped member.", (Throwable)exception);
                }
                break;
            }
            case AGENT_GROUP: {
                long l5 = jobSuiteInstanceMember.getTargetID();
                AgentGroupProxy agentGroupProxy = this.retrieveAgentGroupProxy(l5);
                String string2 = agentGroupProxy.getName();
                AgentGroupType agentGroupType = agentGroupProxy.getAgentGroupType();
                switch (agentGroupType) {
                    case ALL_AGENTS: {
                        long l6;
                        long l7 = jobSuiteInstanceMember.getSuiteInstanceID();
                        AgentGroupAgentWithName[] agentGroupAgentWithNameArray = this.agentGroupDM.getAgentsInGroup(l5);
                        try {
                            l6 = this.getSuiteScheduledTime(l7);
                        }
                        catch (Exception exception) {
                            logger.error((Object)"Unable to retrieve the suite scheduled time", (Throwable)exception);
                            l6 = l2;
                        }
                        for (AgentGroupAgentWithName agentGroupAgentWithName : agentGroupAgentWithNameArray) {
                            if (agentGroupAgentWithName.currentlyIgnored(l6)) continue;
                            jobHistory = this.createBasicJobHistoryObject_ForMember(jobSuiteInstanceMember, l, l2, suiteInfo);
                            jobHistory.setAgentID(agentGroupAgentWithName.getAgentID());
                            jobHistory.setAgentName(agentGroupAgentWithName.getAgentName());
                            jobHistory.setAgentGroupID(l5);
                            jobHistory.setAgentGroupName(string2);
                            jobHistory.setJobQueueID(jobSuiteInstanceMember.getJobQueueID());
                            jobHistory.setJobQueueName(jobSuiteInstanceMember.getJobQueueName());
                            this.setAgentTimezone(jobHistory);
                            jobHistory.setInitiationCode(JobInitCode.SUITE_MEMBER);
                            jobHistory.setStatusCode(JobStatusCode.SKIPPED);
                            try {
                                jobHistory = this.jobHistoryDM.save(jobHistory, true);
                            }
                            catch (Exception exception) {
                                this.logError_MemberSubmitError(jobHistory, suiteInfo, exception);
                                throw new RuntimeException(MessageUtil.formatMsg((String)"Unable to create the Job History entry for suite member {0}.", (Object[])new Object[]{jobSuiteInstanceMember.getName()}));
                            }
                            this.activityMatcherAM.memberSkipped(l3, jobHistory.getAgentID(), jobHistory.getId(), l);
                            if (agentGroupAgentWithName.getIgnoreInGroup() != 2) continue;
                            try {
                                this.agentGroupDM.release(agentGroupAgentWithName.getOid());
                            }
                            catch (Exception exception) {
                                logger.error((Object)MessageUtil.formatMsg((String)"Error releasing ignored Agent Group Agent {0}.", (Object[])new Object[]{agentGroupAgentWithName.getOid()}), (Throwable)exception);
                            }
                        }
                        try {
                            if (jobHistory == null) break block10;
                            String exception = RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_MEMBER_JOB_SKIPPED_ON_GROUP_STATUS_NOTICE, new String[]{jobSuiteInstanceMember.getName(), string2, suiteInfo.getSuiteName(), String.valueOf(jobSuiteInstanceMember.getSuiteInstanceID()), ScheduleLogger.formatTimeStamp(l2)});
                            this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy, exception, string);
                        }
                        catch (Exception exception) {
                            logger.error((Object)"Error performing notification of skipped member.", (Throwable)exception);
                        }
                        break block10;
                    }
                    case UTILIZATION_BALANCED: 
                    case PREFERRED_AGENT: {
                        jobHistory = this.createBasicJobHistoryObject_ForMember(jobSuiteInstanceMember, l, l2, suiteInfo);
                        jobHistory.setAgentName(Agent.getTBDInGroupAgentName(string2));
                        jobHistory.setAgentGroupID(l5);
                        jobHistory.setAgentGroupName(string2);
                        jobHistory.setJobQueueID(jobSuiteInstanceMember.getJobQueueID());
                        jobHistory.setJobQueueName(jobSuiteInstanceMember.getJobQueueName());
                        jobHistory.setInitiationCode(JobInitCode.SUITE_MEMBER);
                        jobHistory.setStatusCode(JobStatusCode.SKIPPED);
                        try {
                            jobHistory = this.jobHistoryDM.save(jobHistory, true);
                        }
                        catch (Exception exception) {
                            this.logError_MemberSubmitError(jobHistory, suiteInfo, exception);
                            throw new RuntimeException(MessageUtil.formatMsg((String)"Unable to create the Job History entry for suite member {0}.", (Object[])new Object[]{jobSuiteInstanceMember.getName()}));
                        }
                        this.activityMatcherAM.memberSkipped(l3, jobHistory.getAgentID(), jobHistory.getId(), l);
                        try {
                            this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy, string);
                        }
                        catch (Exception exception) {
                            logger.error((Object)"Error perfoming notification of skipped member.", (Throwable)exception);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                    }
                }
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{jobSuiteInstanceMember.getTargetType()}));
            }
        }
        return jobHistory;
    }

    @Override
    public int submitJobSuiteMember(JobSuiteInstanceMember jobSuiteInstanceMember, long l, long l2, SuiteInfo suiteInfo) throws ResourceUnavailableException {
        JobInitCode jobInitCode = JobInitCode.SUITE_MEMBER;
        if (suiteInfo.getMemberInitCode() != null) {
            jobInitCode = suiteInfo.getMemberInitCode();
        }
        JobReactCode jobReactCode = suiteInfo.isPerformReactivity() ? JobReactCode.PERFORM_REACTIVITY : JobReactCode.SKIP_REACTIVITY;
        block6 : switch (jobSuiteInstanceMember.getTargetType()) {
            case AGENT: {
                JobHistory jobHistory = this.createBasicJobHistoryObject_ForMember(jobSuiteInstanceMember, l, l2, suiteInfo);
                long l3 = jobSuiteInstanceMember.getTargetID();
                jobHistory.setAgentID(l3);
                jobHistory.setJobQueueID(jobSuiteInstanceMember.getJobQueueID());
                jobHistory.setJobQueueName(jobSuiteInstanceMember.getJobQueueName());
                try {
                    Agent agent = this.agentDM.get(l3);
                    jobHistory.setAgentName(agent.getName());
                    jobHistory.setAgentTimezone(agent.getTimeZone());
                }
                catch (Exception exception) {
                    logger.warn((Object)("Error loading agent information for agent id: " + l3), (Throwable)exception);
                }
                jobHistory.setInitiationCode(jobInitCode);
                jobHistory.setBypassJobMonitors(suiteInfo.isIgnoreMonitors());
                jobHistory.setReactCode(jobReactCode);
                long l4 = this.forecastAM.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
                jobHistory.setEstimatedRuntime(l4);
                try {
                    jobHistory = this.jobHistoryDM.save(jobHistory);
                }
                catch (Exception exception) {
                    this.logError_MemberSubmitError(jobHistory, suiteInfo, exception);
                    throw new RuntimeException(MessageUtil.formatMsg((String)"Unable to create the Job History entry for suite member {0}.", (Object[])new Object[]{jobSuiteInstanceMember.getName()}));
                }
                this.submitJobSuiteMember(jobHistory, l, suiteInfo);
                break;
            }
            case AGENT_GROUP: {
                long l5 = jobSuiteInstanceMember.getTargetID();
                AgentGroupProxy agentGroupProxy = this.retrieveAgentGroupProxy(l5);
                String string = agentGroupProxy.getName();
                AgentGroupType agentGroupType = agentGroupProxy.getAgentGroupType();
                switch (agentGroupType) {
                    case ALL_AGENTS: {
                        long l6;
                        ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>();
                        long l7 = jobSuiteInstanceMember.getSuiteInstanceID();
                        AgentGroupAgentWithName[] agentGroupAgentWithNameArray = this.agentGroupDM.getAgentsInGroup(l5);
                        logger.debug((Object)MessageUtil.formatMsg((String)"Suite member {0} of job suite {1} runs on agent group {2}, which as of suite run number {3} has {4} agents. However, some may be ignored. See Server History for any ignore messages.", (Object[])new Object[]{jobSuiteInstanceMember.getName(), suiteInfo.getSuiteName(), string, l7, agentGroupAgentWithNameArray.length}));
                        if (agentGroupAgentWithNameArray.length == 0) {
                            return 1;
                        }
                        try {
                            l6 = this.getSuiteScheduledTime(l7);
                        }
                        catch (Exception exception) {
                            logger.error((Object)"Unable to retrieve the suite scheduled time", (Throwable)exception);
                            l6 = l2;
                        }
                        for (AgentGroupAgentWithName agentGroupAgentWithName : agentGroupAgentWithNameArray) {
                            if (agentGroupAgentWithName.currentlyIgnored(l6)) {
                                RosettaMsg rosettaMsg;
                                String[] stringArray = new String[]{jobSuiteInstanceMember.getName(), agentGroupAgentWithName.getAgentName(), suiteInfo.getSuiteName(), Long.toString(l7), ScheduleLogger.formatTimeStamp(agentGroupAgentWithName.getIgnoreUntilTimestamp())};
                                switch (agentGroupAgentWithName.getIgnoreInGroup()) {
                                    case 1: {
                                        rosettaMsg = RosettaMsg.SUITE_MEMBER_WAS_IGNORED_IN_AGENT_GROUP;
                                        break;
                                    }
                                    case 2: {
                                        rosettaMsg = RosettaMsg.SUITE_MEMBER_WAS_IGNORED_UNTIL_IN_AGENT_GROUP;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group Ignore flag {0} is not supported by this method.", (Object[])new Object[]{agentGroupAgentWithName.getIgnoreInGroup()}));
                                    }
                                }
                                long l8 = 0L;
                                ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, agentGroupAgentWithName.getAgentID(), jobSuiteInstanceMember.getJobID(), l8, suiteInfo.getSuiteID(), l7);
                                ScheduleLogger.write(scheduleLogEntry);
                                continue;
                            }
                            JobHistory jobHistory = this.createBasicJobHistoryObject_ForMember(jobSuiteInstanceMember, l, l2, suiteInfo);
                            jobHistory.setAgentID(agentGroupAgentWithName.getAgentID());
                            jobHistory.setAgentName(agentGroupAgentWithName.getAgentName());
                            jobHistory.setAgentGroupID(l5);
                            jobHistory.setAgentGroupName(string);
                            jobHistory.setInitiationCode(jobInitCode);
                            jobHistory.setBypassJobMonitors(suiteInfo.isIgnoreMonitors());
                            jobHistory.setReactCode(jobReactCode);
                            this.setAgentTimezone(jobHistory);
                            jobHistory.setJobQueueID(jobSuiteInstanceMember.getJobQueueID());
                            jobHistory.setJobQueueName(jobSuiteInstanceMember.getJobQueueName());
                            long l9 = this.forecastAM.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
                            jobHistory.setEstimatedRuntime(l9);
                            try {
                                jobHistory = this.jobHistoryDM.save(jobHistory);
                            }
                            catch (Exception exception) {
                                this.logError_MemberSubmitError(jobHistory, suiteInfo, exception);
                                throw new RuntimeException(MessageUtil.formatMsg((String)"Unable to create the Job History entry for suite member {0}.", (Object[])new Object[]{jobSuiteInstanceMember.getName()}));
                            }
                            arrayList.add(jobHistory);
                            if (agentGroupAgentWithName.getIgnoreInGroup() != 2) continue;
                            try {
                                this.agentGroupDM.release(agentGroupAgentWithName.getOid());
                            }
                            catch (Exception exception) {
                                logger.error((Object)MessageUtil.formatMsg((String)"Error releasing ignored Agent Group Agent {0}.", (Object[])new Object[]{agentGroupAgentWithName.getOid()}), (Throwable)exception);
                            }
                        }
                        if (arrayList.isEmpty()) {
                            return 2;
                        }
                        for (JobHistory jobHistory : arrayList) {
                            this.submitJobSuiteMember(jobHistory, l, suiteInfo);
                        }
                        break block6;
                    }
                    case UTILIZATION_BALANCED: 
                    case PREFERRED_AGENT: {
                        JobHistory jobHistory = this.createBasicJobHistoryObject_ForMember(jobSuiteInstanceMember, l, l2, suiteInfo);
                        jobHistory.setAgentName(Agent.getTBDInGroupAgentName(string));
                        jobHistory.setAgentGroupID(l5);
                        jobHistory.setAgentGroupName(string);
                        jobHistory.setInitiationCode(jobInitCode);
                        jobHistory.setBypassJobMonitors(suiteInfo.isIgnoreMonitors());
                        jobHistory.setReactCode(jobReactCode);
                        jobHistory.setJobQueueID(jobSuiteInstanceMember.getJobQueueID());
                        jobHistory.setJobQueueName(jobSuiteInstanceMember.getJobQueueName());
                        long l10 = this.forecastAM.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
                        jobHistory.setEstimatedRuntime(l10);
                        try {
                            jobHistory = this.jobHistoryDM.save(jobHistory);
                        }
                        catch (Exception exception) {
                            this.logError_MemberSubmitError(jobHistory, suiteInfo, exception);
                            throw new RuntimeException(MessageUtil.formatMsg((String)"Unable to create the Job History entry for suite member {0}.", (Object[])new Object[]{jobSuiteInstanceMember.getName()}));
                        }
                        this.submitJobSuiteMember(jobHistory, l, suiteInfo);
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                    }
                }
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{jobSuiteInstanceMember.getTargetType()}));
            }
        }
        return 0;
    }

    private void submitJobSuiteMember(JobHistory jobHistory, long l, SuiteInfo suiteInfo) {
        long l2 = jobHistory.getAgentID();
        try {
            this.queue.offer(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to notify the Enterprise Server that suite member {0} with run number {1} is ready to be submitted.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getId()}), (Throwable)exception);
            jobHistory.setStatusCode(JobStatusCode.ERROR);
            try {
                this.jobHistoryDM.save(jobHistory);
            }
            catch (Exception exception2) {
                throw new RuntimeException(MessageUtil.formatMsg((String)"Error updating job history to status ERROR for suite member {0} with run number {1}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getId()}), exception2);
            }
        }
        long l3 = jobHistory.getJobSuiteMemberID();
        this.activityMatcherAM.memberSubmitted(l3, l2, jobHistory.getId(), l);
        RosettaMsg rosettaMsg = RosettaMsg.SUITE_MEMBER_SUBMITTED;
        long l4 = jobHistory.getJobSuiteHistoryID();
        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), ScheduleLogger.formatTimeStamp(l), Long.toString(jobHistory.getId()), suiteInfo.getSuiteName(), Long.toString(l4)};
        this.writeToScheduleLog(rosettaMsg, stringArray, jobHistory);
    }

    @Override
    public JobHistory reSubmitLoadBalancedJob(long l) throws ActionFailedException {
        String string = "Error submitting job for load balancing.";
        String string2 = "Unknown";
        try {
            JobHistory jobHistory = this.getJobHistory(l);
            string2 = jobHistory.getAgentName();
            if (jobHistory.getAgentGroupID() == 0L) {
                throw new ActionFailedException(string + " Job history ID " + l + " is not assigned to an" + " Agent Group.");
            }
            AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(jobHistory.getAgentGroupID());
            if (!agentGroupProxy.getAgentGroupType().isLoadBalanced()) {
                throw new ActionFailedException(string + " Job history ID " + l + " is assigned to the" + " All Agents Group " + agentGroupProxy.getName() + ".");
            }
            this.enterpriseServerAM.dequeueJob(jobHistory);
            JobQueueType jobQueueType = this.getJobQueuesDM().getJobQueueType(jobHistory.getJobQueueID());
            switch (jobQueueType) {
                case AGENT: {
                    jobHistory.setJobQueueID(0L);
                    break;
                }
            }
            jobHistory.setAgentID(0L);
            jobHistory.setAgentName("Unassigned");
            jobHistory.setSubsequentSubmit(true);
            this.submitJob(jobHistory, false);
            JobHistory jobHistory2 = new JobHistory();
            jobHistory2.setId(l);
            jobHistory2.setJobName(jobHistory.getJobName());
            jobHistory2.setAgentName(string2);
            return jobHistory2;
        }
        catch (DataException dataException) {
            throw new ActionFailedException(string, (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ActionFailedException(string, (Throwable)resourceUnavailableException);
        }
        catch (NotOnQueueException notOnQueueException) {
            string = "Job is no longer on the queue.";
            throw new ActionFailedException(string, (Throwable)notOnQueueException);
        }
    }

    private void submitJob(JobHistory jobHistory, boolean bl) {
        JobHistory jobHistory2 = jobHistory;
        ValidationHelper.checkForNull((String)"JobHistory info", (Object)((Object)jobHistory));
        jobHistory.setStatusCode(JobStatusCode.INITIATED);
        if (jobHistory.getServerInitiatedTime() <= 0L) {
            jobHistory.setServerInitiatedTime(System.currentTimeMillis());
        }
        if (jobHistory.getAgentEnvironmentType() == null) {
            ScheduleJobProxy scheduleJobProxy = null;
            try {
                scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy(jobHistory.getJobID());
                jobHistory.setAgentEnvironmentType(scheduleJobProxy.getAgentEnvironmentType());
            }
            catch (Exception exception) {
                logger.error((Object)("Error retrieving Schedule Job Proxy for jobID: " + jobHistory.getJobID()), (Throwable)exception);
            }
        }
        if (jobHistory.getId() < 1L || !jobHistory.getStatusCode().equals(JobStatusCode.INITIATED)) {
            try {
                jobHistory2 = this.jobHistoryDM.save(jobHistory);
                jobHistory2.setAgentEnvironmentType(jobHistory.getAgentEnvironmentType());
            }
            catch (Exception exception) {
                logger.error((Object)"Unable to save new job history info", (Throwable)exception);
                return;
            }
        }
        if (bl) {
            this.resetPrereqStatus(jobHistory);
        }
        this.queue.offer(jobHistory2);
    }

    @Override
    public void submitMissedInitJob(JobHistory jobHistory) {
        ValidationHelper.checkForNull((String)"JobHistory info", (Object)((Object)jobHistory));
        this.resetPrereqStatus(jobHistory);
        jobHistory.setStatusCode(JobStatusCode.SUBMITTED);
        jobHistory.setServerSubmittedTime(System.currentTimeMillis());
        try {
            PersistedJobQueueEntry persistedJobQueueEntry = new PersistedJobQueueEntry(jobHistory.getId(), PersistedJobQueueEntry.Action.ADDED_TO_QUEUE);
            PersistedJobQueueEntryDM persistedJobQueueEntryDM = (PersistedJobQueueEntryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PersistedJobQueueEntryDM");
            persistedJobQueueEntryDM.save(persistedJobQueueEntry);
        }
        catch (Exception exception) {
            logger.error((Object)"Error saving persistent entry.", (Throwable)exception);
        }
        try {
            this.jobHistoryDM.save(jobHistory, true);
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to update a job history state", (Throwable)exception);
        }
    }

    private void resetPrereqStatus(JobHistory jobHistory) {
        try {
            this.prereqDM.resetPrereqStatus(jobHistory.getAgentID(), jobHistory.getJobID(), PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS, jobHistory.getId());
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error resetting prereq status.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public void jobCompletedByAgent(JobHistory jobHistory, boolean bl) throws ActionFailedException {
        this.jobCompleted(jobHistory, null, true, bl, true);
    }

    @Override
    public void jobCompletedMissed(JobHistory jobHistory, ScheduleJobBigProxy scheduleJobBigProxy) throws ActionFailedException {
        this.jobCompleted(jobHistory, scheduleJobBigProxy, false, false, false);
    }

    @Override
    public void jobCompleted(JobHistory jobHistory) throws ActionFailedException {
        this.jobCompleted(jobHistory, null, false, false, false);
    }

    private void jobCompleted(JobHistory jobHistory, ScheduleJobBigProxy scheduleJobBigProxy, boolean bl, boolean bl2, boolean bl3) throws ActionFailedException {
        ScheduleJobBigProxy scheduleJobBigProxy2;
        ScheduleLogEntry scheduleLogEntry;
        block47: {
            block45: {
                if (jobHistory.getJobEndedReasonCode() == null || !jobHistory.getJobEndedReasonCode().equals(JobEndedReasonCode.MISSED_JOB_ACTION)) {
                    if (bl2) {
                        this.deleteAllJobMonitors(jobHistory.getId());
                    } else {
                        this.jobMonitorManagerAM.jobHasCompleted(jobHistory, bl);
                    }
                }
                if (bl2) {
                    ScheduleJobBigProxy scheduleJobBigProxy3;
                    JobHistory jobHistory2 = null;
                    try {
                        jobHistory2 = this.jobHistoryDM.get(jobHistory.getId());
                        if (!jobHistory2.getStatusCode().isTerminalState()) break block45;
                        try {
                            if (jobHistory.isCopiedJobLogToServer() && !jobHistory2.isCopiedJobLogToServer()) {
                                this.jobHistoryDM.updateToCopiedJobLog(jobHistory.getId());
                            }
                        }
                        catch (Exception exception) {
                            logger.warn((Object)"Failed to update history indicating job log was copied to server.", (Throwable)exception);
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Unable to obtain recorded Job History for ID " + jobHistory.getId()), (Throwable)exception);
                    }
                    String string = "Unknown";
                    String string2 = "Unknown";
                    String string3 = "";
                    if (jobHistory2 != null) {
                        string3 = string = jobHistory2.getStatusCode_asText();
                        if (jobHistory2.getJobEndedReasonCode() != null) {
                            string2 = jobHistory2.getJobEndedReasonCode().name();
                            string3 = string3 + "(" + string2 + ")";
                        }
                    }
                    if ((scheduleJobBigProxy3 = scheduleJobBigProxy) == null) {
                        scheduleJobBigProxy3 = this.getJobBigProxy(jobHistory.getJobID());
                    }
                    if (scheduleJobBigProxy3.isEmailJobLog()) {
                        this.outputDistributionAM.sendJobLog(jobHistory.getId());
                    }
                    String string4 = "Job History is already in a terminal status " + string3 + " and will not be updated.";
                    InvalidStateException invalidStateException = new InvalidStateException(string4);
                    this.enterpriseServerAM.jobCompleted(jobHistory, bl3);
                    throw new ActionFailedException("Job " + jobHistory.getJobName() + " with run number " + jobHistory.getId() + " is already in a terminal status.", (Throwable)invalidStateException);
                }
            }
            if (jobHistory.getServerEndedTime() == 0L) {
                jobHistory.setServerEndedTime(System.currentTimeMillis());
            }
            try {
                this.jobHistoryDM.save(jobHistory, true);
            }
            catch (Exception exception) {
                logger.error((Object)"Error saving job history info", (Throwable)exception);
            }
            if (!bl2) {
                try {
                    this.jobStartEndRollupDM.saveEndCount(jobHistory.getServerEndedTime());
                }
                catch (Exception exception) {
                    logger.error((Object)"Error saving jobStartEndRollup for job ending.", (Throwable)exception);
                }
                long l = 0L;
                if (jobHistory.getServerEndedTime() != 0L && jobHistory.getQueueEndedTime() != 0L) {
                    l = jobHistory.getServerEndedTime() - jobHistory.getQueueEndedTime();
                }
                try {
                    this.jobStatusCountRollupDM.saveStatusCount(jobHistory.getStatusCode(), jobHistory.getServerEndedTime(), jobHistory.getAgentID(), l);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error saving job_status_count_rollups for job ending.", (Throwable)exception);
                }
            }
            this.enterpriseServerAM.jobCompleted(jobHistory, bl3);
            String string = String.valueOf(jobHistory.getId());
            String string5 = String.valueOf(jobHistory.getFailedAtCommandSequence());
            String string6 = ScheduleLogger.formatTimeStamp(jobHistory.getServerEndedTime());
            String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getStatusCode_asText(), string, string5, string6};
            scheduleLogEntry = null;
            if (!bl) {
                if (jobHistory.getJobEndedReasonCode() == JobEndedReasonCode.PLATFORM_COMMAND_MISMATCH) {
                    try {
                        this.jobHistoryDM.save(jobHistory, true);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        logger.debug((Object)(resourceUnavailableException.getMessage() + resourceUnavailableException.getStackTrace()));
                    }
                    catch (DataException dataException) {
                        logger.debug((Object)(dataException.getMessage() + dataException.getStackTrace()));
                    }
                }
                scheduleLogEntry = RosettaMsg.JOB_WAS_NOT_RUN.newLogEntry(stringArray);
            } else if (jobHistory.getStatusCode().equals(JobStatusCode.COMPLETED)) {
                scheduleLogEntry = RosettaMsg.JOB_COMPLETED.newLogEntry(stringArray);
            } else if (jobHistory.getFailedAtCommandSequence() > 0) {
                scheduleLogEntry = RosettaMsg.JOB_FAILED_AT_COMMAND.newLogEntry(stringArray);
            } else if (jobHistory.getJobEndedReasonCode() != null && jobHistory.getJobEndedReasonCode().equals(JobEndedReasonCode.CONDITION_NOT_MET) && jobHistory.getTerminationData().length() > 0) {
                try {
                    JobConditionR02M03 jobConditionR02M03 = new JobConditionR02M03(jobHistory.getTerminationData());
                    logger.debug((Object)("run # " + jobHistory.getId() + " failed condition = " + JobConditionMessageGenerator.getConditionMessage(jobConditionR02M03)));
                    String[] stringArray2 = new String[]{jobHistory.getJobName(), string, jobHistory.getAgentName(), string6, JobConditionMessageGenerator.getConditionMessage(jobConditionR02M03)};
                    if (jobHistory.getStatusCode().equals(JobStatusCode.CANCELED)) {
                        scheduleLogEntry = RosettaMsg.JOB_CANCELED_DUE_TO_CONDITION.newLogEntry(stringArray2);
                        break block47;
                    }
                    scheduleLogEntry = RosettaMsg.JOB_FAILED_DUE_TO_CONDITION.newLogEntry(stringArray2);
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                }
            } else {
                scheduleLogEntry = RosettaMsg.JOB_FAILED.newLogEntry(stringArray);
            }
        }
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistory.getId());
        long l = jobHistory.getJobSuiteHistoryID();
        if (l != 0L) {
            scheduleLogEntry.setJobSuiteID(jobHistory.getJobSuiteID());
            scheduleLogEntry.setJobSuiteHistoryID(l);
        }
        if (!bl2 && JobEndedReasonCode.AGENT_INCOMPLETE_PATH_SPECIFIED_FOR_THE_CONDITION != jobHistory.getJobEndedReasonCode()) {
            ScheduleLogger.write(scheduleLogEntry);
        }
        if ((scheduleJobBigProxy2 = scheduleJobBigProxy) == null) {
            scheduleJobBigProxy2 = this.getJobBigProxy(jobHistory.getJobID());
        }
        if (!bl2) {
            try {
                this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy2, scheduleLogEntry.getMessageText(), bl2, bl3);
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error sending notification for job status change for job {0} with run number {1}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getId()}), (Throwable)exception);
            }
            if (jobHistory.getStatusCode().equals(JobStatusCode.FAILED) && !jobHistory.isJobSuiteMember()) {
                this.holdFailedJob(jobHistory, scheduleJobBigProxy2);
            }
        }
        if (scheduleJobBigProxy2.isEmailJobLog()) {
            this.outputDistributionAM.sendJobLog(jobHistory.getId());
        }
    }

    private ScheduleJobBigProxy getJobBigProxy(long l) {
        try {
            return this.scheduleJobDM.getScheduleJobBigProxy(l);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error retrieving job details.", exception);
        }
    }

    private void holdFailedJob(JobHistory jobHistory, ScheduleJobBigProxy scheduleJobBigProxy) {
        if (scheduleJobBigProxy == null) {
            try {
                scheduleJobBigProxy = this.getJobBigProxy(jobHistory.getJobID());
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Job {0} with run number {1} is in a Failed status, but unable to retrieve the Hold-on-failure setting.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getId()}), (Throwable)exception);
                return;
            }
        }
        if (scheduleJobBigProxy.isHoldOnFailure() && !scheduleJobBigProxy.isJobHeld()) {
            try {
                this.scheduleJobDM.hold(jobHistory.getJobID());
                String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName()};
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_HELD_DUE_TO_FAILURE.newLogEntry(stringArray);
                scheduleLogEntry.setAgentID(jobHistory.getAgentID());
                scheduleLogEntry.setJobID(jobHistory.getJobID());
                scheduleLogEntry.setJobHistoryID(jobHistory.getId());
                ScheduleLogger.write(scheduleLogEntry);
                SystemMessage systemMessage = RosettaMsg.JOB_HELD_DUE_TO_FAILURE.newSystemMessage(stringArray);
                SystemMessageQueue.write(systemMessage);
                logger.warn((Object)scheduleLogEntry.getMessageText());
                CrossAppenderLogger.logMessage(Log4jID.SCHEDULER, Level.WARN, scheduleLogEntry.getMessageText());
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error implementing Hold-on-failure for job {0} with run number {1}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getId()}), (Throwable)exception);
            }
        }
    }

    @Override
    public void holdFailedJob(JobHistory jobHistory) {
        this.holdFailedJob(jobHistory, null);
    }

    @Override
    public void markJobManaged(JobHistory jobHistory) {
        jobHistory.setStatusCode(JobStatusCode.MANAGED);
        try {
            this.jobHistoryDM.save(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"Error saving job history info", (Throwable)exception);
        }
        String string = String.valueOf(jobHistory.getId());
        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), string};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_MARKED.newLogEntry(stringArray);
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistory.getId());
        ScheduleLogger.write(scheduleLogEntry);
    }

    @Override
    public List<JobHistory> doJobNow(long l, long l2, ScheduleInfo.TargetType targetType, int n, boolean bl, boolean bl2, String string, String string2, boolean bl3, boolean bl4, int n2, String string3, String string4) {
        ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>();
        if (ScheduleInfo.TargetType.AGENT_GROUP == targetType) {
            AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
            try {
                AgentGroup agentGroup = agentGroupDM.get(l2);
                switch (agentGroup.getAgentGroupType()) {
                    case ALL_AGENTS: {
                        for (AgentGroupAgent agentGroupAgent : agentGroup.getAgents()) {
                            boolean bl5;
                            long l3 = System.currentTimeMillis();
                            boolean bl6 = bl5 = !agentGroupAgent.currentlyIgnored(l3);
                            if (!bl5) continue;
                            JobHistory jobHistory = this.doJobNow(l, agentGroupAgent.getAgentID(), n, bl, bl2, string, string2, bl3, bl4, n2, string3, string4);
                            arrayList.add(jobHistory);
                        }
                        break;
                    }
                    case UTILIZATION_BALANCED: 
                    case PREFERRED_AGENT: {
                        long l4 = 0L;
                        JobHistory jobHistory = this.doJobNow(l, l4, n, bl, bl2, string, string2, bl3, bl4, n2, string3, string4);
                        arrayList.add(jobHistory);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{agentGroup.getAgentGroupType()}));
                    }
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"An error occured when trying to get agents from agent group.", (Throwable)resourceUnavailableException);
            }
            catch (NoDataException noDataException) {
                logger.error((Object)"An error occured when trying to get agent group agent.", (Throwable)noDataException);
            }
            catch (DataException dataException) {
                logger.error((Object)"An error occured when trying to load an agent group.", (Throwable)dataException);
            }
        } else {
            JobHistory jobHistory = this.doJobNow(l, l2, n, bl, bl2, string, string2, bl3, bl4, n2, string3, string4);
            arrayList.add(jobHistory);
        }
        return arrayList;
    }

    @Override
    public String getLoadRunningJobLogResult(String string, String string2, JobHistory jobHistory) {
        Agent agent = null;
        String string3 = "An error occurred.";
        try {
            agent = this.agentDM.get(jobHistory.getAgentID());
        }
        catch (Exception exception) {
            string3 = "Error getting running job log for job history " + jobHistory.getId() + ".  Unable to get agent using ID " + jobHistory.getAgentID();
            logger.error((Object)string3, (Throwable)exception);
            return new RunningJobLogException(string3, RunningJobLogException.Reason.AGENT_UNAVAILABLE, exception).getErrorString();
        }
        if (agent == null) {
            string3 = "Error getting running job log for job history " + jobHistory.getId() + ".  Unable to get agent using ID " + jobHistory.getAgentID();
            logger.error((Object)string3);
            return new RunningJobLogException(string3, RunningJobLogException.Reason.AGENT_UNAVAILABLE).getErrorString();
        }
        if (this.peer == null) {
            string3 = "Error getting running job log for job history " + jobHistory.getId() + ".  peer is null";
            logger.error((Object)string3);
            return new RunningJobLogException(string3, RunningJobLogException.Reason.AGENT_UNAVAILABLE).getErrorString();
        }
        try {
            return this.enterpriseServerAM.loadRunningJobLog(jobHistory, string2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            string3 = "Error getting running job log for job history " + jobHistory.getId() + ".";
            logger.error((Object)string3, (Throwable)resourceUnavailableException);
            return new RunningJobLogException(string3, RunningJobLogException.Reason.AGENT_UNAVAILABLE, resourceUnavailableException).getErrorString();
        }
        catch (RunningJobLogException runningJobLogException) {
            string3 = "Error getting running job log for job history " + jobHistory.getId() + ".";
            logger.error((Object)string3, (Throwable)runningJobLogException);
            if (runningJobLogException.getRootException() != null) {
                logger.error((Object)"Root Exception: ", runningJobLogException.getRootException());
            }
            logger.error((Object)string3, (Throwable)runningJobLogException);
            return runningJobLogException.getErrorString();
        }
    }

    private JobHistory doJobNow(long l, long l2, int n, boolean bl, boolean bl2, String string, String string2, boolean bl3, boolean bl4, int n2, String string3, String string4) {
        String[] stringArray;
        Object object;
        Date date = new Date(System.currentTimeMillis());
        JobHistory jobHistory = new JobHistory();
        jobHistory.setJobID(l);
        jobHistory.setAgentID(l2);
        jobHistory.setServerInitiatedTime(date.getTime());
        jobHistory.setScheduledTime(date.getTime());
        ScheduleJobProxy scheduleJobProxy = null;
        Agent agent = null;
        try {
            scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy(l);
            object = JobHistory.buildOverridenJobName(scheduleJobProxy.getName(), string4);
            jobHistory.setJobName((String)object);
            jobHistory.setJobPriority(n2);
            jobHistory.setJobParameters(string3);
            jobHistory.setJobQueueID(scheduleJobProxy.getJobQueueID());
            jobHistory.setJobQueueName(scheduleJobProxy.getJobQueueName());
        }
        catch (Exception exception) {
            logger.error((Object)"Error retrieving Job Name - defaulting to Job ID Number.", (Throwable)exception);
            jobHistory.setJobName(String.valueOf(jobHistory.getJobID()));
        }
        try {
            if (scheduleJobProxy.getJobType() == JobType.SUITE) {
                jobHistory.setDefaultSuiteParameters(scheduleJobProxy.getJobParameters());
            }
            object = JobParameterUtil.overrideJobParameters(jobHistory.getJobName(), scheduleJobProxy.getJobParameters(), null, string3);
            jobHistory.setJobParameters((String)object);
        }
        catch (Exception exception) {
            logger.error((Object)"Error processing job parameters starting job.", (Throwable)exception);
        }
        if (l2 == 0L) {
            jobHistory.setAgentName(Agent.getTBDAgentName());
        } else {
            try {
                agent = this.agentDM.get(l2);
                object = agent.getName();
                jobHistory.setAgentName((String)object);
            }
            catch (Exception exception) {
                logger.error((Object)"Error retrieving Agent Name - defaulting to Agent ID.", (Throwable)exception);
                jobHistory.setAgentName(String.valueOf(jobHistory.getAgentID()));
            }
        }
        if (scheduleJobProxy != null && scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
            try {
                jobHistory.setAgentGroupID(scheduleJobProxy.getTargetId());
                object = this.agentGroupDM.getProxy(jobHistory.getAgentGroupID());
                jobHistory.setAgentGroupName(object.getName());
                if (l2 == 0L) {
                    jobHistory.setAgentName(Agent.getTBDInGroupAgentName(object.getName()));
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error retrieving Agent Group Name - defaulting to Agent Group ID.", (Throwable)exception);
                jobHistory.setAgentGroupName(String.valueOf(jobHistory.getAgentGroupID()));
            }
        }
        jobHistory.setStartAtCommandSequence(n);
        jobHistory.setInitiationData(string2);
        jobHistory.setInitiationCode(JobInitCode.USER_DO);
        jobHistory.setManuallyStarted(true);
        jobHistory.setClearPrereqStatus(bl2);
        jobHistory.setBypassJobMonitors(bl3);
        jobHistory.setBypassConditions(bl4);
        if (bl) {
            jobHistory.setReactCode(JobReactCode.PERFORM_REACTIVITY);
        } else {
            jobHistory.setReactCode(JobReactCode.SKIP_REACTIVITY);
        }
        try {
            this.jobHistoryDM.setTimezoneValues(jobHistory, l2, l, scheduleJobProxy, agent);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error updating job history time zone values for job: " + l), throwable);
        }
        long l3 = this.forecastAM.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
        jobHistory.setEstimatedRuntime(l3);
        try {
            jobHistory = this.jobHistoryDM.save(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"Error starting job...unable to save new job history info", (Throwable)exception);
            return null;
        }
        if (bl2) {
            try {
                stringArray = (String[])ManagerRegistry.getManager((String)"ENTERPRISE.PrereqDM");
                stringArray.resetPrereqStatus(jobHistory.getAgentID(), jobHistory.getJobID(), PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS, jobHistory.getId());
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Error resetting prereq status.", (Throwable)resourceUnavailableException);
            }
        }
        this.submitJob(jobHistory, false);
        stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getJobQueueName(), ScheduleLogger.formatTimeStamp(date), string2, Long.toString(jobHistory.getId())};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_SUBMITTED_BY_USER.newLogEntry(stringArray);
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistory.getId());
        ScheduleLogger.write(scheduleLogEntry);
        return jobHistory;
    }

    @Override
    public void doManagedJobNow(long l, long l2, int n, boolean bl, String string, String string2, boolean bl2, boolean bl3, int n2, String string3) throws DataException, ActionFailedException {
        JobHistory jobHistory = null;
        try {
            jobHistory = this.jobHistoryDM.get(l);
        }
        catch (Exception exception) {
            String string4 = "Cannot Start managed Job.  Job History could not be found.";
            logger.debug((Object)string4, (Throwable)exception);
            throw new ActionFailedException(string4, (Throwable)exception);
        }
        if (!jobHistory.getStatusCode().equals(JobStatusCode.MANAGED)) {
            String string5 = "Cannot Start managed Job.  Job is no longer managed.";
            logger.debug((Object)string5);
            throw new ActionFailedException(string5);
        }
        if (n2 != 0) {
            jobHistory.setJobPriority(n2);
        }
        jobHistory.setStartAtCommandSequence(n);
        jobHistory.setInitiationData(string2);
        jobHistory.setManuallyStarted(true);
        jobHistory.setStatusCode(JobStatusCode.INITIATED);
        jobHistory.setBypassJobMonitors(bl2);
        jobHistory.setBypassConditions(bl3);
        if (bl) {
            jobHistory.setReactCode(JobReactCode.PERFORM_REACTIVITY);
        } else {
            jobHistory.setReactCode(JobReactCode.SKIP_REACTIVITY);
        }
        try {
            String string6 = JobParameterUtil.overrideJobParameters(jobHistory.getJobName(), jobHistory.getJobParameters(), null, string3);
            jobHistory.setJobParameters(string6);
        }
        catch (Exception exception) {
            String string7 = "Error processing job parameters starting managed job.";
            logger.error((Object)string7, (Throwable)exception);
            throw new ActionFailedException(string7, (Throwable)exception);
        }
        long l3 = this.forecastAM.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
        jobHistory.setEstimatedRuntime(l3);
        try {
            jobHistory = this.jobHistoryDM.saveManaged(jobHistory, false);
        }
        catch (Exception exception) {
            String string8 = "Error starting job...unable to save new job history info";
            logger.error((Object)string8, (Throwable)exception);
            throw new ActionFailedException(string8, (Throwable)exception);
        }
        this.submitJob(jobHistory);
        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getJobQueueName(), ScheduleLogger.formatTimeStamp(new Date(System.currentTimeMillis())), string2, Long.toString(jobHistory.getId())};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.MANAGED_JOB_SUBMITTED_BY_USER.newLogEntry(stringArray);
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistory.getId());
        ScheduleLogger.write(scheduleLogEntry);
    }

    @Override
    public void doSkippedJobNow(long l, long l2, int n, boolean bl, String string, String string2, boolean bl2, boolean bl3, int n2) throws DataException, ActionFailedException {
        JobHistory jobHistory = null;
        try {
            jobHistory = this.jobHistoryDM.get(l);
        }
        catch (Exception exception) {
            String string3 = "Cannot Start Skipped Job.  Job History could not be found.";
            logger.debug((Object)string3, (Throwable)exception);
            throw new ActionFailedException(string3, (Throwable)exception);
        }
        if (!jobHistory.getStatusCode().equals(JobStatusCode.SKIPPED)) {
            String string4 = "Cannot Start managed Job.  Job is no longer skipped.";
            logger.debug((Object)string4);
            throw new ActionFailedException(string4);
        }
        if (jobHistory.getAgentID() == 0L && jobHistory.getAgentGroupID() != 0L && l2 != 0L) {
            try {
                AgentGroupAgentWithName agentGroupAgentWithName = this.retrieveAgentGroupAgent(jobHistory.getAgentGroupID(), l2);
                jobHistory.setAgentID(l2);
                jobHistory.setAgentName(agentGroupAgentWithName.getAgentName());
            }
            catch (NoDataException noDataException) {
                logger.info((Object)MessageUtil.formatMsg((String)"Unable to honor the request to start skipped job entry {0} on the agent with ID {1} because that agent is not a member of the agent group with ID {2}. The agent id will be left as zero (TBD) and submitted.", (Object[])new Object[]{jobHistory.getId(), l2, jobHistory.getAgentGroupID()}));
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new ActionFailedException("Cannot start skipped job.", (Throwable)resourceUnavailableException);
            }
        }
        if (n2 != 0) {
            jobHistory.setJobPriority(n2);
        }
        jobHistory.setStartAtCommandSequence(n);
        jobHistory.setInitiationData(string2);
        jobHistory.setManuallyStarted(true);
        jobHistory.setStatusCode(JobStatusCode.INITIATED);
        jobHistory.setJobEndedReasonCode(null);
        jobHistory.setMissedCode(JobMissedCode.NOT_MISSED);
        jobHistory.setBypassJobMonitors(bl2);
        jobHistory.setBypassConditions(bl3);
        if (bl) {
            jobHistory.setReactCode(JobReactCode.PERFORM_REACTIVITY);
        } else {
            jobHistory.setReactCode(JobReactCode.SKIP_REACTIVITY);
        }
        long l3 = this.forecastAM.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
        jobHistory.setEstimatedRuntime(l3);
        try {
            jobHistory = this.jobHistoryDM.saveSkipped(jobHistory, false);
        }
        catch (Exception exception) {
            String string5 = "Error starting job...unable to save new job history info";
            logger.error((Object)string5, (Throwable)exception);
            throw new ActionFailedException(string5, (Throwable)exception);
        }
        this.submitJob(jobHistory);
        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getJobQueueName(), ScheduleLogger.formatTimeStamp(new Date(System.currentTimeMillis())), string2, Long.toString(jobHistory.getId())};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.SKIPPED_JOB_SUBMITTED_BY_USER.newLogEntry(stringArray);
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistory.getId());
        ScheduleLogger.write(scheduleLogEntry);
    }

    @Override
    public void moveJobToQueue(String string, String string2, long l, long l2, long l3) throws DataException, ActionFailedException, NotOnQueueException {
        Object object;
        JobHistory jobHistory = this.getJobHistory(l);
        long l4 = jobHistory.getAgentID();
        long l5 = jobHistory.getJobQueueID();
        String string3 = jobHistory.getJobQueueName();
        if (jobHistory.getAgentGroupID() != 0L) {
            try {
                object = this.agentGroupDM.getProxy(jobHistory.getAgentGroupID());
                if (!object.getAgentGroupType().isLoadBalanced()) {
                    throw new ActionFailedException("Unable to move job history ID " + l + " to another queue.  It is assigned to the" + " All Agents Group " + object.getName() + ".");
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new ActionFailedException("Error moving job history ID " + l + " to another queue.", (Throwable)resourceUnavailableException);
            }
        }
        logger.debug((Object)("Received request from " + string2 + " to move job history ID " + l + " from Agent ID " + l4 + " and Job Queue ID " + l5 + " to Agent ID " + l2 + " and Job Queue ID " + l3 + "."));
        object = jobHistory.getAgentName();
        String string4 = jobHistory.getJobQueueName();
        Agent agent = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            agent = this.agentDM.get(l2);
            this.enterpriseServerAM.dequeueJob(jobHistory);
            bl = true;
            jobHistory.setAgentID(l2);
            jobHistory.setAgentName(agent.getName());
            jobHistory.setJobQueueID(l3);
            String string5 = this.getJobQueuesDM().getJobQueueName(l3);
            jobHistory.setJobQueueName(string5);
            this.getJobHistoryDM().save(jobHistory);
            bl2 = true;
            this.enterpriseServerAM.enqueueJob(jobHistory);
            String[] stringArray = new String[]{jobHistory.getJobName(), String.valueOf(l), object, string4, agent.getName(), string5, string2};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_MOVED_TO_QUEUE.newLogEntry(stringArray);
            scheduleLogEntry.setJobID(jobHistory.getJobID());
            scheduleLogEntry.setJobHistoryID(l);
            ScheduleLogger.write(scheduleLogEntry);
        }
        catch (Exception exception) {
            logger.error((Object)("Error moving Job History ID " + l + " to Agent " + agent.getName() + "(" + l2 + ") and Job Queue ID " + l3 + "."), (Throwable)exception);
            logger.info((Object)("Attempting to place Job History ID " + l + " back on the queue for Agent " + (String)object + "(" + l4 + ") and Job Queue " + string3 + "(" + l5 + ")."));
            try {
                if (bl2) {
                    jobHistory.setAgentID(l4);
                    jobHistory.setAgentName((String)object);
                    this.getJobHistoryDM().save(jobHistory);
                }
                if (bl) {
                    this.enterpriseServerAM.enqueueJob(jobHistory);
                }
            }
            catch (Exception exception2) {
                logger.error((Object)("Error moving Job History ID " + l + " back to Agent " + (String)object + "(" + l4 + ") and Job Queue " + string3 + "(" + l5 + ")."), (Throwable)exception2);
            }
            throw new ActionFailedException("Error moving job history ID " + l, (Throwable)exception);
        }
    }

    private JobQueuesDM getJobQueuesDM() {
        if (this.jobQueuesDM == null) {
            this.jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
        }
        return this.jobQueuesDM;
    }

    @Override
    public void terminateJob(long l, String string, String string2, JobStatusCode jobStatusCode) throws ActionFailedException, DataException, EndJobException {
        try {
            this.terminateJob(l, string, string2, jobStatusCode, true, false, false);
        }
        catch (NotOnQueueException notOnQueueException) {
            // empty catch block
        }
    }

    @Override
    public void terminateManagedJob(long l, String string, String string2, JobStatusCode jobStatusCode) throws ActionFailedException, DataException, EndJobException {
        try {
            this.terminateJob(l, string, string2, jobStatusCode, true, false, true);
        }
        catch (NotOnQueueException notOnQueueException) {
            // empty catch block
        }
    }

    @Override
    public void terminateJobViaJobMonitor(long l, JobStatusCode jobStatusCode, String string) throws ActionFailedException, DataException, EndJobException {
        try {
            this.terminateJob(l, null, string, jobStatusCode, true, true, false);
        }
        catch (NotOnQueueException notOnQueueException) {
            logger.error((Object)"An unexpected Exception occurred. ", (Throwable)notOnQueueException);
        }
    }

    @Override
    public int terminateMember(long l, JobStatusCode jobStatusCode, String string) throws NoDataException, ActionFailedException, ResourceUnavailableException {
        JobHistory jobHistory;
        try {
            jobHistory = this.getJobHistoryForMember(l);
        }
        catch (NoDataException noDataException) {
            throw new NoDataException(MessageUtil.formatMsg((String)"A request was made to terminate the suite member with run number {0}, but that run number does not exist.", (Object[])new Object[]{l}));
        }
        JobStatusCode jobStatusCode2 = jobHistory.getStatusCode();
        if (jobStatusCode2.isTerminalState()) {
            this.markMemberAsEnded(jobHistory, jobStatusCode);
            RosettaMsg rosettaMsg = RosettaMsg.SUITE_MEMBER_ENDED;
            String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), Long.toString(jobHistory.getId()), jobStatusCode.toString()};
            ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId(), jobHistory.getJobSuiteID(), jobHistory.getJobSuiteHistoryID());
            ScheduleLogger.write(scheduleLogEntry);
            return 2;
        }
        long l2 = System.currentTimeMillis();
        jobHistory.setStatusCode(jobStatusCode);
        jobHistory.setServerEndedTime(l2);
        jobHistory.setJobEndedReasonCode(JobEndedReasonCode.PARENT_SUITE_ENDED);
        try {
            this.jobHistoryDM.save(jobHistory, true);
        }
        catch (DataException dataException) {
            throw new RuntimeException("Unable to save the job history.", dataException);
        }
        try {
            this.jobStartEndRollupDM.saveEndCount(l2);
        }
        catch (Exception exception) {
            logger.error((Object)"Error saving jobStartEndRollup for member termination.", (Throwable)exception);
        }
        long l3 = 0L;
        if (jobHistory.getServerEndedTime() != 0L && jobHistory.getQueueEndedTime() != 0L) {
            l3 = jobHistory.getServerEndedTime() - jobHistory.getQueueEndedTime();
        }
        try {
            this.jobStatusCountRollupDM.saveStatusCount(jobHistory.getStatusCode(), jobHistory.getServerEndedTime(), jobHistory.getAgentID(), l3);
        }
        catch (Exception exception) {
            logger.error((Object)"Error saving job_status_count_rollups for member termination.", (Throwable)exception);
        }
        if (jobHistory.getServerRunningTime() > 0L) {
            this.jobMonitorManagerAM.jobHasCompleted(jobHistory, true);
        } else {
            this.deleteAllJobMonitors(l);
        }
        boolean bl = false;
        if (jobStatusCode2 == JobStatusCode.SUBMITTED || jobStatusCode2 == JobStatusCode.INITIATED) {
            try {
                this.enterpriseServerAM.dequeueJob(jobHistory);
                bl = true;
            }
            catch (NotOnQueueException notOnQueueException) {
            }
            catch (ActionFailedException actionFailedException) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to remove the member job with run number {0} from the agent queue.", (Object[])new Object[]{l}), (Throwable)actionFailedException);
            }
        }
        if (!bl) {
            try {
                this.enterpriseServerAM.terminateRunningMemberJob(jobHistory, string);
            }
            catch (NoDataException noDataException) {
                throw new NoDataException(MessageUtil.formatMsg((String)"A request was made to terminate the suite member with run number {0}, but that run number was neither found on the agent queue or running on the agent.", (Object[])new Object[]{l}));
            }
            catch (ActionFailedException actionFailedException) {
                RosettaMsg rosettaMsg = RosettaMsg.SUITE_MEMBER_NOT_ENDED;
                long l4 = jobHistory.getJobSuiteHistoryID();
                String[] stringArray = new String[]{jobHistory.getJobName(), Long.toString(l4)};
                this.writeToScheduleLog(rosettaMsg, stringArray, jobHistory);
                throw actionFailedException;
            }
        }
        RosettaMsg rosettaMsg = RosettaMsg.SUITE_MEMBER_ENDED;
        if (bl) {
            rosettaMsg = RosettaMsg.SUITE_MEMBER_ENDED_VIA_REMOVAL_FROM_QUEUE;
        }
        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), Long.toString(jobHistory.getId()), jobStatusCode.toString()};
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId(), jobHistory.getJobSuiteID(), jobHistory.getJobSuiteHistoryID());
        ScheduleLogger.write(scheduleLogEntry);
        try {
            ScheduleJobBigProxy scheduleJobBigProxy = this.scheduleJobDM.getScheduleJobBigProxy(jobHistory.getJobID());
            this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy, scheduleLogEntry.getMessageText());
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error requesting status notification for the terminating suite member with run number {0}.", (Object[])new Object[]{l}), (Throwable)exception);
        }
        this.enterpriseServerAM.jobCompleted(jobHistory);
        if (bl) {
            return 0;
        }
        return 1;
    }

    @Override
    public void dequeueJob(long l, String string, String string2, JobStatusCode jobStatusCode) throws ActionFailedException, NotOnQueueException, DataException, EndJobException {
        this.terminateJob(l, string, string2, jobStatusCode, false, false, false);
    }

    @Override
    public void jobRequeuedForRetry(JobHistory jobHistory) {
        Object object;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing jobRequeuedForRetry for job " + jobHistory.getJobName() + " (" + jobHistory.getJobID() + ")."));
        }
        boolean bl = false;
        if (jobHistory.getRetryNumber() == 1) {
            bl = true;
        }
        try {
            object = jobHistory;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(jobHistory.getRetryNextTime());
            TimeZone timeZone = calendar.getTimeZone();
            calendar.setTimeZone(timeZone);
            object.setRetryNextTime(calendar.getTimeInMillis());
            this.jobHistoryDM.updateJobHistoryForConditionRetry((JobHistory)((Object)object), bl);
        }
        catch (Exception exception) {
            logger.error((Object)"Error saving job history.", (Throwable)exception);
            return;
        }
        if (bl) {
            try {
                object = MessageUtil.formatMsg((String)"Conditional Job {0} on Agent {1} with run number {2} has entered Retry Wait status.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getId()});
                this.notifyOfJobStatus(jobHistory, null, (String)object);
            }
            catch (Exception exception) {
                logger.error((Object)"Error sending notification for job status change.", (Throwable)exception);
            }
        }
    }

    @Override
    public void saveJobHistory(JobHistory jobHistory) {
        try {
            this.jobHistoryDM.save(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"Error saving job history info", (Throwable)exception);
            return;
        }
    }

    private JobHistory getJobHistory(long l) throws DataException {
        JobHistory jobHistory = null;
        ResourceUnavailableException resourceUnavailableException = null;
        try {
            jobHistory = this.jobHistoryDM.getWithAgentEnvironment(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException2) {
            jobHistory = null;
            resourceUnavailableException = resourceUnavailableException2;
        }
        if (jobHistory == null) {
            throw new NoDataException("History record was not found: " + l, (Throwable)resourceUnavailableException);
        }
        return jobHistory;
    }

    private JobHistory getJobHistoryForMember(long l) throws NoDataException, ResourceUnavailableException {
        try {
            return this.jobHistoryDM.get(l);
        }
        catch (NoDataException noDataException) {
            throw new NoDataException(MessageUtil.formatMsg((String)"The job history for the suite member with run number {0} was not found.", (Object[])new Object[]{l}));
        }
        catch (DataException dataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Error while retrieving the job history for the suite member with run number {0}.", (Object[])new Object[]{l}), dataException);
        }
    }

    private ScheduleJobBigProxy getScheduleJobBigProxy(long l) throws DataException {
        ScheduleJobBigProxy scheduleJobBigProxy = null;
        ResourceUnavailableException resourceUnavailableException = null;
        try {
            scheduleJobBigProxy = this.scheduleJobDM.getScheduleJobBigProxy(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException2) {
            scheduleJobBigProxy = null;
            resourceUnavailableException = resourceUnavailableException2;
        }
        if (scheduleJobBigProxy == null) {
            throw new NoDataException("Schedule Job record was not found: " + l, (Throwable)resourceUnavailableException);
        }
        return scheduleJobBigProxy;
    }

    private void validateJobState(JobHistory jobHistory, boolean bl, String string, List<JobStatusCode> list) throws InvalidStateException {
        if (list.contains(jobHistory.getStatusCode())) {
            return;
        }
        throw new InvalidStateException(string + " jobs with a status of '" + jobHistory.getStatusCode_asText() + "' is not allowed.");
    }

    private void validateMemberJobState(JobHistory jobHistory, boolean bl, String string, List<JobStatusCode> list, JobStatusCode jobStatusCode) throws InvalidStateException {
        JobStatusCode jobStatusCode2 = jobHistory.getStatusCode();
        String string2 = jobHistory.getStatusCode_asText();
        StringBuilder stringBuilder = new StringBuilder();
        if (jobStatusCode2 == JobStatusCode.FAILED) {
            if (jobStatusCode != JobStatusCode.COMPLETED) {
                stringBuilder.append("Member jobs with '");
                stringBuilder.append(string2);
                stringBuilder.append("' status are only allowed to be changed to '");
                stringBuilder.append(JobStatusCode.COMPLETED);
                stringBuilder.append("'.");
                throw new InvalidStateException(stringBuilder.toString());
            }
            return;
        }
        this.validateJobState(jobHistory, bl, string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void terminateJob(long l, String string, String string2, JobStatusCode jobStatusCode, boolean bl, boolean bl2, boolean bl3) throws ActionFailedException, NotOnQueueException, DataException, EndJobException {
        ScheduleLogEntry scheduleLogEntry;
        JobHistory jobHistory;
        block54: {
            long l2;
            boolean bl4;
            block53: {
                block50: {
                    logger.debug((Object)MessageUtil.formatMsg((String)"Processing terminateJob request for Job History ID {0}. Status to use:{1} Terminate running job:{2} Via Job Monitor:{3} Is Managed:{4}.", (Object[])new Object[]{l, jobStatusCode, bl, bl2, bl3}));
                    bl4 = bl;
                    jobHistory = this.getJobHistory(l);
                    if (bl3) {
                        if (!jobHistory.getStatusCode().equals(JobStatusCode.MANAGED)) {
                            throw new ActionFailedException(MessageUtil.formatMsg((String)"The termination of managed job {0} with run number {1} failed. The current status is {2}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getId(), jobHistory.getStatusCode()}));
                        }
                    } else {
                        if (bl4) {
                            try {
                                if (!jobHistory.isJobSuiteMember()) {
                                    this.validateJobState(jobHistory, bl4, "Terminating", JobStatusCode.TERMINATABLE_STATES);
                                    break block50;
                                } else {
                                    this.validateMemberJobState(jobHistory, bl4, "Terminating", JobStatusCode.MEMBER_TERMINATABLE_STATES, jobStatusCode);
                                    if (jobHistory.getRestartChildHistoryID() > 0L) {
                                        throw new InvalidStateException("It is invalid to end a member that has been restarted.");
                                    }
                                }
                                break block50;
                            }
                            catch (InvalidStateException invalidStateException) {
                                if (jobHistory.getJobEndedReasonCode() != null && jobHistory.getJobEndedReasonCode().equals(JobEndedReasonCode.MISSED_JOB_ACTION)) {
                                    throw new EndJobException(invalidStateException.getMessage(), EndJobException.Reason.MISSED_PROCESS_HISTORY);
                                }
                                if (!jobHistory.getStatusCode().equals(JobStatusCode.MANAGED)) throw new EndJobException(invalidStateException.getMessage(), invalidStateException, EndJobException.Reason.JOB_NOT_ACTIVE);
                                throw new EndJobException(invalidStateException.getMessage(), EndJobException.Reason.MANAGED_STATUS);
                            }
                        }
                        try {
                            this.validateJobState(jobHistory, bl4, "De-queueing", JobStatusCode.DEQUEUEABLE_STATES);
                        }
                        catch (InvalidStateException invalidStateException) {
                            throw new ActionFailedException(invalidStateException.getMessage(), (Throwable)invalidStateException);
                        }
                    }
                }
                boolean bl5 = JobStatusCode.RUNNING_STATES.contains(jobHistory.getStatusCode());
                if (jobHistory.isIBMiJobSubmitted()) {
                    bl5 = true;
                }
                l2 = System.currentTimeMillis();
                if (jobHistory.getQueueEndedTime() == 0L) {
                    jobHistory.setQueueEndedTime(l2);
                }
                jobHistory.setStatusCode(jobStatusCode);
                jobHistory.setServerEndedTime(l2);
                JobEndedReasonCode jobEndedReasonCode = bl2 ? JobEndedReasonCode.JOB_MONITOR_ACTION : (bl3 ? JobEndedReasonCode.MANAGED_JOB_ACTION : (bl4 ? JobEndedReasonCode.ENDED_MANUALLY : JobEndedReasonCode.REMOVED_MANUALLY));
                jobHistory.setJobEndedReasonCode(jobEndedReasonCode);
                try {
                    if (bl3) {
                        this.jobHistoryDM.saveManaged(jobHistory, true);
                    } else {
                        this.jobHistoryDM.save(jobHistory, true);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to save the job history.", exception);
                }
                try {
                    this.jobStartEndRollupDM.saveEndCount(l2);
                    if (bl3) {
                        this.jobStartEndRollupDM.saveSubmitCount(l2);
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)"Error saving jobStartEndRollup for job termination.", (Throwable)exception);
                }
                long l3 = 0L;
                if (jobHistory.getServerEndedTime() != 0L && jobHistory.getQueueEndedTime() != 0L) {
                    l3 = jobHistory.getServerEndedTime() - jobHistory.getQueueEndedTime();
                }
                try {
                    this.jobStatusCountRollupDM.saveStatusCount(jobHistory.getStatusCode(), jobHistory.getServerEndedTime(), jobHistory.getAgentID(), l3);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error saving job_status_count_rollups for job termination.", (Throwable)exception);
                }
                if (jobHistory.getServerRunningTime() > 0L) {
                    this.jobMonitorManagerAM.jobHasCompleted(jobHistory, true);
                } else {
                    this.deleteAllJobMonitors(jobHistory.getId());
                }
                if (jobHistory.getStatusCode().equals(JobStatusCode.FAILED) && !jobHistory.isJobSuiteMember()) {
                    this.holdFailedJob(jobHistory, null);
                }
                if (jobHistory.isIBMiJobSubmitted()) {
                    bl4 = true;
                }
                try {
                    block52: {
                        if (!bl3) {
                            if (bl4) {
                                if (!jobHistory.getMissedCode().equals(JobMissedCode.MISSED_END)) {
                                    try {
                                        this.enterpriseServerAM.terminateJob(jobHistory, string2, bl5);
                                    }
                                    catch (NoDataException noDataException) {
                                        if (bl2) {
                                            throw new EndJobException("The Job was not actually ended.", (Exception)((Object)noDataException));
                                        }
                                        throw new ActionFailedException(MessageUtil.formatMsg((String)"A request was made to terminate job {0} with run number {1}, but that run number was neither found on the agent queue or running on the agent. Job History was updated, but the job was not actually ended.", (Object[])new Object[]{jobHistory.getJobName(), l}), (Throwable)noDataException);
                                    }
                                    catch (RemoteManagerNotFoundException remoteManagerNotFoundException) {
                                        if (bl2) {
                                            throw new EndJobException("The Job was not actually ended.", (Exception)((Object)remoteManagerNotFoundException));
                                        }
                                        throw new ActionFailedException(MessageUtil.formatMsg((String)"A request was made to terminate job {0} with run number {1}, but an error occurred while requesting that the agent terminate it. Job History was updated, but the job may not have been actually ended.", (Object[])new Object[]{jobHistory.getJobName(), l}), (Throwable)remoteManagerNotFoundException);
                                    }
                                    catch (Exception exception) {
                                        throw new ActionFailedException(MessageUtil.formatMsg((String)"A request was made to terminate job {0} with run number {1}, but an error occurred while requesting that the agent terminate it. Job History was updated, but the job may not have been actually ended.", (Object[])new Object[]{jobHistory.getJobName(), l}), (Throwable)exception);
                                    }
                                }
                            } else {
                                try {
                                    this.enterpriseServerAM.dequeueJob(jobHistory);
                                }
                                catch (ResourceUnavailableException resourceUnavailableException) {
                                    if (bl2) break block52;
                                    throw new ActionFailedException("The dequeue of job " + jobHistory.getJobName() + " failed.", (Throwable)resourceUnavailableException);
                                }
                            }
                        }
                    }
                    if (!bl2) break block53;
                }
                catch (Throwable throwable) {
                    ScheduleLogEntry scheduleLogEntry2;
                    if (bl2) {
                        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), Long.toString(jobHistory.getId()), ScheduleLogger.formatTimeStamp(l2)};
                        scheduleLogEntry2 = RosettaMsg.JOB_CANCELED_BY_JOB_MONITOR.newLogEntry(stringArray);
                    } else {
                        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), Long.toString(jobHistory.getId()), ScheduleLogger.formatTimeStamp(l2), string2, jobStatusCode.toString()};
                        scheduleLogEntry2 = bl3 ? RosettaMsg.MANAGED_JOB_ENDED_BY_USER.newLogEntry(stringArray) : (bl4 ? RosettaMsg.JOB_ENDED_BY_USER.newLogEntry(stringArray) : RosettaMsg.JOB_REMOVED_FROM_QUEUE_BY_USER.newLogEntry(stringArray));
                    }
                    scheduleLogEntry2.setAgentID(jobHistory.getAgentID());
                    scheduleLogEntry2.setJobID(jobHistory.getJobID());
                    scheduleLogEntry2.setJobHistoryID(jobHistory.getId());
                    if (jobHistory.isJobSuiteMember()) {
                        scheduleLogEntry2.setJobSuiteID(jobHistory.getJobSuiteID());
                        scheduleLogEntry2.setJobSuiteHistoryID(jobHistory.getJobSuiteHistoryID());
                    }
                    ScheduleLogger.write(scheduleLogEntry2);
                    try {
                        ScheduleJobBigProxy scheduleJobBigProxy = this.scheduleJobDM.getScheduleJobBigProxy(jobHistory.getJobID());
                        this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy, scheduleLogEntry2.getMessageText());
                    }
                    catch (Exception exception) {
                        logger.error((Object)MessageUtil.formatMsg((String)"Error requesting status notification for the terminating job with run number {0}.", (Object[])new Object[]{l}), (Throwable)exception);
                    }
                    this.enterpriseServerAM.jobCompleted(jobHistory);
                    throw throwable;
                }
                String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), Long.toString(jobHistory.getId()), ScheduleLogger.formatTimeStamp(l2)};
                scheduleLogEntry = RosettaMsg.JOB_CANCELED_BY_JOB_MONITOR.newLogEntry(stringArray);
                break block54;
            }
            String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), Long.toString(jobHistory.getId()), ScheduleLogger.formatTimeStamp(l2), string2, jobStatusCode.toString()};
            scheduleLogEntry = bl3 ? RosettaMsg.MANAGED_JOB_ENDED_BY_USER.newLogEntry(stringArray) : (bl4 ? RosettaMsg.JOB_ENDED_BY_USER.newLogEntry(stringArray) : RosettaMsg.JOB_REMOVED_FROM_QUEUE_BY_USER.newLogEntry(stringArray));
        }
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setJobHistoryID(jobHistory.getId());
        if (jobHistory.isJobSuiteMember()) {
            scheduleLogEntry.setJobSuiteID(jobHistory.getJobSuiteID());
            scheduleLogEntry.setJobSuiteHistoryID(jobHistory.getJobSuiteHistoryID());
        }
        ScheduleLogger.write(scheduleLogEntry);
        try {
            ScheduleJobBigProxy scheduleJobBigProxy = this.scheduleJobDM.getScheduleJobBigProxy(jobHistory.getJobID());
            this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy, scheduleLogEntry.getMessageText());
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error requesting status notification for the terminating job with run number {0}.", (Object[])new Object[]{l}), (Throwable)exception);
        }
        this.enterpriseServerAM.jobCompleted(jobHistory);
    }

    @Override
    public void deleteAllJobMonitors(long l) {
        this.jobMonitorManagerAM.jobWasTerminated(l);
    }

    @Override
    public void notifyOfJobStatus(JobHistory jobHistory, ScheduleJobBigProxy scheduleJobBigProxy, String string) throws ResourceUnavailableException, ActionFailedException, DataException {
        this.notifyOfJobStatus(jobHistory, scheduleJobBigProxy, string, false, false);
    }

    private void notifyOfJobStatus(JobHistory jobHistory, ScheduleJobBigProxy scheduleJobBigProxy, String string, boolean bl, boolean bl2) throws ResourceUnavailableException, ActionFailedException, DataException {
        String string2 = jobHistory.isJobSuiteMember() ? RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_MEMBER_JOB_STATUS_NOTICE, new String[]{jobHistory.getJobName(), String.valueOf(jobHistory.getId()), jobHistory.getAgentName(), jobHistory.getStatusCode().name(), jobHistory.getJobSuiteName(), String.valueOf(jobHistory.getJobSuiteHistoryID())}) : (jobHistory.isJobSuite() ? RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_JOB_SUITE_STATUS_NOTICE, new String[]{jobHistory.getJobName(), String.valueOf(jobHistory.getId()), jobHistory.getStatusCode().name()}) : RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_JOB_STATUS_NOTICE, new String[]{jobHistory.getJobName(), String.valueOf(jobHistory.getId()), jobHistory.getAgentName(), jobHistory.getStatusCode().name()}));
        this.processNotifications(jobHistory, scheduleJobBigProxy, string2, string, bl, bl2);
    }

    private void notifyOfJobStatus(JobHistory jobHistory, ScheduleJobBigProxy scheduleJobBigProxy, String string, String string2) throws ResourceUnavailableException, ActionFailedException, DataException {
        this.processNotifications(jobHistory, scheduleJobBigProxy, string, string2, false, false);
    }

    private void processNotifications(JobHistory jobHistory, ScheduleJobBigProxy scheduleJobBigProxy, String string, String string2, boolean bl, boolean bl2) throws ResourceUnavailableException, ActionFailedException, DataException {
        boolean bl3;
        Object object;
        ScheduleJobBigProxy scheduleJobBigProxy2 = scheduleJobBigProxy != null ? scheduleJobBigProxy : this.getScheduleJobBigProxy(jobHistory.getJobID());
        boolean bl4 = false;
        boolean bl5 = false;
        long l = 0L;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        long l2 = 0L;
        boolean bl9 = false;
        String string3 = jobHistory.getJobName();
        long l3 = jobHistory.getJobID();
        long l4 = jobHistory.getAgentID();
        String string4 = jobHistory.getAgentName();
        EnterpriseSNMPTrap enterpriseSNMPTrap = null;
        EnterpriseSNMPTrap enterpriseSNMPTrap2 = null;
        EmailInformation emailInformation = new EmailInformation(string, string2);
        EmailInformation emailInformation2 = new EmailInformation(string, string2);
        if (scheduleJobBigProxy2 != null) {
            switch (jobHistory.getStatusCode()) {
                case SUBMITTED: {
                    bl4 = scheduleJobBigProxy2.isSendSubmitSNMPTrap();
                    bl5 = scheduleJobBigProxy2.isSendSubmitEmail();
                    l = scheduleJobBigProxy2.getSubmitNotificationListID();
                    emailInformation.setOverrideSubject(scheduleJobBigProxy2.getEmailSubjectSubmitted());
                    emailInformation.setOverrideBody(scheduleJobBigProxy2.getEmailBodySubmitted());
                    break;
                }
                case RUNNING: {
                    bl4 = scheduleJobBigProxy2.isSendRunSNMPTrap();
                    bl5 = scheduleJobBigProxy2.isSendRunEmail();
                    l = scheduleJobBigProxy2.getRunNotificationListID();
                    emailInformation.setOverrideSubject(scheduleJobBigProxy2.getEmailSubjectRunning());
                    emailInformation.setOverrideBody(scheduleJobBigProxy2.getEmailBodyRunning());
                    break;
                }
                case COMPLETED: {
                    bl4 = scheduleJobBigProxy2.isSendCompleteSNMPTrap();
                    bl5 = scheduleJobBigProxy2.isSendCompleteEmail();
                    l = scheduleJobBigProxy2.getCompleteNotificationListID();
                    bl6 = scheduleJobBigProxy2.isSendCompleteJobLog();
                    emailInformation.setOverrideSubject(scheduleJobBigProxy2.getEmailSubjectCompleted());
                    emailInformation.setOverrideBody(scheduleJobBigProxy2.getEmailBodyCompleted());
                    break;
                }
                case FAILED: {
                    ScheduleJobBigProxy scheduleJobBigProxy3;
                    bl4 = scheduleJobBigProxy2.isSendFailSNMPTrap();
                    bl5 = scheduleJobBigProxy2.isSendFailEmail();
                    l = scheduleJobBigProxy2.getFailNotificationListID();
                    bl6 = scheduleJobBigProxy2.isSendFailJobLog();
                    if (bl5) {
                        emailInformation.setOverrideSubject(scheduleJobBigProxy2.getEmailSubjectFailed());
                        emailInformation.setOverrideBody(scheduleJobBigProxy2.getEmailBodyFailed());
                    }
                    if (!scheduleJobBigProxy2.isSuiteMember() || (scheduleJobBigProxy3 = this.getScheduleJobBigProxy(jobHistory.getJobSuiteID())) == null) break;
                    JobHistory jobHistory2 = this.jobSuiteDM.getSuiteHistory(jobHistory.getJobSuiteHistoryID());
                    object = JobSuiteStatus.MEMBER_FAILED;
                    bl7 = scheduleJobBigProxy3.isSendMemberFailSNMPTrap();
                    bl8 = scheduleJobBigProxy3.isSendMemberFailEmail();
                    if (bl8) {
                        emailInformation2.setOverrideSubject(scheduleJobBigProxy3.getEmailSubjectMemberFailed());
                        emailInformation2.setOverrideBody(scheduleJobBigProxy3.getEmailBodyMemberFailed());
                    }
                    l2 = scheduleJobBigProxy3.getMemberFailNotificationListID();
                    bl9 = scheduleJobBigProxy3.isSendMemberFailedEmailLog();
                    if (!bl7) break;
                    enterpriseSNMPTrap2 = this.getSuiteMemberSNMPTrap(jobHistory2, string2, l2, l4, string4, (JobSuiteStatus)object, string3, l3);
                    break;
                }
                case CANCELED: {
                    ScheduleJobBigProxy scheduleJobBigProxy3;
                    bl4 = scheduleJobBigProxy2.isSendCancelSNMPTrap();
                    bl5 = scheduleJobBigProxy2.isSendCancelEmail();
                    l = scheduleJobBigProxy2.getCancelNotificationListID();
                    bl6 = scheduleJobBigProxy2.isSendCancelJobLog();
                    if (bl5) {
                        emailInformation.setOverrideSubject(scheduleJobBigProxy2.getEmailSubjectCanceled());
                        emailInformation.setOverrideBody(scheduleJobBigProxy2.getEmailBodyCanceled());
                    }
                    if (!scheduleJobBigProxy2.isSuiteMember() || (scheduleJobBigProxy3 = this.getScheduleJobBigProxy(jobHistory.getJobSuiteID())) == null) break;
                    JobHistory jobHistory2 = this.jobSuiteDM.getSuiteHistory(jobHistory.getJobSuiteHistoryID());
                    object = JobSuiteStatus.MEMBER_CANCELED;
                    bl7 = scheduleJobBigProxy3.isSendMemberCancelSNMPTrap();
                    bl8 = scheduleJobBigProxy3.isSendMemberCancelEmail();
                    if (bl8) {
                        emailInformation2.setOverrideSubject(scheduleJobBigProxy3.getEmailSubjectMemberCanceled());
                        emailInformation2.setOverrideBody(scheduleJobBigProxy3.getEmailBodyMemberCanceled());
                    }
                    l2 = scheduleJobBigProxy3.getMemberCancelNotificationListID();
                    bl9 = scheduleJobBigProxy3.isSendMemberCanceledEmailLog();
                    if (!bl7) break;
                    enterpriseSNMPTrap2 = this.getSuiteMemberSNMPTrap(jobHistory2, string2, l2, l4, string4, (JobSuiteStatus)object, string3, l3);
                    break;
                }
                case CONDITION_RETRY_WAIT: {
                    bl4 = scheduleJobBigProxy2.isSendRetryWaitSNMPTrap();
                    bl5 = scheduleJobBigProxy2.isSendRetryWaitEmail();
                    l = scheduleJobBigProxy2.getRetryWaitNotificationListID();
                    emailInformation.setOverrideSubject(scheduleJobBigProxy2.getEmailSubjectRetryWait());
                    emailInformation.setOverrideBody(scheduleJobBigProxy2.getEmailBodyRetryWait());
                    break;
                }
                case SKIPPED: {
                    bl4 = scheduleJobBigProxy2.isSendSkippedSNMPTrap();
                    bl5 = scheduleJobBigProxy2.isSendSkippedEmail();
                    l = scheduleJobBigProxy2.getSkippedNotificationListID();
                    emailInformation.setOverrideSubject(scheduleJobBigProxy2.getEmailSubjectSkipped());
                    emailInformation.setOverrideBody(scheduleJobBigProxy2.getEmailBodySkipped());
                    break;
                }
            }
        }
        if (bl4) {
            enterpriseSNMPTrap = this.getJobStatusSNMPTrap(jobHistory, string2);
        }
        if (bl && bl2) {
            logger.debug((Object)("Job History ID " + jobHistory.getId() + " was previously terminated and the Agent is now reporting completion." + "  SNMP Traps will not be sent."));
        } else {
            if (enterpriseSNMPTrap != null) {
                this.sendSNMPTrap(enterpriseSNMPTrap);
            }
            if (enterpriseSNMPTrap2 != null) {
                this.sendSNMPTrap(enterpriseSNMPTrap2);
            }
        }
        boolean bl10 = bl && bl2 && !bl6;
        boolean bl11 = bl3 = bl && bl2 && !bl9;
        if (bl5 || bl8) {
            if (scheduleJobBigProxy2.isSuiteMember()) {
                this.sendMemberEmailNotification(bl5, bl8, l, l2, bl6, bl9, scheduleJobBigProxy2, string, string2, jobHistory, emailInformation, emailInformation2, bl10, bl3);
            } else {
                object = this.notificationListDM.get(l).getListOfUniqueEmails();
                this.sendEmailNotification(scheduleJobBigProxy2, (String[])object, l, bl6, string, string2, jobHistory, emailInformation);
            }
        }
    }

    private EnterpriseSNMPTrap getJobStatusSNMPTrap(JobHistory jobHistory, String string) {
        JobStatusSNMPTrap jobStatusSNMPTrap = new JobStatusSNMPTrap(jobHistory.getStatusCode());
        jobStatusSNMPTrap.setJobID(jobHistory.getJobID());
        jobStatusSNMPTrap.setJobName(jobHistory.getJobName());
        jobStatusSNMPTrap.setJobSuiteName(jobHistory.getJobSuiteName());
        jobStatusSNMPTrap.setJobSuiteID(jobHistory.getJobSuiteID());
        jobStatusSNMPTrap.setJobSuiteRunID(jobHistory.getJobSuiteHistoryID());
        jobStatusSNMPTrap.setRunID(jobHistory.getId());
        jobStatusSNMPTrap.setAgentID(jobHistory.getAgentID());
        jobStatusSNMPTrap.setAgentName(jobHistory.getAgentName());
        jobStatusSNMPTrap.setText(string);
        return jobStatusSNMPTrap;
    }

    private void sendMemberEmailNotification(boolean bl, boolean bl2, long l, long l2, boolean bl3, boolean bl4, ScheduleJobBigProxy scheduleJobBigProxy, String string, String string2, JobHistory jobHistory, EmailInformation emailInformation, EmailInformation emailInformation2, boolean bl5, boolean bl6) throws ResourceUnavailableException, ActionFailedException, DataException {
        String[] stringArray;
        boolean bl7 = false;
        if (bl) {
            String[] stringArray2;
            stringArray = this.notificationListDM.get(l).getListOfUniqueEmails();
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            ArrayList<Object> arrayList2 = new ArrayList();
            if (bl2) {
                stringArray2 = this.notificationListDM.get(l2).getListOfUniqueEmails();
                arrayList2 = new ArrayList<String>(Arrays.asList(stringArray2));
                if (bl4 && !bl3) {
                    arrayList.removeAll(arrayList2);
                    stringArray = arrayList.toArray(new String[arrayList.size()]);
                }
                arrayList2.removeAll(arrayList);
            }
            if (!bl5) {
                this.sendEmailNotification(scheduleJobBigProxy, stringArray, l, bl3, string, string2, jobHistory, emailInformation);
            }
            if (arrayList2.size() > 0 && !bl6) {
                stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
                this.sendEmailNotification(scheduleJobBigProxy, stringArray2, l2, bl4, string, string2, jobHistory, emailInformation2);
                bl7 = true;
            }
        }
        if (bl2 && !bl6 && !bl7) {
            stringArray = this.notificationListDM.get(l2).getListOfUniqueEmails();
            this.sendEmailNotification(scheduleJobBigProxy, stringArray, l2, bl4, string, string2, jobHistory, emailInformation2);
        }
    }

    private void sendEmailNotification(ScheduleJobBigProxy scheduleJobBigProxy, String[] stringArray, long l, boolean bl, String string, String string2, JobHistory jobHistory, EmailInformation emailInformation) throws ResourceUnavailableException, ActionFailedException, DataException {
        boolean bl2;
        boolean bl3 = false;
        String string3 = string2;
        JobStatusCode jobStatusCode = jobHistory.getStatusCode();
        JobEndedReasonCode jobEndedReasonCode = jobHistory.getJobEndedReasonCode();
        String[] stringArray2 = null;
        boolean bl4 = bl2 = (jobStatusCode.equals(JobStatusCode.FAILED) || jobStatusCode.equals(JobStatusCode.CANCELED)) && jobEndedReasonCode.equals(JobEndedReasonCode.CONDITION_NOT_MET);
        if (bl && l > 0L && (jobHistory.getServerRunningTime() > 0L || bl2)) {
            String string4;
            stringArray2 = new String[1];
            if (!scheduleJobBigProxy.isEmailJobLog() && !scheduleJobBigProxy.isCopyJobLogToServer()) {
                if (jobEndedReasonCode != null && jobEndedReasonCode.equals(JobEndedReasonCode.ENDED_MANUALLY)) {
                    bl3 = false;
                } else if (jobStatusCode != JobStatusCode.FAILED && jobStatusCode != JobStatusCode.CANCELED) {
                    bl3 = true;
                }
            }
            CustomMailMessage customMailMessage = new CustomMailMessage(l, string, string3, null);
            customMailMessage.setType(0);
            long l2 = jobHistory.getServerEndedTime();
            String string5 = DefaultConfigPath.getServerDirectoryName((long)l2, (boolean)false);
            stringArray2[0] = string4 = DefaultConfigPath.getLogFile((String)string5, (long)jobHistory.getId(), (String)jobHistory.getAgentName(), (String)jobHistory.getJobName(), (long)l2, (boolean)false);
            customMailMessage.setDeleteWhenFinished(bl3);
            customMailMessage.setBody(string3);
            customMailMessage.setAttachmentNameList(stringArray2);
            if (jobHistory.getCopiedJobLogToServer()) {
                SystemSetupDM systemSetupDM;
                SystemSetup systemSetup;
                int n;
                long l3 = FileHandler.getFileSizeInBytes(string4);
                if (l3 > (long)(n = (systemSetup = (systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM")).get()).getMaxEmailAttachmentSize() * 1024 * 1024)) {
                    String string6 = this.outputDistributionAM.bigAttachmentLogInfo(string4, l3);
                    logger.info((Object)string6);
                    string3 = string3 + string6;
                    bl3 = false;
                    stringArray2 = null;
                }
                customMailMessage.setDeleteWhenFinished(bl3);
                customMailMessage.setBody(string3);
                customMailMessage.setAttachmentNameList(stringArray2);
                emailInformation.replaceJobVariables(jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getId(), jobHistory.getStatusCode().toString(), jobHistory.getScheduledTime());
                this.outputDistributionAM.doSend(l, emailInformation.getFinalSubject(), emailInformation.getFinalBody(), stringArray2, (Object)customMailMessage);
            } else {
                AgentOutputWorker.addJobLogCopiedEventToList(new JobLogCopiedEvent(stringArray2[0], customMailMessage));
            }
        } else if (stringArray != null && stringArray.length > 0) {
            try {
                emailInformation.replaceJobVariables(jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getId(), jobHistory.getStatusCode().toString(), jobHistory.getScheduledTime());
            }
            catch (Exception exception) {
                logger.error((Object)"Error preparing email subject/body.", (Throwable)exception);
            }
            this.emailAM.sendMessage(stringArray, emailInformation.getFinalSubject(), emailInformation.getFinalBody());
        }
    }

    private EnterpriseSNMPTrap getSuiteMemberSNMPTrap(JobHistory jobHistory, String string, long l, long l2, String string2, JobSuiteStatus jobSuiteStatus, String string3, long l3) {
        JobSuitesStatusSNMPTrap jobSuitesStatusSNMPTrap = new JobSuitesStatusSNMPTrap(jobSuiteStatus);
        jobSuitesStatusSNMPTrap.setJobSuiteID(jobHistory.getJobID());
        jobSuitesStatusSNMPTrap.setJobSuiteName(jobHistory.getJobName());
        jobSuitesStatusSNMPTrap.setSuiteRunID(jobHistory.getId());
        jobSuitesStatusSNMPTrap.setText(string);
        jobSuitesStatusSNMPTrap.setRunID(l);
        jobSuitesStatusSNMPTrap.setAgentID(l2);
        jobSuitesStatusSNMPTrap.setAgentName(string2);
        jobSuitesStatusSNMPTrap.setJobName(string3);
        jobSuitesStatusSNMPTrap.setJobID(l3);
        return jobSuitesStatusSNMPTrap;
    }

    @Override
    public void notifyOfJobSuiteStatus(JobHistory jobHistory, JobSuiteStatus jobSuiteStatus, String string) throws DataException, ResourceUnavailableException, ActionFailedException {
        String[] stringArray;
        String string2 = RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_JOB_SUITE_STATUS_NOTICE, new String[]{jobHistory.getJobName(), String.valueOf(jobHistory.getId()), jobSuiteStatus.name()});
        ScheduleJobBigProxy scheduleJobBigProxy = this.getScheduleJobBigProxy(jobHistory.getJobID());
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        EmailInformation emailInformation = new EmailInformation(string2, string);
        boolean bl3 = false;
        switch (jobSuiteStatus) {
            case RUNNING: {
                bl = scheduleJobBigProxy.isSendRunSNMPTrap();
                bl2 = scheduleJobBigProxy.isSendRunEmail();
                l = scheduleJobBigProxy.getRunNotificationListID();
                emailInformation.setOverrideSubject(scheduleJobBigProxy.getEmailSubjectRunning());
                emailInformation.setOverrideBody(scheduleJobBigProxy.getEmailBodyRunning());
                bl3 = true;
                break;
            }
            case COMPLETED: {
                bl = scheduleJobBigProxy.isSendCompleteSNMPTrap();
                bl2 = scheduleJobBigProxy.isSendCompleteEmail();
                l = scheduleJobBigProxy.getCompleteNotificationListID();
                emailInformation.setOverrideSubject(scheduleJobBigProxy.getEmailSubjectCompleted());
                emailInformation.setOverrideBody(scheduleJobBigProxy.getEmailBodyCompleted());
                bl3 = true;
                break;
            }
            case SKIPPED: {
                bl = scheduleJobBigProxy.isSendSkippedSNMPTrap();
                bl2 = scheduleJobBigProxy.isSendSkippedEmail();
                l = scheduleJobBigProxy.getSkippedNotificationListID();
                emailInformation.setOverrideSubject(scheduleJobBigProxy.getEmailSubjectSkipped());
                emailInformation.setOverrideBody(scheduleJobBigProxy.getEmailBodySkipped());
                bl3 = true;
                break;
            }
        }
        if (bl) {
            stringArray = new JobSuitesStatusSNMPTrap(jobSuiteStatus);
            stringArray.setJobSuiteID(jobHistory.getJobID());
            stringArray.setJobSuiteName(jobHistory.getJobName());
            stringArray.setSuiteRunID(jobHistory.getId());
            stringArray.setText(string);
            this.sendSNMPTrap((EnterpriseSNMPTrap)stringArray);
        }
        if (bl2 && l > 0L && bl3) {
            stringArray = null;
            try {
                stringArray = this.notificationListDM.get(l).getListOfUniqueEmails();
            }
            catch (Exception exception) {
                logger.error((Object)"Error retrieving Job Suite Notification Options.", (Throwable)exception);
            }
            if (stringArray != null && stringArray.length > 0) {
                try {
                    emailInformation.replaceJobSuiteVariables(jobHistory.getJobName(), jobHistory.getId(), jobSuiteStatus.toString(), jobHistory.getScheduledTime());
                }
                catch (Exception exception) {
                    logger.error((Object)"Error preparing email subject/body.", (Throwable)exception);
                }
                this.emailAM.sendMessage(stringArray, emailInformation.getFinalSubject(), emailInformation.getFinalBody());
            }
        }
    }

    @Override
    public void restartJob(long l, long l2, ScheduleInfo.TargetType targetType, int n, boolean bl, String string, String string2, boolean bl2, boolean bl3, int n2, String string3) throws ActionFailedException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        JobHistory jobHistory = null;
        try {
            jobHistory = this.jobHistoryDM.get(l);
            if (jobHistory == null) {
                throw new RuntimeException("History record for restart was not found: " + l);
            }
        }
        catch (DataException dataException) {
            throw new RuntimeException("Error loading existing history record for restart: " + l, dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RuntimeException("Error loading existing history record for restart: " + l, resourceUnavailableException);
        }
        if (!(jobHistory.getStatusCode().equals(JobStatusCode.CANCELED) || jobHistory.getStatusCode().equals(JobStatusCode.ERROR) || jobHistory.getStatusCode().equals(JobStatusCode.FAILED))) {
            throw new ActionFailedException("The restart of jobs with a status of '" + jobHistory.getStatusCode_asText() + "' is not allowed.");
        }
        ScheduleJobProxy scheduleJobProxy = null;
        try {
            scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy(jobHistory.getJobID());
        }
        catch (Exception exception) {
            logger.error((Object)"Error retrieving Schedule Job.  Job cannot be restarted.", (Throwable)exception);
        }
        if (scheduleJobProxy == null) {
            throw new ActionFailedException("The job cannot be restarted because the job has been deleted.");
        }
        long l3 = 0L;
        String string4 = null;
        if (targetType == ScheduleInfo.TargetType.AGENT) {
            l3 = l2;
        } else if (targetType == ScheduleInfo.TargetType.AGENT_GROUP) {
            try {
                object4 = this.agentGroupDM.getProxy(l2);
                string4 = object4.getName();
                if (((AgentGroupProxy)((Object)object4)).getAgentGroupType() == AgentGroupType.ALL_AGENTS) {
                    l3 = jobHistory.getAgentID();
                }
            }
            catch (Exception exception) {
                throw new ActionFailedException("The job cannot be restarted.  Error retrieving Agent Group.", (Throwable)exception);
            }
        }
        object4 = "";
        if (l3 != 0L) {
            boolean bl4 = false;
            object3 = null;
            try {
                object3 = this.agentDM.get(l3);
                if (object3 != null) {
                    bl4 = true;
                    object4 = object3.getName();
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Job cannot be restarted.  Error retrieving Agent.", (Throwable)exception);
            }
            if (!bl4) {
                throw new ActionFailedException("The job cannot be restarted because the agent has been deleted.");
            }
            if (scheduleJobProxy.getSystem() != 0 && (long)scheduleJobProxy.getSystem() != l3) {
                throw new ActionFailedException("The job cannot be restarted because the job is now defined to a different agent.");
            }
            if (scheduleJobProxy.getModel() != 0) {
                AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
                try {
                    object2 = agentGroupDM.getAgentGroupAgent(scheduleJobProxy.getModel(), l3, null);
                }
                catch (NoDataException noDataException) {
                    throw new ActionFailedException("The job cannot be restarted because the original agent is not defined in the agent group for the job.");
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    throw new ActionFailedException("Error checking agent group for agent.", (Throwable)resourceUnavailableException);
                }
            }
        } else {
            object4 = Agent.getTBDInGroupAgentName(string4);
        }
        Date date = new Date(System.currentTimeMillis());
        object3 = new JobHistory();
        ((JobHistory)((Object)object3)).setJobPriority(n2);
        ((JobHistory)((Object)object3)).setServerInitiatedTime(date.getTime());
        ((JobHistory)((Object)object3)).setScheduledTime(jobHistory.getScheduledTime());
        ((JobHistory)((Object)object3)).setMovedFromScheduledDateTime(jobHistory.getMovedFromScheduledDateTime());
        ((JobHistory)((Object)object3)).setJobID(jobHistory.getJobID());
        ((JobHistory)((Object)object3)).setAgentName((String)object4);
        ((JobHistory)((Object)object3)).setAgentID(l3);
        ((JobHistory)((Object)object3)).setAgentGroupID(jobHistory.getAgentGroupID());
        ((JobHistory)((Object)object3)).setAgentGroupName(jobHistory.getAgentGroupName());
        ((JobHistory)((Object)object3)).setJobQueueID(jobHistory.getJobQueueID());
        ((JobHistory)((Object)object3)).setJobQueueName(jobHistory.getJobQueueName());
        if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT) {
            long l4 = scheduleJobProxy.getJobQueueID();
            try {
                object = this.getJobQueuesDM().getJobQueue(l4);
                ((JobHistory)((Object)object3)).setJobQueueID(l4);
                ((JobHistory)((Object)object3)).setJobQueueName(object.getName());
                logger.debug((Object)("Assigning agent job (" + l + ") to restart on job queue: " + ((JobHistory)((Object)object3)).getJobQueueName() + " (" + ((JobHistory)((Object)object3)).getJobQueueID() + ")."));
            }
            catch (Exception exception) {
                logger.warn((Object)("Error loading job queue (" + l4 + ") for restarting job."), (Throwable)exception);
            }
        } else if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
            long l5 = scheduleJobProxy.getJobQueueID();
            if (l5 != 0L) {
                try {
                    object = this.getJobQueuesDM().getJobQueue(l5);
                    ((JobHistory)((Object)object3)).setJobQueueID(l5);
                    ((JobHistory)((Object)object3)).setJobQueueName(object.getName());
                }
                catch (Exception exception) {
                    logger.warn((Object)("Error loading cross agent job queue (" + l5 + ") for restarting job."), (Throwable)exception);
                }
            } else {
                ((JobHistory)((Object)object3)).setJobQueueName(scheduleJobProxy.getJobQueueName());
                ((JobHistory)((Object)object3)).setJobQueueID(0L);
            }
            logger.debug((Object)("Assigning agent group job (" + l + ") to restart on job queue: " + ((JobHistory)((Object)object3)).getJobQueueName() + " (" + ((JobHistory)((Object)object3)).getJobQueueID() + ")."));
        } else {
            logger.warn((Object)"Un-defined target type restarting job.");
        }
        ((JobHistory)((Object)object3)).setBypassJobMonitors(bl2);
        ((JobHistory)((Object)object3)).setBypassConditions(bl3);
        ((JobHistory)((Object)object3)).setJobName(jobHistory.getJobName());
        ((JobHistory)((Object)object3)).setRestartParentHistoryID(l);
        ((JobHistory)((Object)object3)).setStartAtCommandSequence(n);
        ((JobHistory)((Object)object3)).setInitiationCode(JobInitCode.RESTART);
        ((JobHistory)((Object)object3)).setInitiationData(string2);
        ((JobHistory)((Object)object3)).setManuallyStarted(true);
        if (bl) {
            ((JobHistory)((Object)object3)).setReactCode(JobReactCode.PERFORM_REACTIVITY);
        } else {
            ((JobHistory)((Object)object3)).setReactCode(JobReactCode.SKIP_REACTIVITY);
        }
        ((JobHistory)((Object)object3)).setTimezoneType(jobHistory.getTimezoneType());
        ((JobHistory)((Object)object3)).setAgentTimezone(jobHistory.getAgentTimezone());
        ((JobHistory)((Object)object3)).setJobTimezone(jobHistory.getJobTimezone());
        ((JobHistory)((Object)object3)).setJobSuiteHistoryID(jobHistory.getJobSuiteHistoryID());
        ((JobHistory)((Object)object3)).setJobSuiteMemberID(jobHistory.getJobSuiteMemberID());
        ((JobHistory)((Object)object3)).setJobSuiteMemberInstanceID(jobHistory.getJobSuiteMemberInstanceID());
        ((JobHistory)((Object)object3)).setJobSuiteID(jobHistory.getJobSuiteID());
        ((JobHistory)((Object)object3)).setJobSuiteName(jobHistory.getJobSuiteName());
        try {
            String string5 = JobParameterUtil.overrideJobParameters(((JobHistory)((Object)object3)).getJobName(), jobHistory.getJobParameters(), null, string3);
            ((JobHistory)((Object)object3)).setJobParameters(string5);
        }
        catch (Exception exception) {
            object2 = "Error processing job parameters during job restart.";
            logger.error(object2, (Throwable)exception);
            throw new ActionFailedException((String)object2, (Throwable)exception);
        }
        long l6 = this.forecastAM.runDuration(((JobHistory)((Object)object3)).getJobID(), ((JobHistory)((Object)object3)).getAgentID());
        ((JobHistory)((Object)object3)).setEstimatedRuntime(l6);
        try {
            object3 = this.jobHistoryDM.save((JobHistory)((Object)object3));
        }
        catch (Exception exception) {
            logger.error((Object)"Error restarting job...unable to save new job history info", (Throwable)exception);
            return;
        }
        try {
            object = (EventHistoryXRefDM)ManagerRegistry.getManager((String)"ENTERPRISE.EventHistoryXRefDM");
            int n3 = object.copyRestartedXRefs(l, ((JobHistory)((Object)object3)).getId());
            logger.debug((Object)(n3 + " Agent Event History XREF Records were copied from " + l + " to " + ((JobHistory)((Object)object3)).getId() + "."));
        }
        catch (Exception exception) {
            logger.error((Object)"Error copying Agent Event History XREF Records.", (Throwable)exception);
        }
        this.submitJob((JobHistory)((Object)object3), false);
        try {
            jobHistory.setRestartChildHistoryID(((JobHistory)((Object)object3)).getId());
            this.jobHistoryDM.save(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"Error updating job history info", (Throwable)exception);
            return;
        }
        object = new String[]{((JobHistory)((Object)object3)).getJobName(), Long.toString(l), ((JobHistory)((Object)object3)).getAgentName(), ScheduleLogger.formatTimeStamp(date), string2, Long.toString(((JobHistory)((Object)object3)).getId())};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_RESTARTED_BY_USER.newLogEntry((String[])object);
        scheduleLogEntry.setAgentID(((JobHistory)((Object)object3)).getAgentID());
        scheduleLogEntry.setJobID(((JobHistory)((Object)object3)).getJobID());
        scheduleLogEntry.setJobHistoryID(((JobHistory)((Object)object3)).getId());
        long l7 = ((JobHistory)((Object)object3)).getJobSuiteHistoryID();
        if (l7 != 0L) {
            scheduleLogEntry.setJobSuiteID(((JobHistory)((Object)object3)).getJobSuiteID());
            scheduleLogEntry.setJobSuiteHistoryID(l7);
        }
        ScheduleLogger.write(scheduleLogEntry);
    }

    private void sendSNMPTrap(EnterpriseSNMPTrap enterpriseSNMPTrap) {
        try {
            this.snmpTrapAM.sendSNMPTrap(enterpriseSNMPTrap);
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending a Job Status SNMP Trap.", (Throwable)exception);
        }
    }

    private JobHistory createBasicJobHistoryObject_ForMember(JobSuiteInstanceMember jobSuiteInstanceMember, long l, long l2, SuiteInfo suiteInfo) throws ResourceUnavailableException {
        JobHistory jobHistory = new JobHistory();
        jobHistory.setJobID(jobSuiteInstanceMember.getJobID());
        jobHistory.setJobName(jobSuiteInstanceMember.getName());
        jobHistory.setJobSuiteHistoryID(jobSuiteInstanceMember.getSuiteInstanceID());
        jobHistory.setJobSuiteMemberID(jobSuiteInstanceMember.getMemberID());
        jobHistory.setJobSuiteMemberInstanceID(jobSuiteInstanceMember.getMemberInstanceID());
        jobHistory.setJobSuiteID(suiteInfo.getSuiteID());
        jobHistory.setJobSuiteName(suiteInfo.getSuiteName());
        jobHistory.setServerInitiatedTime(l);
        jobHistory.setScheduledTime(l2);
        jobHistory.setJobPriority(jobSuiteInstanceMember.getPriority());
        jobHistory.setAgentEnvironmentType(jobSuiteInstanceMember.getAgentEnvironmentType());
        jobHistory.setJobParameters(suiteInfo.getJobParameters());
        jobHistory.setTimezoneType(suiteInfo.getTimezoneType());
        jobHistory.setJobTimezone(suiteInfo.getJobTimezone());
        return jobHistory;
    }

    private long getSuiteScheduledTime(long l) throws DataException, ResourceUnavailableException {
        return this.jobHistoryDM.get(l).getScheduledTime();
    }

    private void logError_MemberSubmitError(JobHistory jobHistory, SuiteInfo suiteInfo, Exception exception) {
        RosettaMsg rosettaMsg = RosettaMsg.SUITE_MEMBER_CREATE_HISTORY_ERROR;
        long l = jobHistory.getJobSuiteHistoryID();
        String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), suiteInfo.getSuiteName(), Long.toString(l)};
        this.writeToScheduleLog(rosettaMsg, stringArray, jobHistory);
        this.writeToDiagnosticLog(rosettaMsg, stringArray, exception);
    }

    private void markMemberAsEnded(JobHistory jobHistory, JobStatusCode jobStatusCode) throws ResourceUnavailableException {
        long l = System.currentTimeMillis();
        jobHistory.setStatusCode(jobStatusCode);
        jobHistory.setServerEndedTime(l);
        jobHistory.setJobEndedReasonCode(JobEndedReasonCode.PARENT_SUITE_ENDED);
        try {
            this.jobHistoryDM.save(jobHistory, true);
        }
        catch (DataException dataException) {
            throw new RuntimeException("Unable to save the job history.", dataException);
        }
        long l2 = 0L;
        try {
            this.jobStatusCountRollupDM.saveStatusCount(jobHistory.getStatusCode(), jobHistory.getServerEndedTime(), jobHistory.getAgentID(), l2);
        }
        catch (Exception exception) {
            logger.error((Object)"Error saving job_status_count_rollups for member termination.", (Throwable)exception);
        }
    }

    private AgentGroupProxy retrieveAgentGroupProxy(long l) throws ResourceUnavailableException {
        try {
            return this.agentGroupDM.getProxy(l);
        }
        catch (DataException dataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve the agent group proxy because no agent group was found whose id is {0}.", (Object[])new Object[]{l}));
        }
    }

    private AgentGroupAgentWithName retrieveAgentGroupAgent(long l, long l2) throws NoDataException, ResourceUnavailableException {
        AgentGroupAgentWithName[] agentGroupAgentWithNameArray;
        for (AgentGroupAgentWithName agentGroupAgentWithName : agentGroupAgentWithNameArray = this.agentGroupDM.getAgentsInGroup(l)) {
            if (agentGroupAgentWithName.getAgentID() != l2) continue;
            return agentGroupAgentWithName;
        }
        throw new NoDataException(MessageUtil.formatMsg((String)"The agent with ID {0} is not a member of the agent group with ID {1}.", (Object[])new Object[]{l2, l}));
    }

    private void setAgentTimezone(JobHistory jobHistory) {
        try {
            Agent agent = this.agentDM.get(jobHistory.getAgentID());
            jobHistory.setAgentTimezone(agent.getTimeZone());
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to determine the time zone of agent {0}.", (Object[])new Object[]{jobHistory.getAgentID()}), (Throwable)exception);
        }
    }

    private String writeToDiagnosticLog(RosettaMsg rosettaMsg, String[] stringArray, Exception exception) {
        String string = RosettaMsg.getMsgText(rosettaMsg, stringArray);
        logger.error((Object)string, (Throwable)exception);
        return string;
    }

    private void writeToScheduleLog(RosettaMsg rosettaMsg, String[] stringArray, JobHistory jobHistory) {
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId(), jobHistory.getJobSuiteID(), jobHistory.getJobSuiteHistoryID());
        ScheduleLogger.write(scheduleLogEntry);
    }

    @Override
    public ScheduleJobProxy getJobProxy(long l) {
        try {
            ScheduleJobProxy scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy(l);
            return scheduleJobProxy;
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Schedule Job Proxy for Job/Suite ID: " + l), (Throwable)exception);
            return null;
        }
    }

    @Override
    public JobHistoryDM getJobHistoryDM() {
        if (this.jobHistoryDM == null) {
            this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        }
        return this.jobHistoryDM;
    }

    @Override
    public boolean serviceEvent(GenericEvent genericEvent, long l, boolean bl) {
        if (genericEvent != null && genericEvent instanceof JobLogCopiedEvent) {
            JobLogCopiedEvent jobLogCopiedEvent = (JobLogCopiedEvent)genericEvent;
            CustomMailMessage customMailMessage = jobLogCopiedEvent.getCustMailMessage();
            String string = jobLogCopiedEvent.getCopiedFileName();
            String string2 = customMailMessage.getBody();
            String[] stringArray = customMailMessage.getAttachmentNameList();
            try {
                if (stringArray[0].equalsIgnoreCase(string)) {
                    JobHistoryDM jobHistoryDM = this.getJobHistoryDM();
                    JobHistory jobHistory = jobHistoryDM.get(l);
                    jobHistory.setCopiedJobLogToServer(true);
                    this.notifyOfJobStatus(jobHistory, null, string2, bl, true);
                    return true;
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Error sending job log: " + stringArray[0]), (Throwable)exception);
                return false;
            }
        }
        return false;
    }

    public void setForecastAM(ForecastAM forecastAM) {
        ValidationHelper.checkForNull((String)"ForecastAM", (Object)forecastAM);
        this.forecastAM = forecastAM;
    }

    class JobQueueRunner
    implements Runnable {
        JobQueueRunner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.dequeue();
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"The JobQueueRunner has encoundered a severe error. No more jobs will be run until the server is restarted.", throwable);
                return;
            }
        }

        private void dequeue() {
            JobHistory jobHistory = null;
            try {
                jobHistory = (JobHistory)((Object)JobTrackerAMImpl.this.queue.take());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (jobHistory == null) {
                return;
            }
            try {
                JobTrackerAMImpl.this.enterpriseServerAM.runJob(jobHistory);
                if (jobHistory.isSubsequentSubmit()) {
                    logger.debug((Object)"*** This is a subsequent submit for this record.  Rollup counts will not be updated.");
                    return;
                }
                try {
                    JobTrackerAMImpl.this.jobStartEndRollupDM.saveSubmitCount(jobHistory.getServerSubmittedTime());
                }
                catch (Exception exception) {
                    logger.error((Object)"Error saving jobStartEndRollup for job submitting", (Throwable)exception);
                }
                try {
                    JobTrackerAMImpl.this.jobInitiationCountRollupDM.saveInitCount(jobHistory.getInitiationCode(), jobHistory.getServerInitiatedTime());
                }
                catch (Exception exception) {
                    logger.error((Object)"Error saving job_initiation_count_rollup for job submitting", (Throwable)exception);
                }
                Object[] objectArray = new String[]{jobHistory.getJobName(), String.valueOf(jobHistory.getId()), jobHistory.getAgentName(), jobHistory.getStatusCode().name()};
                String string = RosettaMsg.getMsgText(RosettaMsg.SKYBOT_SCHEDULER_JOB_STATUS_NOTICE, objectArray);
                try {
                    JobTrackerAMImpl.this.notifyOfJobStatus(jobHistory, null, string, string);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error sending notification for job status change.", (Throwable)exception);
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.debug((Object)("Unable to submit job.  " + resourceUnavailableException.getMessage()));
            }
            catch (Exception exception) {
                jobHistory.setStatusCode(JobStatusCode.ERROR);
                logger.error((Object)("Error running job " + jobHistory.getJobID()), (Throwable)exception);
                try {
                    JobTrackerAMImpl.this.jobCompleted(jobHistory);
                }
                catch (ActionFailedException actionFailedException) {
                    logger.error((Object)"Error updating job history", (Throwable)actionFailedException);
                }
                return;
            }
        }
    }
}

