/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.access.jdbc.JobHistoryDMJdbc;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.MissedAgentJob;
import com.helpsystems.enterprise.core.busobj.PersistedJobQueueEntry;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMonitorDM;
import com.helpsystems.enterprise.core.dm.JobQueuePersisterAM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.PersistedJobQueueEntryDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobBigProxy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class JobQueuePersisterAMImpl
extends AbstractManager
implements JobQueuePersisterAM {
    private static final Logger logger = Logger.getLogger(JobQueuePersisterAMImpl.class);
    static PersistedJobQueueEntry.Action currentGroupAction = null;
    private static int rollingGroupID = 1;
    private ScheduleJobDM scheduleJobDM;
    private AgentGroupDM agentGroupDM;
    private JobHistoryDM jobHistoryDM;
    private JobTrackerAM jobTrackerAM;
    private EnterpriseServerAM enterpriseServerAM;
    private PersistedJobQueueEntryDM persistedJobQueueEntryDM;
    private Thread persisterThread;
    private BlockingQueue<PersistedJobQueueEntry> queue;
    private HashSet<MissedAgentJob> allAddedEntries;
    private boolean runnerIsActive = false;

    public JobQueuePersisterAMImpl(ScheduleJobDM scheduleJobDM, JobHistoryDMJdbc jobHistoryDMJdbc, JobTrackerAM jobTrackerAM, EnterpriseServerAM enterpriseServerAM, AgentGroupDM agentGroupDM) {
        this.setName("ENTERPRISE.JobQueuePersisterAM");
        this.scheduleJobDM = scheduleJobDM;
        this.jobHistoryDM = jobHistoryDMJdbc;
        this.jobTrackerAM = jobTrackerAM;
        this.enterpriseServerAM = enterpriseServerAM;
        this.agentGroupDM = agentGroupDM;
        this.persistedJobQueueEntryDM = (PersistedJobQueueEntryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PersistedJobQueueEntryDM");
        this.queue = new LinkedBlockingQueue<PersistedJobQueueEntry>();
    }

    @Override
    public int deletePersistedJobQueueEntries(ArrayList<Long> arrayList) {
        try {
            return this.persistedJobQueueEntryDM.delete(arrayList);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred attempting to delete persisted entries.", (Throwable)exception);
            return 0;
        }
    }

    @Override
    public void processNewJobHistory(JobHistory jobHistory) {
        boolean bl = jobHistory.getServerSubmittedTime() == 0L;
        jobHistory.setStatusCode(JobStatusCode.SUBMITTED);
        jobHistory.setServerSubmittedTime(System.currentTimeMillis());
        PersistedJobQueueEntry persistedJobQueueEntry = new PersistedJobQueueEntry(jobHistory.getId(), PersistedJobQueueEntry.Action.ADDED_TO_QUEUE);
        this.processPersistentEntry(persistedJobQueueEntry);
        try {
            this.jobHistoryDM.save(jobHistory, bl);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to update a job history state", (Throwable)exception);
        }
    }

    @Override
    public void processPersistentEntry(PersistedJobQueueEntry persistedJobQueueEntry) {
        this.queue.offer(persistedJobQueueEntry);
    }

    @Override
    public void removePersistedEntry(long l, long l2) {
        PersistedJobQueueEntry persistedJobQueueEntry = new PersistedJobQueueEntry(l, PersistedJobQueueEntry.Action.REMOVED_FROM_QUEUE, l2);
        this.queue.offer(persistedJobQueueEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPersistentEntryGroup(ArrayList<PersistedJobQueueEntry> arrayList) {
        BlockingQueue<PersistedJobQueueEntry> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            for (PersistedJobQueueEntry persistedJobQueueEntry : arrayList) {
                persistedJobQueueEntry.setGroupID(rollingGroupID);
                this.processPersistentEntry(persistedJobQueueEntry);
            }
            JobQueuePersisterAMImpl.rollGroupID();
        }
    }

    @Override
    public Set<MissedAgentJob> start() {
        this.processInitJobs();
        int n = this.reloadPersistedAgentJobs();
        if (this.persisterThread == null || !this.persisterThread.isAlive()) {
            this.persisterThread = new Thread(new PersistentJobQueueRunner());
            this.persisterThread.setName("PersistentJobQueueRunner");
            this.persisterThread.start();
            this.runnerIsActive = true;
        }
        String[] stringArray = new String[]{String.valueOf(n)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.REQUEUED_JOBS.newLogEntry(stringArray);
        ScheduleLogger.write(scheduleLogEntry);
        return this.getAllAddedEntries();
    }

    private void processInitJobs() {
        try {
            ArrayList<Long> arrayList = this.jobHistoryDM.getInitJobs();
            for (Long l : arrayList) {
                JobHistory jobHistory = this.jobHistoryDM.getWithAgentEnvironment(l);
                this.jobTrackerAM.submitMissedInitJob(jobHistory);
                String[] stringArray = new String[]{jobHistory.getJobName() + "(" + String.valueOf(jobHistory.getJobID()) + ")", String.valueOf(l)};
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.MISSED_JOB_SUBMITTED.newLogEntry(stringArray);
                ScheduleLogger.write(scheduleLogEntry);
            }
            logger.debug((Object)("Submitted " + arrayList.size() + " INIT job(s)."));
        }
        catch (Exception exception) {
            logger.error((Object)"Error persisting INIT jobs. ", (Throwable)exception);
        }
    }

    @Override
    public boolean isPersisterStopped() {
        return !this.runnerIsActive;
    }

    @Override
    public void stopJobQueuePersister() {
        if (this.persisterThread != null && this.persisterThread.isAlive()) {
            this.persisterThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reloadPersistedAgentJobs() {
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.REQUEUING_AGENT_QUEUES.newLogEntry();
        ScheduleLogger.write(scheduleLogEntry);
        int n = 0;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        JobMonitorDM jobMonitorDM = (JobMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorDM");
        long l = System.currentTimeMillis();
        long l2 = Calendar.getInstance().getTimeInMillis();
        int n2 = 0;
        try {
            logger.info((Object)"About to reload any persisted jobs...");
            PersistedJobQueueEntry[] persistedJobQueueEntryArray = this.persistedJobQueueEntryDM.getAllEntries();
            n2 = persistedJobQueueEntryArray.length;
            if (n2 == 0) {
                logger.info((Object)"There are no persisted Agent Job Queue entries.");
                int n3 = 0;
                return n3;
            }
            logger.info((Object)("Total persisted Agent Job Queue entries = " + n2 + ".  Note: Does not always equal actual number of jobs as" + " moves are also entries."));
            this.enterpriseServerAM.softHoldAllJobQueues();
            JobHistory jobHistory = null;
            ScheduleJobBigProxy scheduleJobBigProxy = null;
            int n4 = 0;
            for (int i = 0; i < persistedJobQueueEntryArray.length; ++i) {
                long l3;
                PersistedJobQueueEntry persistedJobQueueEntry;
                block23: {
                    persistedJobQueueEntry = persistedJobQueueEntryArray[i];
                    if (persistedJobQueueEntry.getAction() == PersistedJobQueueEntry.Action.ADDED_TO_QUEUE && arrayList.contains(persistedJobQueueEntry.getJobHistoryOID())) {
                        logger.debug((Object)("JobHistoryOID " + persistedJobQueueEntry.getJobHistoryOID() + " was already loaded.  This entry will be skipped."));
                        continue;
                    }
                    try {
                        jobHistory = this.jobHistoryDM.getWithAgentEnvironment(persistedJobQueueEntry.getJobHistoryOID());
                    }
                    catch (NoDataException noDataException) {
                        logger.debug((Object)(noDataException.getMessage() + ".  This persisted AgentJobQueue entry will be skipped."));
                        continue;
                    }
                    l3 = jobHistory.getAgentID();
                    try {
                        AgentGroupProxy agentGroupProxy;
                        if (jobHistory.getAgentGroupID() == 0L || (agentGroupProxy = this.agentGroupDM.getProxy(jobHistory.getAgentGroupID())).getAgentGroupType() != AgentGroupType.UTILIZATION_BALANCED && agentGroupProxy.getAgentGroupType() != AgentGroupType.PREFERRED_AGENT) break block23;
                        l3 = 0L;
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"Error retrieving agent group information.", (Throwable)exception);
                        continue;
                    }
                }
                if (persistedJobQueueEntry.getAction() != PersistedJobQueueEntry.Action.ADDED_TO_QUEUE) continue;
                arrayList.add(persistedJobQueueEntry.getJobHistoryOID());
                try {
                    scheduleJobBigProxy = this.scheduleJobDM.getScheduleJobBigProxy(jobHistory.getJobID());
                    if (!this.jobShouldBeRequeued(persistedJobQueueEntry, scheduleJobBigProxy, jobHistory, l3)) {
                        n4 += this.persistedJobQueueEntryDM.delete(persistedJobQueueEntry.getJobHistoryOID());
                        continue;
                    }
                    if (!jobHistory.isBypassJobMonitors() && scheduleJobBigProxy.isLateStartMonitorSelected() && scheduleJobBigProxy.isLateStartEndJob()) {
                        long l4 = jobMonitorDM.getMonitorTime(jobHistory.getJobID(), jobHistory.getAgentID(), jobHistory.getScheduledTime());
                        if (l4 != 0L) {
                            if (l4 < l) {
                                logger.debug((Object)("jobHistoryOID " + persistedJobQueueEntry.getJobHistoryOID() + " will not be re-queued due to late start " + "end job option."));
                                n4 += this.persistedJobQueueEntryDM.delete(persistedJobQueueEntry.getJobHistoryOID());
                                this.addAgentJobToAllAddedSet(l3, jobHistory.getJobID());
                                jobHistory.setMissedCode(JobMissedCode.MISSED_END);
                                jobHistory.setQueueEndedTime(System.currentTimeMillis());
                                this.jobHistoryDM.save(jobHistory);
                                continue;
                            }
                        } else {
                            logger.error((Object)("Job with job history ID " + jobHistory.getId() + " has Late Start monitor and the option to end " + "the job selected, but no Job Monitor was found" + " in the table " + "job_monitors"));
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)("Error obtaining scheduling or monitor information about persisted job historyID: " + persistedJobQueueEntry.getJobHistoryOID() + " for AgentID: " + jobHistory.getAgentID() + ". "), (Throwable)exception);
                }
                try {
                    this.requeueEntry(jobHistory, persistedJobQueueEntry, l3);
                    logger.trace((Object)("Job HistoryID: " + jobHistory.getId() + " was placed on the queue for AgentID: " + jobHistory.getAgentID()));
                    ++n;
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    logger.error((Object)("Persisted entry " + persistedJobQueueEntry.getJobHistoryOID() + " not requeued. " + illegalStateException.getMessage()));
                    n4 += this.persistedJobQueueEntryDM.delete(persistedJobQueueEntry.getJobHistoryOID());
                }
            }
            logger.trace((Object)("Reload process directly removed " + n4 + " entries from the agent_job_queue_entries table."));
            logger.info((Object)("Finished processing " + n2 + " persisted agent job queue entries.  Total re-queued = " + n));
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to load all persisted Agent jobs from database.", (Throwable)exception);
        }
        finally {
            if (logger.isDebugEnabled()) {
                long l5 = Calendar.getInstance().getTimeInMillis();
                logger.debug((Object)("Processing " + n2 + " persisted entries took " + (l5 - l2) + " ms or " + (l5 - l2) / 1000L + " seconds."));
            }
            this.enterpriseServerAM.softReleaseAllJobQueues();
        }
        return n;
    }

    private void addAgentJobToAllAddedSet(long l, long l2) {
        MissedAgentJob missedAgentJob = new MissedAgentJob(l, l2);
        if (!this.getAllAddedEntries().contains(missedAgentJob)) {
            this.getAllAddedEntries().add(missedAgentJob);
        }
    }

    private long requeueEntry(JobHistory jobHistory, PersistedJobQueueEntry persistedJobQueueEntry, long l) throws ActionFailedException {
        if (persistedJobQueueEntry.getAction() != PersistedJobQueueEntry.Action.ADDED_TO_QUEUE) {
            throw new IllegalStateException("Invalid Action on entry to be requeued.  Action must be ADDED_TO_QUEUE.");
        }
        try {
            this.enterpriseServerAM.reloadPersistedJob(jobHistory);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            jobHistory.setStatusCode(JobStatusCode.CANCELED);
            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.AGENT_MISSING);
            this.jobTrackerAM.jobCompleted(jobHistory);
            throw new IllegalStateException(resourceUnavailableException.getMessage());
        }
        catch (EndJobException endJobException) {
            throw new IllegalStateException(endJobException.getMessage());
        }
        this.addAgentJobToAllAddedSet(l, jobHistory.getJobID());
        return jobHistory.getAgentID();
    }

    private boolean jobShouldBeRequeued(PersistedJobQueueEntry persistedJobQueueEntry, ScheduleJobBigProxy scheduleJobBigProxy, JobHistory jobHistory, long l) {
        boolean bl = false;
        String string = "Persisted run number " + persistedJobQueueEntry.getJobHistoryOID() + " of jobID " + jobHistory.getJobID() + " for AgentID " + jobHistory.getAgentID();
        if (scheduleJobBigProxy.isSuiteMember()) {
            string = string + " will be run.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)string);
            }
            return true;
        }
        if (jobHistory.getStatusCode().isTerminalState()) {
            string = string + " will not be re-queued.  It has a matching Job History record in a terminal state.";
            return false;
        }
        string = string + " with missed job action of " + scheduleJobBigProxy.getMissedJobAction().name();
        switch (scheduleJobBigProxy.getMissedJobAction()) {
            case MANAGE: {
                string = string + " will not be re-queued and will be marked as manage (" + JobStatusCode.MANAGED + ").";
                bl = true;
                break;
            }
            case RUN_ALL: {
                string = string + " will be run.";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)string);
                }
                return true;
            }
            case IGNORE: {
                string = string + " will not be re-queued and its history record will be removed.";
                jobHistory.setStatusCode(JobStatusCode.CANCELED);
                break;
            }
            case FAIL: {
                string = string + " will not be re-queued and will be marked failed (" + JobStatusCode.FAILED + ").";
                jobHistory.setStatusCode(JobStatusCode.FAILED);
                break;
            }
            case COMPLETE: {
                string = string + " will not be re-queued and will be marked completed (" + JobStatusCode.COMPLETED + ").";
                jobHistory.setStatusCode(JobStatusCode.COMPLETED);
                break;
            }
            case RUN_ONCE_COMPLETE_OTHERS: 
            case RUN_ONCE_IGNORE_OTHERS: 
            case RUN_ONCE_MANAGE_OTHERS: 
            case RUN_ONCE_FAIL_OTHERS: {
                MissedAgentJob missedAgentJob = new MissedAgentJob(l, jobHistory.getJobID());
                if (this.getAllAddedEntries().contains(missedAgentJob)) {
                    string = string + " will not be re-queued as another instance is already re-queued.  It will be ";
                    switch (scheduleJobBigProxy.getMissedJobAction()) {
                        case RUN_ONCE_COMPLETE_OTHERS: {
                            jobHistory.setStatusCode(JobStatusCode.COMPLETED);
                            string = string + " marked as completed (" + JobStatusCode.COMPLETED + ").";
                            break;
                        }
                        case RUN_ONCE_IGNORE_OTHERS: {
                            jobHistory.setStatusCode(JobStatusCode.CANCELED);
                            string = string + " removed from history.";
                            break;
                        }
                        case RUN_ONCE_MANAGE_OTHERS: {
                            string = string + " marked as manage (" + JobStatusCode.MANAGED + ").";
                            bl = true;
                            break;
                        }
                        case RUN_ONCE_FAIL_OTHERS: {
                            jobHistory.setStatusCode(JobStatusCode.FAILED);
                            string = string + " marked as failed (" + JobStatusCode.FAILED + ").";
                        }
                    }
                    break;
                }
                string = string + " will be run.";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)string);
                }
                return true;
            }
            default: {
                logger.error((Object)(string + " resolved to an invalid MissedJobAction and will " + "not be re-queued.  It will be marked Managed(" + JobStatusCode.MANAGED + ")."));
                bl = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)string);
        }
        if (bl) {
            this.jobTrackerAM.markJobManaged(jobHistory);
        } else {
            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.MISSED_JOB_ACTION);
            try {
                this.jobTrackerAM.jobCompletedMissed(jobHistory, scheduleJobBigProxy);
            }
            catch (ActionFailedException actionFailedException) {
                logger.error((Object)"Error updating job history", (Throwable)actionFailedException);
            }
        }
        return false;
    }

    private Set<MissedAgentJob> getAllAddedEntries() {
        if (this.allAddedEntries == null) {
            this.allAddedEntries = new HashSet();
        }
        return this.allAddedEntries;
    }

    private static void rollGroupID() {
        rollingGroupID = rollingGroupID == Integer.MAX_VALUE ? 1 : ++rollingGroupID;
    }

    class PersistentJobQueueRunner
    implements Runnable {
        private boolean readyToShutDown = false;

        PersistentJobQueueRunner() {
        }

        @Override
        public void run() {
            try {
                logger.debug((Object)"The PersistentJobQueueRunner has started.");
                while (!this.readyToShutDown) {
                    this.dequeue();
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"The PersistentJobQueueRunner has encountered a severe error. No more jobs on an Agent Job Queue will be persisted until the server is restarted.", throwable);
            }
            finally {
                logger.debug((Object)"The PersistentJobQueueRunner has ended.");
                JobQueuePersisterAMImpl.this.runnerIsActive = false;
            }
        }

        private void dequeue() {
            PersistedJobQueueEntry persistedJobQueueEntry;
            block7: {
                persistedJobQueueEntry = null;
                try {
                    persistedJobQueueEntry = (PersistedJobQueueEntry)((Object)JobQueuePersisterAMImpl.this.queue.take());
                }
                catch (InterruptedException interruptedException) {
                    if (!JobQueuePersisterAMImpl.this.queue.isEmpty()) break block7;
                    this.readyToShutDown = true;
                }
            }
            if (persistedJobQueueEntry == null) {
                return;
            }
            try {
                if (persistedJobQueueEntry.getAction() == PersistedJobQueueEntry.Action.REMOVED_FROM_QUEUE) {
                    JobQueuePersisterAMImpl.this.persistedJobQueueEntryDM.delete(persistedJobQueueEntry.getJobHistoryOID());
                    JobQueuePersisterAMImpl.this.jobHistoryDM.updateQueuedEndedTime(persistedJobQueueEntry.getJobHistoryOID(), persistedJobQueueEntry.getQueueEndedTime());
                } else {
                    JobQueuePersisterAMImpl.this.persistedJobQueueEntryDM.save(persistedJobQueueEntry);
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to update database persistence for entry with JobHistory ID " + persistedJobQueueEntry.getJobHistoryOID()), (Throwable)exception);
            }
        }
    }
}

