/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.FileTransfer;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import com.helpsystems.enterprise.core.busobj.SkybotVariableResolveException;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.SkybotVariableDM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class IBMiExecutableJobHelper {
    private static Logger logger = Logger.getLogger(IBMiExecutableJobHelper.class);
    private CalendarObjectDM calendarObjectDM;

    IBMiExecutableJobHelper() {
    }

    public String getValidIBMiJobName(String string) throws InvalidStateException {
        char c;
        String string2 = "";
        char[] cArray = string.toUpperCase().toCharArray();
        for (int i = 0; i < cArray.length && (string2 = this.isValidIBMiCharacter(c = cArray[i]) ? string2 + String.valueOf(c) : string2 + "_").length() != 10; ++i) {
        }
        if (string2.length() == 0) {
            throw new InvalidStateException("Unable to convert '" + string + "' to a valid IBM i job name.");
        }
        return string2;
    }

    private boolean isValidIBMiCharacter(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '$' || c == '#' || c == '@' || c == '_' || c == '.';
    }

    public void resolveCommandWithEventDataVariables(CommandSetCommand commandSetCommand, AgentEventHistoryInfo[] agentEventHistoryInfoArray) {
        String string = commandSetCommand.getCommandString();
        if (!string.contains("%")) {
            return;
        }
        String string2 = this.getResolvedWithEventDataVariables(string, agentEventHistoryInfoArray);
        commandSetCommand.setCommandString(string2);
    }

    private String getResolvedWithEventDataVariables(String string, AgentEventHistoryInfo[] agentEventHistoryInfoArray) {
        String string2 = "";
        String string3 = null;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '%') {
                if (bl) {
                    String string4;
                    bl = false;
                    string3 = string3 + c;
                    boolean bl2 = false;
                    if (string3.length() > 2) {
                        string4 = string3.substring(1, string3.length() - 1);
                        String string5 = this.getEventDataFromVariable(string4, agentEventHistoryInfoArray);
                        if (string5 != null) {
                            string2 = string2 + string5;
                            logger.debug((Object)("Event Data Variable '" + string4 + "' was resolved."));
                            bl2 = true;
                        } else {
                            logger.warn((Object)("No Event Data Variable found with name '" + string4 + "'"));
                        }
                    }
                    if (bl2) continue;
                    bl = true;
                    string4 = string3.substring(0, string3.length() - 1);
                    string2 = string2 + string4;
                    string3 = String.valueOf(c);
                    continue;
                }
                bl = true;
                string3 = String.valueOf(c);
                continue;
            }
            if (bl) {
                string3 = string3 + c;
                continue;
            }
            string2 = string2 + c;
        }
        if (bl) {
            string2 = string2 + string3;
        }
        return string2;
    }

    private String getEventDataFromVariable(String string, AgentEventHistoryInfo[] agentEventHistoryInfoArray) {
        String string2 = null;
        for (int i = 0; i < agentEventHistoryInfoArray.length; ++i) {
            AgentEventHistoryInfo agentEventHistoryInfo = agentEventHistoryInfoArray[i];
            HashMap<String, String> hashMap = agentEventHistoryInfo.getEnvironmentVariables();
            string2 = hashMap.get(string);
            if (string2 == null) continue;
            return string2;
        }
        return string2;
    }

    public void resolveCommandWithVariables(CommandSetCommand commandSetCommand, Map<String, String> map) {
        String string = commandSetCommand.getCommandString();
        String string2 = this.getResolvedWithVariables(string, map);
        commandSetCommand.setCommandString(string2);
    }

    public void resolveCommandWithSkybotVariables(CommandSetCommand commandSetCommand, SkybotVariableDM skybotVariableDM, Calendar calendar) throws SkybotVariableResolveException {
        if (commandSetCommand.getCommandType() == 1) {
            FileTransfer fileTransfer = commandSetCommand.getFileTransfer();
            String string = this.getResolvedWithSkybotVariables(fileTransfer.getAgentFileName(), skybotVariableDM, calendar);
            fileTransfer.setAgentFileName(string);
            String string2 = this.getResolvedWithSkybotVariables(fileTransfer.getRemoteFileName(), skybotVariableDM, calendar);
            fileTransfer.setRemoteFileName(string2);
        } else {
            String string = commandSetCommand.getCommandString();
            String string3 = this.getResolvedWithSkybotVariables(string, skybotVariableDM, calendar);
            commandSetCommand.setCommandString(string3);
        }
    }

    private String getResolvedWithVariables(String string, Map<String, String> map) {
        if (!string.contains("{")) {
            return string;
        }
        String string2 = "";
        String string3 = null;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '{') {
                if (bl) {
                    string2 = string2 + string3;
                } else {
                    bl = true;
                }
                string3 = String.valueOf(c);
                continue;
            }
            if (c == '}') {
                if (bl) {
                    bl = false;
                    if ((string3 = string3 + c).length() > 2) {
                        boolean bl2 = false;
                        String string4 = string3.substring(1, string3.length() - 1);
                        String string5 = map.get(string4);
                        if (string5 != null) {
                            string2 = string2 + string5;
                            logger.debug((Object)("Variable or Job Parameter '" + string4 + "' was resolved."));
                            bl2 = true;
                        } else {
                            logger.warn((Object)("No Variable or Job Parameter found with name '" + string4 + "'"));
                        }
                        if (bl2) continue;
                        string2 = string2 + string3;
                        continue;
                    }
                    string2 = string2 + string3;
                    continue;
                }
                string2 = string2 + c;
                continue;
            }
            if (bl) {
                string3 = string3 + c;
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    private String getResolvedWithSkybotVariables(String string, SkybotVariableDM skybotVariableDM, Calendar calendar) throws SkybotVariableResolveException {
        if (!string.contains("{")) {
            return string;
        }
        String string2 = "";
        String string3 = null;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '{') {
                if (bl) {
                    string2 = string2 + string3;
                } else {
                    bl = true;
                }
                string3 = String.valueOf(c);
                continue;
            }
            if (c == '}') {
                if (bl) {
                    bl = false;
                    if ((string3 = string3 + c).length() > 2) {
                        boolean bl2 = false;
                        String string4 = string3.substring(1, string3.length() - 1);
                        try {
                            String string5;
                            SkybotVariable skybotVariable = skybotVariableDM.get(string4);
                            if (skybotVariable.isStaticValue()) {
                                string5 = skybotVariable.getValue();
                                string2 = string2 + string5;
                            } else {
                                CalendarObject calendarObject = null;
                                Long l = skybotVariable.getCalendarObjectID();
                                if (l != null) {
                                    calendarObject = this.getCalendarObjectDM().get(l);
                                }
                                string5 = skybotVariable.getValue(calendarObject, calendar);
                                string2 = string2 + string5;
                            }
                            logger.debug((Object)("Automate Schedule Variable '" + string4 + "' was resolved."));
                            bl2 = true;
                        }
                        catch (DataException dataException) {
                            logger.warn((Object)("No Automate Schedule Variable found with name '" + string4 + "'"));
                        }
                        catch (ResourceUnavailableException resourceUnavailableException) {
                            logger.error((Object)("Error resolving Automate Schedule Variable '" + string4 + "'"), (Throwable)resourceUnavailableException);
                        }
                        if (bl2) continue;
                        string2 = string2 + string3;
                        continue;
                    }
                    string2 = string2 + string3;
                    continue;
                }
                string2 = string2 + c;
                continue;
            }
            if (bl) {
                string3 = string3 + c;
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    private CalendarObjectDM getCalendarObjectDM() {
        if (this.calendarObjectDM == null) {
            this.calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
        }
        return this.calendarObjectDM;
    }
}

