/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.SNMPTrap;
import com.helpsystems.common.core.busobj.SNMPTrapManager;
import com.helpsystems.common.core.dm.SNMPTrapAM;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.EnterpriseSNMPTrapManager;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapManagerDM;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class EnterpriseSNMPTrapAMImpl
extends AbstractManager
implements EnterpriseSNMPTrapAM {
    private static Logger logger = Logger.getLogger(EnterpriseSNMPTrapAMImpl.class);
    private EnterpriseSNMPTrapManagerDM trapManagerDM;
    private SNMPTrapAM snmpTrapAM;
    private HashMap<Long, Long> coldStartMap = new HashMap();
    private BlockingQueue<EnterpriseSNMPTrap> queue;

    public EnterpriseSNMPTrapAMImpl(EnterpriseSNMPTrapManagerDM enterpriseSNMPTrapManagerDM, SNMPTrapAM sNMPTrapAM) {
        ValidationHelper.checkForNull((String)"SNMPTrapManagerDM", (Object)enterpriseSNMPTrapManagerDM);
        ValidationHelper.checkForNull((String)"SNMPTrapAM", (Object)sNMPTrapAM);
        this.trapManagerDM = enterpriseSNMPTrapManagerDM;
        this.snmpTrapAM = sNMPTrapAM;
        this.setName("ENTERPRISE.EnterpriseSNMPTrapAM");
        this.sendColdStartToAllManagers(false);
        this.queue = new LinkedBlockingQueue<EnterpriseSNMPTrap>();
        Thread thread = new Thread(new TrapQueueRunner());
        thread.setName("TrapQueueRunner");
        thread.start();
    }

    @Override
    public void reloadManagers() throws ResourceUnavailableException, ActionFailedException {
        this.sendColdStartToAllManagers(true);
    }

    private void sendColdStartToAllManagers(boolean bl) {
        EnterpriseSNMPTrapManager[] enterpriseSNMPTrapManagerArray = null;
        try {
            enterpriseSNMPTrapManagerArray = this.trapManagerDM.getList();
        }
        catch (Exception exception) {
            logger.error((Object)"Error retrieving SNMP Trap Managers.", (Throwable)exception);
            return;
        }
        if (enterpriseSNMPTrapManagerArray != null && enterpriseSNMPTrapManagerArray.length > 0) {
            for (int i = 0; i < enterpriseSNMPTrapManagerArray.length; ++i) {
                boolean bl2 = false;
                Long l = this.coldStartMap.get(enterpriseSNMPTrapManagerArray[i].getID());
                if (l != null && l > 0L) {
                    bl2 = true;
                }
                if (bl && bl2) continue;
                try {
                    this.sendColdStart(enterpriseSNMPTrapManagerArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof UnknownHostException) {
                        this.coldStartMap.put(enterpriseSNMPTrapManagerArray[i].getID(), new Long(-1L));
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Error sending Cold Start Trap to SNMP Trap Manager " + enterpriseSNMPTrapManagerArray[i].getManagerAddress() + ":" + enterpriseSNMPTrapManagerArray[i].getPortNumber()), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public long sendColdStart(EnterpriseSNMPTrapManager enterpriseSNMPTrapManager) throws ResourceUnavailableException, ActionFailedException {
        long l = System.currentTimeMillis();
        this.snmpTrapAM.sendColdStart("1.3.6.1.4.1.6872.2.1.1", (SNMPTrapManager)enterpriseSNMPTrapManager);
        this.coldStartMap.put(enterpriseSNMPTrapManager.getID(), l);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sent Cold Start Trap to SNMP Trap Manager " + enterpriseSNMPTrapManager.getManagerAddress() + ":" + enterpriseSNMPTrapManager.getPortNumber()));
        }
        return l;
    }

    @Override
    public void sendSNMPTrapNow(EnterpriseSNMPTrap enterpriseSNMPTrap) throws ResourceUnavailableException, ActionFailedException {
        this.sendSNMPTrap(enterpriseSNMPTrap, false);
    }

    @Override
    public void sendSNMPTrap(EnterpriseSNMPTrap enterpriseSNMPTrap) throws ResourceUnavailableException, ActionFailedException {
        this.sendSNMPTrap(enterpriseSNMPTrap, true);
    }

    private void sendSNMPTrap(EnterpriseSNMPTrap enterpriseSNMPTrap, boolean bl) throws ResourceUnavailableException, ActionFailedException {
        if (enterpriseSNMPTrap != null) {
            if (bl) {
                this.queue.offer(enterpriseSNMPTrap);
            } else {
                this.sendTrap(enterpriseSNMPTrap);
            }
        }
    }

    private void sendTrap(EnterpriseSNMPTrap enterpriseSNMPTrap) {
        if (enterpriseSNMPTrap == null) {
            return;
        }
        EnterpriseSNMPTrapManager[] enterpriseSNMPTrapManagerArray = null;
        try {
            enterpriseSNMPTrapManagerArray = this.trapManagerDM.getList();
        }
        catch (Exception exception) {
            logger.error((Object)"Error retrieving SNMP Trap Managers.", (Throwable)exception);
            return;
        }
        if (enterpriseSNMPTrapManagerArray != null && enterpriseSNMPTrapManagerArray.length > 0) {
            for (int i = 0; i < enterpriseSNMPTrapManagerArray.length; ++i) {
                long l = 0L;
                Long l2 = this.coldStartMap.get(enterpriseSNMPTrapManagerArray[i].getID());
                if (l2 == null || l2.equals(0)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Cold Start Trap has not been sent to SNMP Trap Manager " + enterpriseSNMPTrapManagerArray[i].getManagerAddress() + ":" + enterpriseSNMPTrapManagerArray[i].getPortNumber()));
                    }
                    try {
                        l = this.sendColdStart(enterpriseSNMPTrapManagerArray[i]);
                    }
                    catch (Exception exception) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Error sending Cold Start Trap to SNMP Trap Manager " + enterpriseSNMPTrapManagerArray[i].getManagerAddress() + ":" + enterpriseSNMPTrapManagerArray[i].getPortNumber() + ".  SNMP Trap will not be sent! "), (Throwable)exception);
                        }
                    }
                } else if (!l2.equals(-1)) {
                    l = l2;
                }
                if (l <= 0L) continue;
                try {
                    this.snmpTrapAM.sendTrap((SNMPTrap)enterpriseSNMPTrap, (SNMPTrapManager)enterpriseSNMPTrapManagerArray[i], l);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Sent Trap '" + enterpriseSNMPTrap.getText() + "' to SNMP Trap Manager " + enterpriseSNMPTrapManagerArray[i].getManagerAddress() + ":" + enterpriseSNMPTrapManagerArray[i].getPortNumber()));
                    continue;
                }
                catch (Exception exception) {
                    logger.error((Object)"Error sending an SNMP Trap.", (Throwable)exception);
                    if (!(exception.getCause() instanceof UnknownHostException)) continue;
                    this.coldStartMap.put(enterpriseSNMPTrapManagerArray[i].getID(), new Long(-1L));
                }
            }
        } else {
            logger.warn((Object)"There are no SNMP Trap Managers defined.  Trap not sent.");
        }
    }

    class TrapQueueRunner
    implements Runnable {
        TrapQueueRunner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.dequeue();
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"The TrapQueueRunner has encoundered a severe error. No more SNMP traps will be sent until the server is restarted.", throwable);
                return;
            }
        }

        private void dequeue() {
            EnterpriseSNMPTrap enterpriseSNMPTrap = null;
            try {
                enterpriseSNMPTrap = (EnterpriseSNMPTrap)((Object)EnterpriseSNMPTrapAMImpl.this.queue.take());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (enterpriseSNMPTrap == null) {
                return;
            }
            EnterpriseSNMPTrapAMImpl.this.sendTrap(enterpriseSNMPTrap);
        }
    }
}

