/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.NotOnQueueException;
import com.helpsystems.enterprise.core.busobj.RequeueJobException;
import com.helpsystems.enterprise.core.busobj.RunningJobLogException;
import com.helpsystems.enterprise.core.busobj.actions.ChangeJobPriorityEvent;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentWorkManagerAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.module.AgentWorkManager;
import com.helpsystems.enterprise.module.JobQueueManager;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class AgentWorkManagerAMImpl
extends AbstractManager
implements AgentWorkManagerAM {
    private static Logger logger = Logger.getLogger(AgentWorkManagerAMImpl.class);
    private static final int DEFAULT_MAX_PERMITS = 35;
    private Semaphore theSemaphore;
    private int semaphorePermits;
    private AgentPeer agentServer;
    private JobQueueManager jobQueueManager;
    private JobMonitorManagerAM jobMonitorManagerAM;
    private JobHistoryDM jobHistoryDM;
    JobTrackerAM jobTrackerAM;
    private AgentDM agentDM;
    private HashMap<Long, AgentWorkManager> agentWorkManagerHM = new HashMap();
    private boolean busySendingJob;
    private HashMap<Long, ArrayList<Long>> jobQueueAgentRetryHM = new HashMap();

    public AgentWorkManagerAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.AgentWorkManagerAM");
        this.agentServer = agentPeer;
        this.init();
        logger.debug((Object)"*** The main Agent Work Manager has started ***");
    }

    private void init() {
        this.semaphorePermits = this.agentServer.getAgentConfig().getSemaphorePermits();
        if (this.semaphorePermits <= 0) {
            logger.warn((Object)("Semaphore Permits value of " + this.semaphorePermits + " in entServer.xml invalid."));
            this.semaphorePermits = 35;
        }
        this.theSemaphore = new Semaphore(this.semaphorePermits, false);
        logger.info((Object)("*** Semaphore Permits set to " + this.semaphorePermits + " ***"));
    }

    @Override
    public void jobCompleted(JobHistory jobHistory, boolean bl) {
        AgentWorkManager agentWorkManager = null;
        try {
            agentWorkManager = this.getAgentWorkManager(jobHistory.getAgentID(), false);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            // empty catch block
        }
        if (agentWorkManager != null && bl) {
            agentWorkManager.jobCompleted(jobHistory.getId());
        }
        this.getJobQueueManager().jobCompleted(jobHistory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAgentsOfLicenseChange() {
        logger.debug((Object)"Received notification of license change.");
        HashMap<Long, AgentWorkManager> hashMap = this.agentWorkManagerHM;
        synchronized (hashMap) {
            for (AgentWorkManager agentWorkManager : this.agentWorkManagerHM.values()) {
                agentWorkManager.notifyJobHelperOfLicenseChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAgentsOfSAPXMIAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        HashMap<Long, AgentWorkManager> hashMap = this.agentWorkManagerHM;
        synchronized (hashMap) {
            for (AgentWorkManager agentWorkManager : this.agentWorkManagerHM.values()) {
                agentWorkManager.notifyOfSAPXMIAuditLevelChange(l, sAPXMIAuditLevel);
            }
        }
    }

    @Override
    public void processJob(JobHistory jobHistory) throws Exception {
        this.processJob(jobHistory, true);
    }

    private void processJob(JobHistory jobHistory, boolean bl) throws Exception {
        if (!jobHistory.isBypassJobMonitors()) {
            try {
                this.getJobMonitorManagerAM().loadLateStartJobMonitor(jobHistory);
            }
            catch (EndJobException endJobException) {
                logger.debug((Object)("Job History ID " + jobHistory.getId() + " will not be enqueued. " + endJobException.getMessage()));
                throw endJobException;
            }
            catch (Exception exception) {
                logger.error((Object)("Error loading Job Monitors for jobHistoryOID " + jobHistory.getId()), (Throwable)exception);
            }
        }
        this.getJobQueueManager().enqueue(jobHistory, bl);
    }

    private JobMonitorManagerAM getJobMonitorManagerAM() {
        if (this.jobMonitorManagerAM == null) {
            this.jobMonitorManagerAM = (JobMonitorManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorManagerAM");
        }
        return this.jobMonitorManagerAM;
    }

    @Override
    public void updateAgentInfo(Agent agent) {
        if (this.agentWorkManagerHM.containsKey(agent.getOid())) {
            AgentWorkManager agentWorkManager = this.agentWorkManagerHM.get(agent.getOid());
            agentWorkManager.updateAgentInfo(agent);
        }
    }

    @Override
    public void agentConnected(Agent agent) {
        logger.debug((Object)("Received notice of agent " + agent.getName() + " connected."));
        try {
            AgentWorkManager agentWorkManager = this.getAgentWorkManager(agent.getOid());
            agentWorkManager.agentConnected(agent);
            agentWorkManager.notifyOfAgentAvailable("Agent connected.", true);
            ArrayList<JobHistory> arrayList = agentWorkManager.getActiveJobsFromAgent();
            logger.debug((Object)("Found " + arrayList.size() + " running jobs on Agent " + agent.getName()));
            this.getJobQueueManager().loadRunningJobs(arrayList);
            this.getJobQueueManager().agentConnected(agent.getOid());
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)("Error establishing AgentWorkManager for connected Agent " + agent.getName()), (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public void agentDisconnected(Agent agent) {
        logger.debug((Object)("Received notice of agent " + agent.getName() + " disconnected."));
        try {
            AgentWorkManager agentWorkManager = this.getAgentWorkManager(agent.getOid(), false);
            if (agentWorkManager != null) {
                agentWorkManager.agentDisconnected();
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)("Error establishing AgentWorkManager for disconnected Agent " + agent.getName()), (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public void bypassJobConditions(JobHistory jobHistory, String string) throws ResourceUnavailableException, ActionFailedException, DataException {
        this.getAgentWorkManager(jobHistory.getAgentID()).bypassConditionsOnJob(jobHistory, string);
    }

    @Override
    public void changeJobPriority(ChangeJobPriorityEvent changeJobPriorityEvent) throws DataException, ResourceUnavailableException, NotOnQueueException {
        this.getJobQueueManager().changeJobPriority(changeJobPriorityEvent);
    }

    @Override
    public int clearJobQueue(long l, String string) throws Exception {
        Collection<JobHistory> collection = this.getJobQueueManager().clearJobQueue(l);
        int n = collection.size();
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        for (JobHistory jobHistory : collection) {
            jobHistory.setStatusCode(JobStatusCode.CANCELED);
            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.REMOVED_MANUALLY);
            jobHistory.setServerEndedTime(l2);
            jobHistory.setQueueEndedTime(l2);
            try {
                this.getJobHistoryDM().save(jobHistory, true);
                this.getJobMonitorManagerAM().jobWasTerminated(jobHistory.getId());
                ++n2;
            }
            catch (Exception exception) {
                logger.error((Object)("Error cancelling job " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") which was removed from the queue " + string), (Throwable)exception);
            }
        }
        logger.debug((Object)("Cancelled " + n2 + " of " + collection.size() + " jobs which were removed from the queue " + string));
        return n;
    }

    private JobHistoryDM getJobHistoryDM() {
        if (this.jobHistoryDM == null) {
            this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        }
        return this.jobHistoryDM;
    }

    @Override
    public void jobQueueChanged(long l) {
        this.getJobQueueManager().jobQueueChanged(l);
    }

    @Override
    public void jobStartedOnAgent(JobHistory jobHistory) {
        this.getJobQueueManager().jobStartedOnAgent(jobHistory);
    }

    @Override
    public String loadRunningJobLog(JobHistory jobHistory, String string) throws ResourceUnavailableException, RunningJobLogException {
        AgentWorkManager agentWorkManager = this.getAgentWorkManager(jobHistory.getAgentID());
        return agentWorkManager.loadRunningJobLog(jobHistory, string);
    }

    @Override
    public String lockAgent(long l) throws Exception {
        Agent agent = this.getAgentDM().get(l);
        if (agent.isQueuesLocked()) {
            throw new Exception("Already locked.");
        }
        this.getAgentDM().updateLock(l, true);
        agent.setQueuesLocked(true);
        if (this.agentWorkManagerHM.containsKey(l)) {
            this.getAgentWorkManager(l).updateAgentInfo(agent);
        }
        this.getJobQueueManager().lockAgent(l);
        return agent.getName();
    }

    @Override
    public String unlockAgent(long l) throws Exception {
        Agent agent = this.getAgentDM().get(l);
        if (!agent.isQueuesLocked()) {
            throw new Exception("Already unlocked.");
        }
        this.getAgentDM().updateLock(l, false);
        agent.setQueuesLocked(false);
        if (this.agentWorkManagerHM.containsKey(l)) {
            this.getAgentWorkManager(l).updateAgentInfo(agent);
        }
        this.getJobQueueManager().unlockAgent(l);
        return agent.getName();
    }

    @Override
    public void dequeueJob(JobHistory jobHistory) throws NotOnQueueException, ActionFailedException, ResourceUnavailableException {
        this.getJobQueueManager().dequeue(jobHistory);
    }

    private JobQueueManager getJobQueueManager() {
        if (this.jobQueueManager == null) {
            this.jobQueueManager = new JobQueueManager(this);
        }
        return this.jobQueueManager;
    }

    @Override
    public boolean isAgentLocked(long l) {
        try {
            AgentWorkManager agentWorkManager = this.getAgentWorkManager(l, false);
            if (agentWorkManager != null) {
                return agentWorkManager.getAgent().isQueuesLocked();
            }
            Agent agent = this.getAgentDM().get(l);
            return agent.isQueuesLocked();
        }
        catch (Exception exception) {
            logger.error((Object)("Error determining if Agent with ID " + l + " is locked."), (Throwable)exception);
            return false;
        }
    }

    protected boolean isGlobalHoldInEffect() {
        return this.agentServer.getAgentConfig().getHoldAgents();
    }

    @Override
    public boolean isJobOnQueue(JobHistory jobHistory) throws ResourceUnavailableException {
        return this.getJobQueueManager().isJobOnQueue(jobHistory);
    }

    @Override
    public boolean isJobQueueHeldForBalancing(long l) throws ResourceUnavailableException {
        return this.getJobQueueManager().isJobQueueHeldForBalancing(l);
    }

    @Override
    public void holdAllJobQueues() {
        this.getJobQueueManager().holdAllJobQueues();
    }

    @Override
    public void holdJobQueue(long l) {
        this.getJobQueueManager().holdJobQueue(l);
    }

    @Override
    public void releaseAllJobQueues() {
        this.getJobQueueManager().releaseAllJobQueues();
    }

    @Override
    public void releaseGlobalHold() {
        this.getJobQueueManager().releaseGlobalHold();
    }

    @Override
    public void releaseJobQueue(long l) {
        this.getJobQueueManager().releaseJobQueue(l);
    }

    @Override
    public void removeFromActiveList(JobHistory jobHistory) {
        this.getJobQueueManager().decrementActiveForQueue(jobHistory);
    }

    @Override
    public void requeueJob(JobHistory jobHistory, SubmitFailedException.Reason reason) throws EndJobException, ResourceUnavailableException {
        this.getJobQueueManager().requeue(jobHistory, reason);
    }

    @Override
    public Object[] runJobsImmediately(List<JobHistory> list) {
        ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>();
        ArrayList<JobHistory> arrayList2 = new ArrayList<JobHistory>();
        ArrayList<JobHistory> arrayList3 = new ArrayList<JobHistory>();
        for (JobHistory jobHistory : list) {
            String string = "Error performing 'Run Immediately' for Job " + jobHistory.getJobName() + " with Job ID " + jobHistory.getJobID() + " and Job History ID: " + jobHistory.getId();
            try {
                this.getJobQueueManager().dequeue(jobHistory);
                this.getJobQueueManager().incrementActiveJobCount(jobHistory);
                this.sendJobToAgent(jobHistory, true);
                arrayList.add(jobHistory);
            }
            catch (RequeueJobException requeueJobException) {
                if (!requeueJobException.isJobRequeued()) {
                    try {
                        this.getJobQueueManager().enqueue(jobHistory, true);
                        logger.debug((Object)("Placed job " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") back on the queue " + jobHistory.getJobQueueName() + "(" + jobHistory.getJobQueueID() + ").  Reason: " + requeueJobException.getMessage()));
                        this.getJobQueueManager().decrementActiveForQueue(jobHistory);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error placing job " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") back on the queue."), (Throwable)exception);
                    }
                }
                arrayList3.add(jobHistory);
            }
            catch (Exception exception) {
                if (exception instanceof NotOnQueueException) {
                    logger.warn((Object)(string + ". " + exception.getMessage()));
                } else {
                    logger.error((Object)string, (Throwable)exception);
                }
                arrayList2.add(jobHistory);
                this.getJobQueueManager().decrementActiveForQueue(jobHistory);
            }
        }
        Object[] objectArray = new Object[]{arrayList, arrayList2, arrayList3};
        return objectArray;
    }

    @Override
    public void reloadPersistedJob(JobHistory jobHistory) throws Exception {
        this.processJob(jobHistory, false);
    }

    public void sendJobToAgent(JobHistory jobHistory) throws RequeueJobException, EndJobException {
        this.sendJobToAgent(jobHistory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendJobToAgent(JobHistory jobHistory, boolean bl) throws RequeueJobException, EndJobException {
        this.busySendingJob = true;
        logger.debug((Object)("Received job " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") from JobQueueManager to send to Agent: " + jobHistory.getAgentName()));
        this.acquireSemaphore();
        try {
            AgentWorkManager agentWorkManager = this.getAgentWorkManager(jobHistory.getAgentID());
            if (!agentWorkManager.isAgentAvailable()) {
                this.releaseSemaphore();
                if (agentWorkManager.isToBeTerminated(jobHistory.getId())) {
                    logger.debug((Object)("Job History ID " + jobHistory.getId() + " is flagged to be terminated and will not be requeued."));
                    throw new EndJobException("Job was previously terminated.");
                }
                throw new RequeueJobException("Agent " + jobHistory.getAgentName() + "(" + jobHistory.getAgentID() + ") is unavailable.", SubmitFailedException.Reason.AGENT_OFFLINE);
            }
            Exception exception = agentWorkManager.processJob(jobHistory, bl);
            if (exception != null && exception instanceof EndJobException) {
                throw (EndJobException)exception;
            }
            if (exception != null && exception instanceof RequeueJobException) {
                RequeueJobException requeueJobException = (RequeueJobException)exception;
                if (requeueJobException.getReason().equals((Object)SubmitFailedException.Reason.CREATE_PROCESS_FAILED) && requeueJobException.hasNoActiveJobsFromQueue()) {
                    this.startRetryForAgentTimer(jobHistory);
                    requeueJobException.setRetryTimerStarted(true);
                }
                throw requeueJobException;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)("Error obtaining AgentWorkManager for Agent ID: " + jobHistory.getAgentID()), (Throwable)resourceUnavailableException);
            this.jobFailedToStart(jobHistory);
            try {
                this.getJobTrackerAM().jobCompleted(jobHistory);
            }
            catch (ActionFailedException actionFailedException) {
                logger.debug((Object)"Error updating job history", (Throwable)actionFailedException);
            }
            this.releaseSemaphore();
        }
        finally {
            this.busySendingJob = false;
        }
    }

    protected void startRetryForAgentTimer(final JobHistory jobHistory) {
        final long l = jobHistory.getJobQueueID();
        final long l2 = jobHistory.getAgentID();
        if (this.getAgentArrayForJobQueue(l).contains(l2)) {
            logger.debug((Object)("Already have retry timer active for agentID " + l2));
            return;
        }
        this.getAgentArrayForJobQueue(l).add(l2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                logger.debug((Object)"Start of Retry timer.");
                try {
                    logger.debug((Object)("Waiting up to 10 seconds to retry Job " + jobHistory.getJobName() + "(" + jobHistory.getId() + ")"));
                    Thread.sleep(10000L);
                    logger.debug((Object)"Retry timeout expired.");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    AgentWorkManagerAMImpl.this.getAgentWorkManager(l2).notifyOfAgentAvailable("Retry timer expired.");
                    AgentWorkManagerAMImpl.this.getJobQueueManager().releaseAgentForQueue(l, l2);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error during retry process.", (Throwable)exception);
                }
                AgentWorkManagerAMImpl.this.getAgentArrayForJobQueue(l).remove(l2);
                logger.debug((Object)"End of Retry timer.");
            }
        };
        Thread thread = new Thread(runnable, "Retry Timer for Agent " + jobHistory.getAgentName() + "(" + l2 + ") and Job Queue " + jobHistory.getJobQueueName() + "(" + l + ")");
        thread.start();
    }

    private ArrayList<Long> getAgentArrayForJobQueue(long l) {
        if (!this.jobQueueAgentRetryHM.containsKey(l)) {
            ArrayList arrayList = new ArrayList();
            this.jobQueueAgentRetryHM.put(l, arrayList);
        }
        return this.jobQueueAgentRetryHM.get(l);
    }

    private JobTrackerAM getJobTrackerAM() {
        if (this.jobTrackerAM == null) {
            this.jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
        }
        return this.jobTrackerAM;
    }

    protected ArrayList<Long> getLockedAgentsList() {
        try {
            return this.getAgentDM().getLockedAgentIDs();
        }
        catch (Exception exception) {
            logger.error((Object)"Error obtaining list of locked Agents.", (Throwable)exception);
            return new ArrayList<Long>();
        }
    }

    @Override
    public int getMaxActiveJobsForUtilization(long l) throws ResourceUnavailableException {
        return this.getJobQueueManager().getMaxActiveIndexForUtilization(l);
    }

    private AgentWorkManager getAgentWorkManager(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManager(l, true);
    }

    private AgentWorkManager getAgentWorkManager(long l, boolean bl) throws ResourceUnavailableException {
        if (!this.agentWorkManagerHM.containsKey(l) && bl) {
            Agent agent;
            try {
                agent = this.getAgentDM().get(l);
            }
            catch (DataException dataException) {
                throw new ResourceUnavailableException("AgentID " + l + " not found.", (Throwable)dataException);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.debug((Object)("Failed to add an AgentWorkManager to the HashMap for agentID: " + l), (Throwable)resourceUnavailableException);
                throw new ResourceUnavailableException(resourceUnavailableException.getMessage());
            }
            AgentWorkManager agentWorkManager = new AgentWorkManager(agent, this.agentServer, this);
            this.agentWorkManagerHM.put(l, agentWorkManager);
        }
        return this.agentWorkManagerHM.get(l);
    }

    @Override
    public Agent getAgent(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManager(l).getAgent();
    }

    private AgentDM getAgentDM() {
        if (this.agentDM == null) {
            this.agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        }
        return this.agentDM;
    }

    @Override
    public void setGlobalHold() throws ActionFailedException {
        this.getJobQueueManager().setGlobalHold();
    }

    @Override
    public void shutDown() {
        logger.debug((Object)"*** Received notice to shut down.");
        this.getJobQueueManager().shutDown();
        try {
            while (this.busySendingJob) {
                logger.debug((Object)"Waiting while job is being sent to an Agent before shutting down ...");
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDownForAgent(long l) {
        HashMap<Long, AgentWorkManager> hashMap = this.agentWorkManagerHM;
        synchronized (hashMap) {
            if (this.agentWorkManagerHM.containsKey(l)) {
                AgentWorkManager agentWorkManager = this.agentWorkManagerHM.remove(l);
                logger.debug((Object)("Removed AgentWorkManager for Agent " + agentWorkManager.getAgent().getName() + " (" + l + ") from the internal HashMap."));
                agentWorkManager.shutdown();
                agentWorkManager = null;
                this.getJobQueueManager().agentDeleted(l);
            }
        }
    }

    @Override
    public void acquireSemaphore() {
        try {
            logger.trace((Object)("Before theSemaphore.acquire(). Available = " + this.theSemaphore.availablePermits()));
            if (this.theSemaphore.availablePermits() == 0) {
                logger.debug((Object)("AgentWorkManager semaphore reached 0 available.  Current setting is " + this.semaphorePermits + "."));
            }
            this.theSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            logger.warn((Object)"theSemaphore.acquire() was interrupted.", (Throwable)interruptedException);
        }
    }

    @Override
    public void releaseSemaphore() {
        this.theSemaphore.release();
        logger.trace((Object)("After theSemaphore.release() Available = " + this.theSemaphore.availablePermits()));
    }

    @Override
    public void jobFailedToStart(JobHistory jobHistory) {
        if (jobHistory.getStatusCode() == null || jobHistory.getStatusCode() != JobStatusCode.CANCELED) {
            jobHistory.setStatusCode(JobStatusCode.ERROR);
        }
        jobHistory.setQueueEndedTime(System.currentTimeMillis());
        this.getJobQueueManager().depersistJob(jobHistory);
        try {
            this.getJobTrackerAM().jobCompleted(jobHistory);
        }
        catch (ActionFailedException actionFailedException) {
            logger.debug((Object)"Error updating job history", (Throwable)actionFailedException);
        }
    }

    @Override
    public int getJobQueueCount(long l) throws ResourceUnavailableException {
        return this.getJobQueueManager().getJobQueueCount(l);
    }

    @Override
    public int getJobQueueCount(long l, long l2) throws ResourceUnavailableException {
        return this.getJobQueueManager().getJobQueueCount(l, l2);
    }

    @Override
    public int getJobQueueCountForAgent(long l) throws ResourceUnavailableException {
        return this.getJobQueueManager().getJobQueueCountForAgent(l);
    }

    @Override
    public int getAgentJobRunningCount(long l) throws ResourceUnavailableException {
        if (!this.agentWorkManagerHM.containsKey(l)) {
            return 0;
        }
        return this.getAgentWorkManager(l).getAgentActiveJobCount();
    }

    @Override
    public PeerID getAgentPeerID(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManager(l).getAgentPeerID();
    }

    @Override
    public int getTotalJobsQueued() {
        return this.getJobQueueManager().getTotalJobQueueCount();
    }

    @Override
    public ArrayList<JobHistory> getJobQueueEntries(long l) throws ResourceUnavailableException {
        return this.getJobQueueManager().getJobQueueEntries(l);
    }

    @Override
    public int getJobQueueRunningCount(long l) throws ResourceUnavailableException {
        return this.getJobQueueManager().getJobQueueRunningCount(l);
    }

    @Override
    public int getJobQueueRunningCount(long l, long l2) throws ResourceUnavailableException {
        return this.getJobQueueManager().getJobQueueRunningCount(l, l2);
    }

    @Override
    public void terminateJob(JobHistory jobHistory, String string, boolean bl) throws Exception {
        if (!bl) {
            try {
                this.dequeueJob(jobHistory);
                return;
            }
            catch (NotOnQueueException notOnQueueException) {
                logger.debug((Object)("Job History " + jobHistory.getId() + " was not on the queue."));
            }
        }
        this.getAgentWorkManager(jobHistory.getAgentID()).terminateJob(jobHistory, string, bl);
    }
}

