/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.webservices;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import java.io.Serializable;

public class WebServiceServer
implements XMLSerializable,
Serializable {
    private static final long serialVersionUID = 5649422338053396990L;
    public static final int AUTH_TYPE_NONE = 0;
    public static final int AUTH_TYPE_BASIC = 1;
    private static final String CHARSET_UTF8 = "UTF-8";
    private String url = null;
    private int authType = 0;
    private String authUser = null;
    private boolean trustAll = false;
    private long OID;
    private String pwd_salt = null;
    private String pwd_encrypted = null;
    private String name = null;
    private String charSet = "UTF-8";

    public WebServiceServer() {
    }

    public WebServiceServer(String string) {
        this.url = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int n) {
        this.authType = n;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String string) {
        this.authUser = string;
    }

    public String authPwd() {
        if (this.getPwd_encrypted() == null || this.getPwd_salt() == null) {
            this.authUser = "";
            return this.authUser;
        }
        try {
            String string = UnacodeMash.unMash(this.getPwd_encrypted());
            return string.replace(this.getPwd_salt(), "");
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            System.out.println("Unable to decrypt password");
            return "";
        }
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }

    public void setBasicAuthority(String string, String string2, String string3) {
        this.authType = 1;
        this.authUser = string;
        this.pwd_encrypted = string2;
        this.pwd_salt = string3;
    }

    public void resetAuthority() {
        this.authType = 0;
        this.authUser = null;
        this.pwd_salt = null;
        this.pwd_encrypted = null;
    }

    public String[] doNotInvoke() {
        return null;
    }

    public boolean getTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean bl) {
        this.trustAll = bl;
    }

    public long getOID() {
        return this.OID;
    }

    public void setOID(long l) {
        this.OID = l;
    }

    public String getPwd_salt() {
        return this.pwd_salt;
    }

    public void setPwd_salt(String string) {
        this.pwd_salt = string;
    }

    public String getPwd_encrypted() {
        return this.pwd_encrypted;
    }

    public void setPwd_encrypted(String string) {
        this.pwd_encrypted = string;
    }
}

