/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.SNMPMibCriteria;
import java.io.Serializable;
import junit.framework.TestCase;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SNMPMibCriteriaTest
extends TestCase {
    private SNMPMibCriteria crit;

    protected void setUp() throws Exception {
        super.setUp();
        this.crit = new SNMPMibCriteria(".2", (Serializable)((Object)"good"), 0);
    }

    protected void tearDown() throws Exception {
        this.crit = null;
        super.tearDown();
    }

    public void testNoArgConstructor() {
        SNMPMibCriteria sNMPMibCriteria = new SNMPMibCriteria();
        SNMPMibCriteriaTest.assertNotNull((Object)((Object)sNMPMibCriteria));
        SNMPMibCriteriaTest.assertTrue((boolean)(sNMPMibCriteria instanceof SNMPMibCriteria));
    }

    public void testNoMatchOtherObject() {
        Object object = new Object();
        SNMPMibCriteriaTest.assertFalse((boolean)this.crit.matches(object));
    }

    public void testMatchV1Trap() {
        SnmpVarBind snmpVarBind = new SnmpVarBind(".1");
        snmpVarBind.setValue((SnmpSyntax)new SnmpOctetString("bad".getBytes()));
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(".2");
        snmpVarBind2.setValue((SnmpSyntax)new SnmpOctetString("good".getBytes()));
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.addVarBind(snmpVarBind);
        snmpPduTrap.addVarBind(snmpVarBind2);
        SNMPMibCriteriaTest.assertTrue((boolean)this.crit.matches(snmpPduTrap));
    }

    public void testNoMatchV1Trap() {
        SnmpVarBind snmpVarBind = new SnmpVarBind(".1");
        snmpVarBind.setValue((SnmpSyntax)new SnmpOctetString("good".getBytes()));
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(".2");
        snmpVarBind2.setValue((SnmpSyntax)new SnmpOctetString("bad".getBytes()));
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.addVarBind(snmpVarBind);
        snmpPduTrap.addVarBind(snmpVarBind2);
        SNMPMibCriteriaTest.assertFalse((boolean)this.crit.matches(snmpPduTrap));
    }

    public void testNoFieldV1Trap() {
        SnmpVarBind snmpVarBind = new SnmpVarBind(".1");
        snmpVarBind.setValue((SnmpSyntax)new SnmpOctetString("good".getBytes()));
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.addVarBind(snmpVarBind);
        SNMPMibCriteriaTest.assertFalse((boolean)this.crit.matches(snmpPduTrap));
    }

    public void testMatchV2Trap() {
        SnmpVarBind snmpVarBind = new SnmpVarBind(".1");
        snmpVarBind.setValue((SnmpSyntax)new SnmpOctetString("bad".getBytes()));
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(".2");
        snmpVarBind2.setValue((SnmpSyntax)new SnmpOctetString("good".getBytes()));
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.addVarBind(snmpVarBind);
        snmpPduRequest.addVarBind(snmpVarBind2);
        SNMPMibCriteriaTest.assertTrue((boolean)this.crit.matches(snmpPduRequest));
    }

    public void testNoMatchV2Trap() {
        SnmpVarBind snmpVarBind = new SnmpVarBind(".1");
        snmpVarBind.setValue((SnmpSyntax)new SnmpOctetString("good".getBytes()));
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(".2");
        snmpVarBind2.setValue((SnmpSyntax)new SnmpOctetString("bad".getBytes()));
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.addVarBind(snmpVarBind);
        snmpPduRequest.addVarBind(snmpVarBind2);
        SNMPMibCriteriaTest.assertFalse((boolean)this.crit.matches(snmpPduRequest));
    }

    public void testNoFieldV2Trap() {
        SnmpVarBind snmpVarBind = new SnmpVarBind(".1");
        snmpVarBind.setValue((SnmpSyntax)new SnmpOctetString("good".getBytes()));
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.addVarBind(snmpVarBind);
        SNMPMibCriteriaTest.assertFalse((boolean)this.crit.matches(snmpPduRequest));
    }
}

