/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.busobj.JobCondition;

public class JobConditionMessageGenerator {
    public static String getConditionMessage(JobCondition jobCondition) {
        switch (jobCondition.getConditionType()) {
            case PROCESS: {
                if (jobCondition.getConditionData() != null && !jobCondition.getConditionData().isEmpty() && jobCondition.getConditionData1() != null && !jobCondition.getConditionData1().isEmpty()) {
                    return "A process that " + JobConditionMessageGenerator.getProcessVar(jobCondition.getConditionVar1()) + " '" + jobCondition.getConditionData() + "' and is owned by username that " + JobConditionMessageGenerator.getProcessUserVar(jobCondition.getConditionVar2()) + " '" + jobCondition.getConditionData1() + "' is " + (jobCondition.isConditionChoice() ? "active" : "not active");
                }
                if (jobCondition.getConditionData() != null && !jobCondition.getConditionData().isEmpty()) {
                    return "A process that " + JobConditionMessageGenerator.getProcessVar(jobCondition.getConditionVar1()) + " '" + jobCondition.getConditionData() + "' is " + (jobCondition.isConditionChoice() ? "active" : "not active");
                }
                if (jobCondition.getConditionData1() != null && !jobCondition.getConditionData1().isEmpty()) {
                    return "Process owned by username that " + JobConditionMessageGenerator.getProcessUserVar(jobCondition.getConditionVar2()) + " '" + jobCondition.getConditionData1() + "' is " + (jobCondition.isConditionChoice() ? "active" : "not active");
                }
            }
            case DRIVE_SPACE: {
                return "Minimum Drive Space of '" + jobCondition.getConditionVar2() + "' " + JobConditionMessageGenerator.getSpaceVar(jobCondition.getConditionVar1()) + " is " + (jobCondition.isConditionChoice() ? "available" : "not available") + " in Directory '" + jobCondition.getConditionData() + "'";
            }
            case SERVER_SERVICE_TCP: 
            case FILE_TRANSFER_SYSTEM: {
                return "TCP Server Name/IP named '" + jobCondition.getConditionData() + "' and Service/Port '" + jobCondition.getConditionVar1() + "' is " + (jobCondition.isConditionChoice() ? "available" : "not available");
            }
            case FILE: {
                return "File named '" + jobCondition.getConditionData() + "' is " + (jobCondition.isConditionChoice() ? "present" : "not present");
            }
            case FOLDER: {
                return "Directory named '" + jobCondition.getConditionData() + "' is " + (jobCondition.isConditionChoice() ? "present" : "not present");
            }
        }
        throw new IllegalArgumentException("Job Condition Type is not valid: " + jobCondition.getConditionType());
    }

    public static String getConditionFailedMessage(JobCondition jobCondition) {
        switch (jobCondition.getConditionType()) {
            case PROCESS: {
                if (jobCondition.getConditionData() != null && !jobCondition.getConditionData().isEmpty() && jobCondition.getConditionData1() != null && !jobCondition.getConditionData1().isEmpty()) {
                    return "A process that " + JobConditionMessageGenerator.getProcessVar(jobCondition.getConditionVar1()) + " '" + jobCondition.getConditionData() + "' and is owned by username that " + JobConditionMessageGenerator.getProcessUserVar(jobCondition.getConditionVar2()) + " '" + jobCondition.getConditionData1() + "' is " + (jobCondition.isConditionChoice() ? "active" : "not active");
                }
                if (jobCondition.getConditionData() != null && !jobCondition.getConditionData().isEmpty()) {
                    return "A process that " + JobConditionMessageGenerator.getProcessVar(jobCondition.getConditionVar1()) + " '" + jobCondition.getConditionData() + "' is " + (jobCondition.isConditionChoice() ? "active" : "not active");
                }
                if (jobCondition.getConditionData1() != null && !jobCondition.getConditionData1().isEmpty()) {
                    return "A process owned by username that " + JobConditionMessageGenerator.getProcessUserVar(jobCondition.getConditionVar2()) + " '" + jobCondition.getConditionData1() + "' is " + (jobCondition.isConditionChoice() ? "active" : "not active");
                }
            }
            case DRIVE_SPACE: {
                return "Minimum Drive Space of '" + jobCondition.getConditionVar2() + "' " + JobConditionMessageGenerator.getSpaceVar(jobCondition.getConditionVar1()) + " is " + (jobCondition.isConditionChoice() ? "not available" : "available") + " in Directory '" + jobCondition.getConditionData() + "'";
            }
            case SERVER_SERVICE_TCP: 
            case FILE_TRANSFER_SYSTEM: {
                return "TCP Server Name/IP named '" + jobCondition.getConditionData() + "' and Service/Port '" + jobCondition.getConditionVar1() + "' is " + (jobCondition.isConditionChoice() ? "not available" : "available");
            }
            case FILE: {
                return "File named '" + jobCondition.getConditionData() + "' is " + (jobCondition.isConditionChoice() ? "not present" : "present");
            }
            case FOLDER: {
                return "Directory named '" + jobCondition.getConditionData() + "' is " + (jobCondition.isConditionChoice() ? "not present" : "present");
            }
        }
        throw new IllegalArgumentException("Job Condition Type is not valid: " + jobCondition.getConditionType());
    }

    private static String getProcessVar(int n) {
        switch (n) {
            case 1: {
                return "begins with";
            }
            case 2: {
                return "contains";
            }
            case 3: {
                return "ends with";
            }
        }
        return null;
    }

    private static String getProcessUserVar(int n) {
        switch (n) {
            case 1: {
                return "begins with";
            }
            case 0: {
                return "contains";
            }
            case 2: {
                return "is";
            }
            case 3: {
                return "isn't";
            }
        }
        return null;
    }

    private static String getSpaceVar(int n) {
        switch (n) {
            case 1: {
                return "KB";
            }
            case 2: {
                return "MB";
            }
            case 3: {
                return "GB";
            }
            case 4: {
                return "TB";
            }
        }
        return null;
    }
}

