/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.HSSnmpPduPacket;
import java.net.InetAddress;
import junit.framework.TestCase;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpVarBind;

public class HSSnmpPduPacketTest
extends TestCase {
    private String hostname;
    private SnmpPduPacket pduPacket;
    private SnmpVarBind var0;
    private SnmpVarBind var1;
    private HSSnmpPduPacket packet;

    protected void setUp() throws Exception {
        super.setUp();
        this.var0 = new SnmpVarBind("zero");
        this.var1 = new SnmpVarBind("one");
        this.pduPacket = new SnmpPduRequest(0, new SnmpVarBind[]{this.var0, this.var1});
        this.hostname = InetAddress.getLocalHost().toString();
        this.packet = new HSSnmpPduPacket(this.pduPacket, InetAddress.getLocalHost(), new SnmpOctetString(), 1234);
    }

    protected void tearDown() throws Exception {
        this.packet = null;
        this.pduPacket = null;
        this.var0 = null;
        this.var1 = null;
        this.hostname = null;
        super.tearDown();
    }

    public void testGetHostName() {
        String string = this.hostname;
        String string2 = this.packet.getHostName();
        HSSnmpPduPacketTest.assertEquals((String)string, (String)string2);
    }

    public void testSetCommunity() {
        SnmpOctetString snmpOctetString = new SnmpOctetString("community".getBytes());
        this.packet.setCommunity(snmpOctetString);
        HSSnmpPduPacketTest.assertEquals((String)snmpOctetString.toString(), (String)this.packet.getCommunity().toString());
    }

    public void testSetPort() {
        this.packet.setPort(4321);
        HSSnmpPduPacketTest.assertEquals((int)4321, (int)this.packet.getPort());
    }

    public void testSetSendingAddress() throws Exception {
        InetAddress inetAddress = InetAddress.getByAddress(new byte[]{10, 20, 30, 40});
        this.packet.setSendingAddress(inetAddress);
        HSSnmpPduPacketTest.assertEquals((Object)inetAddress, (Object)this.packet.getSendingAddress());
    }

    public void testCloneReturnsNull() {
        HSSnmpPduPacketTest.assertNull((Object)this.packet.clone());
    }

    public void testDuplicateReturnsNull() {
        HSSnmpPduPacketTest.assertNull((Object)this.packet.duplicate());
    }
}

