/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.util.StringTokenizer;

public class ArrayTokenizer {
    private static final String tabChar = "\t";
    private static final String TAB_STR = "{{tab}}";
    private static final String TAB_STR_REGEX = "\\{\\{tab\\}\\}";
    private static final String NULL_STR = "{{null}}";
    private static final String BLANK_STR = "{{blank}}";

    private ArrayTokenizer() {
    }

    public static String tokenateArray(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                stringBuffer.append(NULL_STR);
            } else if (stringArray[i].length() == 0) {
                stringBuffer.append(BLANK_STR);
            } else if (stringArray[i].contains(tabChar)) {
                stringBuffer.append(stringArray[i].replaceAll(tabChar, TAB_STR));
            } else {
                stringBuffer.append(stringArray[i]);
            }
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(tabChar);
        }
        return stringBuffer.toString();
    }

    public static String[] tokenizeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, tabChar);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            stringArray[n] = string2.equals(BLANK_STR) ? "" : (string2.equals(NULL_STR) ? null : (string2.contains(TAB_STR) ? string2.replaceAll(TAB_STR_REGEX, tabChar) : string2));
            ++n;
        }
        return stringArray;
    }
}

