/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.ScheduledTime;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class ScheduledTimeTest
extends TestCase {
    private ScheduledTime st;

    public ScheduledTimeTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.st = new ScheduledTime();
    }

    protected void tearDown() throws Exception {
        this.st = null;
        super.tearDown();
    }

    public void testToString() {
        String string = "at: null|cst: null|nst: null";
        String string2 = this.st.toString();
        ScheduledTimeTest.assertEquals((String)string, (String)string2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("CDT"));
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 5);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, 13);
        gregorianCalendar.set(12, 20);
        gregorianCalendar.set(13, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("CDT"));
        gregorianCalendar2.set(1, 2010);
        gregorianCalendar2.set(2, 5);
        gregorianCalendar2.set(5, 15);
        gregorianCalendar2.set(11, 14);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar(TimeZone.getTimeZone("CDT"));
        gregorianCalendar3.set(1, 2010);
        gregorianCalendar3.set(2, 5);
        gregorianCalendar3.set(5, 15);
        gregorianCalendar3.set(11, 14);
        gregorianCalendar3.set(12, 30);
        gregorianCalendar3.set(13, 0);
        this.st.setConsideredAtDateTime(gregorianCalendar);
        this.st.setConsideredScheduledTime(gregorianCalendar2);
        this.st.setNextScheduledTime(gregorianCalendar3);
        string = "at: 2010-06-15 13:20 GMT|cst: 2010-06-15 14:00 GMT|nst: 2010-06-15 14:30 GMT";
        string2 = this.st.toString();
        ScheduledTimeTest.assertEquals((String)string, (String)string2);
    }

    public void testSetPersistent() {
        this.st.setPersistent(false);
        ScheduledTimeTest.assertFalse((boolean)this.st.isPersistent());
        this.st.setPersistent(true);
        ScheduledTimeTest.assertTrue((boolean)this.st.isPersistent());
    }

    public void testSetJobNumber() {
        this.st.setJobNumber(12345);
        ScheduledTimeTest.assertEquals((int)12345, (int)this.st.getJobNumber());
        try {
            this.st.setJobNumber(34567);
            ScheduledTimeTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.st.setJobNumber(12345);
    }

    public void testSetUpdateCounter() {
        this.st.setUpdateCounter(1234);
        ScheduledTimeTest.assertEquals((int)1234, (int)this.st.getUpdateCounter());
    }

    public void testSetSystem() {
        this.st.setSystem(54321);
        ScheduledTimeTest.assertEquals((int)54321, (int)this.st.getSystem());
    }

    public void testGetConsideredAtDateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.st.setConsideredAtDateTime(gregorianCalendar);
        ScheduledTimeTest.assertEquals((Object)gregorianCalendar, (Object)this.st.getConsideredAtDateTime());
    }

    public void testGetConsideredScheduledTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.st.setConsideredScheduledTime(gregorianCalendar);
        ScheduledTimeTest.assertEquals((Object)gregorianCalendar, (Object)this.st.getConsideredScheduledTime());
    }

    public void testGetJobNumber() {
        this.st.setJobNumber(12345);
        ScheduledTimeTest.assertEquals((int)12345, (int)this.st.getJobNumber());
    }

    public void testGetNextScheduledTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.st.setNextScheduledTime(gregorianCalendar);
        ScheduledTimeTest.assertEquals((Object)gregorianCalendar, (Object)this.st.getNextScheduledTime());
    }

    public void testSetMaintainedAtDateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.st.setMaintainedAtDateTime(gregorianCalendar);
        ScheduledTimeTest.assertEquals((Object)gregorianCalendar, (Object)this.st.getMaintainedAtDateTime());
    }

    public void testValidateRequiresJobNumber() {
        this.st.setSystem(12345);
        try {
            this.st.validate();
            ScheduledTimeTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValidateRequiresSystem() {
        this.st.setJobNumber(12345);
        try {
            this.st.validate();
            ScheduledTimeTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValidateShouldNotThrowException() {
        this.st.setSystem(12345);
        this.st.setJobNumber(34567);
        this.st.validate();
    }
}

