/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.scheduler.JobHoldFlag;
import com.helpsystems.enterprise.core.scheduler.MissedJobAction;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobBigProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import junit.framework.TestCase;

public class ScheduleJobBigProxyTest
extends TestCase {
    private ScheduleJobBigProxy proxy;

    protected void setUp() throws Exception {
        super.setUp();
        this.proxy = new ScheduleJobBigProxy();
    }

    protected void tearDown() throws Exception {
        this.proxy = null;
        super.tearDown();
    }

    public void testSetSkybotJobNumber() {
        this.proxy.setSkybotJobNumber(12345L);
        ScheduleJobBigProxyTest.assertEquals((long)12345L, (long)this.proxy.getSkybotJobNumber());
        this.proxy.setSkybotJobNumber(12345L);
        ScheduleJobBigProxyTest.assertEquals((long)12345L, (long)this.proxy.getSkybotJobNumber());
        try {
            this.proxy.setSkybotJobNumber(54321L);
            ScheduleJobBigProxyTest.fail((String)"Changes to the job number should not be allowed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetSkybotJobName() {
        this.proxy.setSkybotJobName("job_name");
        ScheduleJobBigProxyTest.assertEquals((String)"job_name", (String)this.proxy.getSkybotJobName());
    }

    public void testSetJobHoldFlag() {
        this.proxy.setJobHoldFlag(JobHoldFlag.HELD);
        ScheduleJobBigProxyTest.assertEquals((Object)JobHoldFlag.HELD, (Object)this.proxy.getJobHoldFlag());
    }

    public void testSetHoldTimes() {
        this.proxy.setHoldTimes(123);
        ScheduleJobBigProxyTest.assertEquals((int)123, (int)this.proxy.getHoldTimes());
    }

    public void testSetHeldCount() {
        this.proxy.setHeldCount(23);
        ScheduleJobBigProxyTest.assertEquals((int)23, (int)this.proxy.getHeldCount());
    }

    public void testSetHoldOnFailure() {
        this.proxy.setHoldOnFailure(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isHoldOnFailure());
        this.proxy.setHoldOnFailure(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isHoldOnFailure());
    }

    public void testSetScheduleType() {
        this.proxy.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        ScheduleJobBigProxyTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_COUNT, (Object)this.proxy.getScheduleType());
    }

    public void testSetMissedJobAction() {
        this.proxy.setMissedJobAction(MissedJobAction.IGNORE);
        ScheduleJobBigProxyTest.assertEquals((Object)MissedJobAction.IGNORE, (Object)this.proxy.getMissedJobAction());
    }

    public void testSetOverrunTargetCompletionTime() {
        this.proxy.setOverrunTargetCompletionTime(123456);
        ScheduleJobBigProxyTest.assertEquals((int)123456, (int)this.proxy.getOverrunTargetCompletionTime());
    }

    public void testSetOverrunMonitorSelected() {
        this.proxy.setOverrunMonitorSelected(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isOverrunMonitorSelected());
        this.proxy.setOverrunMonitorSelected(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isOverrunMonitorSelected());
    }

    public void testSetOverrunMonitorOption() {
        this.proxy.setOverrunMonitorOption(JobMonitor.MonitorOption.RUN_DURATION);
        ScheduleJobBigProxyTest.assertEquals((Object)JobMonitor.MonitorOption.RUN_DURATION, (Object)this.proxy.getOverrunMonitorOption());
    }

    public void testSetOverrunMaximumMinutes() {
        this.proxy.setOverrunMaximumMinutes(135);
        ScheduleJobBigProxyTest.assertEquals((int)135, (int)this.proxy.getOverrunMaximumMinutes());
    }

    public void testSetOverrunSendSNMPTrap() {
        this.proxy.setOverrunSendSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isOverrunSendSNMPTrap());
        this.proxy.setOverrunSendSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isOverrunSendSNMPTrap());
    }

    public void testSetOverrunSendEmail() {
        this.proxy.setOverrunSendEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isOverrunSendEmail());
        this.proxy.setOverrunSendEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isOverrunSendEmail());
    }

    public void testSetOverrunEndJob() {
        this.proxy.setOverrunEndJob(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isOverrunEndJob());
        this.proxy.setOverrunEndJob(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isOverrunEndJob());
    }

    public void testSetOverrunNotificationListID() {
        this.proxy.setOverrunNotificationListID(13579L);
        ScheduleJobBigProxyTest.assertEquals((long)13579L, (long)this.proxy.getOverrunNotificationListID());
    }

    public void testSetUnderrunMonitorSelected() {
        this.proxy.setUnderrunMonitorSelected(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isUnderrunMonitorSelected());
        this.proxy.setUnderrunMonitorSelected(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isUnderrunMonitorSelected());
    }

    public void testSetUnderrunMinimumMinutes() {
        this.proxy.setUnderrunMinimumMinutes(13);
        ScheduleJobBigProxyTest.assertEquals((int)13, (int)this.proxy.getUnderrunMinimumMinutes());
    }

    public void testSetUnderrunSendSNMPTrap() {
        this.proxy.setUnderrunSendSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isUnderrunSendSNMPTrap());
        this.proxy.setUnderrunSendSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isUnderrunSendSNMPTrap());
    }

    public void testSetUnderrunSendEmail() {
        this.proxy.setUnderrunSendEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isUnderrunSendEmail());
        this.proxy.setUnderrunSendEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isUnderrunSendEmail());
    }

    public void testSetUnderrunNotificationListID() {
        this.proxy.setUnderrunNotificationListID(24680L);
        ScheduleJobBigProxyTest.assertEquals((long)24680L, (long)this.proxy.getUnderrunNotificationListID());
    }

    public void testSetLateStartMonitorSelected() {
        this.proxy.setLateStartMonitorSelected(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isLateStartMonitorSelected());
        this.proxy.setLateStartMonitorSelected(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isLateStartMonitorSelected());
    }

    public void testSetLateStartMonitorOption() {
        this.proxy.setLateStartMonitorOption(JobMonitor.MonitorOption.RUN_DURATION);
        ScheduleJobBigProxyTest.assertEquals((Object)JobMonitor.MonitorOption.RUN_DURATION, (Object)this.proxy.getLateStartMonitorOption());
    }

    public void testSetLateStartMaximumMinutes() {
        this.proxy.setLateStartMaximumMinutes(246);
        ScheduleJobBigProxyTest.assertEquals((int)246, (int)this.proxy.getLateStartMaximumMinutes());
    }

    public void testSetLateStartTargetStartTime() {
        this.proxy.setLateStartTargetStartTime(654321);
        ScheduleJobBigProxyTest.assertEquals((int)654321, (int)this.proxy.getLateStartTargetStartTime());
    }

    public void testSetLateStartSendSNMPTrap() {
        this.proxy.setLateStartSendSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isLateStartSendSNMPTrap());
        this.proxy.setLateStartSendSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isLateStartSendSNMPTrap());
    }

    public void testSetLateStartSendEmail() {
        this.proxy.setLateStartSendEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isLateStartSendEmail());
        this.proxy.setLateStartSendEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isLateStartSendEmail());
    }

    public void testSetLateStartEndJob() {
        this.proxy.setLateStartEndJob(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isLateStartEndJob());
        this.proxy.setLateStartEndJob(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isLateStartEndJob());
    }

    public void testSetLateStartNotificationListID() {
        this.proxy.setLateStartNotificationListID(23571113L);
        ScheduleJobBigProxyTest.assertEquals((long)23571113L, (long)this.proxy.getLateStartNotificationListID());
    }

    public void testSetSendSubmitSNMPTrap() {
        this.proxy.setSendSubmitSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendSubmitSNMPTrap());
        this.proxy.setSendSubmitSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendSubmitSNMPTrap());
    }

    public void testSetSendSubmitEmail() {
        this.proxy.setSendSubmitEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendSubmitEmail());
        this.proxy.setSendSubmitEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendSubmitEmail());
    }

    public void testSetSubmitNotificationListID() {
        this.proxy.setSubmitNotificationListID(23571113L);
        ScheduleJobBigProxyTest.assertEquals((long)23571113L, (long)this.proxy.getSubmitNotificationListID());
    }

    public void testSetSendRunSNMPTrap() {
        this.proxy.setSendRunSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendRunSNMPTrap());
        this.proxy.setSendRunSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendRunSNMPTrap());
    }

    public void testSetSendRunEmail() {
        this.proxy.setSendRunEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendRunEmail());
        this.proxy.setSendRunEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendRunEmail());
    }

    public void testSetRunNotificationListID() {
        this.proxy.setRunNotificationListID(46891012L);
        ScheduleJobBigProxyTest.assertEquals((long)46891012L, (long)this.proxy.getRunNotificationListID());
    }

    public void testSetSendCompleteSNMPTrap() {
        this.proxy.setSendCompleteSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendCompleteSNMPTrap());
        this.proxy.setSendCompleteSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendCompleteSNMPTrap());
    }

    public void testSetSendCompleteEmail() {
        this.proxy.setSendCompleteEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendCompleteEmail());
        this.proxy.setSendCompleteEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendCompleteEmail());
    }

    public void testSetCompleteNotificationListID() {
        this.proxy.setCompleteNotificationListID(46891012L);
        ScheduleJobBigProxyTest.assertEquals((long)46891012L, (long)this.proxy.getCompleteNotificationListID());
    }

    public void testSetSendFailSNMPTrap() {
        this.proxy.setSendFailSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendFailSNMPTrap());
        this.proxy.setSendFailSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendFailSNMPTrap());
    }

    public void testSetSendFailEmail() {
        this.proxy.setSendFailEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendFailEmail());
        this.proxy.setSendFailEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendFailEmail());
    }

    public void testSetFailNotificationListID() {
        this.proxy.setFailNotificationListID(1491625L);
        ScheduleJobBigProxyTest.assertEquals((long)1491625L, (long)this.proxy.getFailNotificationListID());
    }

    public void testSetSendCancelSNMPTrap() {
        this.proxy.setSendCancelSNMPTrap(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendCancelSNMPTrap());
        this.proxy.setSendCancelSNMPTrap(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendCancelSNMPTrap());
    }

    public void testSetSendCancelEmail() {
        this.proxy.setSendCancelEmail(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isSendCancelEmail());
        this.proxy.setSendCancelEmail(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isSendCancelEmail());
    }

    public void testSetCancelNotificationListID() {
        this.proxy.setCancelNotificationListID(31415927L);
        ScheduleJobBigProxyTest.assertEquals((long)31415927L, (long)this.proxy.getCancelNotificationListID());
    }

    public void testSetUseDefaultsForJobHistoryPurge() {
        this.proxy.setUseDefaultsForJobHistoryPurge(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isUseDefaultsForJobHistoryPurge());
        this.proxy.setUseDefaultsForJobHistoryPurge(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isUseDefaultsForJobHistoryPurge());
    }

    public void testSetPurgeJobHistory() {
        this.proxy.setPurgeJobHistory(false);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isPurgeJobHistory());
        this.proxy.setPurgeJobHistory(true);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isPurgeJobHistory());
    }

    public void testSetJobHistoriesToKeep() {
        this.proxy.setJobHistoriesToKeep(13579);
        ScheduleJobBigProxyTest.assertEquals((int)13579, (int)this.proxy.getJobHistoriesToKeep());
    }

    public void testIsJobHeld() {
        this.proxy.setJobHoldFlag(JobHoldFlag.NOT_HELD);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isJobHeld());
        this.proxy.setJobHoldFlag(JobHoldFlag.HELD);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isJobHeld());
        this.proxy.setJobHoldFlag(JobHoldFlag.HELD_FOR_X_TIMES);
        this.proxy.setHoldTimes(5);
        this.proxy.setHeldCount(4);
        ScheduleJobBigProxyTest.assertTrue((boolean)this.proxy.isJobHeld());
        this.proxy.setHeldCount(5);
        ScheduleJobBigProxyTest.assertFalse((boolean)this.proxy.isJobHeld());
    }
}

