/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DSTHelper;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_CronExpression;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DateList;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayCount;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfPeriod;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_TimedInterval;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class ScheduleInfo {
    private static final long serialVersionUID = -2950619845462425161L;
    private ScheduleJobProxy.ScheduleType scheduleType;
    private TimeZoneType timeZoneType;
    private int updateCounter;
    private CalendarObject calendarObject;
    private DateObject omitDates;
    private NonWorkdayOption nonWorkdayOption;
    private String jobTimezone;
    private boolean lateStartJob;
    private int targetID;
    private TargetType targetType;
    private AgentGroupType agentGroupType;
    private static ThreadLocal<Boolean> suppressScheduleLogEntry = new ThreadLocal();

    public static void setSuppressScheduleLogEntry(boolean bl) {
        suppressScheduleLogEntry.set(bl);
    }

    protected ScheduleInfo(ScheduleJobProxy.ScheduleType scheduleType) {
        ValidationHelper.checkForNull((String)"Schedule type", (Object)scheduleType);
        this.scheduleType = scheduleType;
    }

    public AgentGroupType getAgentGroupType() {
        return this.agentGroupType;
    }

    public CalendarObject getCalendarObject() {
        return this.calendarObject;
    }

    public String getJobTimezone() {
        return this.jobTimezone;
    }

    public NonWorkdayOption getNonWorkdayOption() {
        return this.nonWorkdayOption;
    }

    public DateObject getOmitDates() {
        return this.omitDates;
    }

    public ScheduleJobProxy.ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public int getTargetID() {
        return this.targetID;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public TimeZoneType getTimeZoneType() {
        return this.timeZoneType;
    }

    public int getUpdateCounter() {
        return this.updateCounter;
    }

    public boolean isLateStartJob() {
        return this.lateStartJob;
    }

    public void setAgentGroupType(AgentGroupType agentGroupType) {
        this.agentGroupType = agentGroupType;
    }

    public void setCalendarObject(CalendarObject calendarObject) {
        ValidationHelper.checkForNull((String)"CalendarObject", (Object)calendarObject);
        this.calendarObject = calendarObject;
    }

    public void setJobTimezone(String string) {
        this.jobTimezone = string;
    }

    public void setLateStartJob(boolean bl) {
        this.lateStartJob = bl;
    }

    public void setNonWorkdayOption(NonWorkdayOption nonWorkdayOption) {
        ValidationHelper.checkForNull((String)"Non-Workday Option", (Object)nonWorkdayOption);
        this.nonWorkdayOption = nonWorkdayOption;
    }

    public void setOmitDates(DateObject dateObject) {
        this.omitDates = dateObject;
    }

    public void setScheduleType(ScheduleJobProxy.ScheduleType scheduleType) {
        ValidationHelper.checkForNull((String)"Schedule type", (Object)scheduleType);
        this.scheduleType = scheduleType;
    }

    public void setTargetID(int n) {
        this.targetID = n;
    }

    public void setTargetType(TargetType targetType) {
        ValidationHelper.checkForNull((String)"Target Type", (Object)targetType);
        this.targetType = targetType;
    }

    public void setTimeZoneToUse(TimeZoneType timeZoneType) {
        ValidationHelper.checkForNull((String)"TimeZone Type", (Object)timeZoneType);
        this.timeZoneType = timeZoneType;
    }

    public void setUpdateCounter(int n) {
        this.updateCounter = n;
    }

    public void validate() {
        ValidationHelper.validateReqFieldNotNull((String)"Calendar", (Object)this.calendarObject);
        ValidationHelper.validateReqFieldNotNull((String)"Schedule Type", (Object)this.scheduleType);
        ValidationHelper.validateReqFieldNotNull((String)"TimeZone Type", (Object)this.timeZoneType);
        if (this.timeZoneType == TimeZoneType.JOB) {
            ValidationHelper.validateReqFieldNotNull((String)"Job TimeZone", (Object)this.jobTimezone);
        }
    }

    public static ScheduleInfo createScheduleInfoOfType(ScheduleJobProxy.ScheduleType scheduleType) {
        switch (scheduleType) {
            case DAY_COUNT: {
                return new ScheduleInfo_DayCount();
            }
            case DAY_OF_PERIOD: {
                return new ScheduleInfo_DayOfPeriod();
            }
            case DAY_OF_WEEK: {
                return new ScheduleInfo_DayOfWeek();
            }
            case DATE_LIST: {
                return new ScheduleInfo_DateList();
            }
            case TIMED_INTERVAL: {
                return new ScheduleInfo_TimedInterval();
            }
            case CRON_EXPRESSION: {
                return new ScheduleInfo_CronExpression();
            }
        }
        throw new IllegalArgumentException("Unrecognized schedule type: " + scheduleType);
    }

    protected void advanceOneDay(Calendar calendar) {
        try {
            DSTHelper.addDays(calendar, 1);
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            calendar = invalidDateTimeException.getMovedInvalidDateTime();
        }
    }

    protected Calendar adjustForNonWorkdayIfNecessary(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        ScheduleLogEntry scheduleLogEntry;
        if (calendar == null || this.calendarObject.isWorkday(calendar)) {
            return calendar;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        switch (this.nonWorkdayOption) {
            case RUN: {
                return calendar;
            }
            case DO_NOT_RUN: {
                String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime())};
                scheduleLogEntry = RosettaMsg.SKIP_NON_WORKDAY_RUN_DO_NOT_RUN.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
                calendar = null;
                break;
            }
            case RUN_ON_NEAREST_PRIOR_WORKDAY: {
                Calendar calendar2;
                try {
                    calendar2 = this.calendarObject.addDays(-1, CalendarObject.DayType.WORKDAYS, calendar);
                    calendar2 = this.restoreOriginalTime(calendar2);
                }
                catch (InvalidDateTimeException invalidDateTimeException) {
                    calendar2 = invalidDateTimeException.getMovedInvalidDateTime();
                }
                Calendar calendar3 = Calendar.getInstance();
                if (calendar2.before(calendar3)) {
                    return this.calcNST(calendar, jobInfo, timeZone);
                }
                if (this.isOmitDate(calendar2)) {
                    String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(calendar2.getTime()), this.omitDates.getName()};
                    scheduleLogEntry = RosettaMsg.SKIP_NON_WORKDAY_RUN_PRIOR_WORKDAY_IS_OMIT.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
                    calendar = null;
                    break;
                }
                if (this.isRunDay(calendar2, jobInfo)) {
                    String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(calendar2.getTime())};
                    scheduleLogEntry = RosettaMsg.SKIP_NON_WORKDAY_RUN_PRIOR_WORKDAY_IS_RUNDAY.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
                    calendar = null;
                    break;
                }
                String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(calendar2.getTime())};
                scheduleLogEntry = RosettaMsg.MOVE_NON_WORKDAY_RUN_TO_PRIOR_WORKDAY.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
                calendar = new MovedNST(calendar2, calendar);
                break;
            }
            case RUN_ON_NEAREST_SUBSEQUENT_WORKDAY: {
                Calendar calendar4;
                try {
                    calendar4 = this.calendarObject.addDays(1, CalendarObject.DayType.WORKDAYS, calendar);
                    calendar4 = this.restoreOriginalTime(calendar4);
                }
                catch (InvalidDateTimeException invalidDateTimeException) {
                    calendar4 = invalidDateTimeException.getMovedInvalidDateTime();
                }
                if (this.isOmitDate(calendar4)) {
                    String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(calendar4.getTime()), this.omitDates.getName()};
                    scheduleLogEntry = RosettaMsg.SKIP_NON_WORKDAY_RUN_SUBSEQUENT_WORKDAY_IS_OMIT.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
                    calendar = null;
                    break;
                }
                if (this.isRunDay(calendar4, jobInfo)) {
                    String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(calendar4.getTime())};
                    scheduleLogEntry = RosettaMsg.SKIP_NON_WORKDAY_RUN_SUBSEQUENT_WORKDAY_IS_RUNDAY.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
                    calendar = null;
                    break;
                }
                String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(calendar4.getTime())};
                scheduleLogEntry = RosettaMsg.MOVE_NON_WORKDAY_RUN_TO_SUBSEQUENT_WORKDAY.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
                calendar = new MovedNST(calendar4, calendar);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized Run on Non-workday option: " + this.nonWorkdayOption);
            }
        }
        this.writeScheduleLogEntry(scheduleLogEntry);
        return calendar;
    }

    protected Calendar calculateMaximumTimeHorizon(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, 3);
        return calendar2;
    }

    protected String formatAsYyyymmdd(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        return simpleDateFormat.format(calendar.getTime());
    }

    protected boolean isOmitDate(Calendar calendar) {
        if (this.omitDates == null) {
            return false;
        }
        int n = this.calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar);
        return this.omitDates.contains(n);
    }

    protected boolean isOmitDate(int n) {
        return this.omitDates != null && this.omitDates.contains(n);
    }

    protected void logThatJobWasOmitted(Calendar calendar, JobInfo jobInfo) {
        if (!this.isSuppressScheduleLogEntry()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            String[] stringArray = new String[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime()), this.omitDates.getName()};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.SCHEDULED_JOB_RUN_OMITTED.newLogEntry(stringArray, jobInfo.getAgentID(), jobInfo.getJobID());
            this.writeScheduleLogEntry(scheduleLogEntry);
        }
    }

    protected String maximumTimeHorizonExceededErrorText(Calendar calendar) {
        return MessageUtil.formatMsg((String)"Searched 3 years (out to {0}) without being able to find the next date and time that the job should run. Within this time horizon, either no rundays met the scheduling rule for this job or every potential runday got negated by exception scheduling.", (Object[])new Object[]{this.formatAsYyyymmdd(calendar)});
    }

    protected void writeScheduleLogEntry(ScheduleLogEntry scheduleLogEntry) {
        if (!this.isSuppressScheduleLogEntry()) {
            ScheduleLogger.write(scheduleLogEntry);
        }
    }

    public String toString() {
        String string = "Schedule type: " + this.scheduleType + "|Timezone type: " + this.timeZoneType + "|Calendar: " + this.calendarObject.getName();
        if (this.omitDates != null) {
            string = string + "|Omit Date List: " + this.omitDates.getName();
        }
        return string;
    }

    public abstract Calendar calcNST(Calendar var1, JobInfo var2, TimeZone var3);

    protected abstract boolean isRunDay(Calendar var1, JobInfo var2);

    private Calendar restoreOriginalTime(Calendar calendar) {
        if (calendar instanceof MovedInvalidDateTime) {
            int n = ((MovedInvalidDateTime)calendar).getMinutesMoved();
            Calendar calendar2 = ((MovedInvalidDateTime)calendar).toCalendar();
            calendar2.add(12, n);
            return calendar2;
        }
        return calendar;
    }

    private boolean isSuppressScheduleLogEntry() {
        Boolean bl = suppressScheduleLogEntry.get();
        return bl != null && bl == Boolean.TRUE;
    }

    public static enum TargetType implements PersistableEnum<String>
    {
        AGENT("Agent"),
        AGENT_GROUP("AgentGroup");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, TargetType> map;

        private TargetType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static TargetType persistanceCodeToEnum(String string) {
            TargetType targetType = map.get(string);
            if (targetType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return targetType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])TargetType.values());
        }
    }

    public static enum TimeZoneType implements PersistableEnum<String>
    {
        SERVER("S"),
        AGENT("A"),
        JOB("J");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, TimeZoneType> map;

        private TimeZoneType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static TimeZoneType persistanceCodeToEnum(String string) {
            TimeZoneType timeZoneType = map.get(string);
            if (timeZoneType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return timeZoneType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])TimeZoneType.values());
        }
    }

    public static enum NonWorkdayOption implements PersistableEnum<String>
    {
        RUN("R"),
        DO_NOT_RUN("N"),
        RUN_ON_NEAREST_PRIOR_WORKDAY("B"),
        RUN_ON_NEAREST_SUBSEQUENT_WORKDAY("A");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, NonWorkdayOption> map;

        private NonWorkdayOption(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static NonWorkdayOption persistanceCodeToEnum(String string) {
            if (string == null || string.trim().length() == 0) {
                return RUN;
            }
            NonWorkdayOption nonWorkdayOption = map.get(string);
            if (nonWorkdayOption == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return nonWorkdayOption;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])NonWorkdayOption.values());
        }
    }
}

