/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import com.helpsystems.enterprise.core.scheduler.Runtimes_WeekOfPeriod;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class Runtimes_WeekOfPeriodTest
extends TestCase {
    private Runtimes_WeekOfPeriod runtimes;
    private CalendarObject calendar;
    private JobInfo jobInfo = null;

    public Runtimes_WeekOfPeriodTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = new CalendarObject();
        this.calendar.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        this.runtimes = new Runtimes_WeekOfPeriod(this.calendar);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddRuntime() {
        this.runtimes.addRuntime(3, new LocalHHMM(8, 30));
        this.runtimes.addRuntime(3, new LocalHHMM(8, 45));
        this.runtimes.addRuntime(1, new LocalHHMM(9, 0));
        this.runtimes.addRuntime(2, new LocalHHMM(9, 30));
        String string = "{1=[09:00], 2=[09:30], 3=[08:30, 08:45]}";
        Runtimes_WeekOfPeriodTest.assertEquals((String)string, (String)this.runtimes.toString());
    }

    public void testAddLastWeekOfPeriodRuntime() {
        this.runtimes.addLastWeekOfPeriodRuntime(new LocalHHMM(7, 45));
        this.runtimes.addLastWeekOfPeriodRuntime(new LocalHHMM(5, 45));
        this.runtimes.addLastWeekOfPeriodRuntime(new LocalHHMM(9, 45));
        String string = "{}, L=[05:45, 07:45, 09:45]";
        Runtimes_WeekOfPeriodTest.assertEquals((String)string, (String)this.runtimes.toString());
    }

    public void testAddRuntimeToEachWeek() {
        this.runtimes.addRuntimeToEachWeek(new LocalHHMM(9, 0));
        String string = "{1=[09:00], 2=[09:00], 3=[09:00], 4=[09:00], 5=[09:00]}";
        Runtimes_WeekOfPeriodTest.assertEquals((String)string, (String)this.runtimes.toString());
    }

    public void testAddRuntimesToEachWeek() {
        Runtimes_Basic runtimes_Basic = new Runtimes_Basic(new LocalHHMM(0, 0));
        runtimes_Basic.addRuntime(new LocalHHMM(8, 15));
        runtimes_Basic.addRuntime(new LocalHHMM(9, 45));
        this.runtimes.addRuntimesToEachWeek(runtimes_Basic);
        String string = "{1=[08:15, 09:45], 2=[08:15, 09:45], 3=[08:15, 09:45], 4=[08:15, 09:45], 5=[08:15, 09:45]}";
        Runtimes_WeekOfPeriodTest.assertEquals((String)string, (String)this.runtimes.toString());
    }

    public void testFirstRuntimeOfDay() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 16);
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 14);
        Runtimes_WeekOfPeriodTest.assertEquals((int)6, (int)gregorianCalendar.get(7));
        Runtimes_WeekOfPeriodTest.assertNull((Object)this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo));
        this.runtimes.addRuntime(2, new LocalHHMM(9, 0));
        Runtimes_WeekOfPeriodTest.assertNull((Object)this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo));
        this.runtimes.addRuntime(3, new LocalHHMM(10, 0));
        Calendar calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Calendar calendar2 = (Calendar)((Calendar)gregorianCalendar).clone();
        calendar2.set(11, 10);
        calendar2.set(12, 0);
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(5), (int)calendar.get(5));
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(11), (int)calendar.get(11));
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(12), (int)calendar.get(12));
        this.runtimes.addRuntimeToEachWeek(new LocalHHMM(10, 15));
        calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(5), (int)calendar.get(5));
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(11), (int)calendar.get(11));
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(12), (int)calendar.get(12));
        gregorianCalendar.set(5, 7);
        Runtimes_WeekOfPeriodTest.assertEquals((int)4, (int)gregorianCalendar.get(7));
        calendar2.set(5, 7);
        calendar2.set(11, 10);
        calendar2.set(12, 15);
        calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(5), (int)calendar.get(5));
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(11), (int)calendar.get(11));
        Runtimes_WeekOfPeriodTest.assertEquals((int)calendar2.get(12), (int)calendar.get(12));
    }

    public void testNextRuntimeSameDay() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 16);
        gregorianCalendar.set(11, 12);
        Runtimes_WeekOfPeriodTest.assertNull((Object)this.runtimes.nextRuntimeSameDay(gregorianCalendar, this.jobInfo));
    }

    public void testIsEmpty() {
        Runtimes_WeekOfPeriodTest.assertTrue((boolean)this.runtimes.isEmpty());
        this.runtimes.addRuntime(1, new LocalHHMM(9, 0));
        Runtimes_WeekOfPeriodTest.assertFalse((boolean)this.runtimes.isEmpty());
    }
}

