/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class RuntimeRanges_DayOfWeekTest
extends TestCase {
    private RuntimeRanges_DayOfWeek ranges;
    private CalendarObject calendar;

    public RuntimeRanges_DayOfWeekTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = new CalendarObject();
        this.ranges = new RuntimeRanges_DayOfWeek(this.calendar);
    }

    protected void tearDown() throws Exception {
        this.ranges = null;
        this.calendar = null;
        super.tearDown();
    }

    public void testToString() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        TimeRange timeRange2 = new TimeRange(new LocalHHMM(9, 15), new LocalHHMM(11, 45));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.WEEK1, timeRange2);
        String string = "{MON=[08:00 - 12:00], TUE={1=[09:15 - 11:45]}}";
        String string2 = this.ranges.toString();
        RuntimeRanges_DayOfWeekTest.assertEquals((String)string, (String)string2);
    }

    public void testAddRuntimeRangeEveryWeek() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 7);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 13);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testAddRuntimeRangeNever() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.NEVER, timeRange);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 7);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 13);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testAddRuntimeRangeLastWeek() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.LAST_WEEK, timeRange);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 7);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 13);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(5, 26);
        gregorianCalendar.set(11, 7);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 13);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testAddRuntimeRangeWeek1() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.WEEK1, timeRange);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 7);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 13);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(5, 5);
        gregorianCalendar.set(11, 7);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 13);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testAddMultipleRuntimeRanges() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.SUN, Runtimes_DayOfWeek.RunCode.NEVER, timeRange);
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.WEEK1, timeRange);
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.WEEK2, timeRange);
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.WED, Runtimes_DayOfWeek.RunCode.WEEK3, timeRange);
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.THU, Runtimes_DayOfWeek.RunCode.WEEK4, timeRange);
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.FRI, Runtimes_DayOfWeek.RunCode.WEEK5, timeRange);
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.SAT, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)((Calendar)gregorianCalendar).clone();
        gregorianCalendar2.set(5, 13);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)3, (int)gregorianCalendar2.get(7));
        GregorianCalendar gregorianCalendar3 = (GregorianCalendar)((Calendar)gregorianCalendar).clone();
        gregorianCalendar3.set(5, 14);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)4, (int)gregorianCalendar3.get(7));
        GregorianCalendar gregorianCalendar4 = (GregorianCalendar)((Calendar)gregorianCalendar).clone();
        gregorianCalendar4.set(5, 15);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)5, (int)gregorianCalendar4.get(7));
        GregorianCalendar gregorianCalendar5 = (GregorianCalendar)((Calendar)gregorianCalendar).clone();
        gregorianCalendar5.set(5, 16);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)6, (int)gregorianCalendar5.get(7));
        GregorianCalendar gregorianCalendar6 = (GregorianCalendar)((Calendar)gregorianCalendar).clone();
        gregorianCalendar6.set(5, 17);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)7, (int)gregorianCalendar6.get(7));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar2));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar3));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar4));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar5));
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar6));
    }

    public void testContains() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        TimeRange timeRange2 = new TimeRange(new LocalHHMM(15, 0), new LocalHHMM(18, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 7);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 14);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 16);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 19);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testHasNoRuntimeRangesDefinedForDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.set(1, 2010);
        gregorianCalendar2.set(2, 3);
        gregorianCalendar2.set(5, 13);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)3, (int)gregorianCalendar2.get(7));
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar2));
    }

    public void testIsEmpty() {
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.isEmpty());
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.isEmpty());
    }

    public void testWeekOfPeriodToEveryWeek() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 10);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.WEEK4, timeRange);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        TimeRange timeRange2 = new TimeRange(new LocalHHMM(14, 0), new LocalHHMM(16, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange2);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        gregorianCalendar.set(11, 15);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testAddLastWeekToEveryWeek() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 26);
        gregorianCalendar.set(11, 15);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        TimeRange timeRange2 = new TimeRange(new LocalHHMM(14, 0), new LocalHHMM(16, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.LAST_WEEK, timeRange2);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testAddSpecificWeekToEveryWeek() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 26);
        gregorianCalendar.set(11, 15);
        RuntimeRanges_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        TimeRange timeRange = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, timeRange);
        RuntimeRanges_DayOfWeekTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        TimeRange timeRange2 = new TimeRange(new LocalHHMM(14, 0), new LocalHHMM(16, 0));
        this.ranges.addRuntimeRange(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.WEEK4, timeRange2);
        RuntimeRanges_DayOfWeekTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
    }
}

