/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_Basic;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class RuntimeRanges_BasicTest
extends TestCase {
    private RuntimeRanges_Basic ranges;

    public RuntimeRanges_BasicTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ranges = new RuntimeRanges_Basic();
    }

    protected void tearDown() throws Exception {
        this.ranges = null;
        super.tearDown();
    }

    public void testConstructor() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(9, 0), new LocalHHMM(12, 0));
        this.ranges = new RuntimeRanges_Basic(timeRange);
        TimeRange[] timeRangeArray = this.ranges.getRuntimeRanges();
        RuntimeRanges_BasicTest.assertEquals((int)1, (int)timeRangeArray.length);
        RuntimeRanges_BasicTest.assertEquals((Object)timeRange, (Object)timeRangeArray[0]);
    }

    public void testAddRuntimeRange() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(9, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(timeRange);
        TimeRange[] timeRangeArray = this.ranges.getRuntimeRanges();
        RuntimeRanges_BasicTest.assertEquals((int)1, (int)timeRangeArray.length);
        RuntimeRanges_BasicTest.assertEquals((Object)timeRange, (Object)timeRangeArray[0]);
    }

    public void testContains() {
        TimeRange timeRange = new TimeRange(new LocalHHMM(9, 0), new LocalHHMM(12, 0));
        this.ranges.addRuntimeRange(timeRange);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(11, 6);
        gregorianCalendar.set(12, 30);
        RuntimeRanges_BasicTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 9);
        gregorianCalendar.set(12, 0);
        RuntimeRanges_BasicTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 10);
        gregorianCalendar.set(12, 30);
        RuntimeRanges_BasicTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 0);
        RuntimeRanges_BasicTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 1);
        RuntimeRanges_BasicTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testIsEmpty() {
        RuntimeRanges_BasicTest.assertTrue((boolean)this.ranges.isEmpty());
        this.ranges.addRuntimeRange(new TimeRange(new LocalHHMM(9, 0), new LocalHHMM(12, 0)));
        RuntimeRanges_BasicTest.assertFalse((boolean)this.ranges.isEmpty());
    }

    public void testHasNoRuntimeRangesDefinedForDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        RuntimeRanges_BasicTest.assertTrue((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        this.ranges.addRuntimeRange(new TimeRange(new LocalHHMM(9, 0), new LocalHHMM(12, 0)));
        RuntimeRanges_BasicTest.assertFalse((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
    }

    public void testToString() {
        this.ranges.addRuntimeRange(new TimeRange(new LocalHHMM(9, 0), new LocalHHMM(12, 0)));
        RuntimeRanges_BasicTest.assertEquals((String)"[09:00 - 12:00]", (String)this.ranges.toString());
        this.ranges.addRuntimeRange(new TimeRange(new LocalHHMM(14, 15), new LocalHHMM(15, 45)));
        RuntimeRanges_BasicTest.assertEquals((String)"[09:00 - 12:00, 14:15 - 15:45]", (String)this.ranges.toString());
    }
}

