/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import junit.framework.TestCase;

public class PersistanceCodeToEnumMapTest
extends TestCase {
    PersistanceCodeToEnumMap<String, Suit> p;

    public PersistanceCodeToEnumMapTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.p = new PersistanceCodeToEnumMap((Enum[])new Suit[]{Suit.CLUBS, Suit.DIAMONDS, Suit.SPADES, Suit.HEARTS});
    }

    protected void tearDown() throws Exception {
        this.p = null;
        super.tearDown();
    }

    public void testGet() {
        PersistanceCodeToEnumMapTest.assertEquals((Object)Suit.SPADES, (Object)this.p.get("S"));
        PersistanceCodeToEnumMapTest.assertEquals((Object)Suit.DIAMONDS, (Object)this.p.get("D"));
        PersistanceCodeToEnumMapTest.assertEquals((Object)Suit.CLUBS, (Object)this.p.get("C"));
        PersistanceCodeToEnumMapTest.assertEquals((Object)Suit.HEARTS, (Object)this.p.get("H"));
        PersistanceCodeToEnumMapTest.assertNull((Object)this.p.get("bogus"));
    }

    public void testGetEnumName() {
        PersistanceCodeToEnumMapTest.assertEquals((String)"Suit", (String)this.p.getEnumName());
    }

    public void testGetEnumNameForEmptyEnum() {
        PersistanceCodeToEnumMap persistanceCodeToEnumMap = new PersistanceCodeToEnumMap((Enum[])new EmptyEnum[0]);
        PersistanceCodeToEnumMapTest.assertEquals((String)"unknown", (String)persistanceCodeToEnumMap.getEnumName());
    }

    static enum Suit implements PersistableEnum<String>
    {
        HEARTS("H"),
        DIAMONDS("D"),
        CLUBS("C"),
        SPADES("S");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, Suit> map;

        private Suit(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static Suit persistanceCodeToEnum(String string) {
            Suit suit = map.get(string);
            if (suit == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return suit;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])Suit.values());
        }
    }

    static enum EmptyEnum implements PersistableEnum<String>
    {


        @Override
        public String persistanceCode() {
            return "";
        }
    }
}

