/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MovedNST
extends GregorianCalendar {
    private static final long serialVersionUID = -7385933286782170956L;
    private int daysMoved;
    private int minutesMoved;
    private Calendar originalNST;
    private boolean isTimeZoneSet;

    public MovedNST(Calendar calendar, int n, int n2) {
        this(calendar);
        this.daysMoved = n;
        this.minutesMoved = n2;
    }

    public MovedNST(Calendar calendar, Calendar calendar2) {
        this(calendar);
        ValidationHelper.checkForNull((String)"Original NST", (Object)calendar2);
        this.originalNST = calendar2;
        this.calcDaysAndMinutesMoved();
        this.isTimeZoneSet = true;
    }

    private MovedNST(Calendar calendar) {
        super(calendar.getTimeZone());
        this.clear();
        this.setTimeInMillis(calendar.getTimeInMillis());
    }

    public int getDaysMoved() {
        return this.daysMoved;
    }

    public int getMinutesMoved() {
        return this.minutesMoved;
    }

    public long getOriginalDateTimeYYYYMMDDHHMM() {
        Calendar calendar = this.getOriginalNST();
        if (calendar instanceof MovedInvalidDateTime) {
            return ((MovedInvalidDateTime)calendar).getOriginalDateTimeYYYYMMDDHHMM();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        TimeZone timeZone = this.getTimeZone();
        simpleDateFormat.setTimeZone(timeZone);
        return Long.valueOf(simpleDateFormat.format(this.getOriginalNST().getTime()));
    }

    public Calendar getOriginalNST() {
        if (this.originalNST == null) {
            this.originalNST = this.originalNST();
        }
        return this.originalNST;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        ValidationHelper.checkForNull((String)"TimeZone", (Object)timeZone);
        super.setTimeZone(timeZone);
        this.isTimeZoneSet = true;
    }

    private long adjustForDST(long l) {
        MovedNST movedNST = this;
        Calendar calendar = this.originalNST;
        if (this.dstBoundaryCrossed()) {
            long l2 = movedNST.get(16) - calendar.get(16);
            return l + l2;
        }
        return l;
    }

    private void calcDaysAndMinutesMoved() {
        long l = 86400000L;
        long l2 = 60000L;
        int n = 720;
        long l3 = this.getTimeInMillis() - this.originalNST.getTimeInMillis();
        l3 = this.adjustForDST(l3);
        this.daysMoved = (int)(l3 / l);
        if (l3 % l == 0L) {
            this.minutesMoved = 0;
        } else {
            long l4 = l3 % l;
            if (l4 % l2 != 0L) {
                throw new IllegalStateException("Program usage error. The MovedNST class was not designed to handle Calendars with non-zero seconds or milliseconds. Non-zero values were detected.");
            }
            this.minutesMoved = (int)(l4 / l2);
            this.validateMinutesMoved();
            if (Math.abs(this.minutesMoved) > n) {
                int n2 = 1440;
                if (this.minutesMoved > 0) {
                    this.minutesMoved -= n2;
                    ++this.daysMoved;
                } else {
                    this.minutesMoved += n2;
                    --this.daysMoved;
                }
            }
        }
    }

    private boolean dstBoundaryCrossed() {
        MovedNST movedNST = this;
        Calendar calendar = this.originalNST;
        if (!((Calendar)movedNST).getTimeZone().hasSameRules(calendar.getTimeZone())) {
            throw new IllegalStateException("Program error. In order to determine if a DST boundary was crossed, the TimeZones must have the same rules.");
        }
        return movedNST.get(16) != calendar.get(16);
    }

    private Calendar originalNST() {
        if (!this.isTimeZoneSet) {
            throw new IllegalStateException("Program error: The TimeZone must be set before trying to access original NST data.");
        }
        if (this.daysMoved == 0 && this.minutesMoved == 0) {
            throw new IllegalStateException("Program error: The MovedNST class is not being used properly.");
        }
        if (this.daysMoved == 0) {
            return new MovedInvalidDateTime((Calendar)this, this.minutesMoved);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.clear();
        gregorianCalendar.setTimeInMillis(this.getTimeInMillis());
        if (this.minutesMoved < 0) {
            ((Calendar)gregorianCalendar).add(12, -this.minutesMoved);
            ((Calendar)gregorianCalendar).add(5, -this.daysMoved);
            return new MovedInvalidDateTime((Calendar)gregorianCalendar, this.minutesMoved);
        }
        ((Calendar)gregorianCalendar).add(5, -this.daysMoved);
        ((Calendar)gregorianCalendar).add(12, -this.minutesMoved);
        return gregorianCalendar;
    }

    private void validateMinutesMoved() {
    }
}

